Attribute VB_Name = "basGym2Mid"
Option Explicit

Private Type LowEndianWord
    MSB As Byte
    LSB As Byte
End Type

Private Type LowEndianDoubleWord
    MSB As Byte
    Byte3 As Byte
    Byte2 As Byte
    LSB As Byte
End Type

Private Type MidiHeaderData
    MThd As String * 4
    HeaderLen As LowEndianDoubleWord
    MidiFormat As LowEndianWord
    NumTracks As LowEndianWord
    NumTicks As LowEndianWord
End Type

Public MidiHeader As MidiHeaderData

Private Type MidiTrackHeaderData
    Filler(1 To 14) As Byte
    MTrk As String * 4
    TrackLen As LowEndianDoubleWord
End Type

Public MidiTrackHeader As MidiTrackHeaderData

Private Type MidiTrackData
    Filler(1 To 22) As Byte
    MidiEvents As String
End Type

Public MidiTrack As String

Private Type ymRegisterData
    LFOEn As Boolean
    LFOFreq As Byte
    TimerA As Integer
    TimerB As Byte
    Ch3Mode As Boolean
    Operator As Boolean
    Channel As Byte
    DacEn As Boolean
    DACData As Byte
End Type

Public ymRegData As ymRegisterData

Private Type ymFrequencyData
    MSB As Byte
    LSB As Byte
    Block As Byte
    Freq As Integer
    OldFreq As Integer
End Type

Private Type ymChannelData
    OpNum As Byte
    DT1(0 To 3) As Byte
    MUL(0 To 3) As Byte
    TL(0 To 3) As Byte
    MidiVol As Byte
    RS(0 To 3) As Byte
    AR(0 To 3) As Byte
    AM(0 To 3) As Byte
    D1R(0 To 3) As Byte
    D2R(0 To 3) As Byte
    D1L(0 To 3) As Byte
    RR(0 To 3) As Byte
    ymFreqData As ymFrequencyData
    MidiNote As Byte
    Feedback As Byte
    Algorithm As Byte
    L As Boolean
    R As Boolean
    MidiPan As Byte
    AMS As Byte
    FMS As Byte
End Type

Public ymChanData(0 To 7) As ymChannelData

Private Type ProgrammableSoundGeneratorData
    Channel As Byte
    Freq As Integer
    FB As Byte
    NF1 As Byte
    NF0 As Byte
End Type

Public PSGData As ProgrammableSoundGeneratorData

Public GymData As String
Private Function CIntToLEWord(intInt As Integer) As LowEndianWord
    With CIntToLEWord
        .MSB = (intInt And &HFF00) / 256
        .LSB = intInt And &HFF
    End With
End Function
Private Function CLEDblWordToLng(LEDblWord As LowEndianDoubleWord) As Long
    With LEDblWord
        CLEDblWordToLng = .LSB + (.Byte2 * 256) + (.Byte3 * (256 ^ 2)) + (.MSB * (256 ^ 3))
    End With
End Function
Private Function CLEWordToInt(LEWord As LowEndianWord) As Integer
    With LEWord
        CLEWordToInt = .LSB + (.MSB * 256)
    End With
End Function
Private Function CLngToLEDblWord(lngLong As Long) As LowEndianDoubleWord
    With CLngToLEDblWord
        .MSB = (lngLong And &HFF000000) / (256 ^ 3)
        .Byte3 = (lngLong And &HFF0000) / (256 ^ 2)
        .Byte2 = (lngLong And &HFF00) / 256
        .LSB = lngLong And &HFF
    End With
End Function
Public Function CYmFreqToMidiNote(FreqData As ymFrequencyData, MidiNote As Byte) As Byte
    With FreqData
        .OldFreq = .Freq
        .Block = (.MSB And 56) / 8
        .Freq = (.MSB And 7) * 256
        .Freq = .Freq + .LSB
        
        If .Freq > 581 And .Freq < 635 Then
            CYmFreqToMidiNote = 11 + (.Block * 12)
        ElseIf .Freq > 636 And .Freq < 672 Then
            CYmFreqToMidiNote = 12 + (.Block * 12)
        ElseIf .Freq > 673 And .Freq < 712 Then
            CYmFreqToMidiNote = 13 + (.Block * 12)
        ElseIf .Freq > 713 And .Freq < 755 Then
            CYmFreqToMidiNote = 14 + (.Block * 12)
        ElseIf .Freq > 756 And .Freq < 800 Then
            CYmFreqToMidiNote = 15 + (.Block * 12)
        ElseIf .Freq > 801 And .Freq < 847 Then
            CYmFreqToMidiNote = 16 + (.Block * 12)
        ElseIf .Freq > 848 And .Freq < 897 Then
            CYmFreqToMidiNote = 17 + (.Block * 12)
        ElseIf .Freq > 898 And .Freq < 947 Then
            CYmFreqToMidiNote = 18 + (.Block * 12)
        ElseIf .Freq > 948 And .Freq < 1010 Then
            CYmFreqToMidiNote = 19 + (.Block * 12)
        ElseIf .Freq > 1011 And .Freq < 1068 Then
            CYmFreqToMidiNote = 20 + (.Block * 12)
        ElseIf .Freq > 1069 And .Freq < 1131 Then
            CYmFreqToMidiNote = 21 + (.Block * 12)
        ElseIf .Freq > 1132 And .Freq < 1199 Then
            CYmFreqToMidiNote = 22 + (.Block * 12)
        Else
            CYmFreqToMidiNote = MidiNote
        End If
    End With
End Function
Public Function ReadGym(GymFileName As String)
    Dim FilePos As Long, CharBuffer As Byte
    Dim ymPort As Byte, ymReg As Byte, ymData As Byte, ymDelay As Long
'    Dim ymChannel As Byte, ymKeyOn(0 To 6) As Boolean, YMFreq(0 To 6) As ymFrequencyData , MidiNote(0 To 7) As Byte
    
    Open GymFileName For Binary As #1
        GymData = Input(LOF(1), 1)
    Close

    MidiTrack = ""
    For FilePos = 1 To Len(GymData)
        CharBuffer = Asc(Mid(GymData, FilePos, 1))
        Select Case CharBuffer
        Case 0:
            ymDelay = ymDelay + 1
        Case 1:
            ymPort = 0
            ymReg = Asc(Mid(GymData, FilePos + 1, 1))
            ymData = Asc(Mid(GymData, FilePos + 2, 1))
            FilePos = FilePos + 2
        Case 2:
            ymPort = 1
            ymReg = Asc(Mid(GymData, FilePos + 1, 1))
            ymData = Asc(Mid(GymData, FilePos + 2, 1))
            FilePos = FilePos + 2
        Case 3:
            ymData = Asc(Mid(GymData, FilePos + 1, 1))
'            Select Case ymData And &HF0
'            Case 128, 160, 192:
'                PSGData.Channel = (ymData And 112) / 32
'                PSGData.Freq = (ymData And 15) * 256
'                ymData = Asc(Mid(GymData, FilePos + 3, 1))
'                PSGData.Freq = PSGData.Freq + ymData
'                Debug.Print "PSG Channel=" & PSGData.Channel & "; Freq=" & PSGData.Freq
'                FilePos = FilePos + 3
'            Case Else:
                FilePos = FilePos + 1
'            End Select
        End Select
        
        Select Case ymReg
'        Case &H22:
'            If ymData >= 8 Then
'                RegisterData.LFOEn = True
'                ymData = ymData - 8
'                ymRegData.LFOFreq = ymData
'            Else
'                ymRegData.LFOEn = False
'            End If
'        Case &H24:
'            ymRegData.TimerA = 0
'            ymRegData.TimerA = ymData
'        Case &H25:
'            ymRegData.TimerA = ymData * 256
'        Case &H27:
'            If ymData >= 128 Then
'                ymRegData.Ch3Mode = True
'            Else
'                ymRegData.Ch3Mode = False
'            End If
        Case &H28:
            ymRegData.Channel = ymData And 7
            If ymData >= &HF0 Then
                ymRegData.Operator = True
            Else
                ymRegData.Operator = False
            End If
            Select Case ymRegData.Operator
            Case True:
'                ymKeyOn(ymRegData.Channel) = True
                If ymDelay >= 128 Then
                    Do Until ymDelay < 128
                        MidiTrack = MidiTrack & Chr(128)
                        ymDelay = ymDelay - 128
                    Loop
                End If
                MidiTrack = MidiTrack & Chr(ymDelay) & Chr(&H80 + ymRegData.Channel) & Chr(ymChanData(ymRegData.Channel).MidiNote) & Chr(&H0)
                ymChanData(ymRegData.Channel).MidiNote = CYmFreqToMidiNote(ymChanData(ymRegData.Channel).ymFreqData, ymChanData(ymRegData.Channel).MidiNote)
                MidiTrack = MidiTrack & Chr(0) & Chr(&H90 + ymRegData.Channel) & Chr(ymChanData(ymRegData.Channel).MidiNote) & Chr(&H7F)
                ymDelay = 0
            Case False:
'                ymKeyOn(ymRegData.Channel) = False
                MidiTrack = MidiTrack & Chr(ymDelay) & Chr(&H80 + ymRegData.Channel) & Chr(ymChanData(ymRegData.Channel).MidiNote) & Chr(&H0)
                ymDelay = 0
            End Select
'        Case &H2A:
'            ymRegData.DACData = ymData
'        Case &H2B:
'            If ymData >= 128 Then ymRegData.DacEn = True
'        Case &H30 To &H3E:
'            ymRegData.Channel = (((ymReg Xor &H30) / 12) - Fix((ymReg Xor &H30) / 12)) + (ymPort * 4)
'            With ymChanData(ymRegData.Channel)
'                .OpNum = (Fix((ymReg Xor &H30) / 4))
'                .DT1(.OpNum) = (ymData And 240) / 16
'                .MUL(.OpNum) = ymData And 15
'            End With
'        Case &H40 To &H4E:
'            ymRegData.Channel = (((ymReg Xor &H40) / 12) - Fix((ymReg Xor &H40) / 12)) + (ymPort * 4)
'            With ymChanData(ymRegData.Channel)
'                .OpNum = (Fix((ymReg Xor &H40) / 4))
'                .TL(.OpNum) = ymData
'                If .TL(.OpNum) = 127 Then .TL(.OpNum) = 0
'                .MidiVol = .TL(0) Or .TL(1) Or .TL(2) Or .TL(3)
'                If ymDelay >= 128 Then
'                    Do Until ymDelay < 128
'                        MidiTrack = MidiTrack & Chr(128)
'                        ymDelay = ymDelay - 128
'                    Loop
'                End If
'                MidiTrack = MidiTrack & Chr(ymDelay) & Chr(&HB0 + ymRegData.Channel) & Chr(7) & Chr(.MidiVol)
'            End With
'            ymDelay = 0
        Case &HA0 To &HAF:
            Select Case ymReg:
            Case &HA4 To &HA6:
                ymRegData.Channel = (ymReg Xor &HA4) + (ymPort * 4)
                With ymChanData(ymRegData.Channel).ymFreqData
                    .MSB = ymData
                End With
            Case &HA0 To &HA2:
                ymRegData.Channel = (ymReg Xor &HA0) + (ymPort * 4)
                With ymChanData(ymRegData.Channel).ymFreqData
                    .LSB = ymData
                End With
            End Select
        Case &HB0 To &HB2:
            ymRegData.Channel = (ymReg Xor &HB0) + (ymPort * 4)
            With ymChanData(ymRegData.Channel)
                .Algorithm = ymData And 7
                Select Case .Algorithm
                Case 0:
                    .Algorithm = 0
                Case 1:
                    .Algorithm = 0
                Case 2:
                    .Algorithm = 0
                Case 3:
                    .Algorithm = 0
                Case 4:
                    .Algorithm = 0
                Case 5:
                    .Algorithm = 0
                Case 6:
                    .Algorithm = 0
                Case 7:
                    .Algorithm = 0
                End Select
                MidiTrack = MidiTrack & Chr(ymDelay) & Chr(&HC0 + ymRegData.Channel) & Chr(.Algorithm)
                ymDelay = 0
            End With
        Case &HB4 To &HB6:
            ymRegData.Channel = (ymReg Xor &HB4) + (ymPort * 4)
            If ymDelay >= 128 Then
                Do Until ymDelay < 128
                    MidiTrack = MidiTrack & Chr(128)
                    ymDelay = ymDelay - 128
                Loop
            End If
            Select Case (ymData And 192)
            Case 128:
                MidiTrack = MidiTrack & Chr(ymDelay) & Chr(&HB0 + ymRegData.Channel) & Chr(10) & Chr(&H1F)
            Case 64:
                MidiTrack = MidiTrack & Chr(ymDelay) & Chr(&HB0 + ymRegData.Channel) & Chr(10) & Chr(&H5F)
            Case 192:
                MidiTrack = MidiTrack & Chr(ymDelay) & Chr(&HB0 + ymRegData.Channel) & Chr(10) & Chr(&H3F)
            End Select
            ymDelay = 0
        End Select
        ymReg = &H0
        ymData = &H0
    Next
End Function
Public Function ReadMidi(MidiFileName As String)
    Dim FilePos As Long, CharBuffer As Byte
    Dim lngMThd As Long, lngHeaderLen As Long, intMidiFormat As Integer, intNumTracks As Integer, intNumTicks As Integer, lngTrackLen As Long
    
    Open MidiFileName For Random As #1 Len = Len(MidiHeader)
        Get #1, 1, MidiHeader
    Close
    
    With MidiHeader
'        Debug.Print "MThd: (" & .MThd & ")"
    
        lngHeaderLen = CLEDblWordToLng(.HeaderLen)
'        Debug.Print "Header Length: (" & lngHeaderLen & ")"

        intMidiFormat = CLEWordToInt(.MidiFormat)
'        Debug.Print "Midi File Format: (" & intMidiFormat & ")"

        intNumTracks = CLEWordToInt(.NumTracks)
'        Debug.Print "Number of Tracks: (" & intNumTracks & ")"
        
        intNumTicks = CLEWordToInt(.NumTicks)
'        Debug.Print "Number of Ticks: (" & intNumTicks & ")"
    End With

    Open MidiFileName For Random As #1 Len = Len(MidiTrackHeader)
        Get #1, 1, MidiTrackHeader
    Close
    
    With MidiTrackHeader
'        Debug.Print "MTrk: (" & .MTrk & ")"
        
        lngTrackLen = CLEDblWordToLng(.TrackLen)
'        Debug.Print "Track Length: (" & lngTrackLen & ")"
    End With
    
    Open MidiFileName For Binary As #1
        MidiTrack = Input(LOF(1), 1)
        MidiTrack = Right(MidiTrack, Len(MidiTrack) - 22)
    Close
'    Debug.Print MidiTrack

    For FilePos = 1 To Len(MidiTrack)
        Debug.Print Hex(Asc(Mid(MidiTrack, FilePos, 1))) & "; ";
    Next
End Function
Public Function WriteMidi(MidiFileName As String)
    Dim FilePos As Long, CharBuffer As Byte
    Dim lngMThd As Long, lngHeaderLen As Long, intMidiFormat As Integer, intNumTracks As Integer, intNumTicks As Integer, lngTrackLen As Long
    
    If Dir(MidiFileName) <> "" Then Kill (MidiFileName)
    
'    MidiTrack = " untitled &Copyright  1998 by Paul Edward Jensen Paul Edward Jensen X Y   Q  ' HdxCdx<dpH xC x<  / "

'    MidiTrack = MidiTrack & Chr(0)
'    MidiTrack = MidiTrack & Chr(&HC0) & Chr(&H0)
'    MidiTrack = MidiTrack & Chr(0)
'    MidiTrack = MidiTrack & Chr(&H90) & Chr(48) & Chr(100)
'    MidiTrack = MidiTrack & Chr(128) & Chr(112)
'    MidiTrack = MidiTrack & Chr(&H80) & Chr(48) & Chr(0)
'    MidiTrack = MidiTrack & Chr(0)
'    MidiTrack = MidiTrack & Chr(&HFF) & Chr(&H2F) & Chr(0)
    
    MidiTrack = MidiTrack & Chr(0) & Chr(&HFF) & Chr(&H2F) & Chr(0)
    
    With MidiTrackHeader
        .MTrk = "MTrk"
        lngTrackLen = Len(MidiTrack)
        .TrackLen = CLngToLEDblWord(lngTrackLen)
    End With
    
    Open MidiFileName For Random As #1 Len = Len(MidiTrackHeader)
        Put #1, 1, MidiTrackHeader
    Close
    
    With MidiHeader
        .MThd = "MThd"
        lngHeaderLen = 6
        .HeaderLen = CLngToLEDblWord(lngHeaderLen)
        intMidiFormat = 0
        .MidiFormat = CIntToLEWord(intMidiFormat)
        intNumTracks = 1
        .NumTracks = CIntToLEWord(intNumTracks)
        intNumTicks = 30
        .NumTicks = CIntToLEWord(intNumTicks)
    End With
    
    Open MidiFileName For Random As #1 Len = Len(MidiHeader)
        Put #1, 1, MidiHeader
    Close
    
    Open MidiFileName For Binary As #1
        For FilePos = 1 To Len(MidiTrack)
            Put #1, FilePos + 22, Asc(Mid(MidiTrack, FilePos, 1))
        Next
    Close
End Function
