/****************************************************
 * SnesPRO cable driver and tester.
 ****************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <pc.h>
#include <dos.h>

#define power1 64
#define clock1 1
#define reset1 2
#define select1 4
#define power2 128
#define clock2 8
#define reset2 16
#define select2 32

int par_ioport = 0x378;

// Reads SnesPRO!-type connected joypads.
int SP_pad2int(unsigned short int * pad1, unsigned short int * pad2)
{
    static int old_pad1 = 0, old_pad2 = 0;
    int val=0, value, p1, p2, i;

    p1 = p2 = 0;
    outportb(par_ioport, power1 | power2 | reset1 | reset2);
    for (i = 0; i < 16; i++)
    {
          outportb(par_ioport, power1 | power2);
          value = inportb(par_ioport + 1);
          p1 <<= 1;
          if ((value & 64) == 0)
             p1 |= 1;
          p2 <<= 1;
          if ((value & 32) == 0)
             p2 |= 1;
          outportb(par_ioport, power1 | power2 | clock1 | clock2);
    }
    val = p1 ^ old_pad1;
    for (i = 0; i < 16; i++)
       if (val & 1 << i)
       {
           *pad1 &= ~(1<<i);
           *pad1 |= p1 & (1<<i);
       }
    val = p2 ^ old_pad2;
    for (i = 0; i < 16; i++)
       if (val & 1 << i)
       {
           *pad2 &= ~(1<<i);
           *pad2 |= p2 & (1<<i);
       }
    old_pad1 = p1;
    old_pad2 = p2;
}

/*
int SP_pad2int(int * pad1, int * pad2)
{
    int val=0, value;
    *pad1=0;
    *pad2=0;
    outportb(0x378, power1 | power2 | reset1 | reset2);
    for (int i=0; i<16; i++)
    {
          outportb(0x378, power1 | power2);
          value = inportb(0x379);
          *pad1 >>= 1;
          if ((value & 64) == 0)
             *pad1 |= 0x8000;
          *pad2 >>= 1;
          if ((value & 32) == 0)
             *pad2 |= 0x8000;
          outportb(0x378, power1 | power2 | clock1 | clock2);
    }
}
*/

void main()
{
   unsigned int value, x, y;
   value = 3;
   outportb(0x378, power1 | power2 | reset1 | reset2);
   for (x = 0; x < 32; x++)
   {
       outportb(0x378, power1 | power2 | clock1 | clock2);
       outportb(0x378, power1 | power2);
       y = inportb(0x379);
       if (x>=16)
       {
          if ((y & 64) == 64)
              value &= 2;
          if ((y & 32) != 32)
              value &= 1;
       }
       else if (x>=12)
       {
          if ((y & 64) != 64)
              value &= 2;
          if ((y & 32) == 32)
              value &= 1;
       }
   }
   //printf ("\nDetected flag: %i\n", value);
   printf("Joystick connected to port 1: %s\nJoystick connected to port 2: %s\n",
          (value & 1) ? "Yes": "No",
          (value & 2) ? "Yes": "No");
   getch();
   while (!kbhit())
   {
#if 0
       outportb(0x378, power1 | power2 | reset1 | reset2);
       x = y = 0;
       for (int i=0; i<32; i++)
       {
          outportb(0x378, power1 | power2);
          x <<= 1;
          value = inportb(0x379);
          if (i<16)
          {
          if (value & 64)
             printf("X");
          else
             printf(".");
          }
          else
             if (value & 64)
               x |= 1;
          

/*          if (value & 128)
             printf("X");
          else
             printf(".");*/
          outportb(0x378, power1 | power2 | clock1 | clock2);
       }
       printf("%8X\n", (~x) & 0xFFFF);
#else
       short unsigned int pad1, pad2;
       pad1 = pad2 = 0;
       SP_pad2int(&pad1, &pad2);
       printf("Pad1: %4X, Pad2: %4X\n", pad1, pad2);
#endif
   }
}

