#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include "swinder.h"

#undef TRUE
#undef FALSE
#include <allegro.h>
#include <go32.h>
#include <dpmi.h>
#include "vgakeybo.h"

#undef TRUE
#undef FALSE
#define TRUE 1
#define FALSE 0

#include <dpmi.h>

#include "snes9x.h"
#include "memmap.h"
#include "debug.h"
#include "ppu.h"
#include "snapshot.h"
#include "gfx.h"
#include "display.h"
#include "apu.h"
#include "soundux.h"

#include "gui.h"
#include "msdos.h"
#include "unzip.h"

#define COUNT(a) (sizeof(a) / sizeof(a[0]))

#define sti() __asm__ __volatile__ ("sti": : :"memory")
#define cli() __asm__ __volatile__ ("cli": : :"memory")

static int screen_pitch = 0;
static int screen_width = 0;
static int screen_height = 0;
extern int vid_mode, vid_xres, vid_yres, vid_adaptor;
extern BOOL nothingloaded, Windows_Friendly, FastFPU;
extern BOOL scanlines;
extern BOOL SnesPro, Keyboard_P2;
BOOL Keyboard_P2 = TRUE;
int SP_pad2int(unsigned short int * pad1, unsigned short int * pad2);
BOOL scanlines = 0;
extern int highcolourmode, highresmode;
int highcolourmode = FALSE, highresmode = FALSE;
int vid_mode = 2;
int vid_xres, vid_yres, vid_adaptor;
static BOOL planar = FALSE;
static BOOL in_text_mode = TRUE;
static BOOL stretch = FALSE;
static BITMAP *off_screen;
#ifdef SIDEWINDER_SUPPORT
extern int sidewinder_present;
int sidewinder_present = 0;
static int num_sidewinders = 0;
#endif
extern int NumControllers;

#ifdef GRIP_SUPPORT
#include "grip.h"
void InitGrip ();
void ReadGrip ();
static BOOL num_grip_controllers = 0;
static BOOL grip_initialised = FALSE;
#endif

extern DWORD joypads [5];
extern BITMAP *screen;

#ifdef JOYSTICK_SUPPORT
extern BOOL joysticks_have_four_buttons;
extern BOOL joysticks_have_six_buttons;
#endif

#define ATTRCON_ADDR	0x3c0
#define MISC_ADDR	0x3c2
#define VGAENABLE_ADDR	0x3c3
#define SEQ_ADDR	0x3c4
#define GRACON_ADDR	0x3ce
#define CRTC_ADDR	0x3d4
#define STATUS_ADDR	0x3da

typedef struct
{
    unsigned port;
    unsigned char index;
    unsigned char value;
} Register;

typedef Register *RegisterPtr;
void outRegArray (Register *r, int n);

Register scr256x256[] =
{
     { 0x3c2, 0x00, 0xe3},{ 0x3d4, 0x00, 0x5f},{ 0x3d4, 0x01, 0x3f},
     { 0x3d4, 0x02, 0x40},{ 0x3d4, 0x03, 0x82},{ 0x3d4, 0x04, 0x4A},
     { 0x3d4, 0x05, 0x9A},{ 0x3d4, 0x06, 0x23},{ 0x3d4, 0x07, 0xb2},
     { 0x3d4, 0x08, 0x00},{ 0x3d4, 0x09, 0x61},{ 0x3d4, 0x10, 0x0a},
     { 0x3d4, 0x11, 0xac},{ 0x3d4, 0x12, 0xff},{ 0x3d4, 0x13, 0x20},
     { 0x3d4, 0x14, 0x40},{ 0x3d4, 0x15, 0x07},{ 0x3d4, 0x16, 0x1a},
     { 0x3d4, 0x17, 0xa3},{ 0x3c4, 0x01, 0x01},{ 0x3c4, 0x04, 0x0e},
     { 0x3ce, 0x05, 0x40},{ 0x3ce, 0x06, 0x05},{ 0x3c0, 0x10, 0x41},
     { 0x3c0, 0x13, 0x00}
};

// Only partially works -- Remember to put a BIG WARNING in the readme!
Register scr256x256Scan[] =
{
     { 0x3c2, 0x0, 0xe3}, { 0x3d4, 0x0, 0x5f}, { 0x3d4, 0x1, 0x3f},
     { 0x3d4, 0x2, 0x40}, { 0x3d4, 0x3, 0x82}, { 0x3d4, 0x4, 0x4a},
     { 0x3d4, 0x5, 0x9a}, { 0x3d4, 0x6, 0x23}, { 0x3d4, 0x7, 0x1d},
     { 0x3d4, 0x8, 0x0},  { 0x3d4, 0x9, 0x60}, { 0x3d4, 0x10, 0xa},
     { 0x3d4, 0x11, 0xac},{ 0x3d4, 0x12, 0xff},{ 0x3d4, 0x13, 0x20},
     { 0x3d4, 0x14, 0x40},{ 0x3d4, 0x15, 0x7}, { 0x3d4, 0x16, 0x1a},
     { 0x3d4, 0x17, 0xa3},{ 0x3c4, 0x1, 0x1},  { 0x3c4, 0x4, 0xe},
     { 0x3ce, 0x5, 0x40}, { 0x3ce, 0x6, 0x5},  { 0x3c0, 0x10, 0x41},
     { 0x3c0, 0x13, 0x0}
};

// Partially working
Register scr256x240[] =
{
        { 0x3c2, 0x0, 0xe3}, { 0x3d4, 0x0, 0x5f}, { 0x3d4, 0x1, 0x3f},
        { 0x3d4, 0x2, 0x40}, { 0x3d4, 0x3, 0x82}, { 0x3d4, 0x4, 0x4e},
        { 0x3d4, 0x5, 0x96}, { 0x3d4, 0x6, 0xd},  { 0x3d4, 0x7, 0x3e},
        { 0x3d4, 0x8, 0x0},  { 0x3d4, 0x9, 0x41}, { 0x3d4, 0x10, 0xea},
        { 0x3d4, 0x11, 0xac},{ 0x3d4, 0x12, 0xdf},{ 0x3d4, 0x13, 0x20},
        { 0x3d4, 0x14, 0x40},{ 0x3d4, 0x15, 0xe7},{ 0x3d4, 0x16, 0x6},
        { 0x3d4, 0x17, 0xe3},{ 0x3c4, 0x1, 0x1},  { 0x3c4, 0x4, 0xe},
        { 0x3ce, 0x5, 0x40}, { 0x3ce, 0x6, 0x5},  { 0x3c0, 0x10, 0x41},
        { 0x3c0, 0x13, 0x0}
};

// Partially working
Register scr256x240Scan[] =
{
        { 0x3c2, 0x0, 0xe3}, { 0x3d4, 0x0, 0x61}, { 0x3d4, 0x1, 0x3f},
        { 0x3d4, 0x2, 0x40}, { 0x3d4, 0x3, 0x82}, { 0x3d4, 0x4, 0x4a},
        { 0x3d4, 0x5, 0x9a}, { 0x3d4, 0x6, 0x23}, { 0x3d4, 0x7, 0x1d},
        { 0x3d4, 0x8, 0x0},  { 0x3d4, 0x9, 0x60}, { 0x3d4, 0x10, 0xa},
        { 0x3d4, 0x11, 0xaa},{ 0x3d4, 0x12, 0xef},{ 0x3d4, 0x13, 0x20},
        { 0x3d4, 0x14, 0x40},{ 0x3d4, 0x15, 0x7}, { 0x3d4, 0x16, 0x1a},
        { 0x3d4, 0x17, 0xa3},{ 0x3c4, 0x1, 0x1},  { 0x3c4, 0x4, 0xe},
        { 0x3ce, 0x5, 0x40}, { 0x3ce, 0x6, 0x5},  { 0x3c0, 0x10, 0x41},
        { 0x3c0, 0x13, 0x0}, { 0x3c0, 0x14, 0x0}
};

typedef struct
{
    int width;
    int height;
    int mode;
} Mode;

static Mode modes [] = {
    {320, 240, GFX_MODEX},
    {320, 200, GFX_VGA},
    {256, 256, GFX_VGA},
    {256, 240, GFX_VGA},
    {320, 240, GFX_AUTODETECT},
    {640, 480, GFX_AUTODETECT},
    {640, 480, GFX_VESA2L},
    {640, 400, GFX_XTENDED},
    {800, 600, GFX_AUTODETECT}
};

BYTE PadKeys[4][12] =
  {{ SCANCODE_CURSORRIGHT,     SCANCODE_CURSORLEFT,
     SCANCODE_CURSORDOWN,      SCANCODE_CURSORUP,
     SCANCODE_LEFTCONTROL,     SCANCODE_LEFTSHIFT,
     SCANCODE_X,               SCANCODE_C,
     SCANCODE_W,               SCANCODE_Q,
     SCANCODE_S,               SCANCODE_D
   },
   {0},{0},{0}
  };



void GraphicsMode ()
{
    if (in_text_mode)
    {
	int ret;
        if (vid_mode == 255) // 255 is custom mode.
        {
            screen_width = vid_xres;
            screen_height = vid_yres;
            ret = set_gfx_mode (vid_adaptor, vid_xres, vid_yres, 0, 0);
            planar = vid_adaptor == GFX_MODEX;
        }
        else
        {
            screen_width = modes [vid_mode].width;
            screen_height = modes [vid_mode].height;
            if (modes [vid_mode].mode == GFX_VGA)
                ret = set_gfx_mode (modes [vid_mode].mode, 320, 200, 0, 0);
            else
                ret = set_gfx_mode (modes [vid_mode].mode, modes [vid_mode].width,
                              modes [vid_mode].height, 0, 0);
            planar = (modes [vid_mode].mode == GFX_MODEX);
        }
	
	if (ret < 0)
	{
            set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
            sprintf(String, "Graphics init error!\n   Unable to switch to requested screen mode/resolution:\n   %s",
		    allegro_error);
            FatalExit (String);
	}
    if (vid_mode != 255)
    if (modes [vid_mode].mode == GFX_VGA && screen_width == 256 && screen_height == 256)
	{
            if (!scanlines)
               outRegArray (scr256x256, sizeof (scr256x256) / sizeof (Register));
            else
               outRegArray (scr256x256Scan, sizeof (scr256x256Scan) / sizeof (Register));
	    screen->w = screen->cr = 256;
	    screen->h = screen->cb = 256;
	    for (int i = 1; i < 256; i++)
		screen->line[i] = screen->line[i - 1] + 256;
	}
        if (modes [vid_mode].mode == GFX_VGA && screen_width == 256 && screen_height == 240)
	{
            if (!scanlines)
               outRegArray (scr256x240, sizeof (scr256x240) / sizeof (Register));
            else
               outRegArray (scr256x240, sizeof (scr256x240) / sizeof (Register));
	    screen->w = screen->cr = 256;
            screen->h = screen->cb = 240;
	    for (int i = 1; i < 256; i++)
		screen->line[i] = screen->line[i - 1] + 256;
	}
	clear_to_color (screen, 0);
    
        remove_keyboard();
        if (install_keyboard ())
	{
	    set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
            sprintf (String, "Keyboard initialisation failed.");
            FatalExit (String);
	}
	in_text_mode = FALSE;
        set_palette(desktop_pallete);
    }
    IPPU.ColorsChanged = TRUE;
}

void TextMode ()
{
    if (!in_text_mode)
    {
	remove_keyboard ();
	set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
	in_text_mode = TRUE;
    }
}

void InitDisplay (int argc, char **argv)
{
    if (allegro_init () < 0)
    {
        sprintf (String, "Unable to initialise vga.");
        FatalExit (String);
    }

    Settings.Transparency = FALSE;
    Settings.SixteenBit = FALSE;
    Settings.SupportHiRes = FALSE;
    if (highcolourmode) {
        Settings.Transparency = TRUE;
        Settings.SixteenBit = TRUE;
        set_color_depth(16);
    }
    else
        set_color_depth(8);
    
    if (highresmode)
        Settings.SupportHiRes = TRUE;

    extern int i_love_bill;

#ifdef JOYSTICK_SUPPORT
    //if (num_sidewinders == 0)
    //    initialise_joystick ();
#endif

    if (!Windows_Friendly)
        i_love_bill = FALSE;

#if 0
#ifdef JOYSTICK_SUPPORT
    printf ("Press any key or joystick button...");
#else
    printf ("Press any key...");
#endif
    fflush (stdout);
    install_keyboard ();
    while (TRUE)
    {
	for (int i = 0; i < 127; i++)
	    if (key [i])
		break;

	if (key [i])
	    break;
#ifdef JOYSTICK_SUPPORT
	poll_joystick ();
	if (joy_b1 || joy_b2 || joy2_b1 || joy2_b2 ||
	    (joysticks_have_six_buttons && (joy2_left || joy2_down)))
	    break;
#endif
    }
    remove_keyboard ();
#endif    
//    GraphicsMode ();
    
    off_screen = create_bitmap (IMAGE_WIDTH, IMAGE_HEIGHT);

    GFX.Screen = (BYTE *) off_screen->dat;
    if (!GFX.Screen)
    {
        sprintf (String, "Cannot allocate screen buffer.");
        FatalExit (String);
    }
    if (Settings.SixteenBit) {
       GFX.Pitch = off_screen->w << 1;
       GFX.SubScreen = malloc(1024 * 480);
    }
    else {
       GFX.Pitch = off_screen->w;
       GFX.SubScreen = GFX.Screen;
    }
    screen_pitch = off_screen->w;
}

void DeinitDisplay ()
{
    TextMode ();
}

#ifdef JOYSTICK_SUPPORT
void InitJoysticks ()
{
}

static int old_joy_left = 0;
static int old_joy_right = 0;
static int old_joy_up = 0;
static int old_joy_down = 0;
static int old_joy_b1 = 0;
static int old_joy_b2 = 0;
static int old_joy2_left = 0;
static int old_joy2_right = 0;
static int old_joy2_up = 0;
static int old_joy2_down = 0;
static int old_joy2_b1 = 0;
static int old_joy2_b2 = 0;

void ReadJoysticks ()
{
    if (num_sidewinders == 0)
    {
	poll_joystick ();
	if (joy_b1 ^ old_joy_b1)
	{
	    if (!joysticks_have_four_buttons && !joysticks_have_six_buttons)
	    {
		if (joy_b1)
		    joypads [0] |= 128;
		else
		    joypads [0] &= ~128;
	    }
	    else
	    {
		if (joy_b1)
		    joypads [0] |= (64 << 8);
		else
		    joypads [0] &= ~(64 << 8);
	    }
	}
	if (joy_b2 ^ old_joy_b2)
	{
	    if (!joysticks_have_four_buttons && !joysticks_have_six_buttons)
	    {
		if (joy_b2)
		    joypads [0] |= (128 << 8);
		else
		    joypads [0] &= ~(128 << 8);
	    }
	    else
	    {
		if (joy_b2)
		    joypads [0] |= 64;
		else
		    joypads [0] &= ~64;
	    }
	}
	if (joy_left ^ old_joy_left)
	{
	    if (joy_left)
		joypads [0] |= (2 << 8);
	    else
		joypads [0] &= ~(2 << 8);
	}
	if (joy_right ^ old_joy_right)
	{
	    if (joy_right)
		joypads [0] |= (1 << 8);
	    else
		joypads [0] &= ~(1 << 8);
	}
	if (joy_up ^ old_joy_up)
	{
	    if (joy_up)
		joypads [0] |= (8 << 8);
	    else
		joypads [0] &= ~(8 << 8);
	}
	if (joy_down ^ old_joy_down)
	{
	    if (joy_down)
		joypads [0] |= (4 << 8);
	    else
		joypads [0] &= ~(4 << 8);
	}
	if (joysticks_have_four_buttons || joysticks_have_six_buttons)
	{
	    if (joy2_b1 ^ old_joy2_b1)
	    {
		if (joy2_b1)
		    joypads [0] |= (128 << 8);
		else
		    joypads [0] &= ~(128 << 8);
	    }
	    if (joy2_b2 ^ old_joy2_b2)
	    {
		if (joy2_b2)
		    joypads [0] |= 128;
		else
		    joypads [0] &= ~128;
	    }
	
	    if (joysticks_have_six_buttons)
	    {
		if (joy2_left ^ old_joy2_left)
		{
		    if (joy2_left)
			joypads [0] |= 32;
		    else
			joypads [0] &= ~32;
		}
		if (joy2_down ^ old_joy2_down)
		{
		    if (joy2_down)
			joypads [0] |= 16;
		    else
			joypads [0] &= ~16;
		}
	    }
	}
	else
	{
	    if (joy2_b1 ^ old_joy2_b1)
	    {
		if (joy2_b1)
		    joypads [1] |= 128;
		else
		    joypads [1] &= ~128;
	    }
	    if (joy2_b2 ^ old_joy2_b2)
	    {
		if (joy2_b2)
		    joypads [1] |= (128 << 8);
		else
		    joypads [1] &= ~(128 << 8);
	    }
	    if (joy2_left ^ old_joy2_left)
	    {
		if (joy2_left)
		    joypads [1] |= (2 << 8);
		else
		    joypads [1] &= ~(2 << 8);
	    }
	    if (joy2_right ^ old_joy2_right)
	    {
		if (joy2_right)
		    joypads [1] |= (1 << 8);
		else
		    joypads [1] &= ~(1 << 8);
	    }
	    if (joy2_up ^ old_joy2_up)
	    {
		if (joy2_up)
		    joypads [1] |= (8 << 8);
		else
		    joypads [1] &= ~(8 << 8);
	    }
	    if (joy2_down ^ old_joy2_down)
	    {
		if (joy2_down)
		    joypads [1] |= (4 << 8);
		else
		    joypads [1] &= ~(4 << 8);
	    }
	}
	old_joy_left = joy_left;
	old_joy_right = joy_right;
	old_joy_up = joy_up;
	old_joy_down = joy_down;
	old_joy_b1 = joy_b1;
	old_joy_b2 = joy_b2;
	old_joy2_left = joy2_left;
	old_joy2_right = joy2_right;
	old_joy2_up = joy2_up;
	old_joy2_down = joy2_down;
	old_joy2_b1 = joy2_b1;
	old_joy2_b2 = joy2_b2;
    }
}
#endif

void SetPalette ()
{
    WORD Brightness = IPPU.MaxBrightness * 138;
    PALLETE p;
    for (int i = 0; i < 256; i++)
    {
	p[i].r = (((PPU.CGDATA [i] >> 0) & 0x1F) * Brightness) >> 10;
	p[i].g = (((PPU.CGDATA [i] >> 5) & 0x1F) * Brightness) >> 10;
	p[i].b = (((PPU.CGDATA [i] >> 10) & 0x1F) * Brightness) >> 10;
    }
    set_palette_range (p, 0, 255, FALSE);
}

BITMAP *bmp;
PALETTE pal;

static FONT* oldfont;
static int olddepth = 8;
void MiniGUIDestroy();

void MiniGUIInit()
{
     //MiniGUIDestroy();
     olddepth = _color_depth;
     set_color_depth(8);
     oldfont=font;
     font = &s9gui_xm6x10;
     for (int i=0; i<32; i++)
     {
         s9gui_logopal[i+176].r=(((GradientClr1>>18)&0x3F)*(32-i))/32 +
                                (((GradientClr2>>18)&0x3F)*i)/32;
         if (s9gui_logopal[i+176].r > 63) s9gui_logopal[i+176].r = 63;
         s9gui_logopal[i+176].g=(((GradientClr1>>10)&0x3F)*(32-i))/32 +
                                (((GradientClr2>>10)&0x3F)*i)/32;
         if (s9gui_logopal[i+176].g > 63) s9gui_logopal[i+176].g = 63;
         s9gui_logopal[i+176].b=(((GradientClr1>>2)&0x3F)*(32-i))/32 +
                                (((GradientClr2>>2)&0x3F)*i)/32;
         if (s9gui_logopal[i+176].b > 63) s9gui_logopal[i+176].b = 63;
     }
     if (SaveResolution)
         set_gfx_mode(1, 320, 200, 0, 0);
     else
         set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
     install_mouse();
     set_palette(s9gui_logopal);
     set_mouse_sprite(&s9gui_cursor);
     //set_mouse_sprite_d(&s9gui_cursor_d);
     set_mouse_sprite_focus(14,4);
     gui_fg_color=160;
     gui_bg_color=168;
     show_mouse(NULL);
     stretch_blit(&s9gui_logo, screen, 0, 0, s9gui_logo.w, s9gui_logo.h, 0, 0, gfx_driver->w, gfx_driver->h);
     install_keyboard();
     show_mouse(screen);
}

void MiniGUIDestroy()
{
    remove_keyboard();
    show_mouse(NULL);
    remove_mouse();
    set_color_depth(olddepth);
    set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
    font=oldfont;
}

int GetPix(int x, int y)
{
     return getpixel(bmp, x, y);
}

extern char FileFormat[];

void ProcessEvents (BOOL block)
{
    static char prev_keystate[128];
    extern volatile char key[128];

#ifdef GRIP_SUPPORT
    ReadGrip ();
#endif

    char key1[128];
    char *keystate = (char *) key1;
    int fn = 0;
    
    memcpy (key1, (char *) key, sizeof (key1));

#undef KEY_DOWN
#define KEY_DOWN(a) (keystate[a])
#undef KEY_PRESS
#define KEY_PRESS(a) (keystate[a] && !prev_keystate[a])
#undef KEY_WASPRESSED
#define KEY_WASPRESSED(a) (prev_keystate[a] && !keystate[a])
#undef PROCESS_KEY
#define PROCESS_KEY(k, b, v)\
if (KEY_PRESS(k)) b |= v;\
if (KEY_WASPRESSED(k)) b &= ~v;

    if (KEY_PRESS (SCANCODE_ESCAPE))
	Exit ();

    // Joypad 1:
    PROCESS_KEY(PadKeys[0][0],       joypads [1], 1)
    PROCESS_KEY(PadKeys[0][1],       joypads [1], 2)
    PROCESS_KEY(PadKeys[0][2],       joypads [1], 4)
    PROCESS_KEY(PadKeys[0][3],       joypads [1], 8)
    PROCESS_KEY(PadKeys[0][4],       joypads [1], 16)
    PROCESS_KEY(PadKeys[0][5],       joypads [1], 32)
    PROCESS_KEY(PadKeys[0][6],       joypads [1], 64)
    PROCESS_KEY(PadKeys[0][7],       joypads [1], 128)

    PROCESS_KEY(PadKeys[0][8],       joypads [0], 16)
    PROCESS_KEY(PadKeys[0][9],       joypads [0], 32)
    PROCESS_KEY(PadKeys[0][10],      joypads [0], 64)
    PROCESS_KEY(PadKeys[0][11],      joypads [0], 128)

    // Joypad 2:
    /*
    PROCESS_KEY(SCANCODE_CURSORRIGHT,       joypads [3], 1)
    PROCESS_KEY(SCANCODE_CURSORLEFT,        joypads [3], 2)
    PROCESS_KEY(SCANCODE_CURSORDOWN,	    joypads [3], 4)
    PROCESS_KEY(SCANCODE_CURSORUP,	    joypads [3], 8)
    PROCESS_KEY(SCANCODE_RIGHTALT,	    joypads [3], 16)
    PROCESS_KEY(SCANCODE_RIGHTCONTROL,	    joypads [3], 16)
    PROCESS_KEY(SCANCODE_RIGHTSHIFT,	    joypads [3], 32)
    PROCESS_KEY(SCANCODE_INSERT,	    joypads [2], 32)
    PROCESS_KEY(SCANCODE_REMOVE,	    joypads [2], 16)
    PROCESS_KEY(SCANCODE_HOME,		    joypads [2], 64)
    PROCESS_KEY(SCANCODE_END,		    joypads [3], 64)
    PROCESS_KEY(SCANCODE_PAGEUP,	    joypads [2], 128)
    PROCESS_KEY(SCANCODE_PAGEDOWN,	    joypads [3], 128)
    */

    if (KEY_PRESS(SCANCODE_F1))
	fn = 1;
    if (KEY_PRESS(SCANCODE_F2))
	fn = 2;
    if (KEY_PRESS(SCANCODE_F3))
	fn = 3;
    if (KEY_PRESS(SCANCODE_F4))
	fn = 4;
    if (KEY_PRESS(SCANCODE_F5))
	fn = 5;
    if (KEY_PRESS(SCANCODE_F6))
	fn = 6;
    if (KEY_PRESS(SCANCODE_F7))
	fn = 7;
    if (KEY_PRESS(SCANCODE_F8))
	fn = 8;
    if (KEY_PRESS(SCANCODE_F9))
	fn = 9;
    if (KEY_PRESS(SCANCODE_F10))
	fn = 10;
    if (KEY_PRESS(SCANCODE_F11))
	fn = 11;
    if (KEY_PRESS(SCANCODE_F12))
	fn = 12;

    if (KEY_PRESS (SCANCODE_1))
	PPU.BG_Forced ^= 1;
    if (KEY_PRESS (SCANCODE_2))
	PPU.BG_Forced ^= 2;
    if (KEY_PRESS (SCANCODE_3))
	PPU.BG_Forced ^= 4;
    if (KEY_PRESS (SCANCODE_4))
	PPU.BG_Forced ^= 8;
    if (KEY_PRESS (SCANCODE_5))
	PPU.BG_Forced ^= 16;
    if (KEY_PRESS (SCANCODE_0))
	Settings.DisableHDMA = !Settings.DisableHDMA;
    if (KEY_PRESS (SCANCODE_8))
	Settings.BGLayering = !Settings.BGLayering;
    if (KEY_PRESS (SCANCODE_6))
	Settings.SwapJoypads = !Settings.SwapJoypads;

    if (KEY_PRESS (SCANCODE_PRINTSCREEN) || KEY_PRESS(SCANCODE_7))
    {
        char FilePCX[ 512];
        char FileNAME[255], FileDIR[255], FileDRIVE[MAXDRIVE], FileEXT[255];
        int i, numpos;
        char HexDig[17] = "0123456789ABCDEF";

        //Screen capture!
        fnsplit(Memory.ROMFilename, FileDRIVE, FileDIR, FileNAME, FileEXT);
        if (strlen(FileNAME)<=8)
        {
            for (i=strlen(FileNAME);i<8;i++)
                FileNAME[i]='_';
            FileNAME[8] = 0;  // We extended the filename... Truncate it at 8.
            numpos = 6;
        }
        else  // Must be in windows 95, so we can use LFN's too!
        {
            numpos = strlen(FileNAME);
                             // Make sure our extending terminates properly.
            FileNAME[numpos+1]=FileNAME[numpos+2]=0;
        }

        i=0;
        while (i<=0xFF)    // Find an open slot. 0-FF.
        {
            FileNAME[numpos] = HexDig[i>>4];
            FileNAME[numpos+1] = HexDig[i&0xf];
            fnmerge( FilePCX, FileDRIVE, FileDIR, FileNAME, FileFormat);
            if (!exists(FilePCX))
               i=0x100;
            else
               i++;
        }

        // There.  We have a decent filename, now save the damned thing!
        get_palette(pal);
        bmp = create_sub_bitmap(screen, (screen_width - IMAGE_WIDTH) / 2,
                                 (screen_height - PPU.ScreenHeight) / 2, IMAGE_WIDTH, PPU.ScreenHeight);
        save_bitmap(FilePCX, bmp, pal);
        destroy_bitmap(bmp);
    }

    if (fn > 0)
    {
        if (!(key_shifts&KB_ALT_FLAG) && !(key_shifts&KB_SHIFT_FLAG))
	{
	    if (fn == 11)
	    {
                BOOL i;
                TextMode ();
                if (UseGUI)
                    MiniGUIInit();
                i = FastFPU;
                FastFPU = FALSE;
                disable();
                if (!LoadSnapshot (ChooseFilename (TRUE)))
                {
                    if (UseGUI)
                    {
                        if (stricmp(String, ""))
                           alert_3d("Warning", NULL, String, "Ok", NULL, 0, 0);
                    }
                    else
                        printf(String);
                }
                FastFPU = i;
                if (UseGUI)
                {
                    MiniGUIDestroy();
                }
                in_text_mode = TRUE;
                enable();
                GraphicsMode ();
            }
	    else if (fn == 12)
	    {
                int i;

                TextMode ();
                if (UseGUI)
                    MiniGUIInit();
                Registers.PC = CPU.PC - CPU.PCBase;
                i = FastFPU;
                FastFPU = FALSE;
                disable();
                if (!Snapshot (ChooseFilename (FALSE)))
                {
                    if (UseGUI)
                    {
                        if (stricmp(String, ""))
                           alert_3d("Warning", NULL, String, "Ok", NULL, 0, 0);
                    }
                    else
                        printf(String);
                }
                FastFPU = i;
                if (UseGUI)
                {
                    MiniGUIDestroy();
                }
                in_text_mode = TRUE;
                enable();
                GraphicsMode ();
	    }
	    else
	    {
		char def [PATH_MAX];
		char filename [PATH_MAX];
		char drive [_MAX_DRIVE];
		char dir [_MAX_DIR];
		char ext [_MAX_EXT];

		_splitpath (Memory.ROMFilename, drive, dir, def, ext);
		sprintf (filename, "%s%s%s.%03d",
			 GetSnapshotDirectory (), SLASH_STR, def,
			 fn - 1);
		LoadSnapshot (filename);
	    }
	}
        else if (key_shifts&KB_ALT_FLAG)
	{
	    if (fn >= 4)
		ToggleSoundChannel (fn - 4);
#ifdef DEBUGGER
	    else if (fn == 1)
		CPU.Flags |= DEBUG_MODE_FLAG;
#endif
	    else if (fn == 2)
            {
                BOOL i;
                TextMode ();
                if (UseGUI)
                    MiniGUIInit();
                i = FastFPU;
                FastFPU = FALSE;
                disable();
                if (!LoadSnapshot (ChooseFilename (TRUE)))
                {
                    if (UseGUI)
                    {
                        if (stricmp(String, ""))
                           alert_3d("Warning", NULL, String, "Ok", NULL, 0, 0);
                    }
                    else
                        printf(String);
                }
                FastFPU = i;
                if (UseGUI)
                {
                    MiniGUIDestroy();
                }
                in_text_mode = TRUE;
                enable();
                GraphicsMode ();
            }
            else if (fn == 3)
            {
                int i;

                TextMode ();
                if (UseGUI)
                    MiniGUIInit();
                Registers.PC = CPU.PC - CPU.PCBase;
                i = FastFPU;
                FastFPU = FALSE;
                disable();
                if (!Snapshot (ChooseFilename (FALSE)))
                {
                    if (UseGUI)
                    {
                        if (stricmp(String, ""))
                           alert_3d("Warning", NULL, String, "Ok", NULL, 0, 0);
                    }
                    else
                        printf(String);
                }
                FastFPU = i;
                if (UseGUI)
                {
                    MiniGUIDestroy();
                }
                in_text_mode = TRUE;
                enable();
                GraphicsMode ();
            }
	}
	else
	{
	    char def [PATH_MAX];
	    char filename [PATH_MAX];
            char fname2 [PATH_MAX];
	    char drive [_MAX_DRIVE];
	    char dir [_MAX_DIR];
	    char ext [_MAX_EXT];
            char ext2 [_MAX_EXT];

            strcpy (filename, GetSnapshotDirectory ());
            fnsplit (Memory.ROMFilename, drive, dir, def, ext);
            if (strcmp(filename, "") == 0)
            {
                fnmerge (filename, drive, dir, def, "");
                if (filename[strlen(filename)-1]=='.')
                    sprintf(fname2, "%s%03d", filename, fn - 1);
                else
                    sprintf(fname2, "%s.%03d", filename, fn - 1);
            }
            else
            {
                strcat (filename, SLASH_STR);
                strcat (filename, def);
                sprintf(fname2, "%s.%03d", filename, fn - 1);
            }
            Snapshot (fname2);
	}
    }


    if (KEY_PRESS (SCANCODE_BREAK) || KEY_PRESS (SCANCODE_BREAK_ALTERNATIVE) ||
	KEY_PRESS (SCANCODE_SCROLLLOCK))
	Settings.Paused ^= 1;

    if (KEY_PRESS (SCANCODE_MINUS))
    {
	if (Settings.SkipFrames <= 1)
	    Settings.SkipFrames = AUTO_FRAMERATE;
	else
	if (Settings.SkipFrames != AUTO_FRAMERATE)
	    Settings.SkipFrames--;
    }

    if (KEY_PRESS (SCANCODE_EQUAL))
    {
	if (Settings.SkipFrames == AUTO_FRAMERATE)
	    Settings.SkipFrames = 1;
	else
	if (Settings.SkipFrames < 10)
	    Settings.SkipFrames++;
    }
	
    memcpy (prev_keystate, keystate, sizeof (prev_keystate));

    if (SnesPro)
    {
       SP_pad2int((unsigned short int*)&joypads[0], (unsigned short int*)&joypads[2]);
    }


    if (block)
	__dpmi_yield ();
}

void SetTitle (const char *title)
{
}

void PutImage (int width, int height)
{
    if (stretch)
	stretch_blit (off_screen, screen, 0, 0, width, height,
		      0, 0, screen_width, screen_height);
    else
    {
        if (modes [vid_mode].mode == GFX_VGA && screen_width == 256)
	{
	    int y_buff;
	    int y_start;
	    int y_end;
	    int x_start = (screen_width - width) >> 1;
	    if (screen_height >= height)
	    {
		y_start = (screen_height - height) >> 1;
		y_end = y_start + height;
		y_buff = 0;
	    }
	    else
	    {
		y_start = 0;
		y_end = screen_height;
		y_buff = (height - screen_height) >> 1;
	    }
	    BYTE *s = GFX.Screen + GFX.Pitch * y_buff;
	    BYTE *p = screen->line[0] + screen->w * y_start + x_start;
	    for (int y = y_start; y < y_end; y++, s += GFX.Pitch, p += screen->w)
            movedata (_my_ds(), (unsigned int) s,
			  (unsigned int) screen->seg, (unsigned int) p, 
			  width);
	}
	else
            blit (off_screen, screen, 0, 0, (screen_width - width) >> 1,
		  (screen_height - height) >> 1, width, height);
    }
}

const char *SelectFilename (const char *def, const char *dir1,
			    const char *ext1, const char *title)
{
    static char path [PATH_MAX];
    char buffer [PATH_MAX];
    
    if (!UseGUI)
    {
        TextMode ();
        printf ("\n%s (default: %s.%s): ", title, def, ext1);
        fflush (stdout);
        if (fgets (buffer, sizeof (buffer) - 1, stdin))
        {
            char *p = buffer;
            while (isspace (*p) || *p == '\n')
                p++;
            if (!*p)
            {
                strcpy (buffer, def);
                p = buffer;
            }
    
            char *q = strrchr (p, '\n');
            if (q)
                *q = 0;
            char fname [PATH_MAX];
            char drive [_MAX_DRIVE];
            char dir [_MAX_DIR];
            char ext [_MAX_EXT];

            fnsplit (p, drive, dir, fname, ext);
            fnmerge (path, drive, *dir ? dir : dir1, fname, *ext ? ext : ext1);
            GraphicsMode ();
            return (path);
        }
    }
    else
    {
        char fname [PATH_MAX];
        char drive [_MAX_DRIVE];
        char dir [_MAX_DIR];
        char ext [_MAX_EXT];

        fnsplit (Memory.ROMFilename, drive, dir, fname, ext);
        strcpy(buffer, title);
        if (strcmp(dir1, "") == 0)
            fnmerge(path, drive, dir, def, ext1);
        else
        {
            strcpy(path, dir1);
            if (dir1[strlen(dir1)-1]!='\\')
                strcat(path, "\\");
            strcat(path, def);
            if (ext1[strlen(ext1)-1]!='.')
                strcat(path, ".");
            strcat(path, ext1);
        }
        int ret;
        char dummy;
        ret = FileSelect(buffer, path, "S96;S9X", (char) FALSE, (char) FALSE, &dummy);
        if (ret != 0)
            return path;
        else
            return (NULL);
    }
    GraphicsMode ();
    return (NULL);
}

void outReg(Register r)
{
    switch (r.port)
    {
	/* First handle special cases: */

	case ATTRCON_ADDR:
	    /* reset read/write flip-flop */
	    inportb (STATUS_ADDR);
	    /* ensure VGA output is enabled */
	    outportb (ATTRCON_ADDR, r.index | 0x20);
	    outportb (ATTRCON_ADDR, r.value);
	    break;

	case MISC_ADDR:
	case VGAENABLE_ADDR:
	    /*	directly to the port */
	    outportb (r.port, r.value);
	    break;

	case SEQ_ADDR:
	case GRACON_ADDR:
	case CRTC_ADDR:
	default:
	    /*	index to port			   */
	    outportb (r.port, r.index);
	    /*	value to port+1 		   */
	    outportb (r.port + 1, r.value);
	    break;
    }
}

/*
    readyVgaRegs() does the initialization to make the VGA ready to
    accept any combination of configuration register settings.

    This involves enabling writes to index 0 to 7 of the CRT controller
    (port 0x3d4), by clearing the most significant bit (bit 7) of index
    0x11.
*/

void readyVgaRegs (void)
{
    int v;

    outportb (0x3d4, 0x11);
    v = inportb (0x3d5) & 0x7f;
    outportb (0x3d4, 0x11);
    outportb (0x3d5, v);
}
/*
	outRegArray sets n registers according to the array pointed to by r.
	First, indexes 0-7 of the CRT controller are enabled for writing.
*/

void outRegArray (Register *r, int n)
{
    readyVgaRegs ();
    while (n--)
	outReg (*r++);
}

void ExtraUsage ()
{
    printf ("\
-m  num                   Screen mode:\n\
                          0 - 320x240 (modeX/slow), 1 - 320x200 (fast/clipped)\n\
                          2 - 256x256 (faster/non-std), 3 - 320x240 (Auto),\n\
                          4-6 - 640x480, 7 - 640x400, 8 - 800x600\n");
    printf ("\
-scale                    Scale SNES screen to fit S-VGA screen\n");
    printf ("\
-scanlines                Activates a scanlines mode when using mode 2.  It\n\
                          won't work on many video cards, though.\n");
    printf ("\
-highcolour               Activates high colour mode with translucent effect\n\
                          support\n");
    printf ("\
-highres  -hires          Activates high res mode support\n");
}

void ParseDisplayArg (char **argv, int &ind, int)
{
    if ((strcmp (argv [ind], "-m") == 0 ||
	 strcasecmp (argv [ind], "-mode") == 0 ) && argv [ind + 1])
    {
        vid_mode = atoi (argv [++ind]);
        if (vid_mode >= sizeof (modes) / sizeof (modes [0]))
            vid_mode = 0;
    }
    else
    if (strcasecmp (argv [ind], "-scale") == 0)
	stretch = TRUE;
    else
    if (strcasecmp (argv [ind], "-scanlines") == 0)
        scanlines = TRUE;
    else
    if (strcasecmp (argv [ind], "-HighColour") == 0 ||
        strcasecmp (argv [ind], "-HighColor") == 0 ||
        strcasecmp (argv [ind], "-HiColour") == 0 ||
        strcasecmp (argv [ind], "-HiColor") == 0)
        highcolourmode = TRUE;
    else
    if (strcasecmp (argv [ind], "-HighRes") == 0 ||
        strcasecmp (argv [ind], "-HiRes") == 0)
        highresmode = TRUE;
    else
        Usage ();
}

volatile DWORD FrameTimer = 0;

void TimerInterrupt (...)
{
    FrameTimer++;
}
static END_OF_FUNCTION (TimerInterrupt);

void InitTimer ()
{
    install_timer ();
    LOCK_VARIABLE (FrameTimer);
    LOCK_FUNCTION (TimerInterrupt);
    if (install_int_ex (TimerInterrupt, (long)(((double)Settings.FrameTime * 1193181)/1000000)) < 0)
    {
	printf ("Snes9X: Dynamic speed limiting not available\n");
	Settings.SkipFrames = 3;
    }
}

int MinCommandLineArgs ()
{
    return (2);
}

static DIALOG temp;
/*
int gzread1 (gzFile file, voidp buf, unsigned len)
{
   int length, currentpos, blocks, wid, hit;
   int ammread, thisread;
   static char Title[160];
   if (!InGUI)
      return gzread(file, buf, len);
   //readkey();
   length = filelength(fileno(mystream->file));
   currentpos = ftell(mystream->file);
   blocks = len >> 16;
   wid = temp.w - 24;
   hit = (50-34)-4;
   ammread = 0;
   while (1)
   {
      if ((len - ammread) >= 65536)
         thisread = gzread(file, buf + ammread, 65536);
      else if ((len - ammread) > 0)
         thisread = gzread(file, buf + ammread, len - ammread);
      ammread += thisread;
      if ((len == ammread) || thisread == 0)
         return ammread;
      currentpos = ftell(mystream->file);
      rectfill(screen, temp.x + 12, temp.y + 37, temp.x + ((currentpos * wid) / length) + 12, temp.y + 48, 161);
   }
   gzread(file, buf + ammread, len - ammread);
   return ammread;
   //return gzread(file, buf, len);
}
*/

extern void ProgressMetre(char * Phase, int current, int max);
void ProgressMetre(char * Phase, int current, int max)
{
   if (InGUI)
   {
      if (current == 1)
      {
         temp.proc = d_3d_box_proc;
         temp.w = 200;
         temp.h = 60;
         temp.x = (gfx_driver->w - temp.w) >> 1;
         temp.y = (gfx_driver->h - temp.h) >> 1;
         temp.bg = 168;
         temp.fg = 160;
         temp.key = temp.d1 = temp.d2 = 0;
         temp.dp = "Please wait.";
         temp.flags = D_EXIT;
         d_3d_box_proc(MSG_DRAW, &temp, 0);
         textout_centre(screen, font, "Loading ROM...", (gfx_driver->w >>1), temp.y + 20, 160);
         box3d2(temp.x + 10, temp.y + 35, temp.x + temp.w - 10, temp.y + 50);

         d_3d_box_proc(MSG_DRAW, &temp, 0);
         text_mode(168);
         textout_centre(screen, font, "              ", (gfx_driver->w >>1), temp.y + 20, 160);
         textout_centre(screen, font, Phase, (gfx_driver->w >>1), temp.y + 20, 160);
         rectfill(screen, temp.x + 10, temp.y + 35, temp.x + temp.w - 10, temp.y + 50, 168);
         box3d2(temp.x + 10, temp.y + 35, temp.x + temp.w - 10, temp.y + 50);
      }
      rectfill(screen, temp.x + 12, temp.y + 37, temp.x + ((current * (temp.w - 24)) / max) + 12, temp.y + 48, 161);
   }
   else
      if (current == 1)
      {
         printf("%s", Phase);
         fflush(stdout);
      }
}

#define power1 64
#define clock1 1
#define reset1 2
#define select1 4
#define power2 128
#define clock2 8
#define reset2 16
#define select2 32
extern int par_ioport;
int par_ioport = 0x378;

// Reads SnesPRO!-type connected joypads.
int SP_pad2int(unsigned short int * pad1, unsigned short int * pad2)
{
    static int old_pad1 = 0, old_pad2 = 0;
    int val=0, value, p1, p2, i;

    p1 = p2 = 0;
    outportb(par_ioport, power1 | power2 | reset1 | reset2);
    for (i = 0; i < 16; i++)
    {
          outportb(par_ioport, power1 | power2);
          value = inportb(par_ioport + 1);
          p1 <<= 1;
          if ((value & 64) == 0)
             p1 |= 1;
          p2 <<= 1;
          if ((value & 32) == 0)
             p2 |= 1;
          outportb(par_ioport, power1 | power2 | clock1 | clock2);
    }
    val = p1 ^ old_pad1;
    for (i = 0; i < 16; i++)
       if (val & 1 << i)
       {
           *pad1 &= ~(1<<i);
           *pad1 |= p1 & (1<<i);
       }
    val = p2 ^ old_pad2;
    for (i = 0; i < 16; i++)
       if (val & 1 << i)
       {
           *pad2 &= ~(1<<i);
           *pad2 |= p2 & (1<<i);
       }
    old_pad1 = p1;
    old_pad2 = p2;
}

#include "display.h"

static int Rates[8] =
{
    0, 8192, 11025, 16500, 22050, 29300, 36600, 44100
};

#include "msdos/sb.h"

BOOL OpenSoundDevice (int mode, BOOL stereo, int buffer_size)
{
    static int instereo;
    static int sb_16bit;
    static int buf_size;
    
    /* Lock variables into memory */
    void MixSamples_end();
    void MixStereo (int);
    void MixStereo_end();
    void MixMono (int);
    void MixMono_end();
    void APUSetEndOfSample_end();
    void APUSetEndX_end();
    void SetEnvelopeRate_end();
    
    extern long FilterValues[4][2];
    extern int Echo [15360 + 14];
    extern int DummyEchoBuffer [MAX_BUFFER_SIZE];
    extern int MixBuffer [MAX_BUFFER_SIZE];
    extern int EchoBuffer [MAX_BUFFER_SIZE];
    extern int FilterTaps [8];
    extern unsigned long Z;
    extern int Loop [16];
    extern int NoiseFreq [32];

    LOCK_FUNCTION (MixSamples);
    LOCK_FUNCTION (MixStereo);
    LOCK_FUNCTION (MixMono);
    LOCK_FUNCTION (APUSetEndX);
    LOCK_FUNCTION (APUSetEndOfSample);
    LOCK_FUNCTION (SetEnvelopeRate);
    LOCK_VARIABLE (NoiseFreq);
    LOCK_VARIABLE (APU);
    LOCK_VARIABLE (IAPU);
    LOCK_VARIABLE (SoundData);
    LOCK_VARIABLE (so);
    LOCK_VARIABLE (FilterValues);
    LOCK_VARIABLE (Echo);
    LOCK_VARIABLE (DummyEchoBuffer);
    LOCK_VARIABLE (MixBuffer);
    LOCK_VARIABLE (EchoBuffer);
    LOCK_VARIABLE (FilterTaps);
    LOCK_VARIABLE (Z);
    LOCK_VARIABLE (Loop);

    _go32_dpmi_lock_data ((void *) IAPU.RAM, 64 * 1024);
#ifdef BUFFER_SAMPLES
    _go32_dpmi_lock_data ((void *) IAPU.ShadowRAM, 64 * 1024);
    _go32_dpmi_lock_data ((void *) IAPU.CachedSamples, 256 * 1024);
#endif			  

    /* Set up defaults */
    buf_size = 128;
    sb_16bit = TRUE;
    instereo = stereo;
    buf_size = Settings.SoundBufferSize;
    so.playback_rate = Rates [mode & 7];

    if (sx_sb_init(&instereo, &sb_16bit, &so.playback_rate, &buf_size))
    {
	return (FALSE);
    }

    atexit (sx_sb_exit);

    //return (TRUE);
    //set_volume (255, 255);
    //extern int sb_dma_size;
    //extern int sb_dma_mix_size;

    so.buffer_size = buf_size;
    so.stereo = instereo;
    so.sixteen_bit = sb_16bit;
    so.encoded = FALSE;

    printf ("%s, %dHz, %s-bit, %s\n", sb_desc,
            so.playback_rate, so.sixteen_bit ? "16" : "8",
        so.stereo ? "Stereo" : "Mono");

    //printf ("%s\n",sb_desc);

    return (TRUE);
}

#ifdef SIDEWINDER_SUPPORT
#define INITIAL_TIMEOUT 200
#define FIRST_STROBE_TIMEOUT 160
#define MIN_FIRST_STOBE_LEN 32
#define TIMEOUT 30
#define INTER_SIDEWINDER_STROBE_LEN 16

#define MODE_A_STROBES 15
#define MODE_B_STROBES 5
#define MAX_STROBES_PER_SIDEWINDER MODE_A_STROBES

#define SW_PORT	    0x201

extern int SidewinderToSNES [];
int ReadSidewinders ();

int InitSidewinders ()
{
    num_sidewinders = ReadSidewinders ();
    sidewinder_present = (num_sidewinders > 0);
    return num_sidewinders;
}

int ReadSidewinders ()
{
    static SW_READ_DATA prev_ret = {0};

    int j, i;
    unsigned char b;
    char *t;
    int strobes = 0;
    int start;
    unsigned char data [SW_MAX_SIDEWINDERS * MAX_STROBES_PER_SIDEWINDER * 2];
    unsigned char *p = data;
    unsigned char *pend = p + sizeof (data);
    struct SW_READ_DATA ret;
    unsigned int buttons;
    unsigned int parity;
    
    for (i = 0; i < SW_MAX_SIDEWINDERS; i++)
    {
	ret.buttons [i] = 0;
	ret.valid [i] = 0;
    }
	
    ret.count = 0;
    j = 0;
    
    cli ();
    outportb ((WORD) SW_PORT, (BYTE) 0xff);
    b = inportb ((WORD) SW_PORT);
    b = inportb ((WORD) SW_PORT);

    if (!(b & 0x10))
    {
	/* Search for bit 4 going from 0 to 1 */
	do
	{
	    b = inportb ((WORD) SW_PORT);
	    if (++j >= INITIAL_TIMEOUT)
		goto exit;
	} while (!(b & 0x10));
    }
	    
    j = 0;
    do
    {
	b = inportb ((WORD) SW_PORT);
	if (++j > FIRST_STROBE_TIMEOUT)
	    goto exit;
    } while (b & 0x10);
    
    do
    {
	j = 0;
	do
	{
	    b = inportb ((WORD) SW_PORT);
	    if (++j > TIMEOUT)
	    {
		*p = j;
		*(p + 1) = b;
		p += 2;
		goto exit;
	    }
	} while (!(b & 0x10));
	*p = j;
	*(p + 1) = b;
	p += 2;

	j = 0;
	do
	{
	    b = inportb ((WORD) SW_PORT);
	    if (++j > TIMEOUT)
		goto exit;
	} while (b & 0x10);
    } while (p < pend);
	    
exit:
    sti ();
    start = 0;
    strobes = 0;
    for (i = 0; i < p - data; i += 2)
    {
	if (data [i] >= INTER_SIDEWINDER_STROBE_LEN)
	{
	    if (strobes == MODE_A_STROBES || strobes == MODE_B_STROBES)
	    {
		buttons = 0;
		if (strobes == MODE_A_STROBES)
		{
		    for (j = 0; j < MODE_A_STROBES; j++)
			buttons |= (((data [start + 1 + (j << 1)] >> 5) ^ 1) & 1) << j;
		}
		else
		{
		    for (j = 0; j < MODE_B_STROBES; j++)
			buttons |= (((data [start + 1 + (j << 1)] >> 5) ^ 7) & 7) << (j * 3);
		}
		parity = 0;
		for (j = 0; j < SW_NUM_SIDEWINDER_BUTTONS; j++)
		    if (buttons & (1 << j))
			parity++;

		if ((parity & 1) != ((buttons >> SW_NUM_SIDEWINDER_BUTTONS) & 1))
		{
		    /* No partity error, update the joypad button state */
		    ret.valid [ret.count] = 1;
		    ret.buttons [ret.count++] = buttons & ~SW_PARITY_MASK;
		}
		else
		    ret.valid [ret.count++] = 0;
	    }
	    else
		ret.valid [ret.count++] = 0;
	    start = i;
	    strobes = 1;
	}
	else
	    strobes++;
    }
    if (ret.count)
    {
	if (ret.count < 2)
	    NumControllers = 2;
	else
	{
	    if (ret.count > NumControllers)
	    {
		NumControllers = ret.count;
		if (NumControllers > 5)
		    NumControllers = 5;
	    }
	}

	for (int s = 0; s < ret.count && s < 5; s++)
	{
	    if (ret.valid [s])
	    {
		for (int i = 0; i < SW_NUM_SIDEWINDER_BUTTONS; i++)
		{
		    if ((prev_ret.buttons [s] ^ ret.buttons [s]) & (1 << i))
		    {
			if (ret.buttons [s] & (1 << i))
			    joypads [s] |= SidewinderToSNES [i];
			else
			    joypads [s] &= ~SidewinderToSNES [i];
		    }
		}
		prev_ret.buttons [s] = ret.buttons [s];
	    }
	}
    }
    return (ret.count);
}
#endif

#ifdef GRIP_SUPPORT
void InitGrip ()
{
    char buffer [_MAX_PATH];
    FILE *fs = NULL;
    const char *grip_dir = getenv ("GRIP");
    BYTE *grip_library;
    int size;

/*
    if (grip_dir)
    {
	strcpy (buffer, grip_dir);
	strcat (buffer, "\\");
	strcat (buffer, "GRIP.GLL");
	fs = fopen (buffer, "rb");
    }

    if (!fs)
	fs = fopen ("GRIP.GLL", "rb");

    if (!fs)
	fs = fopen ("C:\\GRIP\\GRIP.GLL", "rb");

    if (!fs)
	fs = fopen ("C:\\GRAVIS\\GRIP\\GRIP.GLL", "rb");

    if (fs)
    {
	fseek (fs, 0, SEEK_END);
	size = ftell (fs);
	if (size > 32 * 1024)
	{
	    fclose (fs);
	    return;
	}
	grip_library = new BYTE [size];
	fseek (fs, 0, SEEK_SET);
	if (fread (grip_library, 1, size, fs) != size)
	{
	    delete grip_library;
	    fclose (fs);
	    return;
	}
	fclose (fs);
	if (!GrLink (grip_library, size))
	{
	    delete grip_library;
	    return;
	}
	delete grip_library;
	if (!GrInitialize ())
	{
	    GrUnlink ();
	    return;
	}
	grip_initialised = TRUE;
    }
*/
    __dpmi_regs r;
    char String11[17]="\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";

    r.x.ax = 0x849F;
    r.x.dx = 0;
    __dpmi_int(0x15, &r);
    (long)(String11[0]) = r.d.ebx;
    (long)(String11[4]) = r.d.edx;
    (long)(String11[8]) = r.d.ecx;
    printf("%08x, %08X, %08X -- %s\n", r.d.ebx, r.d.edx, r.d.ecx, String11);
    if ((r.d.ebx == 0x756E6547) && (r.d.edx == 0x42656E69) && (r.d.ecx == 0x42656E69))
    {
        printf("GrIP???\n");
        grip_initialised = TRUE;
    }
}

void ReadGrip ()
{
    if (num_grip_controllers)
    {
        //GrRefresh (0);
    }
}
#endif

