#define Bullet "  "

#include <signal.h>

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>
#include <ctype.h>
#include <conio.h>
#include <dir.h>

#include <crt0.h>

#include "inifuncs.h"
#include "msdos/cpuid.h"
#include <allegro.h>
#include <dos.h>
#undef TRUE
#undef FALSE

#include "snes9x.h"
#include "memmap.h"
#include "debug.h"
#include "cpuexec.h"
#include "ppu.h"
#include "snapshot.h"
#include "apu.h"
#include "display.h"
#include "gfx.h"
#include "soundux.h"
#include "cheats.h"
#include "cheat.h"
#include "port.h"

#include "gui.h"
#include "msdos.h"

uint32 joypads [5] = {0};
int NumControllers = 2;
extern volatile uint32 FrameTimer;

#define version_string TITLE " " VERSION

#ifdef JOYSTICK_SUPPORT
extern bool8 joysticks_have_four_buttons, joysticks_have_six_buttons;

#ifdef SIDEWINDER_SUPPORT
int InitSidewinders ();
int ReadSidewinders ();
#endif

bool8 joysticks_have_four_buttons = FALSE;
bool8 joysticks_have_six_buttons = FALSE;

void InitJoysticks ();
void ReadJoysticks ();
#endif

void InitTimer ();

void ReadIniDefaults(char * exefilename);

char *rom_filename = NULL;
char *snapshot_filename = NULL;
char rom_name [ROM_NAME_LEN];
uint8 force_screen = 0;

bool8 FastFPU=FALSE;

bool8 ForceFPU = FALSE, ForceFast = FALSE;

extern bool8 nothingloaded, Windows_Friendly;
extern bool8 SnesPro;
bool8 nothingloaded=TRUE, Windows_Friendly=TRUE;
bool8 SnesPro = FALSE;
int SP_pad2int(unsigned short int * pad1, unsigned short int * pad2);

extern char FileFormat[];
char FileFormat[80];

extern char ScreenShotPath[];
char ScreenShotPath[200], SnapshotPath[200], RomPath[200];

#ifdef DEBUGGER
extern FILE *trace;
#endif

bool8 UseGUI = TRUE;

void OutOfMemory ()
{
    fprintf (stderr, "\
Snes9X: Memory allocation failure - not enough RAM/virtual memory available.\n\
        Exiting...\n");
    Memory.DeInit ();
    S9xDeinitAPU ();
    
    exit (1);
}

extern int noiniinter;
int noiniinter = 0;
bool8 quietflag = FALSE;

void S9xParseArg (char **argv, int &i, int argc)
{
    if (strcmp (argv [i], "-2") == 0 ||
             strcasecmp (argv [i], "-two") == 0)
    {
	Settings.JoystickEnabled = 1;
    }
    if (strcmp (argv [i], "-4") == 0 ||
	     strcasecmp (argv [i], "-four") == 0)
    {
	joysticks_have_four_buttons = TRUE;
	Settings.JoystickEnabled = 1;
    }
    else if (strcmp (argv [i], "-6") == 0 ||
	     strcasecmp (argv [i], "-six") == 0)
    {
	joysticks_have_six_buttons = TRUE;
	Settings.JoystickEnabled = 1;
    }
    else if (strcmp (argv [i], "-j") == 0 ||
	     strcasecmp (argv [i], "-nojoy") == 0)
	Settings.JoystickEnabled = 0;
    else if (strcasecmp (argv [i], "-fauto") == 0)
    {
        Settings.SkipFrames = AUTO_FRAMERATE;
    }
    else if (strcasecmp (argv [i], "-nogui") == 0)
        UseGUI = FALSE;
    else if (strcmp (argv [i], "-B") == 0 ||
	     strcasecmp (argv [i], "-buffersize") == 0)
    {
	if (i + 1 < argc)
	    Settings.SoundBufferSize = atoi (argv [++i]);
	else
            S9xUsage ();
    }
    else if (strcmp (argv [i], "-l") == 0 ||
	     strcasecmp (argv [i], "-loadsnapshot") == 0)
    {
	if (i + 1 < argc)
	    snapshot_filename = argv [++i];
	else
            S9xUsage ();
    }
    else
        S9xParseDisplayArg (argv, i, argc);
}

int main (int argc, char **argv)
{
    _crt0_startup_flags = _CRT0_FLAG_FILL_SBRK_MEMORY;
    int i;
    bool8 autoGUI = FALSE;
    char ID[160];
    int cclass, stepp;
    bool8 FPUflag, MMXflag;

    CPUID((char*)&ID, (int*)&cclass, (int*)&stepp, (bool8*)&FPUflag, (bool8*)&FastFPU, (bool8*)&MMXflag);

    if (argc < S9xMinCommandLineArgs ())
    {
       quietflag = TRUE;
       autoGUI = TRUE;
    }

    rom_filename = S9xParseArgs (argv, argc);

    ReadIniDefaults(argv[0]);

    S9xParseArgs1 (argv, argc);      // snesroms.ini may have overridden some settings!

    UseGUI = TRUE;

    puts(version_string);

    if ((UseGUI == FALSE) && (rom_filename != NULL))
    {
        S9xUsage ();
        exit(0);
    }

    if (rom_filename == NULL)
    {
       quietflag = TRUE;
       autoGUI = TRUE;
    }

    if (!Memory.Init () || !S9xInitAPU())
	OutOfMemory ();

    if (!quietflag)
    {
        printf(Bullet "Loading ROM into memory...");
        fflush(stdout);
    }

    uint32 saved_flags = CPU.Flags;
    if (!snapshot_filename)
    {
        if (rom_filename)
        {
            if (!Memory.LoadROM (rom_filename) && !autoGUI)
            {
                char dir [_MAX_DIR];
                char drive [_MAX_DRIVE];
                char name [_MAX_FNAME];
                char ext [_MAX_EXT];
                char fname [_MAX_PATH];

                _splitpath (rom_filename, drive, dir, name, ext);
                _makepath (fname, drive, dir, name, ext);

                strcpy (fname, S9xGetROMDirectory ());
                strcat (fname, SLASH_STR);
                strcat (fname, name);
                if (ext [0])
                {
                    strcat (fname, ".");
                    strcat (fname, ext);
                }
                _splitpath (fname, drive, dir, name, ext);
                _makepath (fname, drive, dir, name, ext);
                if (!Memory.LoadROM (fname))
                {
                    printf ("Error opening: %s\n", rom_filename);
                    exit (1);
                }
            }
            Memory.LoadSRAM (S9xGetSRAMFilename ());
	}
	else
	{
	    S9xReset ();
	    Settings.Paused |= 2;
	}
    }
    CPU.Flags = saved_flags;

    if (rom_filename)
        nothingloaded=FALSE;
    else
        nothingloaded=TRUE;

    S9xInitInputDevices ();

#ifdef SIDEWINDER_SUPPORT
    InitSidewinders ();
#endif
#ifdef JOYSTICK_SUPPORT
    InitJoysticks ();
#endif

    if (!quietflag)
    {
       printf("done!\n");
       fflush(stdout);
       uint8 rom_size;
       uint8 rom_speed;
    
       if (Memory.HiROM)
       {
           strncpy (rom_name, (char *) &Memory.ROM[0xffc0], ROM_NAME_LEN - 1);
           rom_speed = Memory.ROM [0xffd5];
           rom_size = Memory.ROM [0xffd7];
       }
       else
       {
           rom_speed = Memory.ROM [0x7fd5];
           rom_size = Memory.ROM [0x7fd7];
           strncpy (rom_name, (char *) &Memory.ROM[0x7fc0], ROM_NAME_LEN - 1);
       }

       printf (Bullet "ROM Name: %s\n" Bullet "%s, Size: %dMbits, Speed: %s, TV standard: %s, S-RAM: %dKbits\n",
               rom_name, Memory.HiROM ? "HiROM" : "LoROM",
               1 << (rom_size - 7),
               rom_speed & 0xf0 ? "120ns" : "200ns",
               Settings.PAL ? "PAL" : "NTSC", ((Memory.SRAMMask + 1) / 1024) * 8);
    }
    S9xInitDisplay (argc, argv);

extern int sidewinder_present;
    if (Settings.JoystickEnabled || sidewinder_present)
    {
        if (!quietflag)
            printf (Bullet "Joysticks... ");
        if (!sidewinder_present)
            if (initialise_joystick())
            {
                if (!quietflag)
                    printf("Not detected\n");      
                Settings.JoystickEnabled = 0;  //Not available, so turn it off.
            }
            else
            {
                if (!quietflag)
                {
                    printf("Present, using ");
                    if (joysticks_have_four_buttons)
                       printf("4 buttons.\n");
                    else if (joysticks_have_six_buttons)
                       printf("6 buttons.\n");
                    else
                       printf("2 buttons.\n");
                }
            }
        else
            printf("Microsoft Sidewinder.\n");
    }
    if (!quietflag)
    {
        printf(Bullet "CPU detected: %s (%s-speed FPU)\n", ID, FastFPU ? "Low":"High");
    }
    if (ForceFPU)
       if (ForceFast)
          FastFPU = TRUE;
       else
          FastFPU = FALSE;
    if (!quietflag)
    {
        if (FastFPU) printf(Bullet "Fast FPU strings\n");
        printf(Bullet "Running under: ");
        _get_dos_version(1);
        if (windows_version == 4 && windows_sub_version == 0)
           printf("Windows 95 and %s %i.%i\n", _os_flavor, _osmajor, _osminor);
        else
           if (windows_version == 0x100)
               printf("Windows NT\n");
           else if (windows_version == 4 && windows_sub_version == 10)
                    printf("Windows 98 and %s %i.%i\n", _os_flavor, _osmajor, _osminor);
                else if (windows_version != 0)
                    printf("Windows %i.%i and %s %i.%i\n", windows_version, windows_sub_version,
                                                _os_flavor, _osmajor, _osminor);
                else
                    printf("%s %i.%i\n", _os_flavor, _osmajor, _osminor);
    }
    if (!S9xGraphicsInit ())
	OutOfMemory ();

    S9xTextMode ();
    CheatInit ();

    atexit((void *)ClearCheatResults);

    if (!quietflag)
    {
        printf(Bullet "Initialising sound: ");
    }
    fflush(stdout);
    /*
    (void) S9xInitSound (Settings.SoundPlaybackRate, Settings.Stereo,
                      Settings.SoundBufferSize);
    */
    if (!Settings.APUEnabled)
        S9xSetSoundMute (TRUE);

    if (snapshot_filename)
    {
	int Flags = CPU.Flags & (DEBUG_MODE_FLAG | TRACE_FLAG);
        if (!S9xLoadSnapshot (snapshot_filename))
	    exit (1);
	CPU.Flags |= Flags;
    }
    if (!quietflag)
    {
        printf("\nPress any key to proceed.\n");
        while (!kbhit());
        fade_out(8);
    }
    S9xGraphicsMode ();

    sprintf (String, "\"%s\" %s: %s", rom_name, TITLE, VERSION);
    S9xSetTitle (String);

    int count = 0;
#ifdef JOYSTICK_SUPPORT
    uint16 JoypadSkip = 0;
#endif

    InitTimer ();
    if (!Settings.APUEnabled)
        S9xSetSoundMute (FALSE);

    //sb_unmute_sound();

    if (autoGUI)
    {
       Exit();
       autoGUI = FALSE;
    }

    while (1)
    {
	if (!Settings.Paused
#ifdef DEBUGGER
	    || (CPU.Flags & (DEBUG_MODE_FLAG | SINGLE_STEP_FLAG))
#endif
           )
            S9xMailLoop ();

	if (Settings.Paused
#ifdef DEBUGGER
	    || (CPU.Flags & DEBUG_MODE_FLAG)
#endif
           )
	{
            S9xSetSoundMute (TRUE);
	}

#ifdef DEBUGGER
	if (CPU.Flags & DEBUG_MODE_FLAG)
	{
            S9xDoDebug ();
	}
	else
#endif
	if (Settings.Paused)
            S9xProcessEvents (TRUE);

#ifdef JOYSTICK_SUPPORT
	if (Settings.JoystickEnabled && (JoypadSkip++ & 1) == 0)
	    ReadJoysticks ();
#endif	

        S9xProcessEvents (FALSE);
        ApplyConstants();
	
	if (!Settings.Paused
#ifdef DEBUGGER
	    && !(CPU.Flags & DEBUG_MODE_FLAG)
#endif	    
           )
	{
            S9xSetSoundMute (FALSE);
	}
    }
    return (0);
}

// User wants to exit routine.
void Exit ()
{
#ifndef NOGUI
    S9xTextMode();
    S9xSetSoundMute (TRUE);
    if (UseGUI)
        if (mainmnu()==-1) {
            S9xDeinitDisplay ();
            //DeInitTimer();
            Memory.SaveSRAM (S9xGetSRAMFilename ());
            Memory.DeInit ();
            S9xDeinitAPU ();
            exit (0);
        }
        else {
            S9xGraphicsMode();
            FrameTimer = 1;
            if (Settings.APUEnabled)
                S9xSetSoundMute (FALSE);
            return;
        }
    S9xDeinitDisplay ();
    //DeInitTimer();
    Memory.SaveSRAM (S9xGetSRAMFilename ());
    Memory.DeInit ();
    S9xDeinitAPU ();
    exit (0);
#else
    S9xDeinitDisplay ();
    //DeInitTimer();
    Memory.SaveSRAM (S9xGetSRAMFilename ());
    Memory.DeInit ();
    S9xDeinitAPU ();
    exit (0);
#endif
}

void S9xExit()
{
   FatalExit("End session.");
}

// Fatal Error exit route.
void FatalExit (char * Str)
{
    S9xDeinitDisplay ();
    //DeInitTimer();
    Memory.SaveSRAM (S9xGetSRAMFilename ());
    Memory.DeInit ();
    S9xDeinitAPU ();
    set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
    printf("FATAL ERROR: %s\n", Str);
    exit (0);
}

const char *GetHomeDirectory ()
{
#ifdef __MSDOS
    return (".");
#else
    return (getenv ("HOME"));
#endif
}

const char *S9xGetSnapshotDirectory ()
{
    static char filename [PATH_MAX];
    const char *snapshot;
    
    if (!(snapshot = getenv ("SNES96_SNAPSHOT_DIR")))
    {
        if (strcmp(SnapshotPath, "") != 0)
        {
            strcpy (filename, SnapshotPath);
            mkdir (filename, 0777);
        }
        else
        {
            strcpy (filename, "");
        }
    }
    else
	return (snapshot);

    return (filename);
}

const char *S9xGetSRAMFilename ()
{
    static char filename [PATH_MAX];
    char drive [_MAX_DRIVE];
    char dir [_MAX_DIR];
    char fname [_MAX_FNAME];
    char ext [_MAX_EXT];

    _splitpath (Memory.ROMFilename, drive, dir, fname, ext);
    strcpy (filename, S9xGetSnapshotDirectory ());
    if (strcmp(filename, "") == 0)
    {
        fnmerge( filename, drive, dir, fname, ".srm");
    }
    else
    {
        strcat (filename, SLASH_STR);
        strcat (filename, fname);
        strcat (filename, ".srm");
    }

    return (filename);
}

const char *S9xGetROMDirectory ()
{
    const char *roms;
    
    if (strcmp(RomPath, "") != 0)
        return RomPath;
    else
        if (!(roms = getenv ("SNES96_ROM_DIR")))
            return ("");
        else
            return (roms);
}

const char *basename (const char *f)
{
    const char *p;
    if ((p = strrchr (f, '/')) != NULL || (p = strrchr (f, '\\')) != NULL)
	return (p + 1);

#ifdef __DJGPP
    if (p = strrchr (f, SLASH_CHAR))
	return (p + 1);
#endif

    return (f);
}

const char *S9xChooseFilename (bool8 read_only)
{
    char def [PATH_MAX];
    char title [PATH_MAX];
    char drive [_MAX_DRIVE];
    char dir [_MAX_DIR];
    char ext [_MAX_EXT];

    fnsplit (Memory.ROMFilename, drive, dir, def, ext);
    //strcat (def, ".s96");
    sprintf (title, "%s snapshot filename",
	    read_only ? "Select load" : "Choose save");
    const char *filename;

    S9xSetSoundMute (TRUE);
    filename = S9xSelectFilename (def, S9xGetSnapshotDirectory (), "s96", title);
    S9xSetSoundMute (FALSE);
    return (filename);
}

bool8 S9xOpenSnapshotFile (const char *fname, bool8 read_only, STREAM *file)
{
    char filename [PATH_MAX];
    char drive [_MAX_DRIVE];
    char dir [_MAX_DIR];
    char ext [_MAX_EXT];

    char filename2 [PATH_MAX];
    char ext2 [_MAX_EXT];

    fnsplit (fname, drive, dir, filename, ext);

    if (*drive || *dir == '/' ||
	*dir == '\\' ||
	(*dir == '.' && (*(dir + 1) == '/'
                         || *(dir + 1) == '\\'
        )))
    {
	strcpy (filename, fname);
        if (ext[1] == 0 || ext[0] == 0)
            strcat (filename, ".s96");
    }
    else
    {
        strcpy (filename, S9xGetSnapshotDirectory ());
        if (strcmp(filename, "") == 0)
        {
            fnsplit (Memory.ROMFilename, drive, dir, filename2, ext2);
            fnmerge (filename, drive, dir, fname, "");
        }
        else
        {
            strcat (filename, SLASH_STR);
            strcat (filename, fname);
            if (ext[1] == 0 || ext[0] == 0)
                strcat (filename, ".s96");
        }
    }
    char command [PATH_MAX];
    
#ifdef ZLIB
    if (read_only)
    {
	if (*file = OPEN_STREAM (filename, "rb"))
	    return (TRUE);
    }
    else
    {
	if (*file = OPEN_STREAM (filename, "wb"))
	    return (TRUE);
    }
#else
    if (read_only)
    {
	sprintf (command, "gzip -d <\"%s\"", filename);
	if (*file = popen (command, "r"))
	    return (TRUE);
    }
    else
    {
	sprintf (command, "gzip --best >\"%s\"", filename);
	if (*file = popen (command, "wb"))
	    return (TRUE);
    }
#endif
    return (FALSE);
}

void S9xCloseSnapshotFile (STREAM file)
{
#ifdef ZLIB
    CLOSE_STREAM (file);
#else
    pclose (file);
#endif
}

bool8 S9xInitUpdate ()
{
    return (TRUE);
}

void _makepath (char *path, const char *drive, const char *dir,
		const char *fname, const char *ext)
{
    fnmerge (path, drive, dir, fname, ext);

/*
    if (drive && *drive)
    {
	*path = *drive;
	*(path + 1) = ':';
	*(path + 2) = 0;
    }
    else
	*path = 0;
	
    if (dir && *dir)
    {
	strcat (path, dir);
        if ((*(dir + strlen(dir))) != SLASH_STR)
            strcat (path, SLASH_STR);
    }
	
    strcat (path, fname);
    if (ext && *ext)
    {
        if ((*ext) != ".")
            strcat (path, ".");
        strcat (path, ext);
    }*/
}

void _splitpath (const char *path, char *drive, char *dir, char *fname,
		 char *ext)
{
    if (*path && *(path + 1) == ':')
    {
	*drive = toupper (*path);
	path += 2;
    }
    else
	*drive = 0;

    char *slash = strrchr (path, SLASH_CHAR);
    if (!slash)
	slash = strrchr (path, '/');
    char *dot = strrchr (path, '.');
    if (dot && slash && dot < slash)
	dot = NULL;

    if (!slash)
    {
	strcpy (dir, "");
	strcpy (fname, path);
        if (dot)
        {
	    *(fname + (dot - path)) = 0;
	    strcpy (ext, dot + 1);
        }
	else
	    strcpy (ext, "");
    }
    else
    {
	strcpy (dir, path);
	if (slash - path == 0)
	    *(dir + 1) = 0;
	else
	    *(dir + (slash - path)) = 0;
	strcpy (fname, slash + 1);
        if (dot)
	{
	    *(fname + (dot - slash) - 1) = 0;
    	    strcpy (ext, dot + 1);
	}
	else
	    strcpy (ext, "");
    }
}

void S9xToggleSoundChannel (int c)
{
    static int channel_enable = 255;
    if (c == 8)
	channel_enable = 255;
    else
	channel_enable ^= 1 << c;
    S9xSetSoundControl (channel_enable);
}

extern char S9X_IniFilename[];
char S9X_IniFilename[256];

void ReadIniDefaults(char * exefilename)
{
   char sdrv[3], sdir[200], sfile[200], sext[200], inifn[256];
   char S[200] = {0}, S1[200] = {0};
   int i, q;

   fnsplit (exefilename, sdrv, sdir, sfile, sext);
   fnmerge (inifn, sdrv, sdir, sfile, ".ini");
   strcpy (S9X_IniFilename, inifn);
   itoa(Settings.SkipFrames - 1, S1, 10);
   GetPrivateProfileString ("SNES9X", "FrameRate", S1, S, 200, inifn);
   if (strnicmp(S, "Auto", 4) == 0)
       Settings.SkipFrames = AUTO_FRAMERATE;
   else
       Settings.SkipFrames = atoi(S) + 1;
   Settings.BGLayering = GetPrivateProfileInt ("SNES9X", "Layering", Settings.BGLayering, inifn);
   //Settings.OldStyleJoypadsEnable = GetPrivateProfileInt("SNES9X", "OldStyleJoypadsEnable",
   //                                 Settings.OldStyleJoypadsEnable, inifn);
   Settings.Shutdown = GetPrivateProfileInt("SNES9X", "IdleDetect", Settings.Shutdown, inifn);
   Settings.APUEnabled = GetPrivateProfileInt("SNES9X", "SPCEmulation", Settings.APUEnabled, inifn);
   Settings.SoundSkipMethod = GetPrivateProfileInt("SNES9X", "SoundSkipper", Settings.SoundSkipMethod, inifn);

   GetPrivateProfileString("DOS Version", "JoystickSettings", "0", S, 200, inifn);
   i = atoi(S);
   if (strnicmp("SnesPro", S, 7) == 0)
      SnesPro = TRUE;
   else if (i==0)
   {
      Settings.JoystickEnabled = FALSE;
   }
   else if (i==2)
   {
      Settings.JoystickEnabled = TRUE;
      joysticks_have_four_buttons = FALSE;
      joysticks_have_six_buttons = FALSE;
   }
   else if (i==4)
   {
      Settings.JoystickEnabled = TRUE;
      joysticks_have_four_buttons = TRUE;
      joysticks_have_six_buttons = FALSE;
   }
   else if (i==6)
   {
      Settings.JoystickEnabled = TRUE;
      joysticks_have_four_buttons = FALSE;
      joysticks_have_six_buttons = TRUE;
   }
   Settings.SoundPlaybackRate = GetPrivateProfileInt("DOS Version", "SoundPlaybackRate", Settings.SoundPlaybackRate, inifn);
   Settings.Stereo = GetPrivateProfileInt("DOS Version", "Stereo", Settings.Stereo, inifn);
   //Settings.FastRedraw = GetPrivateProfileInt("SNES9X", "TileBasedRedraw", Settings.FastRedraw, inifn);
   extern int vid_mode, vid_xres, vid_yres, vid_adaptor;
   itoa(vid_mode, S1, 10);
   GetPrivateProfileString("DOS Version", "VideoMode", S1, S, 200, inifn);
   if (strnicmp(S, "custom", 6)!=0)
       vid_mode=atoi(S);
   else
   {
       vid_mode = 255;
       vid_adaptor = GetPrivateProfileInt("DOS Version", "VideoAdaptor", 2, inifn);
       vid_xres = GetPrivateProfileInt("DOS Version", "VideoXRes", 320, inifn);
       vid_yres = GetPrivateProfileInt("DOS Version", "VideoYRes", 240, inifn);
   }
   Windows_Friendly = GetPrivateProfileInt("DOS Version", "WindowsFriendly", Windows_Friendly, inifn);
   i = GetPrivateProfileInt("DOS Version", "AllowGUI", 1, inifn);

   if (i==0)
      UseGUI=FALSE;
   else if (i==1)
   {
      UseGUI = TRUE;
      SaveResolution = TRUE;
      UseSFX = TRUE;
   }
   else if (i==2)
   {
      UseGUI = TRUE;
      SaveResolution = TRUE;
      UseSFX = FALSE;
   }
   else if (i==3)
   {
      UseGUI = TRUE;
      SaveResolution = FALSE;
      UseSFX = TRUE;
   }
   else if (i==4)
   {
      UseGUI = TRUE;
      SaveResolution = FALSE;
      UseSFX = FALSE;
   }
   else
   {
      UseGUI = TRUE;
      SaveResolution = FALSE;
      UseSFX = FALSE;
   }
   GetPrivateProfileString("DOS Version", "FPUStrings", "Auto", S, 200, inifn);
   if (strnicmp(S, "yes", 3)==0)
   {
       ForceFPU = TRUE;
       ForceFast = TRUE;
   }
   else if (strnicmp(S, "no", 2)==0)
   {
       ForceFPU = TRUE;
       ForceFast = FALSE;
   }
   else
       ForceFPU = FALSE;
   GetPrivateProfileString("DOS Version", "SnapFormat", "PCX", S, 200, inifn);
   if (strnicmp(S, "PCX", 3)==0)
      strcpy(FileFormat, ".PCX");
   else if (strnicmp(S, "TGA", 3)==0)
      strcpy(FileFormat, ".TGA");
   else
      strcpy(FileFormat, ".PCX");
   GetPrivateProfileString("DOS Paths", "ScreenShotPath", "", ScreenShotPath, 200, inifn);
   GetPrivateProfileString("DOS Paths", "SnapshotPath", ".\\snesnaps", SnapshotPath, 200, inifn);
   GetPrivateProfileString("DOS Paths", "RomPath", ".\\roms", RomPath, 200, inifn);

   GradientClr1 = GetPrivateProfileInt("DOS Version", "GUIGradient1", GradientClr1, inifn);
   GradientClr2 = GetPrivateProfileInt("DOS Version", "GUIGradient2", GradientClr2, inifn);
}

void ReadGameDefaults();
void ReadGameDefaults()
{
   int i;

   //if (!(noiniinter & 1))
   //   Settings.Interleaved = GetPrivateProfileInt(rom_name, "De-Interleave", Settings.Interleaved, "SNESROMS.INI");
   //Settings.FastRedraw = GetPrivateProfileInt(rom_name, "TileBasedRedraw", Settings.FastRedraw, "SNESROMS.INI");
   Settings.SoundSkipMethod = GetPrivateProfileInt(rom_name, "SoundSkipper", Settings.SoundSkipMethod, "SNESROMS.INI");
   Settings.APUEnabled = GetPrivateProfileInt(rom_name, "SPCEmulation", Settings.APUEnabled, "SNESROMS.INI");
   Settings.Shutdown = GetPrivateProfileInt(rom_name, "IdleDetect", Settings.Shutdown, "SNESROMS.INI");
   i = GetPrivateProfileInt(rom_name, "H-Cycles", -1, "SNESROMS.INI");
   if (i != -1)
      Settings.H_Max = (SNES_CYCLES_PER_SCANLINE * i) / 100;
   Settings.DisableGraphicWindows = GetPrivateProfileInt(rom_name, "NoWindowing", Settings.DisableGraphicWindows, "SNESROMS.INI");
   //Settings.OldStyleJoypadsEnable = GetPrivateProfileInt(rom_name, "OldStyleJoypadsEnable", Settings.OldStyleJoypadsEnable, "SNESROMS.INI");
   Settings.ForcePAL = GetPrivateProfileInt(rom_name, "ForcePAL", Settings.ForcePAL, "SNESROMS.INI");
   Settings.ForceNTSC = GetPrivateProfileInt(rom_name, "ForceNTSC", Settings.ForceNTSC, "SNESROMS.INI");
   Settings.BGLayering = GetPrivateProfileInt(rom_name, "BGLayering", Settings.BGLayering, "SNESROMS.INI");
   if (!(noiniinter & 2))
   {
       Memory.HiROM = GetPrivateProfileInt(rom_name, "ForceHiROM", Memory.HiROM, "SNESROMS.INI");
       Memory.LoROM = GetPrivateProfileInt(rom_name, "ForceLoROM", Memory.LoROM, "SNESROMS.INI");
   }

   noiniinter = 0;
}

bool8 DeS9xInitUpdate (int Width, int Height, bool8 sixteen_bit)
{
    S9xPutImage (Width, Height);
#if 0
    extern int plot2_count, plot4_count, plot8_count, plotobj_count;

    printf ("\r%5d, %5d, %5d, %5d", plot2_count, plot4_count, plot8_count, plotobj_count);
    plot2_count = 0;
    plot4_count = 0;
    plot8_count = 0;
    plotobj_count = 0;
    fflush (stdout);
#endif
    return (TRUE);
}

static unsigned long now ()
{
    static unsigned long seconds_base = 0;
    struct timeval tp;
    gettimeofday (&tp, NULL);
    if (!seconds_base)
	seconds_base = tp.tv_sec;

    return ((tp.tv_sec - seconds_base) * 1000 + tp.tv_usec / 1000);
}

void OutputFrameRate ()
{
    static int FrameCount = 0;
    static unsigned long then = now ();

    if (++FrameCount % 60 == 0)
    {
	unsigned long here = now ();
//	printf ("\rFrame rate: %.2lfms", (double) (here - then) / 60);
//	fflush (stdout);
	then = here;
    }
}

static long log2 (long num)
{
    long n = 0;

    while (num >>= 1)
	n++;

    return (n);
}

static long power (int num, int pow)
{
    long val = num;
    int i;
    
    if (pow == 0)
	return (1);

    for (i = 1; i < pow; i++)
	val *= num;

    return (val);
}

uint32 ReadSNESJoypad (int which1)
{
    if (which1 < 4)
    {
	return (0xc0000000 | joypads [which1 << 1] |
		(joypads [(which1 << 1) + 1] << 8));
    }
    return (0);
}

bool8 ReadMousePosition (int which1, int &x, int &y, uint32 &buttons)
{
    return (FALSE);
}


#ifdef SIDEWINDER_SUPPORT
int SidewinderToSNES [] =
{
    SNES_UP_MASK, SNES_DOWN_MASK, SNES_RIGHT_MASK, SNES_LEFT_MASK,
    SNES_A_MASK, SNES_B_MASK, SNES_A_MASK, 
    SNES_X_MASK, SNES_Y_MASK, SNES_X_MASK, 
    SNES_TL_MASK, SNES_TR_MASK,
    SNES_START_MASK, SNES_SELECT_MASK
};
#endif

void PrintMessage(int MessageType, char * Message)
{
}

uint32 S9xReadJoypad (int which1)
{
    if (which1 < NumControllers)
	return (0x80000000 | joypads [which1]);
    return (0);
}


