/* IRQ.C - IRQ handling routines ripped from Allegro

   Currently not used, but will be used if allegro is drastically
   modified in the future.
*/

#include <stdlib.h>
#include <dos.h>
#include <go32.h>
#include <dpmi.h>

#include <allegro.h>
#include "sb.h"

#define MAX_IRQS     4           /* timer + keyboard + soundcard + spare */
#define STACK_SIZE   8*1024      /* 8k stack should be plenty */
#define IRQ_STACKS      8

int _sb_install_irq(int num, int (*handler)());
void _sb_remove_irq(int num);

typedef struct _SB_IRQ_HANDLER
{
   int (*handler)();             /* our C handler */
   int number;                   /* irq number */
   __dpmi_paddr old_vector;      /* original protected mode vector */
} _SB_IRQ_HANDLER;




static int irq_virgin = TRUE;

_SB_IRQ_HANDLER _sb_irq_handler[MAX_IRQS];

unsigned char *_sb_irq_stack[IRQ_STACKS];

extern void _sb_irq_wrapper_0(), _sb_irq_wrapper_1(), 
            _sb_irq_wrapper_2(), _sb_irq_wrapper_3(),
            _sb_irq_wrapper_0_end();



/* _sb_install_irq:
 *  Installs a hardware interrupt handler for the specified irq, allocating
 *  an asm wrapper function which will save registers and handle the stack
 *  switching. The C function should return zero to exit the interrupt with 
 *  an iret instruction, and non-zero to chain to the old handler.
 */
int _sb_install_irq(int num, int (*handler)())
{
   int c;
   __dpmi_paddr addr;

   if (irq_virgin) {                /* first time we've been called? */
      LOCK_VARIABLE(_sb_irq_handler);
      LOCK_VARIABLE(_sb_irq_stack);
      LOCK_FUNCTION(_sb_irq_wrapper_0);

      for (c=0; c<MAX_IRQS; c++) {
         _sb_irq_handler[c].handler = NULL;
         _sb_irq_handler[c].number = 0;
      }

      for (c=0; c<IRQ_STACKS; c++) {
         _sb_irq_stack[c] = malloc(STACK_SIZE);
         if (_sb_irq_stack[c]) {
            _go32_dpmi_lock_data(_sb_irq_stack[c], STACK_SIZE);
            _sb_irq_stack[c] += STACK_SIZE - 32;   /* stacks grow downwards */
	 }
      }

      irq_virgin = FALSE;
   }

   for (c=0; c<MAX_IRQS; c++) {
      if (_sb_irq_handler[c].handler == NULL) {

	 addr.selector = _my_cs();

	 switch (c) {
            case 0: addr.offset32 = (long)_sb_irq_wrapper_0; break;
            case 1: addr.offset32 = (long)_sb_irq_wrapper_1; break;
            case 2: addr.offset32 = (long)_sb_irq_wrapper_2; break;
            case 3: addr.offset32 = (long)_sb_irq_wrapper_3; break;
	    default: return -1;
	 }

         _sb_irq_handler[c].handler = handler;
         _sb_irq_handler[c].number = num;

	 __dpmi_get_protected_mode_interrupt_vector(num, 
                                                &_sb_irq_handler[c].old_vector);

         if (__dpmi_set_protected_mode_interrupt_vector(num, &addr)) {
            puts("ERR!");
            return -1;
         }

	 return 0;
      }
   }

   return -1;
}



/* _sb_remove_irq:
 *  Removes a hardware interrupt handler, restoring the old vector.
 */
void _sb_remove_irq(int num)
{
   int c;

   for (c=0; c<MAX_IRQS; c++) {
      if (_sb_irq_handler[c].number == num) {
         if (__dpmi_set_protected_mode_interrupt_vector(num, 
                                                &_sb_irq_handler[c].old_vector)) {
            puts("ERR!");
            return -1;
         }

         _sb_irq_handler[c].number = 0;
         _sb_irq_handler[c].handler = NULL;

	 break;
      }
   }
}

