#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <io.h>

#include "inifuncs.h"

struct inikeystructure
{
    char * Key;
    char * Value;
    inikeystructure * next;
    char   flags;
};

struct inisectionstruct
{
    char * section;
    inikeystructure * first;
    char   flags;
};

#define ini_comment 1
#define ini_empty   2
#define ini_invalid 4

inikeystructure LoadedIniKeys[20000];   // 20000 line maximum in ini file.
inisectionstruct LoadedIniSect[1000];   // 1000 sections maximum.
char LoadedIni[255] = "", * FileData;
int FileDataLen=0;
int LastSection=0, LastKey=0;

char * FindEOL (char * p)
{
   int found = 0;
   char * c;
   while (*p != 0 && found == 0)
     if (*p == 13)
     {
        *p = 0;
        c = p;
        p++;
        found = 1;
        if (*p == 10)
        {
           *p = 0;
           p++;
        }
     }
     else if (*p == 10)
     {
        *p = 0;
        c = p;
        p++;
        found = 1;
     }
     else
        p++;
   c--;
   while (*c == 32)
   {
      *c = 0;
      c--;
   }
   return p;
}

void ParseStringToTree(char * contents, int len)
{
    char *p = contents, *c;
    int i, prematureeol = 0;

    LastSection = LastKey = 0;
    memset(LoadedIniKeys, 0, sizeof(LoadedIniKeys));
    memset(LoadedIniSect, 0, sizeof(LoadedIniSect));
    for (p=contents; (*p != 0) && (p != NULL);)
    {
        if (*p=='[')
        {
            LoadedIniSect[LastSection].section = p;
            LoadedIniSect[LastSection].first = &LoadedIniKeys[LastKey];
            if (LastKey)
               LoadedIniKeys[LastKey - 1].next = NULL;
            p = FindEOL(p);
            //printf("Found section %s\n", LoadedIniSect[LastSection].section);
            LastSection ++;
        }
        else
        {
            LoadedIniKeys[LastKey].next = &LoadedIniKeys[LastKey + 1];
            if (*p != 0 && *p != 10 && *p != 13)
            {
                LoadedIniKeys[LastKey].Key = p;
                if (*p != ';')
                {
                    p = strpbrk(p, "=\xA\xD");
                    if (p)
                    {
                       if (*p == 10 || *p == 13)   //  We're already at the end of line.
                          prematureeol = 1;        //  Current key is messed up.  Store no value.
                       else
                       {
                          *p = 0;
                          c = p;
                          p++;
                          c--;
                          while (*c == 32)
                          {
                             *c = 0;
                             c--;
                          }
                       }
                    }
                    while (*p == 32)
                       p++;
                    if (!prematureeol) // *p != 0 && *p != 10 && *p != 13 && 
                       LoadedIniKeys[LastKey].Value = p;
                    else
                    {
                       LoadedIniKeys[LastKey].Value = NULL;
                       LoadedIniKeys[LastKey].flags = ini_comment;
                    }
                }
                else
                {
                    LoadedIniKeys[LastKey].Value = NULL;
                    LoadedIniKeys[LastKey].flags = ini_comment;
                }
            }
            else
            {
                LoadedIniKeys[LastKey].Key = NULL;
                LoadedIniKeys[LastKey].Value = NULL;
                LoadedIniKeys[LastKey].flags = ini_empty;
            }
            prematureeol = 0;
            p = FindEOL(p);
            //if (LoadedIniKeys[LastKey].flags == ini_comment)
            //   printf("Found comment with text '%s'\n", LoadedIniKeys[LastKey].Key);
            //else if (LoadedIniKeys[LastKey].flags == ini_empty)
            //   printf("Found empty line.\n");
            //else
            //   printf("Found Key '%s' with value '%s'\n", LoadedIniKeys[LastKey].Key, LoadedIniKeys[LastKey].Value);
            LastKey ++;
        }
    }
    LoadedIniKeys[LastKey - 1].next = NULL;
}

int WritePrivateProfileString(char * Section, char* Entry, char * string, char * iniFilename)
{
    FILE * inifile, * testlog;
    int ourlength, i, found;
    static char Secttst[100], tempkey[100];
    inikeystructure * key, * lastkey;

    //testlog = fopen("C:\\TEST.LOG", "wa");
    if (strcmp(iniFilename, LoadedIni) != 0)
    {
        //fprintf(testlog, "Reading file into RAM.\n");
        inifile = fopen(iniFilename, "rb");
        if (!inifile)
        {
           inifile = fopen(iniFilename, "wa");
           //fprintf(inifile, "[%s]\n", Section);
           //fprintf(inifile, "%s=%s\n", Entry, string);
           fclose(inifile);
           return 0;
        }
        ourlength = filelength(fileno(inifile));
        if (FileData != NULL && (FileDataLen < ourlength + 2048))
        {
            free(FileData);
            FileData = NULL;
        }
        if (FileData == NULL)
        {
            FileDataLen = ourlength + 4096;
            FileData = (char*)calloc(ourlength + 4096, 1);
            if (FileData == NULL)
            {
                //fprintf(stderr, "Error allocating RAM.");
                return 0;
            }
        }
        fread(FileData, 1, ourlength, inifile);
        FileData[ourlength] = 0;  // make sure it's NULL terminated.
        fclose(inifile);
        ParseStringToTree(FileData, ourlength);
   }
   //fprintf(testlog, "Invalidate LoadedIni[].\n");
   strcpy(LoadedIni, "");   // Memory structures will be invalid now.
   // Now just have to find the key.....
   // But first the section.
   sprintf (Secttst, "[%s]", Section);
   i = 0;
   //fprintf(testlog, "Locate section.\n");
   while (LoadedIniSect[i].section != NULL)
   {
       //if (LoadedIniSect[i].section != NULL)
       //   fprintf(testlog, "Scanning section %s\n", LoadedIniSect[i].section);
       //else
       //   fprintf(testlog, "Scanning section (null)\n");
       if (stricmp(Secttst, LoadedIniSect[i].section) == 0)
          break;
       else
          i++;
   }
   //fprintf(testlog, "Section scan done.\n");
   key = LoadedIniSect[i].first;
   if (LoadedIniSect[i].section == NULL)
   {
       //fprintf(testlog, "Creating new section.\n");
       sprintf (Secttst, "\n[%s]", Section);  // Add a newline to the start...
       LoadedIniSect[LastSection].section = Secttst;
       LoadedIniSect[LastSection].first = &LoadedIniKeys[LastKey];
       i = LastSection;
       key = NULL;
       LastSection++;
   }
   //fprintf(testlog, "Locating key.\n");
   while (key != NULL)
   {
       lastkey = key;
       if (key -> Key != NULL)
       {
           if ((stricmp(Entry, key -> Key) == 0) && (key -> flags != ini_comment))
               break;
           //fprintf(testlog, "Scanning key %s with value %s.\n", key -> Key, key -> Value);
       }
       key = key -> next;
   }
   if (key != NULL)
       key -> Value = string;
   else
   {
       //fprintf(testlog, "Make new key.\n");
       key = &LoadedIniKeys[LastKey];
       if (lastkey)
          lastkey -> next = key;
       key -> Key = Entry;
       key -> Value = string;
       key -> flags = 0;
   }
   // Ok, now write it!.
   //fprintf(testlog, "Write out ini.\n");
   inifile = fopen(iniFilename, "wa");
   for (i=0; i<LastSection; i++)
   {
       //fprintf(testlog, "writing section %s.\n", LoadedIniSect[i].section);
       fprintf(inifile, "%s\n", LoadedIniSect[i].section);
       key = LoadedIniSect[i].first;
       while (key != NULL)
       {
          if (key -> flags == ini_comment)
              fprintf(inifile, "%s\n", key -> Key);
          else if (key -> flags == ini_empty)
              fprintf(inifile, "\n");
          else
              fprintf(inifile, "%s=%s\n", key -> Key, key -> Value);
          //fprintf(testlog, "writing key %s with value %s\n", key -> Key, key -> Value);
          key = key -> next;
       }
   }
   fclose(inifile);
   //fprintf(testlog, "Finished.  Returning.\n");
   //fclose(testlog);
}

/*
 * GetPrivateProfileInt -- Windows 3.x compatible
 *                         Reads an integer from an .ini file.
 */
int GetPrivateProfileInt(char * Section, char* Entry, int defaultval, char * iniFilename)
{
    static char strtmp[255], def[6];
    int value;

    itoa (defaultval, def, 10);
    GetPrivateProfileString(Section, Entry, def, strtmp, 255, iniFilename);
    sscanf(strtmp, "%i", &value);
    //printf("I found a key %s with value %s in section %s (read as %i)\n", Entry, strtmp, Section, value);
    return value;
}

/*
 * GetPrivateProfileString -- Windows 3.x compatible
 *                            Reads a string from an .ini file.
 */
int GetPrivateProfileString(char * Section, char* Entry, char * defaultstr, char * returnbuf, int size, char * iniFilename)
{
    FILE * inifile;
    int ourlength, i, found;
    char Secttst[100];
    inikeystructure * key;

    if (!returnbuf || !Section || !Entry || !iniFilename || !size)  // NULL return buffer.
       return 0;
    if (!defaultstr) // NULL default string.  Assume "" default.
       defaultstr = "";

    if (strcmp(iniFilename, LoadedIni) != 0)
    {
        inifile = fopen(iniFilename, "rb");
        if (!inifile)
        {
           if (strlen(returnbuf) > size)
               strncpy (returnbuf, defaultstr, size);
           else
               strcpy (returnbuf, defaultstr);
           returnbuf[size-1]=0;
           return 0;
        }
        strcpy(LoadedIni, iniFilename);
        ourlength = filelength(fileno(inifile));
        if (FileData != NULL && (FileDataLen < ourlength + 2048))
        {
            free(FileData);
            FileData = NULL;
        }
        if (FileData == NULL)
        {
            FileDataLen = ourlength + 4096;
            FileData = (char*)calloc(ourlength + 4096, 1);
            if (FileData == NULL)
            {
                fprintf(stderr, "Error allocating RAM.");
                return 0;
            }
        }
        fread(FileData, 1, ourlength, inifile);
        FileData[ourlength] = 0;  // make sure it's NULL terminated.
        fclose(inifile);
        ParseStringToTree(FileData, ourlength);
   }
   // Now just have to find the key.....
   // But first the section.
   sprintf (Secttst, "[%s]", Section);
   i = 0;
   while (LoadedIniSect[i].section != NULL)
   {
       if (stricmp(Secttst, LoadedIniSect[i].section) == 0)
          break;
       else
          i++;
   }
   if (LoadedIniSect[i].section == NULL)  // Section not found, return default.
   {
       if (strlen(defaultstr) > size)
          strncpy (returnbuf, defaultstr, size - 1); // idiot.
       else
          strcpy (returnbuf, defaultstr);
       returnbuf[size-1]=0;  // Force NULL terminate.
       return 0;
   }
   key = LoadedIniSect[i].first;
   while (key != NULL)
   {
       if (key -> Key != NULL)
           if ((stricmp(Entry, key -> Key) == 0) && (key -> flags != ini_comment))
               break;
       key = key -> next;
   }
   if (key != NULL)
   {
       if (strlen(key -> Value) > size)
           strncpy (returnbuf, key ->Value, size - 1);
       else
           strcpy (returnbuf, key -> Value);
       returnbuf[size-1]=0;
       return 1;
   }
   else
   {
       if (strlen(defaultstr) > size)
          strncpy (returnbuf, defaultstr, size - 1); // idiot.
       else
          strcpy (returnbuf, defaultstr);
       returnbuf[size-1]=0;  // Force NULL terminate.
       return 0;
   }
}
