#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <signal.h>
#include <dos.h>
#include <setjmp.h>
#include <string.h>
//static _go32_dpmi_seginfo badopcodeirq;

jmp_buf cpuid_jb;

bool trapped=false;

void BadOpcode (int q)
{
  trapped=true;
  longjmp(cpuid_jb, 1);
}

void CPUID(char * String, int * trueclass, int * stepping, bool * FPUflag, bool * fastfpu, bool * MMXflag)
{
   char processorstring[15], processorname[80];
   char S[160], S1[160];
   bool tryop=false;
   unsigned long int x, y, z, j, k;

   signal(SIGILL, BadOpcode);
   *trueclass = 4;  //Assume 486 without FPU
   *stepping = 0;
   *FPUflag = false;
   *MMXflag = false;
   *fastfpu = false;

   trapped=false;
   setjmp(cpuid_jb);
   if (!tryop)
   {
   tryop=true;
   asm __volatile__ ("
         movl $0x0, %%eax/n/t
         movl $0, %%edx/n/t
         movl $0, %%ecx/n/t
         movl $0, %%ebx/n/t
         cpuid
       "
       : "=b" (x),
         "=d" (y),
         "=c" (z)
       :
       : "%eax"
       );
   }
   else
   {
     signal(SIGILL, SIG_DFL);
     sprintf(String, "Unknown processor (386/486 class)");
     return;
   }
   signal(SIGILL, SIG_DFL);
   ((long*)(processorstring))[0]=x;
   ((long*)(processorstring))[1]=y;
   ((long*)(processorstring))[2]=z;
   processorstring[12]=0;
   x=0;
   y=0;
   z=0;
   asm __volatile__ ("
         movl $0, %%edx/n/t
         movl $0x1, %%eax/n/t
         cpuid
       "
       :"=a" (x),
        "=d" (y)
       :
       :"%ecx", "%ebx"
       );
  if (y&(1<<23))
    *MMXflag=true;
  else
    *MMXflag=false;
  if (y&(1<<0))
    *FPUflag=true;
  else
    *FPUflag=false;
  k=(x>>8)&15;
  j=(x>>4)&15;
  *stepping = (x&15);
  *trueclass = k;
  switch (k)
  {
      case 4:
             if (!strcmp(processorstring,"GenuineIntel"))
             switch(j)
             {
                        case 0:  strcpy(processorname,"Intel i80486DX-25/33");
                                 break;
                        case 1:  strcpy(processorname,"Intel i80486DX-50");
                                 break;
                        case 2:  strcpy(processorname,"Intel i80486SX");
                                 break;
                        case 3:  strcpy(processorname,"Intel i80486DX2");
                                 break;
                        case 4:  strcpy(processorname,"Intel i80486SL");
                                 break;
                        case 5:  strcpy(processorname,"Intel i80486SX2");
                                 break;
                        case 7:  strcpy(processorname,"Intel i80486DX2WB");
                                 break;
                        case 8:  strcpy(processorname,"Intel i80486DX4");
                                 break;
                        case 9:  strcpy(processorname,"Intel i80486DX4WB");
                                 break;
                        default: sprintf(processorname, "Intel 80486 class (model %i)", j);
             }
             else if (!strcmp(processorstring,"UMC UMC UMC "))
             switch (j)
             {
                        case 1:  strcpy(processorname,"UMC 486-class U5D");
                                 break;
                        case 2:  strcpy(processorname,"UMC 486-class U5S");
                                 break;
                        default: sprintf(processorname, "%s 80486 class (model %i)",processorstring, j);
             }
             else if (!strcmp(processorstring,"AuthenticAMD"))
             switch (j)
             {
                        case 3:  strcpy(processorname,"AMD 80486DX2");
                                 break;
                        case 7:  strcpy(processorname,"AMD 80486DX2WB");
                                 break;
                        case 8:  strcpy(processorname,"AMD 80486DX4");
                                 break;
                        case 9:  strcpy(processorname,"AMD 80486DX4WB");
                                 break;
                        case 14: strcpy(processorname,"AMD 5x86 (80486 class)");
                                 break;
                        case 15: strcpy(processorname,"AMD 5x86WB (80486 class)");
                                 break;
                        default: sprintf(processorname, "%s 80486 class (model %i)",processorstring, j);
             }
             else if (!strcmp(processorstring,"CyrixInstead"))
             switch (j)
             {
                        case 9:  strcpy(processorname,"Cyrix 5x86 (80486 class)");
                                 *trueclass = 5; //Hack for cyrix losers.
                                 break;
                        default: sprintf(processorname, "%s 80486 class (model %i)",processorstring, j);
                                 *trueclass = 5;
             }
             else
                sprintf(processorname, "%s 80486 class (model %i)",processorstring, j);
             break;
      case 5:
             if (!strcmp(processorstring,"GenuineIntel"))
             {
                 switch(j)
                 {
                        case 0:  strcpy(processorname,"Intel Pentium A-step");
                                 break;
                        case 1:  strcpy(processorname,"Intel Pentium");
                                 break;
                        case 2:  strcpy(processorname,"Intel Pentium (P54C)");
                                 break;
                        case 3:  strcpy(processorname,"Intel Pentium Overdrive");
                                 break;
                        case 4:  strcpy(processorname,"Intel Pentium (P55C or P54CTB)");
                                 break;
                        case 7:  strcpy(processorname,"Intel Pentium (P54C)");
                                 break;
                        default: sprintf(processorname, "Intel Pentium class (model %i)", j);
                 }
                 *fastfpu = true; //All true Intel Pentium's have fast FPU's.
             }
             else if (!strcmp(processorstring,"NexGenDriven"))
             switch (j)
             {
                        case 0:  strcpy(processorname,"NexGen Nx586 or Nx586FPU");
                                 break;
                        default: sprintf(processorname, "%s 80586 class (model %i)",processorstring, j);
             }
             else if (!strcmp(processorstring,"AuthenticAMD"))
             switch (j)
             {
                        case 0:  strcpy(processorname,"AMD K5 SSA5 (PR75, PR90, PR100)");
                                 break;
                        case 7:  strcpy(processorname,"AMD K5 5k86 (PR120, PR133)");
                                 break;
                        case 8:  strcpy(processorname,"AMD K5 5k86 (PR166)");
                                 break;
                        case 9:  strcpy(processorname,"AMD K5 5k86 (PR200)");
                                 break;
                        default: sprintf(processorname, "%s 80586 class (model %i)",processorstring, j);
             }
             else if (!strcmp(processorstring,"CyrixInstead"))
             switch (j)
             {
                        case 2:  strcpy(processorname,"Cyrix 6x86 (Pentium class)");
                                 break;
                        default: sprintf(processorname, "%s 80586 class (model %i)",processorstring, j);
             }
             else
                sprintf(processorname, "%s 80586 class (model %i)",processorstring, j);
             break;
      case 6:
             if (!strcmp(processorstring,"GenuineIntel"))
             {
                 switch (j)
                 {
                        case 0:  strcpy(processorname,"Intel PentiumPro A-step");
                                 break;
                        case 1:  strcpy(processorname,"Intel PentiumPro");
                                 break;
                        case 3:  strcpy(processorname,"Intel PentiumII");
                                 break;
                        case 5:  strcpy(processorname,"Intel 80686 class (PentiumII+)");
                                 break;
                        default: sprintf(processorname, "Intel PentiumPro class (model %i)", j);
                 }
                 *fastfpu = true; //This entire family has a pipelined FPU.
             }
             else if (!strcmp(processorstring,"AuthenticAMD"))
             switch (j)
             {
                        case 6:  strcpy(processorname,"AMD K6");
                                 *trueclass = 5;  // Use pentium optimizations, not PPro opt.
                                 *fastfpu = true; // I've heard good things about this FPU.
                                 break;
                        default: sprintf(processorname, "%s 80686 class (model %i)",processorstring, j);
             }
             else if (!strcmp(processorstring,"CyrixInstead"))
             switch (j)
             {
                        case 0:  strcpy(processorname,"Cyrix M2 (PentiumPro class)");
                                 *trueclass = 5;  // Use pentium optimizations, not PPro opt.
                                 break;
                        default: sprintf(processorname, "%s 80686 class (model %i)",processorstring, j);
             }
             else
                sprintf(processorname, "%s 80686 class (model %i)",processorstring, j);
             break;
      default:
             sprintf(processorname, "%s 80%i86 class (model %i)",processorstring, k, j);
  }
  sprintf(String, "%s (Stepping %i, ", processorname, *stepping);
  if (*MMXflag==true)
     strcat(String,"MMX, ");
  if (*FPUflag==true)
     strcat(String, "FPU");
  strcat(String, ")");
}
/*
void main()
{
  char ID[160];
  int cclass, stepp;
  bool flag1, flag2, flag3;
  CPUID((char*)&ID, (int*)&cclass, (int*)&stepp, (bool*)&flag1, (bool*)&flag2, (bool*)&flag3);
  puts(ID);
  printf("Class %i, stepping %i, FPU %i, FastFPU %i, MMX %i\n", cclass, stepp, flag1, flag2, flag3);
}

*/
