#include "snes9x.h"
#include "port.h"
#include "memmap.h"
#include "cheat.h"

struct SValueAddress {
        uint8   Memory;
        uint32  Address;
        uint8   Reference;
        uint8   Values[10];
} ValueAddress;

struct SConstants Constants[MAX_CHEATS];

uint8 PreviousValue;

char tempfile1[L_tmpnam] = "SNES9X.001",
     tempfile2[L_tmpnam] = "SNES9X.002";

bool8 CheatInit()
{
    // Generate temporary filenames.
    tmpnam(tempfile1);
    tmpnam(tempfile2);
    for (int i=0; i < MAX_CHEATS; i++)
        Constants[i].Enabled = FALSE;
    return TRUE;
}

/**********************************************************************************************/
bool8 FindChanged( uint8 Value)
{
gzFile CheatIN, CheatOUT;
uint32 Found = 0;
bool8 Match;
uint8 Byte;
static char Str[80];

	sprintf( Str, "Searching for %i[CHANGED]", Value);
        SetStatusInfo( Str, STATUS_WAIT);

        CheatIN = gzopen( tempfile1, "rb");
	if( CheatIN == NULL)
	{	return FindNearFirst( Value);	}
	gzclose( CheatIN);
        // SNES9X.001 exists, rename it to SNES9X.002
        rename( tempfile1, tempfile2);

        CheatOUT = gzopen( tempfile1, "wb9");
        CheatIN = gzopen( tempfile2, "rb");

	while( 1)
	{
		// Get the last found addresses out CheatIN
		gzread( CheatIN, &ValueAddress, sizeof( ValueAddress));

		// Finishing structure found, exicting
		if( ValueAddress.Memory == 0xFF && ValueAddress.Address == 0xFFFFFFFF)
			break;

		Match = FALSE;

		if( ValueAddress.Memory == 0)
		{
			// The same
			if( PreviousValue == Value)
                        if( Memory.SRAM[ ValueAddress.Address] == ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;
			// Changed
			if( PreviousValue != Value)
                        if( Memory.SRAM[ ValueAddress.Address] != ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;
                        Byte = Memory.SRAM[ ValueAddress.Address];
		}

		if( ValueAddress.Memory == 1)
		{
			// The same
			if( PreviousValue == Value)
                        if( Memory.RAM[ ValueAddress.Address] == ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;
			// Changed
			if( PreviousValue != Value)
                        if( Memory.RAM[ ValueAddress.Address] != ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;
                        Byte = Memory.RAM[ ValueAddress.Address];
		}

		if( Match)
		{
			// Increase the number of references
			ValueAddress.Reference ++;
			// Never get the history bigger then 10 values
			if( ValueAddress.Reference == 10)
			for( ValueAddress.Reference = 0; ValueAddress.Reference != 9; ValueAddress.Reference ++)
		 		 ValueAddress.Values[ValueAddress.Reference] = ValueAddress.Values[ValueAddress.Reference+1];
			// Save the current value
			ValueAddress.Values[ ValueAddress.Reference] = Byte;

			// Dump it to the CheatOUT buffer
			gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

			// Increase the number of addresses found
			Found ++;
		}
	}

	// Finishing structure 
        memset( &ValueAddress, 0xFF, sizeof( ValueAddress));
	gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

	gzclose( CheatIN);
	gzclose( CheatOUT);

	// Remove the OLD file
        remove( tempfile2);

	sprintf( Str, "%i[CHANGED] was found %i time(s)", Value, Found);
        SetStatusInfo( Str, STATUS_DONE);

	PreviousValue = Value;
	// Only 1 address found, always the correct one
	if( Found == 1)
	{
		ShowFound();
                sprintf( Str, "%i[CHANGED] was found.", Value);
                SetStatusInfo( Str, STATUS_FOUND);
		return TRUE;
	}
	return FALSE;
}

/**********************************************************************************************/
bool8 FindNear( uint8 Value)
{
gzFile CheatIN, CheatOUT;
uint32 Found = 0;
bool8 Match;
uint8 Byte;
static char Str[80];

	sprintf( Str, "Searching for %i[NEAR]", Value);
        SetStatusInfo( Str, STATUS_WAIT);

        CheatIN = gzopen( tempfile1, "rb");
	if( CheatIN == NULL)
	{	return FindNearFirst( Value);	}
	gzclose( CheatIN);
        // SNES9X.001 exists, rename it to SNES9X.002
        rename( tempfile1, tempfile2);

        CheatOUT = gzopen( tempfile1, "wb9");
        CheatIN = gzopen( tempfile2, "rb");

	while( 1)
	{
		// Get the last found addresses out CheatIN
		gzread( CheatIN, &ValueAddress, sizeof( ValueAddress));

		// Finishing structure found, exicting
		if( ValueAddress.Memory == 0xFF && ValueAddress.Address == 0xFFFFFFFF)
			break;

		Match = FALSE;

		if( ValueAddress.Memory == 0)
		{
			// Same as before
			if( Value == PreviousValue)
                        if( Memory.SRAM[ ValueAddress.Address] == ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;
			// Bigger as before
			if( Value > PreviousValue)
                        if( Memory.SRAM[ ValueAddress.Address] > ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;
			// Smaller as before
			if( Value < PreviousValue)
                        if( Memory.SRAM[ ValueAddress.Address] < ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;

                        Byte = Memory.SRAM[ ValueAddress.Address];
		}

		if( ValueAddress.Memory == 1)
		{
			// Same as before
			if( Value == PreviousValue)
                        if( Memory.RAM[ ValueAddress.Address] == ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;
			// Bigger as before
			if( Value > PreviousValue)
                        if( Memory.RAM[ ValueAddress.Address] > ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;
			// Smaller as before
			if( Value < PreviousValue)
                        if( Memory.RAM[ ValueAddress.Address] < ValueAddress.Values[ValueAddress.Reference])
				Match = TRUE;

                        Byte = Memory.RAM[ ValueAddress.Address];
		}

		if( Match)
		{
			// Increase the number of references
			ValueAddress.Reference ++;
			// Never get the history bigger then 10 values
			if( ValueAddress.Reference == 10)
			for( ValueAddress.Reference = 0; ValueAddress.Reference != 9; ValueAddress.Reference ++)
		 		 ValueAddress.Values[ValueAddress.Reference] = ValueAddress.Values[ValueAddress.Reference+1];
			// Save the current value
			ValueAddress.Values[ ValueAddress.Reference] = Byte;

			// Dump it to the CheatOUT buffer
			gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

			// Increase the number of addresses found
			Found ++;
		}
	}

	// Finishing structure 
        memset( &ValueAddress, 0xFF, sizeof( ValueAddress));
	gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

	gzclose( CheatIN);
	gzclose( CheatOUT);

	// Remove the OLD file
        remove( tempfile2);

	sprintf( Str, "%i[NEAR] was found %i time(s)", Value, Found);
        SetStatusInfo( Str, STATUS_DONE);

	PreviousValue = Value;

	// Only 1 address found, always the correct one
	if( Found == 1)
	{
		ShowFound();
                sprintf( Str, "%i[NEAR] was found.", Value);
                SetStatusInfo( Str, STATUS_FOUND);
		return TRUE;
	}
	return FALSE;
}

/**********************************************************************************************/
bool8 FindNearFirst( uint8 Value)
{
gzFile CheatOUT;
uint32 Address;
        CheatOUT = gzopen( tempfile1, "wb");
        for( Address = 0; Address != (Memory.SRAMMask + 1); Address ++)
	{
		// Cleanout the structure
		ZeroMemory( &ValueAddress, sizeof( ValueAddress));

                // Memory = 0 = Memory.SRAM
		ValueAddress.Memory  = 0;
                // Current Memory.SRAM Address
		ValueAddress.Address = Address;
		// First Value
                ValueAddress.Values[0] = Memory.SRAM[ Address];
                // Reference count is 0, 1st time we searched
		ValueAddress.Reference = 0;

		// Dump it to the CheatOUT buffer
		gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));
	}

        for( Address = 0; Address != 0x20000; Address ++)
	{
		// Cleanout the structure
		ZeroMemory( &ValueAddress, sizeof( ValueAddress));

                // Memory = 1 = Memory.RAM
		ValueAddress.Memory  = 1;
                // Current Memory.SRAM Address
		ValueAddress.Address = Address;
		// First Value
                ValueAddress.Values[0] = Memory.RAM[ Address];
		// Reference count is 0, 1ste time we searched
		ValueAddress.Reference = 0;

		// Dump it to the CheatOUT buffer
		gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));
	}

	// Finishing structure 
        memset( &ValueAddress, 0xFF, sizeof( ValueAddress));
	gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

	gzclose( CheatOUT);

	PreviousValue = Value;
	return FALSE;
}

/**********************************************************************************************/
bool8 FindExact( uint8 Value)
{
gzFile CheatIN, CheatOUT;
uint32 Found = 0;
static char Str[80];

	sprintf( Str, "Searching for %i[EXACT]", Value);
        SetStatusInfo( Str, STATUS_WAIT);

        CheatIN = gzopen( tempfile1, "rb");
	if( CheatIN == NULL)
	{	return FindExactFirst( Value);	}
	gzclose( CheatIN);

        // SNES9X.001 exists, rename it to SNES9X.002
        rename( tempfile1, tempfile2);

        CheatOUT = gzopen( tempfile1, "wb9");
        CheatIN = gzopen( tempfile2, "rb");

	while( 1)
	{
		// Get the last found addresses out CheatIN
		gzread( CheatIN, &ValueAddress, sizeof( ValueAddress));

		// Finishing structure found, exicting
		if( ValueAddress.Memory == 0xFF && ValueAddress.Address == 0xFFFFFFFF)
			break;

		if( ValueAddress.Memory == 0)
                if( Memory.SRAM[ ValueAddress.Address] == Value)
		{
			// Increase the number of references
			ValueAddress.Reference ++;
			// Never get the history bigger then 10 values
			if( ValueAddress.Reference == 10)
			for( ValueAddress.Reference = 0; ValueAddress.Reference != 9; ValueAddress.Reference ++)
		 		 ValueAddress.Values[ValueAddress.Reference] = ValueAddress.Values[ValueAddress.Reference+1];
			// Save the current value
			ValueAddress.Values[ ValueAddress.Reference] = Value;

			// Dump it to the CheatOUT buffer
			gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

			// Increase the number of addresses found
			Found ++;
		}

		if( ValueAddress.Memory == 1)
                if( Memory.RAM[ ValueAddress.Address] == Value)
		{
			// Increase the number of references
			ValueAddress.Reference ++;
			// Never get the history bigger then 10 values
			if( ValueAddress.Reference == 10)
			for( ValueAddress.Reference = 0; ValueAddress.Reference != 9; ValueAddress.Reference ++)
		 		 ValueAddress.Values[ValueAddress.Reference] = ValueAddress.Values[ValueAddress.Reference+1];
			// Save the current value
			ValueAddress.Values[ ValueAddress.Reference] = Value;

			// Dump it to the CheatOUT buffer
			gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

			// Increase the number of addresses found
			Found ++;
		}
	}

	// Finishing structure 
        memset( &ValueAddress, 0xFF, sizeof( ValueAddress));
	gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

	gzclose( CheatIN);
	gzclose( CheatOUT);

	// Remove the OLD file
        remove( tempfile2);

	sprintf( Str, "%i[EXACT] was found %i time(s)", Value, Found);
        SetStatusInfo( Str, STATUS_DONE);

	// Only 1 address found, always the correct one
	if( Found == 1)
	{
		ShowFound();
                sprintf( Str, "%i[EXACT] was found.", Value);
                SetStatusInfo( Str, STATUS_FOUND);
		return TRUE;
	}

	return FALSE;
}

/**********************************************************************************************/
bool8 FindExactFirst( uint8 Value)
{
gzFile CheatOUT;
uint32 Address, Found = 0;
static char Str[80];

        CheatOUT = gzopen( tempfile1, "wb");
        for( Address = 0; Address != (Memory.SRAMMask + 1); Address ++)
        if( Memory.SRAM[ Address] == Value)
	{
		// Cleanout the structure
		ZeroMemory( &ValueAddress, sizeof( ValueAddress));

                // Memory = 0 = Memory.SRAM
		ValueAddress.Memory  = 0;
                // Current Memory.SRAM Address
		ValueAddress.Address = Address;
		// First Value
		ValueAddress.Values[0] = Value;
		// Reference count is 0, 1ste time we searched
		ValueAddress.Reference = 0;

		// Dump it to the CheatOUT buffer
		gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

		// Increase the number of addresses found
		Found ++;
	}

        for( Address = 0; Address != 0x20000; Address ++)
        if( Memory.RAM[ Address] == Value)
	{
		// Cleanout the structure
		ZeroMemory( &ValueAddress, sizeof( ValueAddress));

                // Memory = 1 = Memory.RAM
		ValueAddress.Memory  = 1;
                // Current Memory.SRAM Address
		ValueAddress.Address = Address;
		// First Value
		ValueAddress.Values[0] = Value;
		// Reference count is 0, 1ste time we searched
		ValueAddress.Reference = 0;

		// Dump it to the CheatOUT buffer
		gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

		// Increase the number of addresses found
		Found ++;
	}

	// Finishing structure 
        memset( &ValueAddress, 0xFF, sizeof( ValueAddress));
	gzwrite( CheatOUT, &ValueAddress, sizeof( ValueAddress));

	gzclose( CheatOUT);

	sprintf( Str, "%i[EXACT] was found %i time(s)", Value, Found);
        SetStatusInfo( Str, STATUS_DONE);

	// Only 1 address found, always the correct one
	if( Found == 1)
	{
		ShowFound();
                sprintf( Str, "%i[EXACT] was found.", Value);
                SetStatusInfo( Str, STATUS_FOUND);
		return TRUE;
	}

	return FALSE;
}

/**********************************************************************************************/
bool8 ShowFound()
{
gzFile CheatIN;
static char Str[80];
uint8 Byte, C;

        CheatIN = gzopen( tempfile1, "rb");
	if( CheatIN == NULL)
	{
                SetStatusInfo( "No search buffer found, can't display results !", STATUS_DONE);
		return FALSE;
	}

	OutputCheat( "Address - History Value(s)                         - Current");
	while( 1)
	{
		// Get the last found addresses out CheatIN
		gzread( CheatIN, &ValueAddress, sizeof( ValueAddress));

		// Finishing structure found, exicting
		if( ValueAddress.Memory == 0xFF)
			break;

                // Get the real CPU memory address of the Memory.SRAM address
		if( ValueAddress.Memory == 0)
		{
			sprintf( Str, "$7%01X%04X", (ValueAddress.Address&0xF8000)>>15, ValueAddress.Address&0x7FFF);
                        Byte = Memory.SRAM[ ValueAddress.Address];
		}

                // Get the real CPU memory address of the Memory.RAM address
		if( ValueAddress.Memory == 1)
		{
                        sprintf( Str, "$%02X%04X", 0x7E + ((ValueAddress.Address&0xF0000)>>16), (ValueAddress.Address&0xFFFF));
                        Byte = Memory.RAM[ ValueAddress.Address];
		}

		// Build a history list
		sprintf( Str, "%s - ", Str);
		for( C = 0; C <= ValueAddress.Reference; C ++)
			sprintf( Str, "%s%3i ", Str, ValueAddress.Values[C]);
		// Add the current value
		sprintf( Str, "%-51s- %3i", Str, Byte);
		OutputCheat( Str);
	}
	gzclose( CheatIN);
	return TRUE;
}

/**********************************************************************************************/
bool8 ClearCheatResults()
{
   remove (tempfile1);
   remove (tempfile2);
   return TRUE;
}

/**********************************************************************************************/
bool8 RemoveConstant( int index)
{
        int C;

        Constants[index].Enabled = FALSE;
        for (C = index; C < (MAX_CHEATS-1); C++)
        {
           Constants[C] = Constants[C+1];
        }
        memset (&Constants[MAX_CHEATS-1], 0, sizeof(SConstants));

	return TRUE;
}

bool8 KeepConstant( uint32 Address, uint8 Value)
{
uint8 C;
        //First scan to see if one with that Address already exists.
        for( C = 0; C != MAX_CHEATS; C++)
            if ((Constants[C].Enabled == TRUE) && (Constants[C].RAddress == Address))
            {
                Constants[C].Value = Value;
                return TRUE;
            }

        for( C = 0; C != MAX_CHEATS && Constants[C].Enabled == TRUE; C++);
	
        if( C == MAX_CHEATS)
	{
                SetStatusInfo( "You can only keep 20 addresses constant", STATUS_DONE);
		return FALSE;
	}

	Constants[C].Enabled  = FALSE;
	Constants[C].RAddress = Address;
        if( (Address&0xFF0000) >= 0x700000 &&
            (Address&0xFF0000) <= 0x770000)
	if( (Address&0xFFFF) <= 0x7FFF)
	{
		Constants[C].Enabled = TRUE;
		Constants[C].Memory  = 0;
		Constants[C].Address = Address&0xFFFF;
		Constants[C].Address = (Address&0x3F0000)>>1;
                Constants[C].Address &= Memory.SRAMMask;
                Constants[C].Value   = Value;
	}

	if( (Address&0x3F0000) == 0x000000)
	if( (Address&0xFFFF) <= 0x7FFF)
	{
		Constants[C].Enabled = TRUE;
                Constants[C].Memory  = 0;
                Constants[C].Address = Address&Memory.SRAMMask;
		Constants[C].Value   = Value;
	}

	if( (Address&0xFF0000) == 0x7E0000 ||
	    (Address&0xFF0000) == 0x7F0000)
	{
		Constants[C].Enabled = TRUE;
		Constants[C].Memory  = 1;
                Constants[C].Address = (Address&0x1FFFF);
		Constants[C].Value   = Value;
	}

	if( !Constants[C].Enabled)
                SetStatusInfo( "You can only keep RAM addresses constant", STATUS_DONE);

	return Constants[C].Enabled;
}
/**********************************************************************************************/

void ApplyConstants()
{
uint8 C;
        for( C = 0; C != MAX_CHEATS; C++)
        {
            if (Constants[C].Enabled)
               if (Constants[C].Memory == 1)
                  Memory.RAM[Constants[C].Address] = Constants[C].Value;
               else
                  Memory.SRAM[Constants[C].Address] = Constants[C].Value;
            else
               return;
        }
}
