VERSION 5.00
Begin VB.Form frmInputBox 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "TitleBarCaption"
   ClientHeight    =   1428
   ClientLeft      =   36
   ClientTop       =   264
   ClientWidth     =   3492
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1428
   ScaleWidth      =   3492
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   372
      Left            =   1800
      TabIndex        =   3
      Top             =   960
      Width           =   972
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   372
      Left            =   720
      TabIndex        =   2
      Top             =   960
      Width           =   972
   End
   Begin VB.TextBox Text1 
      Height          =   288
      Left            =   240
      TabIndex        =   1
      Text            =   "DefaultValue"
      Top             =   480
      Width           =   3012
   End
   Begin VB.Label lblPrompt 
      Caption         =   "Prompt"
      Height          =   252
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   3012
   End
End
Attribute VB_Name = "frmInputBox"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public AllowComma As Boolean
Public AllowDash As Boolean
Public AllowDollarSign As Boolean
Public AllowDecimalPoint As Boolean
Public AllowNegativeSign As Boolean
Public AllowPositiveSign As Boolean
Public AllowSlash As Boolean
Public AlphaOnly As Boolean
Public AutoSelectText As Boolean
Public DefaultValue As Variant
Public ForceUpperCase As Boolean
Public HighlightOnFocus As Boolean
Public HighlightColor As OLE_COLOR
Public MaxLength As Integer
Public MaxDecimalPlaces As Long
Public NumericOnly As Boolean
Public OK As Boolean
Public PasswordChar As String
Public Prompt As String
Public TextAlignment As AlignmentConstants
Public TitleBarCaption As String
Public ToolTipText As String
Public Value As Variant

Private SavedBackColor As OLE_COLOR

Private Sub cmdCancel_Click()
  Unload Me
End Sub

Private Sub cmdOK_Click()
  OK = True
  Unload Me
End Sub

Private Sub Form_Load()
  SavedBackColor = Text1.BackColor
End Sub

Private Sub Form_Unload(Cancel As Integer)
  If OK = True Then
    Value = Text1.Text
  Else
    Value = ""
  End If
End Sub

Private Sub Text1_Change()

  If MaxDecimalPlaces > -1 Then
    Call LimitDecimalPlaces(Text1, MaxDecimalPlaces)
  End If
  
  If ForceUpperCase = True Then
    With Text1
      .Text = UCase$(.Text)
      .SelStart = Len(.Text) 'position cursor at end of the line
      .SelLength = 0
    End With
  End If
  
End Sub

Private Sub Text1_GotFocus()
  If AutoSelectText = True Then
    With Text1
      .SelStart = 0
      .SelLength = Len(.Text)
    End With
  End If
  
  If HighlightOnFocus = True Then
    Text1.BackColor = HighlightColor
  End If
End Sub

Private Sub Text1_KeyPress(KeyAscii As Integer)
  If NumericOnly = True Then
  
    KeyAscii = FilterNumericOnly(KeyAscii, AllowComma, _
    AllowDash, AllowDecimalPoint, AllowDollarSign, _
    AllowPositiveSign, AllowNegativeSign, AllowSlash)
    
    KeyAscii = LimitDuplicates(KeyAscii)
    
  ElseIf AlphaOnly = True Then
  
    KeyAscii = FilterAlphaOnly(KeyAscii)
    
  End If
    
End Sub

Private Function LimitDuplicates(KeyAscii As Integer) As Integer
  
  'limit user to only 1 decimal point
  If AllowDecimalPoint = True Then
    If KeyAscii = 46 Then
      If InStr(1, Text1.Text, ".", vbBinaryCompare) > 0 Then
        KeyAscii = 0
      End If
    End If
  End If
  
  'limit user to only 1 dollar sign point
  If AllowDollarSign = True Then
    If KeyAscii = 36 Then
      If InStr(1, Text1.Text, "$", vbBinaryCompare) > 0 Then
        KeyAscii = 0
      End If
    End If
  End If
  
  'limit user to only 1 positive sign point
  If AllowPositiveSign = True Then
    If KeyAscii = 43 Then
      If InStr(1, Text1.Text, "+", vbBinaryCompare) > 0 Then
        KeyAscii = 0
      End If
    End If
  End If
  
  'limit user to only 1 negative sign point.  Since a
  'negative sign and a dash are the same character, allow
  'multiples if AllowDash is True
  If AllowNegativeSign = True And AllowDash = False Then
    If KeyAscii = 45 Then
      If InStr(1, Text1.Text, "-", vbBinaryCompare) > 0 Then
        KeyAscii = 0
      End If
    End If
  End If
  
  If KeyAscii = 0 Then
    Beep
  End If
  LimitDuplicates = KeyAscii
    
End Function
    
Private Function FilterNumericOnly(ByRef KeyAscii As Integer, _
  ByVal AllowComma As Boolean, ByVal AllowDash As Boolean, _
  ByVal AllowDecimalPoint As Boolean, ByVal AllowDollarSign As Boolean, _
  ByVal AllowPositiveSign As Boolean, ByVal AllowNegativeSign As Boolean, _
  ByVal AllowSlash As Boolean) As Integer
  
  Dim blnOK As Boolean
  
    
  'numbers 0-9
  If KeyAscii >= vbKey0 And KeyAscii <= vbKey9 Then
    blnOK = True
  'backspace
  ElseIf KeyAscii = vbKeyBack Then
    blnOK = True
  End If
  
  If blnOK = False Then
    If AllowComma = True Then
      If KeyAscii = 44 Then
        blnOK = True
      End If
    End If
  End If
  
  If blnOK = False Then
    If AllowDash = True Then
      If KeyAscii = 45 Then
        blnOK = True
      End If
    End If
  End If

  If blnOK = False Then
    If AllowDecimalPoint = True Then
      If KeyAscii = 46 Then
        blnOK = True
      End If
    End If
  End If
  
  If blnOK = False Then
    If AllowDollarSign = True Then
      If KeyAscii = 36 Then
        blnOK = True
      End If
    End If
  End If
  
  If blnOK = False Then
    If AllowPositiveSign = True Then
      If KeyAscii = 43 Then
        blnOK = True
      End If
    End If
  End If

  If blnOK = False Then
    If AllowNegativeSign = True Then
      If KeyAscii = 45 Then
        blnOK = True
      End If
    End If
  End If
  
  If blnOK = False Then
    If AllowSlash = True Then
      If KeyAscii = 47 Then
        blnOK = True
      End If
    End If
  End If
      
  If blnOK = True Then
    FilterNumericOnly = KeyAscii
  Else
    FilterNumericOnly = 0
    Beep
  End If

End Function

Private Function FilterAlphaOnly(ByRef KeyAscii As Integer) As Integer
  Dim blnOK As Boolean
  
  'uppper case letters
  If KeyAscii >= vbKeyA And KeyAscii <= vbKeyZ Then
    blnOK = True
  'lower case letters
  ElseIf KeyAscii >= 97 And KeyAscii <= 122 Then
    blnOK = True
  'backspace
  ElseIf KeyAscii = vbKeyBack Then
    blnOK = True
  End If
  
  If blnOK = True Then
    FilterAlphaOnly = KeyAscii
  Else
    FilterAlphaOnly = 0
    Beep
  End If

  
End Function

Private Sub LimitDecimalPlaces(ByVal textControl As Control, ByVal MaxDecimalPlaces As Long)
    Dim lngDecimalPointPOS As Long              'position of the decimal point
    
    'find position of the decimal point (if it exists)
    lngDecimalPointPOS = InStr(1, textControl.Text, ".", vbBinaryCompare)
    
    If lngDecimalPointPOS > 0 Then
        If MaxDecimalPlaces = 0 Then                                                            'code for when MaxDecimalPlaces
            MaxDecimalPlaces = MaxDecimalPlaces - 1                                             'is zero
        End If
        If Len(textControl.Text) - lngDecimalPointPOS > MaxDecimalPlaces Then                   'if text exceeds the number of decimal places
            textControl.Text = Left$(textControl.Text, lngDecimalPointPOS + MaxDecimalPlaces)   'truncate text in control
            textControl.SelStart = lngDecimalPointPOS + MaxDecimalPlaces                        'position cursor at end of line
            textControl.SelLength = 0
            Beep
        End If
    End If
End Sub

Private Sub Text1_LostFocus()
  If HighlightOnFocus = True Then
    Text1.BackColor = SavedBackColor
  End If
End Sub
