//=============================================================================
// The Unreal Director's Suite                  Release version: Jan 7th, 1999
//=============================================================================
//
// [ CS_HUD ]
// 
// The CS_Hud holds all the code for creating the special hud effects.
//=============================================================================
class CS_Hud expands UnrealHUD;

#exec Texture Import File=Textures\black.pcx Name=CS_LetterBox Mips=Off Flags=2

simulated function ChangeHud(int d)
{
	HudMode = HudMode + d;
	if ( HudMode>5 ) HudMode = 0;
	else if ( HudMode < 0 ) HudMode = 5;
}

simulated function HUDSetup(canvas canvas)
{
	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;
	Canvas.DrawColor.r = 255;
	Canvas.DrawColor.g = 255;
	Canvas.DrawColor.b = 255;
	Canvas.Font = Canvas.LargeFont;
}


simulated function PostRender( canvas Canvas )
{

    local int lbx;

	HUDSetup(canvas);

    // Handle our custom modes	


    if (HudMode==6)  // Normal
      return;
      
    if (HudMode==7)  // Letterboxed
    {
    
        // A letterboxed screen uses the aspect ratio of 16:9. 
    
        lbx = Canvas.CLipX / 16;
        lbx *= 9;
        lbx = (Canvas.ClipY-lbx)/2;
              
    
	    Canvas.SetPos(0,0);
	    Canvas.DrawRect(Texture'CS_LetterBox',Canvas.ClipX,lbx);
	    Canvas.SetPos(0,Canvas.ClipY-lbx);
	    Canvas.DrawRect(Texture'CS_letterBox',Canvas.ClipX,Canvas.ClipY);    

		if (CSPlayer(Owner).bCSInDebug)
			DrawCSDebug(Canvas,lbx);	   

	
	    
	    return;
    }


	// If the CSCamera is different, display info about it
	
	if ( CSPlayer(Owner).CSCamera != None)
	{
	
		Canvas.Font = Font'MedFont';										   
		Canvas.SetPos(5,Canvas.ClipY-80);
		Canvas.DrawText("Camera    : "$CSPlayer(Owner).CSCamera);
						
		Canvas.SetPos(5,Canvas.ClipY-70);
		Canvas.DrawText("Location  : "$CSPlayer(Owner).CSCamera.Location);

		Canvas.SetPos(5,Canvas.ClipY-60);
		Canvas.DrawText("Rotation  : "$CSPlayer(Owner).CSCamera.Rotation);
	
	}

	if ( PlayerPawn(Owner) != None )
	{
		if ( PlayerPawn(Owner).bShowMenu )
		{
			if ( MainMenu == None )
				CreateMenu();
			if ( MainMenu != None )
				MainMenu.DrawMenu(Canvas);
			return;
		}
		if ( PlayerPawn(Owner).bShowScores )
		{
			if ( (PlayerPawn(Owner).Scoring == None) && (PlayerPawn(Owner).ScoringType != None) )
				PlayerPawn(Owner).Scoring = Spawn(PlayerPawn(Owner).ScoringType, PlayerPawn(Owner));
			if ( PlayerPawn(Owner).Scoring != None )
			{ 
				PlayerPawn(Owner).Scoring.ShowScores(Canvas);
				return;
			}
		}
		else if ( (PlayerPawn(Owner).Weapon != None) && (Level.LevelAction == LEVACT_None) )
			DrawCrossHair(Canvas, 0.5 * Canvas.ClipX - 8, 0.5 * Canvas.ClipY - 8);

		if ( PlayerPawn(Owner).ProgressTimeOut > Level.TimeSeconds )
			DisplayProgressMessage(Canvas);

	}


	if (HudMode==5) 
	{
		DrawInventory(Canvas, Canvas.ClipX-96, 0,False);		
		Return;
	}
	if (Canvas.ClipX<320) HudMode = 4;

	// Draw Armor
	if (HudMode<2) DrawArmor(Canvas, 0, 0,False);
	else if (HudMode==3 || HudMode==2) DrawArmor(Canvas, 0, Canvas.ClipY-32,False);
	else if (HudMode==4) DrawArmor(Canvas, Canvas.ClipX-64, Canvas.ClipY-64,True);
	
	// Draw Ammo
	if (HudMode!=4) DrawAmmo(Canvas, Canvas.ClipX-48-64, Canvas.ClipY-32);
	else DrawAmmo(Canvas, Canvas.ClipX-48, Canvas.ClipY-32);
	
	// Draw Health
	if (HudMode<2) DrawHealth(Canvas, 0, Canvas.ClipY-32);
	else if (HudMode==3||HudMode==2) DrawHealth(Canvas, Canvas.ClipX-128, Canvas.ClipY-32);
	else if (HudMode==4) DrawHealth(Canvas, Canvas.ClipX-64, Canvas.ClipY-32);
		
	// Display Inventory
	if (HudMode<2) DrawInventory(Canvas, Canvas.ClipX-96, 0,False);
	else if (HudMode==3) DrawInventory(Canvas, Canvas.ClipX-96, Canvas.ClipY-64,False);
	else if (HudMode==4) DrawInventory(Canvas, Canvas.ClipX-64, Canvas.ClipY-64,True);
	else if (HudMode==2) DrawInventory(Canvas, Canvas.ClipX/2-64, Canvas.ClipY-32,False);	

	// Display Frag count
	if ( (Level.Game == None) || Level.Game.IsA('DeathMatchGame') ) 
	{
		if (HudMode<3) DrawFragCount(Canvas, Canvas.ClipX-32,Canvas.ClipY-64);
		else if (HudMode==3) DrawFragCount(Canvas, 0,Canvas.ClipY-64);
		else if (HudMode==4) DrawFragCount(Canvas, 0,Canvas.ClipY-32);
	}

}

simulated function DrawCrossHair( canvas Canvas, int StartX, int StartY )
{
	local PlayerPawn P;

    if (CSPlayer(Owner).bCSCAmeraMode) return;

	if (Crosshair>5) Return;
	Canvas.SetPos(StartX, StartY );
	Canvas.Style = 2;
	P = PlayerPawn(Owner);	
	if ( (P.Weapon != None) && !P.bShowMenu 
		&& P.Weapon.bLockedOn && P.Weapon.bPointing) 
		Canvas.DrawIcon(Texture'Crosshair6', 1.0);
	else if (Crosshair==0) 	Canvas.DrawIcon(Texture'Crosshair1', 1.0);
	else if (Crosshair==1) 	Canvas.DrawIcon(Texture'Crosshair2', 1.0);	
	else if (Crosshair==2) 	Canvas.DrawIcon(Texture'Crosshair3', 1.0);
	else if (Crosshair==3) 	Canvas.DrawIcon(Texture'Crosshair4', 1.0);
	else if (Crosshair==4) 	Canvas.DrawIcon(Texture'Crosshair5', 1.0);	
	else if (Crosshair==5) 	Canvas.DrawIcon(Texture'Crosshair7', 1.0);		
	Canvas.Style = 1;	
}

function DrawCSDebug(Canvas Canvas, int TX)
{

	local int i,x;
	local string[240] s;

	Canvas.Font = Font'MedFont';										   
	
	// Display the Current Camera;

	Canvas.SetPos(5,TX-20);
	Canvas.DrawText("Current Camera: "$CSPlayer(Owner).CSCamera);

	Canvas.SetPos(5,TX-10);
	Canvas.DrawText("Last Action   : "$CSPlayer(Owner).CSLastAction);
	
	// Display any debug messages;
	
	x = Canvas.ClipY - 60;
	
	for (i=0;i<CSPlayer(Owner).CSDebugCnt;i++)
	{
		Canvas.SetPos(5,X);
		switch (i)
		{
			case 0 : s = CSPlayer(Owner).CSDebug1;break;
			case 1 : s = CSPlayer(Owner).CSDebug2;break;
			case 2 : s = CSPlayer(Owner).CSDebug3;break;
			case 3 : s = CSPlayer(Owner).CSDebug4;break;
			case 4 : s = CSPlayer(Owner).CSDebug5;break;
		}	
			
		Canvas.DrawText(s);
		x+=10;
	}

}

defaultproperties
{
     MainMenuType=Class'Engine.Menu'
}
