//=============================================================================
// The Unreal Director's Suite                  Release version: Jan 7th, 1999
//=============================================================================
//
// [ CSSinglePlayer ]
//
// This actor is the bases for Single Player use of the UDS.  Any map that is
// created that will use the Cut Sequence engine of the UDS needs to be of this
// game type.
//
// It's primary function is to Convert a player from the original Unreal player
// classes to our custom one.
//=============================================================================

class CSSinglePlayer expands UnrealGameInfo;

// Switch players to their Cut Sequence  equivalent as they log in.

event playerpawn Login
(
	string[32] Portal,
	string[120] Options,
	out string[80] Error,
	class<playerpawn> SpawnClass
)
{
	local playerpawn NewPlayer;

	     if (SpawnClass == class 'MaleOne')   SpawnClass = class 'CSMaleOne';
	else if (SpawnClass == class 'MaleTwo')   SpawnClass = class 'CSMaleTwo';
	else if (SpawnClass == class 'MaleThree') SpawnClass = class 'CSMaleThree';
	else if (SpawnClass == class 'FemaleOne') SpawnClass = class 'CSFemaleOne';
	else if (SpawnClass == class 'FemaleTwo') SpawnClass = class 'CSFemaleTwo';

	NewPlayer = Super.Login(Portal, Options, Error, SpawnClass);

	return NewPlayer;
}

defaultproperties
{
     DefaultPlayerClass=None
     HUDType=Class'UDSDemo.CS_Hud'
}
