//=============================================================================
// The Unreal Director's Suite                  Release version: Jan 7th, 1999
//=============================================================================
//
// [ CS_Movie ]
//
// This class is designed for non-intertactive C/S levels.  Any map of this
// game type will automatically launch a CS_ACTION at startup.  There should
// be EXACTLY ONE CS_Action actor in this case.
//=============================================================================

class CSMovie expands CSSinglePlayer;

var PlayerPawn NewPlayer;

event playerpawn Login
(
	string[32] Portal,
	string[120] Options,
	out string[80] Error,
	class<playerpawn> SpawnClass
)
{
	
    NewPlayer = Super.Login(Portal, Options, Error, SpawnClass);	
    SetTimer(0.05,False);
    return NewPlayer;
}

function Timer()
{
    local CS_Action a;
    foreach AllActors(class'CS_Action', a) {
	a.Trigger(NewPlayer, NewPlayer.Instigator);
	break;
    }
}

defaultproperties
{
}
