//=============================================================================
// The Unreal Director's Suite                  Release version: Jan 7th, 1999
//=============================================================================
//
// [ CSMaleThree ]
//
// Simply a subclass (it's 100% exact to the original Unreal Code) for handling players.
//=============================================================================

class CSMaleThree expands CSMale;

#exec MESH IMPORT MESH=Male3 ANIVFILE=MODELS\Male3_a.3D DATAFILE=MODELS\Male3_d.3D X=0 Y=0 Z=0 ZEROTEX=1 UNMIRROR=1
#exec MESH ORIGIN MESH=Male3 X=-150 Y=80 Z=0 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=Male3 SEQ=All       STARTFRAME=0   NUMFRAMES=473
#exec MESH SEQUENCE MESH=Male3 SEQ=GutHit    STARTFRAME=0   NUMFRAMES=1  Group=TakeHit
#exec MESH SEQUENCE MESH=Male3 SEQ=AimDnLg   STARTFRAME=1   NUMFRAMES=1  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=AimDnSm   STARTFRAME=2   NUMFRAMES=1  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=AimUpLg   STARTFRAME=3   NUMFRAMES=1  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=AimUpSm   STARTFRAME=4   NUMFRAMES=1  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=Taunt1    STARTFRAME=5   NUMFRAMES=7  RATE=6  Group=Gesture
#exec MESH SEQUENCE MESH=Male3 SEQ=Breath1   STARTFRAME=12  NUMFRAMES=7  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=Breath2   STARTFRAME=19  NUMFRAMES=6  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=CockGun   STARTFRAME=25  NUMFRAMES=8  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=Dead2     STARTFRAME=33  NUMFRAMES=16 RATE=15 Group=TakeHit
#exec MESH SEQUENCE MESH=Male3 SEQ=Dead3     STARTFRAME=49  NUMFRAMES=13 RATE=15 Group=TakeHit
#exec MESH SEQUENCE MESH=Male3 SEQ=Dead4     STARTFRAME=62  NUMFRAMES=16 RATE=15 Group=TakeHit
#exec MESH SEQUENCE MESH=Male3 SEQ=Dead5     STARTFRAME=78  NUMFRAMES=23 RATE=15 Group=TakeHit
#exec MESH SEQUENCE MESH=Male3 SEQ=Dead6     STARTFRAME=101 NUMFRAMES=28 RATE=15
#exec MESH SEQUENCE MESH=Male3 SEQ=Dead7     STARTFRAME=129 NUMFRAMES=21 RATE=15
#exec MESH SEQUENCE MESH=Male3 SEQ=DeathEnd  STARTFRAME=457 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Male3 SEQ=DeathEnd2 STARTFRAME=48  NUMFRAMES=1
#exec MESH SEQUENCE MESH=Male3 SEQ=DeathEnd3 STARTFRAME=61  NUMFRAMES=1
#exec MESH SEQUENCE MESH=Male3 SEQ=DuckWlkL  STARTFRAME=150 NUMFRAMES=15 RATE=15 Group=Ducking
#exec MESH SEQUENCE MESH=Male3 SEQ=DuckWlkS  STARTFRAME=165 NUMFRAMES=15 RATE=15 Group=Ducking
#exec MESH SEQUENCE MESH=Male3 SEQ=HeadHit   STARTFRAME=180 NUMFRAMES=1  Group=TakeHit
#exec MESH SEQUENCE MESH=Male3 SEQ=JumpLgFr  STARTFRAME=181 NUMFRAMES=1  Group=Jumping
#exec MESH SEQUENCE MESH=Male3 SEQ=JumpSmFr  STARTFRAME=182 NUMFRAMES=1  Group=Jumping
#exec MESH SEQUENCE MESH=Male3 SEQ=LandLgFr  STARTFRAME=183 NUMFRAMES=1 Group=Landing
#exec MESH SEQUENCE MESH=Male3 SEQ=LandSmFr  STARTFRAME=184 NUMFRAMES=1 Group=Landing
#exec MESH SEQUENCE MESH=Male3 SEQ=LeftHit   STARTFRAME=185 NUMFRAMES=1 Group=TakeHit
#exec MESH SEQUENCE MESH=Male3 SEQ=Look      STARTFRAME=186 NUMFRAMES=25 RATE=15 Group=Waiting //FIXME - can't use! - make much more subtle
#exec MESH SEQUENCE MESH=Male3 SEQ=RightHit  STARTFRAME=211 NUMFRAMES=1  Group=TakeHit
#exec MESH SEQUENCE MESH=Male3 SEQ=RunLg     STARTFRAME=212 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Male3 SEQ=RunLgFr   STARTFRAME=222 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Male3 SEQ=RunSm     STARTFRAME=232 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Male3 SEQ=RunSmFr   STARTFRAME=242 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Male3 SEQ=StillFrRp STARTFRAME=252 NUMFRAMES=15 RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=StillLgFr STARTFRAME=267 NUMFRAMES=10 RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=StillSmFr STARTFRAME=277 NUMFRAMES=8  RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=SwimLg    STARTFRAME=285 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Male3 SEQ=SwimSm    STARTFRAME=300 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Male3 SEQ=TreadLg   STARTFRAME=315 NUMFRAMES=15 RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=TreadSm   STARTFRAME=330 NUMFRAMES=15 RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=Victory1  STARTFRAME=345 NUMFRAMES=25 RATE=15 Group=Gesture
#exec MESH SEQUENCE MESH=Male3 SEQ=WalkLg    STARTFRAME=370 NUMFRAMES=15 RATE=17
#exec MESH SEQUENCE MESH=Male3 SEQ=WalkLgFr  STARTFRAME=385 NUMFRAMES=15 RATE=17
#exec MESH SEQUENCE MESH=Male3 SEQ=WalkSm    STARTFRAME=400 NUMFRAMES=15 RATE=17
#exec MESH SEQUENCE MESH=Male3 SEQ=WalkSmFr  STARTFRAME=415 NUMFRAMES=15 RATE=17
#exec MESH SEQUENCE MESH=Male3 SEQ=Wave      STARTFRAME=430 NUMFRAMES=15 RATE=15 Group=Gesture
#exec MESH SEQUENCE MESH=Male3 SEQ=Dead1     STARTFRAME=445 NUMFRAMES=13 RATE=15  
#exec MESH SEQUENCE MESH=Male3 SEQ=Walk      STARTFRAME=458 NUMFRAMES=15 RATE=15  
#exec MESH SEQUENCE MESH=Male3 SEQ=TurnSm    STARTFRAME=415 NUMFRAMES=2
#exec MESH SEQUENCE MESH=Male3 SEQ=TurnLg    STARTFRAME=385 NUMFRAMES=2
#exec MESH SEQUENCE MESH=Male3 SEQ=Taunt1L   STARTFRAME=473 NUMFRAMES=7  RATE=6  Group=Gesture
#exec MESH SEQUENCE MESH=Male3 SEQ=Breath1L  STARTFRAME=480 NUMFRAMES=7  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=Breath2L  STARTFRAME=487 NUMFRAMES=6  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=CockGunL  STARTFRAME=493 NUMFRAMES=8  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male3 SEQ=LookL     STARTFRAME=501 NUMFRAMES=25 RATE=15 Group=Waiting //FIXME - can't use! - make much more subtle
#exec MESH SEQUENCE MESH=Male3 SEQ=Victory1L STARTFRAME=526 NUMFRAMES=25 RATE=15 Group=Gesture
#exec MESH SEQUENCE MESH=Male3 SEQ=WaveL     STARTFRAME=551 NUMFRAMES=15 RATE=15 Group=Gesture

#exec TEXTURE IMPORT NAME=Dante FILE=MODELS\Dante.PCX GROUP=Skins 
#exec MESHMAP SCALE MESHMAP=Male3 X=0.056 Y=0.056 Z=0.112
#exec MESHMAP SETTEXTURE MESHMAP=Male3 NUM=0 TEXTURE=Dante

#exec MESH NOTIFY MESH=Male3 SEQ=RunLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=RunLG TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=RunLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=RunLGFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=RunSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=RunSM TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=RunSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=RunSMFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=WalkLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=WalkLG TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=WalkLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=WalkLGFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=WalkSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=WalkSM TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=WalkSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=WalkSMFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male3 SEQ=Dead2 TIME=0.92 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male3 SEQ=Dead3 TIME=0.45 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male3 SEQ=Dead4 TIME=0.54 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male3 SEQ=Dead5 TIME=0.68 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male3 SEQ=Dead6 TIME=0.57 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male3 SEQ=Dead7 TIME=0.78 FUNCTION=LandThump

#exec AUDIO IMPORT FILE="Sounds\male\jump11.WAV" NAME="MJump3" GROUP="Male"
#exec AUDIO IMPORT FILE="Sounds\male\land12.WAV" NAME="MLand3" GROUP="Male"

defaultproperties
{
     LandGrunt=Sound'UnrealShare.Male.MLand3'
     CarcassType=Class'UnrealShare.MaleThreeCarcass'
     JumpSound=Sound'UnrealShare.Male.MJump3'
     Skin=Texture'UnrealShare.Skins.Dante'
     Mesh=Mesh'UnrealShare.Male3'
}
