//=============================================================================
// The Unreal Director's Suite                  Release version: Jan 7th, 1999
//=============================================================================
//
// [ CSMaleOne ]
//
// Simply a subclass (it's 100% exact to the original Unreal Code) for handling players.
//=============================================================================

class CSMaleOne expands CSMale;

#exec MESH IMPORT MESH=Male1 ANIVFILE=MODELS\Male1_a.3D DATAFILE=..\unrealshare\MODELS\Male_d.3D X=0 Y=0 Z=0 ZEROTEX=1
#exec MESH ORIGIN MESH=Male1 X=150 Y=80 Z=0 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=Male1 SEQ=All       STARTFRAME=0   NUMFRAMES=473
#exec MESH SEQUENCE MESH=Male1 SEQ=GutHit    STARTFRAME=0   NUMFRAMES=1  Group=TakeHit
#exec MESH SEQUENCE MESH=Male1 SEQ=AimDnLg   STARTFRAME=1   NUMFRAMES=1  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=AimDnSm   STARTFRAME=2   NUMFRAMES=1  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=AimUpLg   STARTFRAME=3   NUMFRAMES=1  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=AimUpSm   STARTFRAME=4   NUMFRAMES=1  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=Taunt1    STARTFRAME=5   NUMFRAMES=7  RATE=6  Group=Gesture
#exec MESH SEQUENCE MESH=Male1 SEQ=Breath1   STARTFRAME=12  NUMFRAMES=7  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=Breath2   STARTFRAME=19  NUMFRAMES=6  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=CockGun   STARTFRAME=25  NUMFRAMES=8  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=Dead2     STARTFRAME=33  NUMFRAMES=16 RATE=15 Group=TakeHit
#exec MESH SEQUENCE MESH=Male1 SEQ=Dead3     STARTFRAME=49  NUMFRAMES=13 RATE=15 Group=TakeHit
#exec MESH SEQUENCE MESH=Male1 SEQ=Dead4     STARTFRAME=62  NUMFRAMES=16 RATE=15 Group=TakeHit
#exec MESH SEQUENCE MESH=Male1 SEQ=Dead5     STARTFRAME=78  NUMFRAMES=23 RATE=15 Group=TakeHit
#exec MESH SEQUENCE MESH=Male1 SEQ=Dead6     STARTFRAME=101 NUMFRAMES=28 RATE=15
#exec MESH SEQUENCE MESH=Male1 SEQ=Dead7     STARTFRAME=129 NUMFRAMES=21 RATE=15
#exec MESH SEQUENCE MESH=Male1 SEQ=DeathEnd  STARTFRAME=457 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Male1 SEQ=DeathEnd2 STARTFRAME=48  NUMFRAMES=1
#exec MESH SEQUENCE MESH=Male1 SEQ=DeathEnd3 STARTFRAME=61  NUMFRAMES=1
#exec MESH SEQUENCE MESH=Male1 SEQ=DuckWlkL  STARTFRAME=150 NUMFRAMES=15 RATE=15 Group=Ducking
#exec MESH SEQUENCE MESH=Male1 SEQ=DuckWlkS  STARTFRAME=165 NUMFRAMES=15 RATE=15 Group=Ducking
#exec MESH SEQUENCE MESH=Male1 SEQ=HeadHit   STARTFRAME=180 NUMFRAMES=1  Group=TakeHit
#exec MESH SEQUENCE MESH=Male1 SEQ=JumpLgFr  STARTFRAME=181 NUMFRAMES=1  Group=Jumping
#exec MESH SEQUENCE MESH=Male1 SEQ=JumpSmFr  STARTFRAME=182 NUMFRAMES=1  Group=Jumping
#exec MESH SEQUENCE MESH=Male1 SEQ=LandLgFr  STARTFRAME=183 NUMFRAMES=1 Group=Landing
#exec MESH SEQUENCE MESH=Male1 SEQ=LandSmFr  STARTFRAME=184 NUMFRAMES=1 Group=Landing
#exec MESH SEQUENCE MESH=Male1 SEQ=LeftHit   STARTFRAME=185 NUMFRAMES=1 Group=TakeHit
#exec MESH SEQUENCE MESH=Male1 SEQ=Look      STARTFRAME=186 NUMFRAMES=25 RATE=15 Group=Waiting //FIXME - can't use! - make much more subtle
#exec MESH SEQUENCE MESH=Male1 SEQ=RightHit  STARTFRAME=211 NUMFRAMES=1  Group=TakeHit
#exec MESH SEQUENCE MESH=Male1 SEQ=RunLg     STARTFRAME=212 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Male1 SEQ=RunLgFr   STARTFRAME=222 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Male1 SEQ=RunSm     STARTFRAME=232 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Male1 SEQ=RunSmFr   STARTFRAME=242 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Male1 SEQ=StillFrRp STARTFRAME=252 NUMFRAMES=15 RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=StillLgFr STARTFRAME=267 NUMFRAMES=10 RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=StillSmFr STARTFRAME=277 NUMFRAMES=8  RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=SwimLg    STARTFRAME=285 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Male1 SEQ=SwimSm    STARTFRAME=300 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Male1 SEQ=TreadLg   STARTFRAME=315 NUMFRAMES=15 RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=TreadSm   STARTFRAME=330 NUMFRAMES=15 RATE=15 Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=Victory1  STARTFRAME=345 NUMFRAMES=25 RATE=15 Group=Gesture
#exec MESH SEQUENCE MESH=Male1 SEQ=WalkLg    STARTFRAME=370 NUMFRAMES=15 RATE=17
#exec MESH SEQUENCE MESH=Male1 SEQ=WalkLgFr  STARTFRAME=385 NUMFRAMES=15 RATE=17
#exec MESH SEQUENCE MESH=Male1 SEQ=WalkSm    STARTFRAME=400 NUMFRAMES=15 RATE=17
#exec MESH SEQUENCE MESH=Male1 SEQ=WalkSmFr  STARTFRAME=415 NUMFRAMES=15 RATE=17
#exec MESH SEQUENCE MESH=Male1 SEQ=Wave      STARTFRAME=430 NUMFRAMES=15 RATE=15 Group=Gesture
#exec MESH SEQUENCE MESH=Male1 SEQ=Dead1     STARTFRAME=445 NUMFRAMES=13 RATE=15  
#exec MESH SEQUENCE MESH=Male1 SEQ=Walk      STARTFRAME=458 NUMFRAMES=15 RATE=15  
#exec MESH SEQUENCE MESH=Male1 SEQ=TurnSm    STARTFRAME=415 NUMFRAMES=2
#exec MESH SEQUENCE MESH=Male1 SEQ=TurnLg    STARTFRAME=385 NUMFRAMES=2
#exec MESH SEQUENCE MESH=Male1 SEQ=Taunt1L   STARTFRAME=473 NUMFRAMES=7  RATE=6  Group=Gesture
#exec MESH SEQUENCE MESH=Male1 SEQ=Breath1L  STARTFRAME=480 NUMFRAMES=7  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=Breath2L  STARTFRAME=487 NUMFRAMES=6  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=CockGunL  STARTFRAME=493 NUMFRAMES=8  RATE=6  Group=Waiting
#exec MESH SEQUENCE MESH=Male1 SEQ=LookL     STARTFRAME=501 NUMFRAMES=25 RATE=15 Group=Waiting //FIXME - can't use! - make much more subtle
#exec MESH SEQUENCE MESH=Male1 SEQ=Victory1L STARTFRAME=526 NUMFRAMES=25 RATE=15 Group=Gesture
#exec MESH SEQUENCE MESH=Male1 SEQ=WaveL     STARTFRAME=551 NUMFRAMES=15 RATE=15 Group=Gesture

#exec TEXTURE IMPORT NAME=Kurgan FILE=..\unrealshare\MODELS\Kurgan.PCX GROUP=Skins 
#exec MESHMAP SCALE MESHMAP=Male1 X=0.056 Y=0.056 Z=0.112
#exec MESHMAP SETTEXTURE MESHMAP=Male1 NUM=0 TEXTURE=Kurgan

#exec MESH NOTIFY MESH=Male1 SEQ=RunLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male1 SEQ=RunLG TIME=0.75 FUNCTION=PlayMetalStep
#exec MESH NOTIFY MESH=Male1 SEQ=RunLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male1 SEQ=RunLGFR TIME=0.75 FUNCTION=PlayMetalStep
#exec MESH NOTIFY MESH=Male1 SEQ=RunSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male1 SEQ=RunSM TIME=0.75 FUNCTION=PlayMetalStep
#exec MESH NOTIFY MESH=Male1 SEQ=RunSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male1 SEQ=RunSMFR TIME=0.75 FUNCTION=PlayMetalStep
#exec MESH NOTIFY MESH=Male1 SEQ=WalkLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male1 SEQ=WalkLG TIME=0.75 FUNCTION=PlayMetalStep
#exec MESH NOTIFY MESH=Male1 SEQ=WalkLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male1 SEQ=WalkLGFR TIME=0.75 FUNCTION=PlayMetalStep
#exec MESH NOTIFY MESH=Male1 SEQ=WalkSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male1 SEQ=WalkSM TIME=0.75 FUNCTION=PlayMetalStep
#exec MESH NOTIFY MESH=Male1 SEQ=WalkSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Male1 SEQ=WalkSMFR TIME=0.75 FUNCTION=PlayMetalStep
#exec MESH NOTIFY MESH=Male1 SEQ=Dead2 TIME=0.92 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male1 SEQ=Dead3 TIME=0.45 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male1 SEQ=Dead4 TIME=0.54 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male1 SEQ=Dead5 TIME=0.68 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male1 SEQ=Dead6 TIME=0.57 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Male1 SEQ=Dead7 TIME=0.78 FUNCTION=LandThump

#exec TEXTURE IMPORT NAME=JMale2 FILE=MODELS\HML_1.PCX GROUP=Skins 
#exec TEXTURE IMPORT NAME=JMale3 FILE=MODELS\HML_2.PCX GROUP=Skins 
#exec TEXTURE IMPORT NAME=JMale4 FILE=MODELS\HML_3.PCX GROUP=Skins 
#exec TEXTURE IMPORT NAME=JMale5 FILE=MODELS\HML_4.PCX GROUP=Skins 
#exec TEXTURE IMPORT NAME=JMale6 FILE=MODELS\HML_5.PCX GROUP=Skins 
#exec TEXTURE IMPORT NAME=JMale7 FILE=MODELS\HML_6.PCX GROUP=Skins 
#exec TEXTURE IMPORT NAME=JMale8 FILE=MODELS\HML_7.PCX GROUP=Skins 

#exec AUDIO IMPORT FILE="..\UnrealShare\Sounds\male\metal01.WAV" NAME="metwalk1" GROUP="Male"
#exec AUDIO IMPORT FILE="..\UnrealShare\Sounds\male\metal02.WAV" NAME="metwalk2" GROUP="Male"
#exec AUDIO IMPORT FILE="..\UnrealShare\Sounds\male\metal03.WAV" NAME="metwalk3" GROUP="Male"

simulated function PlayMetalStep()
{
	local sound step;
	local float decision;

	if ( Role < ROLE_Authority )
		return;
	if ( !bIsWalking && (Level.Game.Difficulty > 1) && ((Weapon == None) || !Weapon.bPointing) )
		MakeNoise(0.05 * Level.Game.Difficulty);
	if ( FootRegion.Zone.bWaterZone )
	{
		PlaySound(sound 'LSplash', SLOT_Interact, 1, false, 1000.0, 1.0);
		return;
	}

	decision = FRand();
	if ( decision < 0.34 )
		step = sound'MetWalk1';
	else if (decision < 0.67 )
		step = sound'MetWalk2';
	else
		step = sound'MetWalk3';

	if ( bIsWalking )
		PlaySound(step, SLOT_Interact, 0.5, false, 400.0, 1.0);
	else 
		PlaySound(step, SLOT_Interact, 1, false, 800.0, 1.0);
}

defaultproperties
{
     CarcassType=Class'UnrealI.MaleOneCarcass'
     Skin=Texture'UnrealShare.Skins.Kurgan'
     Mesh=Mesh'UnrealI.Male1'
}
