/* glfix.c:
   This program fixes a bug in Quake's pak1.pak that effects GLQuake. You need
   this program if and only if you use GLQuake. More specifically, GLQuake's
   texture caching crashes when textures of the same name but different sizes
   are loaded in one session. This is the case when both E2M5 and DM4 are
   are loaded. The problem can be removed by renaming the offending texture.

   What this program does:
   It patches the file ../id1/pak1.pak (or, alternatively, the file given
   as an argument on the command line) by parsing it's directory structure,
   looking for maps/dm4.bsp. Once the file is found, it traverses the .bsp
   structure and renames texture metal5_8 into sdsfix_2.

   How to compile and run:
   Simply load this into your C compiler, compile, and run the resulting
   executable. Unix users, type "make jmglfix" and run with "./jmglfix", or
   "./jmglfix <some_other_path>/pak1.pak" if necessary.

   If you compile for DOS/Win:
   Remember to change the path separator from '/' to '\'!
*/

#include <stdio.h>
#include <stdlib.h>

FILE *file;
char *filename = "pak1.pak";
char *glfixstr = "registered 2\n";

typedef struct {
        char packid[4];
        long offset;
        long size;
} pakheader_t;

typedef struct {
        char name[56];
        long offset;
        long size;
} direntry_t;

pakheader_t phdr;
direntry_t *dirents, *deptr;

void scan_level_textures(long);
void change_tex(char*,char*);

long numentries;

void main(int argc, char **argv)
{
        if (argc > 1) filename = argv[1];
        if (!(file = fopen(filename,"r+b")))
        {
                fprintf(stderr,"error: could not open file %s\n",filename);
                exit(1);
        }

        fread(&phdr,sizeof(pakheader_t),1,file);
        fseek(file,phdr.offset,SEEK_SET);
        dirents = deptr = malloc(phdr.size);
        numentries = phdr.size / 0x40;
        fread(dirents,sizeof(direntry_t),numentries,file);

        while (numentries--)
        {
                if (!strcmp(deptr->name,"maps/dm4.bsp"))
                        scan_level_textures(deptr->offset);

/*              if (!strcmp(deptr->name,"gl_fixed.cfg"))
                {
                        printf("file %s has been patched before; "
                                "exiting\n",filename);
                        fclose(file);
                        exit(0);
                }
*/
                deptr++;
        }

/*      fseek(file,0,SEEK_END);
        if (ftell(file) != phdr.offset+phdr.size)
        {
                phdr.offset = ftell(file);
                fwrite(dirents,sizeof(direntry_t),phdr.size / 0x040,file);
        }
        strcpy(dirents->name,"gl_fixed.cfg");
        dirents->offset = ftell(file)+sizeof(direntry_t);
        dirents->size = strlen(glfixstr);
        fwrite(dirents,sizeof(direntry_t),1,file);
        fputs(glfixstr,file);

        phdr.size += sizeof(direntry_t);
        fseek(file,0,SEEK_SET);
        fwrite(&phdr,sizeof(pakheader_t),1,file);
*/
        fclose(file);
        printf("file %s successfully patched\n",filename);
        exit(0);
}

void scan_level_textures(long bspoffset)
{
        long texoffset, numtex;
        long *ofs;
        char texname[16];

        fseek(file,bspoffset+0x14,SEEK_SET);
        fread(&texoffset,4,1,file);
        fseek(file,bspoffset+texoffset,SEEK_SET);
        fread(&numtex,4,1,file);
        ofs = malloc(numtex*4);
        fread(ofs,numtex,4,file);

        while (numtex--)
        {
                fseek(file,bspoffset+texoffset+ofs[numtex],SEEK_SET);
                fread(texname,16,1,file);
                
/*              if (!strcmp(texname,"metal5_6")) change_tex(texname,"sdsfix_1");
*/              if (!strcmp(texname,"metal5_8")) change_tex(texname,"sdsfix_2");
        }

        free(ofs);
}

void change_tex(char *old, char *new)
{
        strcpy(old,new);
        fseek(file,-16,SEEK_CUR);
        fwrite(new,16,1,file);
}