
/* glfix.c:
   This program fixes a bug in Quake's pak1.pak that effects GLQuake. You need
   this program if and only if you use GLQuake. More specifically, GLQuake's
   texture caching crashes when textures of the same name but different sizes
   are loaded in one session. This is the case when both E2M5 and DM4 are
   are loaded. The problem can be removed by renaming the offending texture.

   What this program does:
   It looks for the file ./dm4.bsp (or alternatively, the file given as an
   argument on the command line). Once the file is found, it traverses
   the .bsp structure and renames texture metal5_8 into jmglfix1.

   How to compile and run:
   Simply load this into your C compiler, compile, and run the resulting
   executable. Unix users, type "gcc -o jmglfix jmglfix.c" and run with
   "./jmglfix", or "./jmglfix <some_other_path>/dm4.bsp" if necessary.

   If you compile for DOS/Win:
   Remember to change the path separator from '/' to '\'!


   Original version supplied by Stefan Schwoon of QdQ-team.
   Modified to patch bsp-file instead of pak-file by
   Martin Willers of Clan Jgermeister.
*/

#include <stdio.h>
#include <stdlib.h>

FILE *file;
char *filename = "dm4.bsp";
char input[8];

void scan_level_textures(long);
void change_tex(char*, char*);


void main(int argc, char **argv)
{
        int confirm;

        if (argc > 1) filename = argv[1];

        if ((file = fopen(filename, "r+b")) == NULL) {
                fprintf(stderr, "error: could not open file %s\n", filename);
                exit(1);
        }

        printf("This program patches the map dm4.bsp, renaming the texture\n");
        printf("'metal5_8' into 'jmglfix1', to allow GLQuake to load DM4 and\n");
        printf("E2M5 in the same session without crashing, which happens in\n");
        printf("our Quake movie 'JM_Promo'.\n");
        printf("This may prevent you from playing dm4 on a QuakeWorld server\n");
        printf("with mapcheck enabled, so you are advised not to put the\n");
        printf("patched map into your id1-directory, but into the directory\n");
        printf("'JM_Promo/maps' instead.\n");
        printf("Patch file %s now? [y|n] ", filename);
        confirm = (char)getchar();
        if ((confirm == 'y') || (confirm == 'Y')) {
                scan_level_textures(0);
                printf("file %s successfully patched\n", filename);
        } else {
                printf("Aborting. file %s not patched\n", filename);
        }

        fclose(file);
        exit(0);
}


void scan_level_textures(long bspoffset)
{
        long texoffset, numtex;
        long *ofs;
        char texname[16];
        char texreplace[16];

        fseek(file, bspoffset+0x14, SEEK_SET);
        fread(&texoffset, 4, 1, file);
        fseek(file, bspoffset+texoffset, SEEK_SET);
        fread(&numtex, 4, 1, file);
        ofs = malloc(numtex*4);
        fread(ofs, numtex, 4, file);

        while (numtex--)
        {
                fseek(file, bspoffset+texoffset+ofs[numtex], SEEK_SET);
                fread(texname, 16, 1, file);
               
                if ((strcmp(texname, "metal5_8")) == 0) {
                        memcpy(texreplace, texname, 16);
                        strcpy(texreplace, "jmglfix1");
                        change_tex(texname, texreplace);
                }
        }

        free(ofs);
}

void change_tex(char *old, char *new)
{
        strcpy(old, new);
        fseek(file, -16, SEEK_CUR);
        fwrite(new, 16, 1, file);
}

