unit view;

interface

uses Windows, Classes, Graphics, Forms, Controls,SysUtils,Dialogs, Buttons,Registry,
  Menus,Main;

type
TInit3D=function(h:HWND;p,m,g:Pchar;rm:integer):integer;stdcall;
TChangeSize=procedure(w,h:integer);stdcall;
TShutdown3d=function:integer;stdcall;
TDoRender=procedure(h:HWND);stdcall;
TDoSetCamera=procedure(x,y,z,xa,ya:single);stdcall;
TClearEntities=procedure;stdcall;
TAddEntity=procedure(x,y,z:single);stdcall;
TLoadFile=function(p,m,g:Pchar;fsize:pointer):Pchar;stdcall;
TFreeFile=function(p:Pchar):integer;stdcall;

  TfrmView = class(TForm)
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure WaveOut1WaveOutDone(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
	printtext:string;
   centertext:string;
	timetext:string;
   procedure DoFrame(mb:Tmessageblock;render:boolean);
	procedure SetView(v:integer);
	procedure PlaySound(s:string);

  end;

var
  frmView: TfrmView;
	inited:boolean;
	hinst:HMODULE;
   Init3D:Tinit3d;
	Shutdown3d:Tshutdown3d;
   DoRender:Tdorender;
   ChangeSize:Tchangesize;
	DoSetCamera:TDosetcamera;
   ClearEntities:Tclearentities;
   AddEntity:Taddentity;
	LoadFile:Tloadfile;
   FreeFile:Tfreefile;
	soundp:pchar;
   playing,soundplaying:boolean;
   paused:boolean;

implementation

uses blocks, config, sounds;

{$R *.DFM}

procedure TfrmView.PlaySound(s:string);
var
	fsize:longint;
   junk,junk1,junk2:string;
begin
	if not inited then
   begin
   	Showmessage('You must have the 3d View on to listen to sounds');
       exit;
	end;
	if soundplaying then
   	exit;
	junk := frmConfig.Edit2.text + #0;
   junk1 := 'sound/'+s+#0;
   junk2 := frmConfig.Edit3.text+#0;
   fsize := 0;
   soundp := nil;
   soundp := LoadFile(@junk[1],@junk1[1],@junk2[1],@fsize);
   if soundp = nil then
   	exit;
   soundplaying := true;
//   Waveout1.open;
//	Waveout1.playback(soundp,fsize);
end;

procedure TfrmView.DoFrame(mb:Tmessageblock;render:boolean);
var
   m:Tmsg;
   len,mask:integer;
begin

	if Inited then
   begin
		DoSetCamera(-mb.camerapos[0],-mb.camerapos[2],mb.camerapos[1],90-mb.angles[1],mb.angles[0]);
       m := mb.m;
       while (m <> nil) do
       begin
			 if m.id = $6 then //sound
            begin
				len := 1;
				mask := ord(m.p[1]);
               if ((mask and 1)=1) then
               	len := len + 1;
               if ((mask and 2)=2) then
               	len := len + 1;
           	PlaySound(frmSounds.listbox1.items[ord(m.p[1+len+2])-1]);
				len := len + 9;
            end;

            if m.id > $21 then
            begin
                 if (m.x <> 0) or (m.y <> 0) or (m.z <> 0) then
                    AddEntity(m.x,m.y,m.z);
            end;
            m := m.next;
       end;

		if (render) then
       begin
       	DoRender(Handle);
       	ClearEntities;
       	SpeedButton2.repaint;
       	SpeedButton3.repaint;
       	SpeedButton4.repaint;
       	SpeedButton5.repaint;
			if printtext <> '' then
       		Canvas.TextOUt(5,5,printtext);
       	Canvas.textout(70,ClientHeight - 17,timetext);
       end;
   end;
end;

procedure TfrmView.FormClose(Sender: TObject; var Action: TCloseAction);
begin
//  Action := caFree;
	if Inited then
		Shutdown3D;
end;

procedure TfrmView.FormCreate(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   Top := r.ReadInteger('ViewWindow','Top',0);
   Left := r.ReadInteger('ViewWindow','Left',0);
   Width := r.ReadInteger('ViewWindow','Width',200);
   Height := r.ReadInteger('ViewWindow','Height',320);
	WindowState := TWindowState(r.ReadInteger('ViewWindow','WindowState',0));
   r.free;
	inited := false;

end;

procedure TfrmView.SetView(v:integer);
var
   junk,junk1,junk2:string;
   P:Pointer;
	label dllerror;
begin

	if (v = 0) then
   begin
		if (inited) then
	       FreeLibrary(hinst);
		inited := false;
       exit;
   end;

	if not inited then
   begin
		junk := 'filmat11.dll' + #0;
		hinst := LoadLibrary(@junk[1]);
		if hinst = 0 then
		begin
       	ShowMessage('Unable to find FILMAT11.DLL or OPENGL32.DLL');
			exit;
       end;

	   junk := '_Init3D@20' + #0;
   	P := GetProcAddress(hinst,@junk[1]);
	   if P = nil then goto dllerror;
   	Init3D := Tinit3d(P);

	   junk := '_Shutdown3D@0' + #0;
   	P := GetProcAddress(hinst,@junk[1]);
	   if P = nil then goto dllerror;
   	Shutdown3d := Tshutdown3d(P);

	   junk := '_ChangeSize@8' + #0;
   	P := GetProcAddress(hinst,@junk[1]);
	   if P = nil then goto dllerror;
   	ChangeSize := Tchangesize(P);

	   junk := '_DoRender@4' + #0;
   	P := GetProcAddress(hinst,@junk[1]);
	   if P = nil then goto dllerror;
   	DoRender := TDoRender(P);

	   junk := '_SetCamera@20' + #0;
   	P := GetProcAddress(hinst,@junk[1]);
	   if P = nil then goto dllerror;
   	DoSetCamera := TDoSetCamera(P);

	   junk := '_ClearEntities@0' + #0;
   	P := GetProcAddress(hinst,@junk[1]);
	   if P = nil then goto dllerror;
   	ClearEntities := TClearEntities(P);

       junk := '_AddEntity@12' + #0;
   	P := GetProcAddress(hinst,@junk[1]);
	   if P = nil then goto dllerror;
   	AddEntity := TAddentity(P);

		junk := '_LoadFile@16' + #0;
		P := GetProcAddress(hinst,@junk[1]);
	   if P = nil then goto dllerror;
		LoadFile := TLoadFile(P);

		junk := '_FreeFile@4' + #0;
		P := GetProcAddress(hinst,@junk[1]);
	   if P = nil then goto dllerror;
		FreeFile := TFreeFile(P);

       junk := frmConfig.Edit2.text + #0;
   	junk1 := Mainform.mapname+#0;
       junk2 := frmConfig.Edit3.text+#0;
       if Init3D(Handle,@junk[1],@junk1[1],@junk2[1],v) <> 1 then
       begin
       	Showmessage('Unable to load ' +Mainform.mapname+'. Make sure your quake directory is set in File/Options');
           FreeLibrary(hinst);
           exit;
       end;
  		ChangeSize(Clientwidth,ClientHeight);
	end;
   inited := true;
   exit;

dllerror:
	ShowMessage('Error loading FILMAT11.DLL');

end;

procedure TfrmView.FormDestroy(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   r.writeInteger('ViewWindow','Top',Top);
   r.writeInteger('ViewWindow','Left',Left);
   r.writeInteger('ViewWindow','Width',Width);
   r.writeInteger('ViewWindow','Height',Height);
   r.writeInteger('ViewWindow','WindowState',Longint(WindowState));
   r.free;
	FreeLibrary(hinst);
   inited := false;
end;

procedure TfrmView.FormActivate(Sender: TObject);
begin
	if Inited then
   	DoRender(Handle);
end;

procedure TfrmView.FormPaint(Sender: TObject);
begin
	if Inited then
   	DoRender(Handle);
end;

procedure TfrmView.FormResize(Sender: TObject);
begin
	if Inited then
   	ChangeSize(Clientwidth,ClientHeight);
   SpeedButton2.top := ClientHeight - SpeedButton2.height;
   SpeedButton3.top := ClientHeight - SpeedButton3.height;
   SpeedButton4.top := ClientHeight - SpeedButton4.height;
   SpeedButton5.top := ClientHeight - SpeedButton5.height;
end;

procedure TfrmView.SpeedButton1Click(Sender: TObject);
begin
	if paused then
       paused := false
	else
   	paused := true;
end;

procedure TfrmView.SpeedButton4Click(Sender: TObject);
var
	i,j:integer;
   mb:Tmessageblock;
   starttime:single;
   starttick:longint;
   lastprinttime:single;
begin
	playing := true;
	starttick := GetTickCount;
   starttime := 0;
   j := frmblocks.listbox1.itemindex;
   for i := j to frmblocks.listbox1.items.count -1 do
   begin
		while (paused) do
       	Application.Processmessages;
		if not playing then
       	exit;
       frmBlocks.listbox1.topindex := i;
       frmBlocks.listbox1.itemindex := i;
		mb := Tmessageblock(frmblocks.listbox1.items.objects[i]);
       if lastprinttime = 0 then
          lastprinttime := mb.time;
		if (mb.time - lastprinttime) > 3.0 then
       	printtext := '';
		if mb.printtext <> '' then
       begin
       	printtext := mb.printtext;
       	lastprinttime := mb.time;
       end;
       if starttime = 0 then
       	starttime := mb.time;
		if (starttime + ((GetTickCount - starttick)/1000)) < mb.time then
       begin
			timetext := floattostr(mb.time);
           DoFrame(mb,true);
			Application.ProcessMessages;
       end else
       	DoFrame(mb,false);
   end;
   playing := false;
end;

procedure TfrmView.SpeedButton3Click(Sender: TObject);
begin
   playing := false;
end;

procedure TfrmView.WaveOut1WaveOutDone(Sender: TObject);
begin
	FreeFile(soundp);
	soundplaying := false;
//   Waveout1.close;
end;

end.
