unit sounds;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls,Registry, Menus;

type
  TfrmSounds = class(TForm)
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
	function FindSound(s:string):integer;
  end;

var
  frmSounds: TfrmSounds;

implementation

uses Main, view;

{$R *.DFM}

function TfrmSounds.FindSound(s:string):integer;
var
	i:integer;
begin
	for i := 0 to listbox1.items.count -1 do
   begin
		if listbox1.items[i] = s then
   	begin
       	Result := i+1;
           exit;
       end;
   end;
   Result := -1;
end;

procedure TfrmSounds.FormCreate(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   Top := r.ReadInteger('SoundWindow','Top',0);
   Left := r.ReadInteger('SoundWindow','Left',0);
   Width := r.ReadInteger('SoundWindow','Width',200);
   Height := r.ReadInteger('SoundWindow','Height',320);
	WindowState := TWindowState(r.ReadInteger('SoundWindow','WindowState',0));
   r.free;
end;

procedure TfrmSounds.FormDestroy(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   r.writeInteger('SoundWindow','Top',Top);
   r.writeInteger('SoundWindow','Left',Left);
   r.writeInteger('SoundWindow','Width',Width);
   r.writeInteger('SoundWindow','Height',Height);
   r.writeInteger('SoundWindow','WindowState',Longint(WindowState));
   r.free;
end;

procedure TfrmSounds.ListBox1Click(Sender: TObject);
begin
  	Mainform.Statusbar.simpletext := 'Sound #' +inttostr(listbox1.itemindex);
end;

procedure TfrmSounds.ListBox1DblClick(Sender: TObject);
begin
	frmView.Playsound(frmSounds.listbox1.items[frmSounds.listbox1.itemindex]);
end;

end.
