unit qserv;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,winsock,
  StdCtrls, ExtCtrls,main,math, SuperTimer;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    SuperTimer1: TSuperTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  protected
  	procedure SockEvent(var m:Tmessage);message WM_USER+1;
	procedure SendControlPacket(t:integer;data:pchar;len:integer;toaddr:Tsockaddr);
	procedure SendReliableGamePacket(data:pchar;len:integer;toaddr:Tsockaddr);
	procedure SendUnreliableGamePacket(data:pchar;len:integer;toaddr:Tsockaddr);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
	servsock,clientsock:Tsocket;
	reliableorder,unreliableorder:longint;
	mode:integer;
	clientaddr:Tsockaddr;
	numkeepalives :integer;
   outstandingacks:integer;
   currentblock:integer;
   anglemsg:Tmsg;
	ugp:Pchar;
implementation

uses blocks;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
	bind_sin:TSockaddr;
   i:integer;
   wsd:Twsadata;
begin
	i := WSAStartup($101,wsd);
   if i <> 0 then
   begin
   	showmessage('Unable to init Winsock');
       exit;
   end;
	servsock := socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP);
   if servsock < 0 then
   begin
   	showmessage('Unable to get a socket');
       exit;
   end;
	bind_sin.sin_family := AF_INET;
   bind_sin.sin_port := htons(26000);
   bind_sin.sin_addr.S_addr := 0;
	i := bind(servsock,bind_sin,sizeof(bind_sin));
   if i <> 0 then
   begin
   	showmessage('Unable to bind');
       exit;
   end;
	i:= WSAAsyncSelect(servsock,Handle,WM_USER+1,FD_READ);
   if i <> 0 then
   begin
   	showmessage('Unable to WSAAsyncSelect');
       exit;
   end;

   anglemsg := Tmsg.create;
   anglemsg.p := allocmem(4);
   anglemsg.p[0] := #$A; //setangle
	ugp := allocmem(1024);
end;

procedure TForm1.SockEvent(var m:Tmessage);
var
	inbuf,outbuf:array[0..1024] of char;
   client_sin:Tsockaddrin;
   i,j:integer;
   g:integer;
   p:pchar;
   junk:string;
   mb:Tmessageblock;
   mm:Tmsg;
   a:longint;
   z:Plongint;
begin
	j := sizeof(clientaddr);
	i := recvfrom(m.wparam,inbuf,1024,0,clientaddr,j);
	p := @g;
   g := 0;
	p[1] := inbuf[0];
	p[0] := inbuf[1];
  // listbox1.items.add(inttostr(i));
	if frmBlocks.listbox1.items.count = 0 then
   	exit;

	case g of
   1: //reliable msg...should never get these
		begin
			listbox1.items.add('got reliable msg');
       end;
   2: //ack of reliable msg...we'll ingnore these
		begin
			p := @a;
			p[3] := inbuf[4];
			p[2] := inbuf[5];
			p[1] := inbuf[6];
			p[0] := inbuf[7];
			listbox1.items.add('got ack of reliable msg '+ inttostr(a));
           dec(outstandingacks);
       end;
   9: //end of reliable...we should only ever get these
		begin
			p := @a;
			p[3] := inbuf[4];
			p[2] := inbuf[5];
			p[1] := inbuf[6];
			p[0] := inbuf[7];
			listbox1.items.add('got end of reliable msg '+inttostr(a));
			//turn this into an ack and send it back
			p := @g;
   		g := 2;
			inbuf[0] := p[1];
			inbuf[1] := p[0];
			g := 8;
			inbuf[2] := p[1];
			inbuf[3] := p[0];
           sendto(clientsock,inbuf,8,0,clientaddr,sizeof(clientaddr));
			listbox1.items.add('sending ack of ' + inttostr(a));
           j := 8;
           while j < i do begin
			inc(j);
			case inbuf[j-1] of
           #0: //nop
           	begin
					listbox1.items.add('got nop');
               end;
           #1: //keep alive
           	begin
					listbox1.items.add('got keep alive');
               end;
           #2: //disconnect
           	begin
					listbox1.items.add('got disconnect');
               	mode := -1;
                   Supertimer1.enabled := false;
               end;
           #3: //client movement
           	begin
					listbox1.items.add('got client movement');
               end;
           #4: //console order
           	begin
               	junk := strpas(@inbuf[j]);
                   j := j + length(junk) + 1;
					listbox1.items.add('got console order "'+junk+'" in mode '+inttostr(mode));
       				// watch for "prespawn"
                       if junk = 'prespawn' then
                       begin
           				// send block #1
		           			mode := 2;
                       end;
       				// watch for "spawn "
                       if junk = 'spawn ' then
                       begin
           				// send block #2
		           			mode := 3;
                       end;
       				//watch for "begin"
                       if junk = 'begin' then
                       begin
           				// start streaming demo
                           mode := 4;
                       end;
               end;
           end;
           end;
       end;
   $10: //update msg
		begin
//			listbox1.items.add('got update msg');
       end;
	32768: // control msg
		begin
			p := @g;
   		g := 0;
			p[1] := inbuf[2];
			p[0] := inbuf[3];
       	case inbuf[4] of
       	#1: //connection request
       		begin
				listbox1.items.add('got connect request');
					// send accept
					junk := #0#0#0#0;
                   clientsock := socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP);
                   client_sin.sin_family := AF_INET;
   				client_sin.sin_port := 0;
   				client_sin.sin_addr.S_addr := 0;
					i := bind(clientsock,client_sin,sizeof(client_sin));
					i := sizeof(client_sin);
                   i := getsockname(clientsock,client_sin,i);
					p := @client_sin.sin_port;
					junk[1] := p[1];
                   junk[2] := p[0];
					i := WSAAsyncSelect(clientsock,Handle,WM_USER+1,FD_READ);
					SendControlPacket($81,@junk[1],4,clientaddr);
					SuperTimer1.interval := 20;
					SuperTimer1.enabled := true;
           	end;
       	#2: //server info request
       		begin
					listbox1.items.add('got server info request');
                   junk := '192.0.0.2:26000'+#0+ 'test' + #0 + 'dm3'+#0#4#8#3;
					junk := #$31#$36#$35#$2e#$32#$32#$30#$2e#$31#$36#$2e#$36#$3a#$32#$36#$30#$30#$30#$0#$6e#$6f#$69#$64#$65#$6e#$74#$69#$74#$79#$0#$65#$31#$6d#$32#$0#$4#$8#$3;
					SendControlPacket($83,@junk[1],38,clientaddr);
           	end;
       	#3: //player info request
       		begin
					listbox1.items.add('got player info request');
           	end;
       	#4: //rule info request
       		begin
					listbox1.items.add('got rule info request');
           	end;
       	end;
   	end;
   end;
end;

procedure Tform1.SendControlPacket(t:integer;data:pchar;len:integer;toaddr:Tsockaddr);
var
	outbuf:array[0..1023] of char;
   g,i:integer;
   p:pchar;
begin
	g := 32768;
   p := @g;
   outbuf[0] := p[1];
   outbuf[1] := p[0];
   g := len+5;
   p := @g;
   outbuf[2] := p[1];
   outbuf[3] := p[0];
   outbuf[4] := chr(t);
	CopyMemory(@outbuf[5],data,len);
   i := sendto(servsock,outbuf,g,0,toaddr,sizeof(toaddr));
   listbox1.items.add('sent control '+inttostr(i));
end;

procedure Tform1.SendReliableGamePacket(data:pchar;len:integer;toaddr:Tsockaddr);
var
	outbuf:array[0..1023] of char;
   g:integer;
   p:pchar;
   i,j,plen,maxpacketsize:integer;
begin
	i := 0;
	plen := len;
   maxpacketsize := 1016;
	while (plen > maxpacketsize) do
   begin
		g := 1;
       p := @g;
       outbuf[0] := p[1];
       outbuf[1] := p[0];
		g := maxpacketsize+8;
       outbuf[2] := p[1];
       outbuf[3] := p[0];
		p := @reliableorder;
       outbuf[4] := p[3];
       outbuf[5] := p[2];
       outbuf[6] := p[1];
       outbuf[7] := p[0];
		CopyMemory(@outbuf[8],data+i,maxpacketsize);
       plen := plen - maxpacketsize;
       i := i + maxpacketsize;
   	j := sendto(clientsock,outbuf,maxpacketsize+8,0,toaddr,sizeof(toaddr));
   	listbox1.items.add('sent reliable1 '+inttostr(j));
		inc(reliableorder);
       inc(outstandingacks);
   end;
		g := 9;
       p := @g;
       outbuf[0] := p[1];
       outbuf[1] := p[0];
		g := plen+8;
       outbuf[2] := p[1];
       outbuf[3] := p[0];
		p := @reliableorder;
       outbuf[4] := p[3];
       outbuf[5] := p[2];
       outbuf[6] := p[1];
       outbuf[7] := p[0];
		CopyMemory(@outbuf[8],data+i,plen);
   	j := sendto(clientsock,outbuf,plen+8,0,toaddr,sizeof(toaddr));
   	listbox1.items.add('sent reliable9 '+inttostr(j));
		inc(reliableorder);
       inc(outstandingacks);
end;

procedure Tform1.SendUnreliableGamePacket(data:pchar;len:integer;toaddr:Tsockaddr);
var
   g,j:integer;
   p:pchar;
begin
		g := $10;
       p := @g;
       data[0] := p[1];
       data[1] := p[0];
		g := len;
       data[2] := p[1];
       data[3] := p[0];
		p := @unreliableorder;
       data[4] := p[3];
       data[5] := p[2];
       data[6] := p[1];
       data[7] := p[0];
   	j := sendto(clientsock,data[0],len,0,toaddr,sizeof(toaddr));
//   	listbox1.items.add('sent update '+inttostr(order));
		inc(unreliableorder);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
	WSACleanup;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
	junk:string;
   mb:tmessageblock;
   p:pchar;
   mm:tmsg;
   j:integer;
begin
   case mode of
   0: //send keepalives
		begin
			if numkeepalives > 2 then
           	mode := 1;
           inc(numkeepalives);
			junk := #0#0#0#0#0#0#0#0#1;
			listbox1.items.add('sent keep-alive');
			SendUnreliableGamePacket(@junk[1],9,clientaddr);
       end;
   1: //send block #0
		begin
               	//send block #0
              		mb := Tmessageblock(frmBlocks.listbox1.items.objects[0]);
					p := allocmem(mb.blocksize);
               	mm := mb.m;
               	j := 0;
               	while (mm <> nil) do
               	begin
						CopyMemory(@p[j],mm.p,mm.size);
                   	j := j + mm.size;
                   	mm := mm.next;
               	end;
					SendReliableGamePacket(p,mb.blocksize,clientaddr);
					freemem(p);
               	mode := -1;
       end;
   2: //send block #1
		begin
       	if (outstandingacks = 0) then
           begin
               	//send block #1
               	mb := Tmessageblock(frmBlocks.listbox1.items.objects[1]);
					p := allocmem(mb.blocksize);
               	mm := mb.m;
               	j := 0;
               	while (mm <> nil) do
               	begin
						CopyMemory(@p[j],mm.p,mm.size);
                   	j := j + mm.size;
                   	mm := mm.next;
               	end;
					SendReliableGamePacket(p,mb.blocksize,clientaddr);
					freemem(p);
               	mode := -1;
           end;
       end;
   3: //send block #2
		begin
       	if (outstandingacks = 0) then
           begin
               	//send block #2
               	mb := Tmessageblock(frmBlocks.listbox1.items.objects[2]);
					p := allocmem(mb.blocksize);
               	mm := mb.m;
               	j := 0;
               	while (mm <> nil) do
               	begin
						CopyMemory(@p[j],mm.p,mm.size);
                   	j := j + mm.size;
                   	mm := mm.next;
               	end;
					SendReliableGamePacket(p,mb.blocksize,clientaddr);
					freemem(p);
               	mode := -1;
                   currentblock := 3;
           end;
       end;
   4: //running...stream msgs
		begin
               	mb := Tmessageblock(frmBlocks.listbox1.items.objects[currentblock]);
               	mm := mb.m;
               	j := 8;
               	while (mm <> nil) do
               	begin
						CopyMemory(@ugp[j],mm.p,mm.size);
                   	j := j + mm.size;
                   	mm := mm.next;
               	end;
                   //insert setangles msg to set camera properly...damn this is clever...wish i'd thought of it
					anglemsg.p[1] := chr(floor(mb.angles[0] * 256 / 360));
					anglemsg.p[2] := chr(floor(mb.angles[1] * 256 / 360));
					anglemsg.p[3] := chr(floor(mb.angles[2] * 256 / 360));
                   CopyMemory(@ugp[j],anglemsg.p,4);
					SendUnreliableGamePacket(ugp,mb.blocksize+4+8,clientaddr);
                   inc(currentblock);
                   if currentblock > (frmBlocks.listbox1.items.count -1) then
                   begin
                   	mode := -1;
                       SuperTimer1.enabled := false;
                   end;
       end;
   end;
end;

end.
