unit models;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls,Registry;

type
  TfrmModels = class(TForm)
    ListBox1: TListBox;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
	function FindModel(s:string):integer;
  end;

var
  frmModels: TfrmModels;

implementation

uses Main;

{$R *.DFM}
function TfrmModels.FindModel(s:string):integer;
var
	i:integer;
begin
	for i := 0 to listbox1.items.count -1 do
   begin
		if listbox1.items[i] = s then
   	begin
       	Result := i;
           exit;
       end;
   end;
   Result := -1;
end;

procedure TfrmModels.FormDestroy(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   r.writeInteger('ModelsWindow','Top',Top);
   r.writeInteger('ModelsWindow','Left',Left);
   r.writeInteger('ModelsWindow','Width',Width);
   r.writeInteger('ModelsWindow','Height',Height);
   r.writeInteger('ModelsWindow','WindowState',Longint(WindowState));
   r.free;
end;

procedure TfrmModels.FormCreate(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   Top := r.ReadInteger('ModelsWindow','Top',0);
   Left := r.ReadInteger('ModelsWindow','Left',0);
   Width := r.ReadInteger('ModelsWindow','Width',200);
   Height := r.ReadInteger('ModelsWindow','Height',320);
	WindowState := TWindowState(r.ReadInteger('ModelsWindow','WindowState',0));
   r.free;
end;

procedure TfrmModels.ListBox1Click(Sender: TObject);
begin
  	Mainform.Statusbar.simpletext := 'Model #' +inttostr(listbox1.itemindex);
end;

end.
