/*---------------------------------------------------------\
|                                                          |
| leveldata.h                                              |
|                                                          |
| by Joel Beaudoin                                         |
|                                                          |
|----------------------------------------------------------|
|                                                          |
| This module contains routines for loading the necessary  |
| information from a Quake BSP file. The data loaded has   |
| global scope for now.                                    |
|                                                          |
\---------------------------------------------------------*/


extern BSPPALETTEENTRY qpalette[256];

extern BSPMODEL levelModel;

extern BSPFACE* faces;
extern unsigned short numFaces;

extern BSPTEXINFO* texinfos;
extern short numTexinfos;

extern BSPMIPTEXLUMP* miptexlump;
extern long sizeOfMiptexLump;


extern BSPEDGE* edges;
extern long numEdges;

extern long* edgeIndices;
extern long numEdgeIndices;

extern BSPVERTEX* vertices;
extern unsigned short numVertices;


extern STATUS loadLevelData(void);
extern void destroyLevelData(void);

extern BSPVERTEX* v;

extern BSPNODE *nodes;
extern long numNodes;

extern BSPLEAF *leaves;
extern long numLeaves;

extern BSPMODEL *models;
extern long numModels;

extern BSPPLANE *planes;
extern long numPlanes;

extern u_char *visilist;