/*---------------------------------------------------------\
|                                                          |
| leveldata.c                                              |
|                                                          |
| by Joel Beaudoin                                         |
|                                                          |
|----------------------------------------------------------|
|                                                          |
| This module contains routines for loading the necessary  |
| information from a Quake BSP file. The data loaded has   |
| global scope for now.                                    |
|                                                          |
\---------------------------------------------------------*/


#include <windows.h>
#include <stdlib.h>
#include <time.h>
#include "Bspfile.h"

float randUnitScalar(void);
void loadPalette(void);


/*---------------------------------------------------------------*/

/*------------------\
|                   |
| GLOBAL LEVEL DATA |
|                   |
\------------------*/

BSPMODEL levelModel;

BSPPALETTEENTRY qpalette[256];

BSPFACE* faces = NULL;
unsigned short numFaces = 0;

//BSPTEXINFO* texinfos = NULL;
//short numTexinfos = 0;

//BSPMIPTEXLUMP* miptexlump = NULL;
//long sizeOfMiptexLump = 0;

BSPEDGE* edges = NULL;
long numEdges = 0;

long* edgeIndices = NULL;
long numEdgeIndices = 0;

BSPVERTEX* vertices = NULL;
unsigned short numVertices = 0;

BSPVERTEX* v = NULL;

BSPNODE *nodes=NULL;
long numNodes = 0;

BSPLEAF *leaves=NULL;
long numLeaves = 0;

//BSPENTITY entities[MAX_MAP_ENTITIES];
//long numEntities = 0;

BSPMODEL *models=NULL;
long numModels = 0;

BSPPLANE *planes=NULL;
long numPlanes = 0;

u_char *visilist=NULL;
long vlsize = 0;

/*----------------------\
|                       |
| END GLOBAL LEVEL DATA |
|                       |
\----------------------*/

/*---------------------------------------------------------------*/

STATUS loadLevelData(void)
{
	int i;

	getModel(&levelModel, 0);
	
	numFaces = getNumFaces();
	faces = (BSPFACE*)calloc(numFaces, sizeof(BSPFACE));
	if(faces == NULL)
	{
		MessageBox(NULL, "Error allocating faces array.", NULL, MB_OK);
		return FAILURE;
	}
	getFaceArray(faces);

	v = (BSPVERTEX*)calloc(numFaces, sizeof(BSPVERTEX));
	if(v == NULL)
	{
		MessageBox(NULL, "Error allocating face color array.", NULL, MB_OK);
		return FAILURE;
	}
	for(i=0; i<numFaces; i++)
	{
		v[i].x = randUnitScalar();
		v[i].y = randUnitScalar();
		v[i].z = randUnitScalar();
	}

/*	numTexinfos = getNumTexinfos();
	texinfos = (BSPTEXINFO*)calloc(numTexinfos, sizeof(BSPTEXINFO));
	if(texinfos == NULL)
	{
		MessageBox(NULL, "Error allocating texinfos array.", NULL, MB_OK);
		return FAILURE;
	}
	getTexinfoArray(texinfos);
*/	
/*	sizeOfMiptexLump = getSizeOfMiptexLump();
	miptexlump = (BSPMIPTEXLUMP*)calloc(1, sizeOfMiptexLump);
	if(miptexlump == NULL)
	{
		MessageBox(NULL, "Error allocating miptex lump.", NULL, MB_OK);
		return FAILURE;
	}
	getMiptexLump(miptexlump);
*/
	//loadPalette();
		
	numEdges = getNumEdges();
	edges = (BSPEDGE*)calloc(numEdges, sizeof(BSPEDGE));
	if(edges == NULL)
	{
		MessageBox(NULL, "Error allocating edges array.", NULL, MB_OK);
		return FAILURE;
	}
	getEdgeArray(edges);

	numEdgeIndices = getNumEdgeIndices();
	edgeIndices = (long*)calloc(numEdgeIndices, sizeof(long));
	if(edgeIndices == NULL)
	{
		MessageBox(NULL, "Error allocating edge indices array.", NULL, MB_OK);
		return FAILURE;
	}
	getEdgeIndicesArray(edgeIndices);

	numVertices = getNumVertices();
	vertices = (BSPVERTEX*)calloc(numVertices, sizeof(BSPVERTEX));
	if(vertices == NULL)
	{
		MessageBox(NULL, "Error allocating vertices array.", NULL, MB_OK);
		return FAILURE;
	}
	getVerticesArray(vertices);

/*	numNodes = getNumNodes();
	nodes = (BSPNODE*)calloc(numNodes, sizeof(BSPNODE));
	if(nodes == NULL)
	{
		MessageBox(NULL, "Error allocating nodes array.", NULL, MB_OK);
		return FAILURE;
	}
	getNodeArray(nodes);

	numLeaves = getNumLeaves();
	leaves = (BSPLEAF*)calloc(numLeaves, sizeof(BSPLEAF));
	if(leaves == NULL)
	{
		MessageBox(NULL, "Error allocating leaves array.", NULL, MB_OK);
		return FAILURE;
	}
	getLeavesArray(leaves);

	numEntities = getNumEntities();
	entities = (BSPENTITY*)calloc(numEntities, sizeof(BSPENTITY));
	if(entities == NULL)
	{
		MessageBox(NULL, "Error allocating entities array.", NULL, MB_OK);
		return FAILURE;
	}
	getEntitiesArray(entities);

	numModels = getNumModels();
	models = (BSPMODEL*)calloc(numModels, sizeof(BSPMODEL));
	if(models == NULL)
	{
		MessageBox(NULL, "Error allocating models array.", NULL, MB_OK);
		return FAILURE;
	}
	getModelsArray(models);

	numPlanes = getNumPlanes();
	planes = (BSPPLANE*)calloc(numPlanes, sizeof(BSPPLANE));
	if(planes == NULL)
	{
		MessageBox(NULL, "Error allocating planes array.", NULL, MB_OK);
		return FAILURE;
	}
	getPlanesArray(planes);

	vlsize = getVisiListSize();
	visilist = (u_char *)calloc(vlsize, 1);
	if(visilist == NULL)
	{
		MessageBox(NULL, "Error allocating visilist array.", NULL, MB_OK);
		return FAILURE;
	}
	getVisiList(visilist);
*/
	return SUCCESS;
}

/*---------------------------------------------------------------*/

float randUnitScalar(void)
{
    float num;
	
	//srand((unsigned)time( NULL ));
    num = ((float)rand()) / ((float)(RAND_MAX+1));
    return num;
}

/*---------------------------------------------------------------*/

void loadPalette(void)
{
	FILE* palettefile = NULL;
	
	palettefile = fopen("\\QUAKE\\ID1\\GFX\\PALETTE.LMP", "rb");
	if(palettefile != NULL)
	{
		fread(qpalette, 3*256, 1, palettefile);
		fclose(palettefile);
	}
	else
	{
		MessageBox(NULL, "Error loading palette.", NULL, MB_OK);
		exit(1);
	}
}

/*---------------------------------------------------------------*/

void destroyLevelData(void)
{
	if(faces != NULL)
		free(faces);
//	if(texinfos != NULL)
//		free(texinfos);
//	if(miptexlump != NULL)
//		free(miptexlump);
	if(edges != NULL)
		free(edges);
	if(edgeIndices != NULL)
		free(edgeIndices);
	if(vertices != NULL)
		free(vertices);
	if(nodes != NULL)
		free(nodes);
	if(leaves != NULL)
		free(leaves);
	if(planes != NULL)
		free(planes);
}
