unit film1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type
	TMessageBlock = record
   	blocksize:longint;
       angles:array[0..2] of single;
       msg:Pchar;
	end;
   TMsg = class(Tobject)
   	id:integer;
       size:integer;
       p:pchar;
   end;
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    TreeView1: TTreeView;
    Panel1: TPanel;
    Edit2: TEdit;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  lastsearchnode:longint;

implementation

uses filmprog;

{$R *.DFM}

procedure memcpy(dst,src:Pchar;len:integer);
var
	i:integer;
begin
	for i := 0 to len-1 do
   begin
		dst[i] := src[i];
   end;
end;
procedure TForm1.Button1Click(Sender: TObject);
var
	f:TFileStream;
   c,d:char;
   line:string;
   flen,fpos:longint;
   cdtrack,i,len,j,k,blocks,msgs:integer;
   mask:smallint;
   mb:Tmessageblock;
   p,q:pchar;
   desc:string;
   m:Tmsg;
   root:Ttreenode;
   whole:pchar;
	a:Plongint;
   b:Psingle;
begin
	blocks := 0;
   msgs := 0;
	{read file into memory}
	f := TFileStream.create(edit1.text,fmOpenRead);
	flen := f.size;
	whole := allocmem(flen);
   fpos := f.read(whole^,flen);
	if (fpos <> flen) then
   	SHowmessage('Error loading file');
   F.destroy;

	frmProgress.Progressbar1.min := 0;
	frmProgress.Progressbar1.max := flen / 32000;
	frmProgress.Progressbar1.position := 0;
	frmProgress.Show;
	fpos := 0;
	line := '';
	q := whole;

   while (1=1) do
   begin
		c := q^;
       inc(q);
       fpos := fpos + i;
       if (c = #10) then
       	break;
       line := line + c;
   end;
   cdtrack := strtoint(line);
	fpos := 0;
	while (fpos < flen) do
   begin
		a := Plongint(q);
       q := q + 4;
		mb.Blocksize := a^;
		b := Psingle(q);
       q := q + 4;
		mb.angles[0] := b^;
		b := Psingle(q);
       q := q + 4;
		mb.angles[1] := b^;
		b := Psingle(q);
       q := q + 4;
		mb.angles[2] := b^;

		mb.msg := q;
       q := q + mb.blocksize;

		fpos := q-whole;
{		frmProgress.Progressbar1.position := fpos;}
		frmProgress.label1.caption := 'Loading ' + inttostr(fpos) +' of '+inttostr(flen);
		frmProgress.label1.refresh;
		root := TreeView1.items.addchild(Treeview1.items[0],'block '+inttostr(blocks));
       inc(blocks);

       i:= 0;
		while( i < mb.blocksize -1) do
       begin
			c := mb.msg[i]; { get the msg id }
			i := i + 1;
	       case (c) of
       #0: {bad len=0}
       	begin
           	desc := 'bad!!';
				len := 0;
           end;
       #1: {nop len=0}
       	begin
           	desc := 'NOP';
				len := 0;
           end;
       #2: {disconnect len=0}
       	begin
           	desc := 'disconnect';
				len := 0;
           end;
       #3: {updatestat len=3 byte index, int value}
       	begin
           	desc := 'updatestat';
				len := 5;
           end;
       #4: {version len=2 int ver (0x0F) }
       	begin
           	desc := 'version ';
				len := 4;
           end;
       #5: {setview len=2 int entity}
       	begin
           	desc := 'setview';
				len := 2;
           end;
       #6: {sound len=18?}
       	begin
           	desc := 'sound';
				len := 10;
				mask := ord(mb.msg[i]);
               if ((mask and 1)=1) then
               	len := len + 1;
               if ((mask and 2)=2) then
               	len := len + 1;
				len := len
           end;
       #7: {time len=4}
       	begin
           	desc := 'time';
				len := 4;
           end;
       #8: {print len=null term string }
       	begin
				j := i;
               c := mb.msg[j];
           	desc := 'print "' +strpas(@mb.msg[j])+'"';
				len := 0;
               while (1=1) do
               begin
               	c := mb.msg[j];
                   inc(j);
                   inc(len);
                   if (c = #0) then
                   	break;
               end;
           end;
       #9: {stufftext len=string}
       	begin
				j := i;
               c := mb.msg[j];
           	desc := 'stufftext "' +strpas(@mb.msg[j])+'"';
				len := 0;
               while (1=1) do
               begin
               	c := mb.msg[j];
                   inc(j);
                   inc(len);
                   if (c = #0) then
                   	break;
               end;
           end;
       #$A: {setangle len=1}
       	begin
           	desc := 'setangle';
				len := 1;
           end;
		#$B: {serverinfo len=}
       	begin
           	desc := 'serverinfo';
				len := 6;
				j := i+6;
				while (mb.msg[j] <> #0) do {read a bunch of strings }
               begin
               	c := mb.msg[j];
               	while (1=1) do
               	begin
               		c := mb.msg[j];
                   	inc(j);
                   	inc(len);
                   	if (c = #0) then
                   		break;
               	end;
				end;
               inc(j);
               inc(len);
				while (mb.msg[j] <> #0) do {read a bunch of strings }
               begin
               	c := mb.msg[j];
               	while (1=1) do
               	begin
               		c := mb.msg[j];
                   	inc(j);
                   	inc(len);
                   	if (c = #0) then
                   		break;
               	end;
				end;
               inc(j);
               inc(len);
           end;
		#$C: {lightstyle}
       	begin
           	desc := 'lightstyle';
           	len := 1;
               j := i +1;
               while (1=1) do
               begin
               	c := mb.msg[j];
                   inc(j);
                   inc(len);
                   if (c = #0) then
                   	break;
               end;
           end;
		#$D: {updatename}
       	begin
               j := i +1;
               c := mb.msg[j];
           	desc := 'updatename "' +strpas(@mb.msg[j])+'"';
           	len := 1;
               while (1=1) do
               begin
               	c := mb.msg[j];
                   inc(j);
                   inc(len);
                   if (c = #0) then
                   	break;
               end;
			end;
		#$E: {updatefrags}
       	begin
           	desc := 'updatefrags';
           	len := 3;
			end;
       #$F: {clientdata}
       	begin;
           	desc := 'clientdata';
               mask := 0;
               p := @mask;
				p[0] := mb.msg[i];
               p[1] := mb.msg[i+1];
				len := 10;
               if ((mask and $1)<>0) then
               	inc(len);
               if ((mask and $2)<>0) then
               	inc(len);

               if ((mask and $4)<>0) then
               	inc(len);
               if ((mask and $20)<>0) then
               	inc(len);
               if ((mask and $8)<>0) then
               	inc(len);
               if ((mask and $40)<>0) then
               	inc(len);
               if ((mask and $10)<>0) then
               	inc(len);
               if ((mask and $80)<>0) then
               	inc(len);

               if ((mask and $200)<>0) then {items}
               	len := len + 4;

               if ((mask and $1000)<>0) then
               	inc(len);
               if ((mask and $2000)<>0) then
               	inc(len);
               if ((mask and $4000)<>0) then
               	inc(len);
               end;
		#$10: {stopsound}
       	begin
           	desc := 'stopsound';
           	len := 2;
			end;
		#$11: {updatecolors}
       	begin
           	desc := 'updatecolors';
           	len := 2;
			end;
		#$12: {particle}
       	begin
           	desc := 'particle';
           	len := 11;
			end;
		#$13: {damage}
       	begin
           	desc := 'damage';
           	len := 8;
			end;
		#$14: {spawnstatic}
       	begin
           	desc := 'spawnstatic';
           	len := 13;
			end;
		#$15: {spawnbinary...obsolete, shouldn't occur}
       	begin
           	desc := 'spawnbinary...obselete';
           	len := 0;
			end;
		#$16: {spawnbaseline}
       	begin
               p := @mask;
				p[0] := mb.msg[i];
               p[1] := mb.msg[i+1];
           	desc := 'spawnbaseline '+inttostr(mask);;
           	len := 15;
			end;
		#$17: {tempentity}
       	begin
           	desc := 'tempentity';
           	mask := ord(mb.msg[i]);
               case (mask) of
               0,1,2,3,4,7,8,10,11:
               	len := 7;
				5,6,9:
		           	len := 15;
               end;
			end;
		#$18: {setpause}
       	begin
           	desc := 'setpause';
           	len := 1;
			end;
		#$19: {signon}
       	begin
           	desc := 'signon - '+inttostr(ord(mb.msg[i]));
           	len := 1;
			end;
		#$1A: {centerprint}
       	begin
           	len := 0;
               j := i;
	           	c := mb.msg[j];
               desc := 'centerprint "'+strpas(@mb.msg[j])+'"';
               while (1=1) do
               begin
               	c := mb.msg[j];
                   inc(j);
                   inc(len);
                   if (c = #0) then
                   	break;
               end;
			end;
		#$1B: {killedmonster}
       	begin
           	desc := 'killedmonster';
           	len := 0;
			end;
		#$1C: {foundsecret}
       	begin
           	desc := 'foundsecret';
           	len := 0;
			end;
		#$1D: {spawnstaticsound}
       	begin
           	desc := 'spawnstaticsound';
           	len := 9;
			end;
		#$1E: {intermission}
       	begin
           	desc := 'intermission';
           	len := 0;
			end;
		#$1F: {finale}
       	begin
           	desc := 'finale';
           	len := 0;
               j := i;
               while (1=1) do
               begin
               	c := mb.msg[j];
                   inc(j);
                   inc(len);
                   if (c = #0) then
                   	break;
               end;
			end;

       #$20: {cdtrack len=2}
       	begin
           	desc := 'cdtrack';
           	len := 2;
           end;
		#$21: {sellscreen}
       	begin
           	desc := 'sellscreen';
           	len := 0;
			end;
		else {updateentity}
			begin;
				mask := ord(c) and $7f;
				len := 0;
				j :=i;
               if ((mask and $1)<>0) then
               begin
               	p := @mask;
                   p[1] := mb.msg[i];
{               	mask := mask or (ord(mb.msg[i]) shl 8);}
               	inc(len);
                   inc(j);
               end;
               if ((mask and $4000)<>0) then {entity}
				begin
					p := @k;
                   k := 0;
                   p[0] := mb.msg[j];
                   p[1] := mb.msg[j+1];
               	len := len +2;
               end
               else
               begin
               	len := len + 1;
					k := ord(mb.msg[j]);
               end;
           	desc := 'updateentity ' +inttostr(k)+' '+ inttostr(mask);

               if ((mask and $400)<>0) then {modelindex}
               	len := len +1;
               if ((mask and $40)<>0) then {frame}
               	len := len +1;
               if ((mask and $800)<>0) then {colormap}
               	len := len +1;
               if ((mask and $1000)<>0) then {skin}
               	len := len +1;
               if ((mask and $2000)<>0) then {effects}
               	len := len +1;

               if ((mask and $2)<>0) then
               	len := len +2;
               if ((mask and $100)<>0) then
               	len := len +1;
               if ((mask and $4)<>0) then
               	len := len +2;
               if ((mask and $10)<>0) then
               	len := len +1;
               if ((mask and $8)<>0) then
               	len := len +2;
               if ((mask and $200)<>0) then
               	len := len +1;
           end;
       end;
		inc(msgs);
		m := Tmsg.create;
       m.id := ord(c);
       m.size := len;
		m.p := @mb.msg[i];
		Treeview1.items.AddChildObject(root,desc,m);
		i := i + len;

       end;
   end;
   frmProgress.hide;
   Panel1.caption := Edit1.text + ' loaded, '+inttostr(blocks)+' blocks, '+inttostr(msgs)+' msgs';
   freemem(whole);
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
	i:integer;
   p:pchar;
   m:Tmsg;
begin
end;

procedure TForm1.Button2Click(Sender: TObject);
var
	i:integer;
begin
	for i := lastsearchnode+1 to TreeView1.items.count -1 do
   begin
   	if  pos(edit2.text,Treeview1.items[i].text) >0 then
       begin
			TreeView1.items[i].makevisible;
           lastsearchnode := i;
			exit;
       end;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	Lastsearchnode := 0;
end;

end.
