unit entities;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls,Registry;

type
  TfrmEntities = class(TForm)
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
	function FindEntity(ent:string):integer;
  end;

var
  frmEntities: TfrmEntities;

implementation

uses Main;

{$R *.DFM}

function TfrmEntities.FindEntity(ent:string):integer;
var
	i:integer;
begin
	for i := 0 to listbox1.items.count -1 do
   begin
		if listbox1.items[i] = ent then
   	begin
       	Result := i;
           exit;
       end;
   end;
   Result := -1;
end;

procedure TfrmEntities.FormCreate(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   Top := r.ReadInteger('EntitiesWindow','Top',0);
   Left := r.ReadInteger('EntitiesWindow','Left',0);
   Width := r.ReadInteger('EntitiesWindow','Width',200);
   Height := r.ReadInteger('EntitiesWindow','Height',320);
	WindowState := TWindowState(r.ReadInteger('EntitiesWindow','WindowState',0));
   r.free;
end;

procedure TfrmEntities.FormDestroy(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   r.writeInteger('EntitiesWindow','Top',Top);
   r.writeInteger('EntitiesWindow','Left',Left);
   r.writeInteger('EntitiesWindow','Width',Width);
   r.writeInteger('EntitiesWindow','Height',Height);
   r.writeInteger('EntitiesWindow','WindowState',Longint(WindowState));
   r.free;
end;

procedure TfrmEntities.ListBox1Click(Sender: TObject);
begin
  	Mainform.Statusbar.simpletext := 'Entity #' +inttostr(listbox1.itemindex);
end;

end.
