unit edit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids,main,Registry;

type
  TfrmEdit = class(TForm)
    StringGrid1: TStringGrid;
    ComboBox1: TComboBox;
    StringGrid2: TStringGrid;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
	procedure EncodeMsg;
    procedure StringGrid1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure StringGrid2DblClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
	m:Tmsg;
   mb:TMessageBlock;
	function EditMsg:integer;
  end;

var
  frmEdit: TfrmEdit;
implementation

uses filmprog, editvalu, sounds, models, msgs, blocks, entities;

{$R *.DFM}

procedure TfrmEdit.Button1Click(Sender: TObject);
begin
	if modified then
   begin
		EncodeMsg;
		ModalResult := 1;
   end else
   	ModalResult := 2;

end;

function DecodeText(p:pchar):string;
var
	i:integer;
begin
	for i:= 0 to strlen(p) -1 do
   begin
   	if p[i] = #0 then
       	exit;
		if p[i] = #10 then
       	Result := Result + '\n'
       else if p[i] = #13 then
       	Result := Result + '\r'
       else
       	Result := Result + p[i];
   end;
end;

function EncodeText(s:string):string;
var
	i:integer;
begin
	while pos('\n',s) > 0 do
   begin
		i := pos('\n',s);
       Result := copy(s,1,i-1) + #10;
       Result := Result + copy(s,i+2,length(s));
       s := Result;
   end;

	while pos('\r',s) > 0 do
   begin
		i := pos('\r',s);
       Result := copy(s,1,i-1) + #13;
       Result := Result + copy(s,i+2,length(s));
       s := Result;
   end;
	Result := s;
end;

function TfrmEdit.EditMsg:integer;
var
	mask:smallint;
	u:^smallint;
	i,j,k,len:integer;
	r:longint;
   p,q:pchar;
	a:Plongint;
   b:Psingle;
   c,d:char;
   l:Plongint;
	s:Psingle;
   junk,junk1:string;
begin
	i := 0;
	Result := 0;
   	c := m.p[0];
		len := 1;
{		if ord(c) < $22 then
       	Combobox1.itemindex := ord(c)
       else
       	Combobox1.itemindex := $22;
       Combobox1.update;
       ComboBox1.enabled := false;}

       case (c) of
       #0: {bad len=0}
       	begin
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := '';
               StringGrid1.cells[1,1] := '';
               StringGrid1.cells[2,1] := '';
           end;
       #1: {nop len=0}
       	begin
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := '';
               StringGrid1.cells[1,1] := '';
               StringGrid1.cells[2,1] := '';
           end;
       #2: {disconnect len=0}
       	begin
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := '';
               StringGrid1.cells[1,1] := '';
               StringGrid1.cells[2,1] := '';
           end;
       #3: {updatestat}
       	begin
				c := m.p[1];
           	StringGrid1.rowcount := 3;
               StringGrid1.cells[0,1] := 'Key';
               StringGrid1.cells[1,1] := 'Byte';
               StringGrid1.cells[2,1] := inttostr(ord(c));
				l := @m.p[2];
               StringGrid1.cells[0,2] := 'Value';
               StringGrid1.cells[1,2] := 'Long';
               StringGrid1.cells[2,2] := inttostr(l^);
           end;
       #4: {version}
       	begin
           	l := @m.p[1];
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := 'Version';
               StringGrid1.cells[1,1] := 'Long';
               StringGrid1.cells[2,1] := inttostr(l^);
           end;
       #5: {setview len=2 int entity}
       	begin
				u := @m.p[1];
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := 'Entity';
               StringGrid1.cells[1,1] := 'Entity';
               StringGrid1.cells[2,1] := frmEntities.listbox1.items[u^];
           end;
       #6: {sound len=18?}
       	begin
				mask := ord(m.p[1]);
				c := m.p[2];
				len := 2;
           	StringGrid1.rowcount := 7;
               StringGrid1.cells[0,1] := 'Volume';
               StringGrid1.cells[1,1] := 'Byte';
				c := m.p[len];
               if ((mask and 1)=1) then begin
               	StringGrid1.cells[2,1] := inttostr(ord(c));
                   inc(len);
               end else
               	StringGrid1.cells[2,1] := '255';

               StringGrid1.cells[0,2] := 'Attenuation';
               StringGrid1.cells[1,2] := 'Byte';
				c := m.p[len];
               if ((mask and 1)=2) then begin
               	StringGrid1.cells[2,2] := inttostr(ord(c));
                   inc(len);
               end else
               	StringGrid1.cells[2,2] := '64';

				u := @m.p[len];
               StringGrid1.cells[0,3] := 'Channel';
               StringGrid1.cells[1,3] := 'Byte';
               StringGrid1.cells[2,3] := inttostr(u^ and 7);

               StringGrid1.cells[0,4] := 'Entity';
               StringGrid1.cells[1,4] := 'Byte';
               StringGrid1.cells[2,4] := inttostr((u^ shr 3)  and $1fff);
               len := len + 2;

				c := m.p[len];
               StringGrid1.cells[0,5] := 'Sound';
               StringGrid1.cells[1,5] := 'Sound';
               StringGrid1.cells[2,5] := frmSounds.listbox1.items[ord(c)-1];
               inc(len);
               junk := '';
				for i := 0 to 2 do
               begin
               	u :=@m.p[len];
               	junk := junk + floattostr(u^ * 0.125) +' ';
                   len := len + 2;
               end;
               StringGrid1.cells[0,6] := 'Origin';
               StringGrid1.cells[1,6] := 'Coord';
               StringGrid1.cells[2,6] := junk;

           end;
       #7: {time len=4}
       	begin
				s := @m.p[1];
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := 'Time stamp';
               StringGrid1.cells[1,1] := 'Float';
               StringGrid1.cells[2,1] := floattostr(s^);
           end;
       #8: {print len=null term string }
       	begin
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := 'Text';
               StringGrid1.cells[1,1] := 'String';
               StringGrid1.cells[2,1] := DecodeText(@m.p[1]);
           end;
       #9: {stufftext len=string}
       	begin
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := 'Text';
               StringGrid1.cells[1,1] := 'String';
               StringGrid1.cells[2,1] := DecodeText(@m.p[1]);
           end;
       #$A: {setangle len=1}
       	begin
				c := m.p[1];
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := 'Angle';
               StringGrid1.cells[1,1] := 'Byte';
               StringGrid1.cells[2,1] := inttostr(ord(c));
           end;
		#$C: {lightstyle}
       	begin
				c := m.p[1];
           	StringGrid1.rowcount := 3;
               StringGrid1.cells[0,1] := 'Style';
               StringGrid1.cells[1,1] := 'Byte';
               StringGrid1.cells[2,1] := inttostr(ord(c));
               StringGrid1.cells[0,2] := 'Stylestring';
               StringGrid1.cells[1,2] := 'String';
               StringGrid1.cells[2,2] := DecodeText(@m.p[2]);
           end;
		#$D: {updatename}
       	begin
				c := m.p[1];
           	StringGrid1.rowcount := 3;
               StringGrid1.cells[0,1] := 'Player';
               StringGrid1.cells[1,1] := 'Byte';
               StringGrid1.cells[2,1] := inttostr(ord(c));
               StringGrid1.cells[0,2] := 'Name';
               StringGrid1.cells[1,2] := 'String';
               StringGrid1.cells[2,2] := DecodeText(@m.p[2]);
			end;
		#$E: {updatefrags}
       	begin
				c := m.p[1];
           	StringGrid1.rowcount := 3;
               StringGrid1.cells[0,1] := 'Player';
               StringGrid1.cells[1,1] := 'Byte';
               StringGrid1.cells[2,1] := inttostr(ord(c));
				u := @m.p[2];
               StringGrid1.cells[0,2] := 'Frags';
               StringGrid1.cells[1,2] := 'Short';
               StringGrid1.cells[2,2] := inttostr(u^);
			end;
		#$10: {stopsound}
       	begin
				u := @m.p[1];
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := 'Sound number (?)';
               StringGrid1.cells[1,1] := 'Short';
               StringGrid1.cells[2,1] := inttostr(u^);
			end;
		#$11: {updatecolors}
       	begin
				c := m.p[1];
           	StringGrid1.rowcount := 4;
               StringGrid1.cells[0,1] := 'Player';
               StringGrid1.cells[1,1] := 'Byte';
               StringGrid1.cells[2,1] := inttostr(ord(c));
				c := m.p[2];
               StringGrid1.cells[0,2] := 'Shirtcolor';
               StringGrid1.cells[1,2] := 'Byte';
               i := ord(c);
               StringGrid1.cells[2,2] := inttostr(i shr 4);
               StringGrid1.cells[0,3] := 'Pantcolor';
               StringGrid1.cells[1,3] := 'Byte';
               StringGrid1.cells[2,3] := inttostr(i and $0f);
			end;
		#$16: {spawnbaseline}
       	begin
           	StringGrid1.rowcount := 8;
				u := @m.p[1];
               StringGrid1.cells[0,1] := 'Entity';
               StringGrid1.cells[1,1] := 'Entity';
               StringGrid1.cells[2,1] := frmEntities.listbox1.items[u^];

               StringGrid1.cells[0,2] := 'Model';
               StringGrid1.cells[1,2] := 'Model';
               StringGrid1.cells[2,2] := frmModels.listbox1.items[ord(m.p[3])-1];

               StringGrid1.cells[0,3] := 'Frame';
               StringGrid1.cells[1,3] := 'Byte';
               StringGrid1.cells[2,3] := inttostr(ord(m.p[4]));

               StringGrid1.cells[0,4] := 'Colormap';
               StringGrid1.cells[1,4] := 'Byte';
               StringGrid1.cells[2,4] := inttostr(ord(m.p[5]));

               StringGrid1.cells[0,5] := 'Skin';
               StringGrid1.cells[1,5] := 'Byte';
               StringGrid1.cells[2,5] := inttostr(ord(m.p[6]));
				j := 7;
               junk := '';
               junk1 := '';
				for i := 0 to 2 do
               begin
               	u :=@m.p[j];
               	junk := junk + floattostr(u^ * 0.125) +' ';
                   junk1 := junk1 + floattostr(ord(m.p[j+2])*1.40625) + ' ';
                   j := j + 3;
               end;
               StringGrid1.cells[0,6] := 'Origin';
               StringGrid1.cells[1,6] := 'Coord';
               StringGrid1.cells[2,6] := junk;

               StringGrid1.cells[0,7] := 'Angle';
               StringGrid1.cells[1,7] := 'Angle';
               StringGrid1.cells[2,7] := junk1;
			end;
		#$1A: {centerprint}
       	begin
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := 'Text';
               StringGrid1.cells[1,1] := 'String';
               StringGrid1.cells[2,1] := DecodeText(@m.p[1]);
			end;
		#$1D: {spawnstaticsound}
       	begin
           	StringGrid1.rowcount := 5;
               StringGrid1.cells[0,1] := 'Origin';
               StringGrid1.cells[1,1] := 'Coord';
               u :=@m.p[1];
               junk := floattostr(u^ * 0.125) +' ';
               u :=@m.p[3];
               junk := junk + floattostr(u^ * 0.125) +' ';
               u :=@m.p[5];
               junk := junk + floattostr(u^ * 0.125);
               StringGrid1.cells[2,1] := junk;

               StringGrid1.cells[0,2] := 'Soundnum';
               StringGrid1.cells[1,2] := 'Sound';
               StringGrid1.cells[2,2] := frmSounds.listbox1.items[ord(m.p[7])-1];

               StringGrid1.cells[0,3] := 'Volume';
               StringGrid1.cells[1,3] := 'Byte';
               StringGrid1.cells[2,3] := floattostr(ord(m.p[8])/255.0);

               StringGrid1.cells[0,4] := 'Attenuation';
               StringGrid1.cells[1,4] := 'Byte';
               StringGrid1.cells[2,4] := floattostr(ord(m.p[9])/64.0);

			end;
       #$20: {cdtrack len=2}
       	begin
				c := m.p[1];
           	StringGrid1.rowcount := 3;
               StringGrid1.cells[0,1] := 'From track';
               StringGrid1.cells[1,1] := 'Byte';
               StringGrid1.cells[2,1] := inttostr(ord(c));
				l := @m.p[2];
               StringGrid1.cells[0,2] := 'To track';
               StringGrid1.cells[1,2] := 'Byte';
               StringGrid1.cells[2,2] := inttostr(ord(c));
           end;
		else {updateentity}
			begin;
           	StringGrid1.rowcount := 2;
               StringGrid1.cells[0,1] := 'Not editable';
               StringGrid1.cells[1,1] := '';
               StringGrid1.cells[2,1] := '';
				Result := 1;
           end;
       end;
end;

procedure TfrmEdit.EncodeMsg;
var
	mask:smallint;
	i,j,k,len:integer;
	r:longint;
   p,q:pchar;
	a:Plongint;
   b:Psingle;
   c,d:char;
   l:Plongint;
	s:Psingle;
   junk,junk1:string;
   u:^smallint;
begin
		c := m.p[0];
		if (m.p <> nil) then
       	freemem(m.p);
       m.p := nil;
       mb.blocksize := mb.blocksize  - m.size;
       case c of
       #0: {bad len=0}
       	begin
           	m.desc := 'bad!!';
           	m.size := 1;
				m.p := allocmem(len);
               m.p[0] := #0;
           end;
       #1: {nop len=0}
       	begin
           	m.desc := 'NOP';
           	m.size := 1;
				m.p := allocmem(1);
               m.p[0] := #1;
           end;
       #2: {disconnect len=0}
       	begin
           	m.desc := 'disconnect';
           	m.size := 1;
				m.p := allocmem(1);
               m.p[0] := #2;
           end;
       #3: {updatestat}
       	begin
           	m.desc := 'updatestat ';
           	m.size := 6;
				m.p := allocmem(6);
               m.p[0] := #3;
				m.p[1] := chr(strtoint(StringGrid1.cells[2,1]));
				l := @m.p[2];
				l^ := strtoint(StringGrid1.cells[2,2]);
           end;
       #4: {version}
       	begin
           	m.desc := 'version '+StringGrid1.cells[2,1];
           	m.size := 5;
				m.p := allocmem(5);
               m.p[0] := #4;
				l := @m.p[1];
				l^ := strtoint(StringGrid1.cells[2,1]);
           end;
       #5: {setview len=2 int entity}
       	begin
           	m.desc := 'setview '+StringGrid1.cells[2,1];
           	m.size := 3;
				m.p := allocmem(3);
               m.p[0] := #5;
				u := @m.p[1];
				u^ := frmEntities.FindEntity(StringGrid1.cells[2,1]);
           end;
       #6: {sound len=18?}
       	begin
				len := 11;
               if  strtoint(StringGrid1.cells[2,1]) <> 255 then
               	inc(len);
               if  strtoint(StringGrid1.cells[2,2]) <> 64 then
               	inc(len);

           	m.desc := 'sound '+ StringGrid1.cells[2,5];
           	m.size := len;
				m.p := allocmem(len);
               m.p[0] := #6;
				mask := 0;
               len := 2;
               if  strtoint(StringGrid1.cells[2,1]) <> 255 then
				begin
					mask := mask and 1;
                   m.p[len] := chr(strtoint(StringGrid1.cells[2,1]));
					inc(len);
               end;
               if  strtoint(StringGrid1.cells[2,2]) <> 64 then
				begin
					mask := mask and 2;
                   m.p[len] := chr(strtoint(StringGrid1.cells[2,1]));
					inc(len);
               end;
               m.p[1] := chr(mask);

				u := @m.p[len];
               u^ := strtoint(StringGrid1.cells[2,3])+(strtoint(StringGrid1.cells[2,3]) shr 4);
               len := len + 2;
				m.p[len] := chr(frmSounds.Findsound(StringGrid1.cells[2,5]));
               inc(len);

               junk := StringGrid1.cells[2,6];
				for i := 0 to 2 do
               begin
               	u :=@m.p[len];
					u^ := round(strtofloat(copy(junk,1,pos(' ',junk)-1)) / 0.125);
                   delete(junk,1,pos(' ',junk));
                   len := len + len;
               end;
           end;
       #7: {time len=4}
       	begin
           	m.desc := 'time ' + StringGrid1.cells[2,1];
           	m.size := 5;
				m.p := allocmem(5);
               m.p[0] := #7;
				s := @m.p[1];
               s^ := strtofloat(StringGrid1.cells[2,1]);
           end;
       #8: {print len=null term string }
       	begin
				junk := EncodeText(StringGrid1.cells[2,1]);
				m.desc := 'print ' + StringGrid1.cells[2,1];
           	m.size := 2+length(junk);
				m.p := allocmem(2+length(junk));
               m.p[0] := #8;
				for i := 1 to length(junk) do
               	m.p[i] := junk[i];
               m.p[1+length(junk)] := #0;
           end;
       #9: {stufftext len=string}
       	begin
				junk := EncodeText(StringGrid1.cells[2,1]);
				m.desc := 'stufftext ' + StringGrid1.cells[2,1];
				m.p := allocmem(2+length(junk));
           	m.size := 2+length(junk);
               m.p[0] := #9;
				for i := 1 to length(junk) do
               	m.p[i] := junk[i];
               m.p[1+length(junk)] := #0;
           end;
       #$A: {setangle len=1}
       	begin
           	m.desc := 'setangle';
           	m.size := 2;
				m.p := allocmem(2);
               m.p[0] := #$A;
				c := m.p[1];
           end;
		#$C: {lightstyle}
       	begin
           	m.desc := 'lightstyle';
				junk := EncodeText(StringGrid1.cells[2,2]);
           	m.size := 3+length(junk);
				m.p := allocmem(3+length(junk));
               m.p[0] := #$C;
               m.p[1] := chr(strtoint(StringGrid1.cells[2,1]));
				for i := 1 to length(junk) do
               	m.p[i+1] := junk[i];
               m.p[2+length(junk)] := #0;
           end;
		#$D: {updatename}
       	begin
           	m.desc := 'updatename "' +StringGrid1.cells[2,2]+'"';
				junk := EncodeText(StringGrid1.cells[2,2]);
           	m.size := 3+length(junk);
				m.p := allocmem(3+length(junk));
               m.p[0] := #$D;
               m.p[1] := chr(strtoint(StringGrid1.cells[2,1]));
				for i := 1 to length(junk) do
               	m.p[i+1] := junk[i];
               m.p[2+length(junk)] := #0;
			end;
		#$E: {updatefrags}
       	begin
           	m.desc := 'updatefrags';
           	m.size := 4;
				m.p := allocmem(4);
               m.p[0] := #$E;
               m.p[1] := chr(strtoint(StringGrid1.cells[2,1]));
				u := @m.p[2];
               u^ := strtoint(StringGrid1.cells[2,2]);
			end;
		#$10: {stopsound}
       	begin
           	m.desc := 'stopsound';
           	m.size := 3;
				m.p := allocmem(3);
               m.p[0] := #$10;
				u := @m.p[1];
               u^ := strtoint(StringGrid1.cells[2,1]);
				u := @m.p[1];
			end;
		#$11: {updatecolors}
       	begin
           	m.desc := 'updatecolors';
           	m.size := 3;
				m.p := allocmem(3);
               m.p[0] := #$11;
               m.p[1] := chr(strtoint(StringGrid1.cells[2,1]));
				m.p[2] := chr(strtoint(StringGrid1.cells[2,3]) + (strtoint(StringGrid1.cells[2,2]) shl 4));
			end;
		#$16: {spawnbaseline}
       	begin
          		m.desc := 'spawnbaseline ' + StringGrid1.cells[2,2];
           	m.size := 16;
				m.p := allocmem(16);
               m.p[0] := #$16;
				u := @m.p[1];
				u^ := strtoint(StringGrid1.cells[2,1]);

				m.p[3] := chr(frmModels.FindModel(StringGrid1.cells[2,2])+1);
				m.p[4] := chr(strtoint(StringGrid1.cells[2,3]));
				m.p[5] := chr(strtoint(StringGrid1.cells[2,4]));
				m.p[6] := chr(strtoint(StringGrid1.cells[2,5]));

				j := 7;
               junk := StringGrid1.cells[2,6];
               junk1 := StringGrid1.cells[2,7];
				for i := 0 to 2 do
               begin
               	u :=@m.p[j];
					u^ := round(strtofloat(copy(junk,1,pos(' ',junk)-1)) / 0.125);
                   delete(junk,1,pos(' ',junk));
					m.p[j+2] := chr(round(strtofloat(copy(junk1,1,pos(' ',junk1)-1)) / 1.40625));
                   delete(junk1,1,pos(' ',junk1));
                   j := j + 3;
               end;
			end;
		#$1A: {centerprint}
       	begin
				m.desc := 'centerprint ' +StringGrid1.cells[2,1];
				junk := EncodeText(StringGrid1.cells[2,1]);
           	m.size := 2+length(junk);
				m.p := allocmem(2+length(junk));
               m.p[0] := #$1A;
				for i := 1 to length(junk) do
               	m.p[i] := junk[i];
               m.p[1+length(junk)] := #0;
			end;
		#$1D: {spawnstaticsound}
       	begin
           	m.desc := 'spawnstaticsound ' + StringGrid1.cells[2,2];
           	m.size := 10;
				m.p := allocmem(10);
               m.p[0] := #$1D;
				i := 1;
               junk :=StringGrid1.cells[2,1]+' ';
               for j := 0 to 2 do
               begin
               	u :=@m.p[i];
                   i := i + 2;
					u^ := round(strtofloat(copy(junk,1,pos(' ',junk)-1)) / 0.125);
                   delete(junk,1,pos(' ',junk));
				end;
				m.p[7] := chr(frmSounds.Findsound(StringGrid1.cells[2,2]));
               m.p[8] := chr(round(strtofloat(StringGrid1.cells[2,3])*255));
               m.p[9] := chr(round(strtofloat(StringGrid1.cells[2,4])*64));
			end;
       #$20: {cdtrack len=2}
       	begin
				m.desc := 'cdtrack ' + StringGrid1.cells[2,1] + ' ' + StringGrid1.cells[2,2];
           	m.size := 3;
				m.p := allocmem(3);
               m.p[0] := #$20;
               m.p[1] := chr(strtoint(StringGrid1.cells[2,1]));
               m.p[2] := chr(strtoint(StringGrid1.cells[2,2]));
           end;
       end;
       m.id := ord(c);
       mb.blocksize := mb.blocksize + m.size;
end;

procedure TfrmEdit.FormCreate(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   Top := r.ReadInteger('EditWindow','Top',0);
   Left := r.ReadInteger('EditWindow','Left',0);
   Width := r.ReadInteger('EditWindow','Width',200);
   Height := r.ReadInteger('EditWindow','Height',320);
	WindowState := TWindowState(r.ReadInteger('EditWindow','WindowState',0));
   r.free;

	StringGrid1.cells[0,0] := 'Parameter';
	StringGrid1.cells[1,0] := 'Type';
	StringGrid1.cells[2,0] := 'Value';
	StringGrid1.options := [goFixedVertLine,goFixedHorzLine,goVertLine,goHorzLine,goRowSelect];

	StringGrid2.cells[0,0] := 'Parameter';
	StringGrid2.cells[1,0] := 'Type';
	StringGrid2.cells[2,0] := 'Value';
	StringGrid1.options := [goFixedVertLine,goFixedHorzLine,goVertLine,goHorzLine,goRowSelect];
	StringGrid2.options := [goFixedVertLine,goFixedHorzLine,goVertLine,goHorzLine,goRowSelect];

end;

procedure TfrmEdit.StringGrid1DblClick(Sender: TObject);
begin
	if StringGrid1.cells[0,StringGrid1.row] = '' then
   	exit;

	if StringGrid1.cells[1,StringGrid1.row] = 'Sound' then
   begin
        frmEditValue.Caption := 'Edit Sound';
   	frmEditValue.Edit1.visible := false;
 		frmEditValue.Combobox1.visible := true;
       frmEditValue.ComboBox1.items := frmSounds.listbox1.items;
		frmEditValue.Combobox1.itemindex := frmSounds.Findsound(StringGrid1.cells[2,StringGrid1.row]);
		if frmEditValue.showmodal = mrOk then
   	begin
	   		StringGrid1.cells[2,StringGrid1.row] := frmEditValue.Combobox1.text;
      		modified := true;
       end;
	end
	else if StringGrid1.cells[1,StringGrid1.row] = 'Model' then
   begin
        frmEditValue.Caption := 'Edit Model';
   	frmEditValue.Edit1.visible := false;
 		frmEditValue.Combobox1.visible := true;
       frmEditValue.ComboBox1.items := frmModels.listbox1.items;
		frmEditValue.Combobox1.itemindex := frmModels.FindModel(StringGrid1.cells[2,StringGrid1.row]);
		if frmEditValue.showmodal = mrOk then
   	begin
	   		StringGrid1.cells[2,StringGrid1.row] := frmEditValue.Combobox1.text;
      		modified := true;
       end;
   end
	else if StringGrid1.cells[1,StringGrid1.row] = 'Entity' then
   begin
   	frmEditValue.Caption := 'Edit Entity';
   	frmEditValue.Edit1.visible := false;
 		frmEditValue.Combobox1.visible := true;
       frmEditValue.ComboBox1.items := frmEntities.listbox1.items;
		frmEditValue.Combobox1.itemindex := frmEntities.FindEntity(StringGrid1.cells[2,StringGrid1.row]);
		if frmEditValue.showmodal = mrOk then
   	begin
	   		StringGrid1.cells[2,StringGrid1.row] := frmEditValue.Combobox1.text;
      		modified := true;
       end;
   end else begin
        frmEditValue.Caption := 'Edit Value';
   	frmEditValue.Edit1.visible := true;
 		frmEditValue.Combobox1.visible := false;
   	frmEditValue.Edit1.text := StringGrid1.cells[2,StringGrid1.row];
		if frmEditValue.showmodal = mrOk then
   	begin
	   		StringGrid1.cells[2,StringGrid1.row] := frmEditValue.Edit1.text;
      		modified := true;
       end;
   end;

   if Modified then
   begin
   	EncodeMsg; //best do this now
       frmBlocks.listbox1click(sender);
   end;
end;

procedure TfrmEdit.FormActivate(Sender: TObject);
begin
	modified := false;
end;

procedure TfrmEdit.Button2Click(Sender: TObject);
begin
	ModalResult := 2;
end;



procedure TfrmEdit.StringGrid2DblClick(Sender: TObject);
var
	i:integer;
begin
	if StringGrid2.cells[0,StringGrid2.row] = '' then
   	exit;

   if StringGrid2.row = 1 then
   begin
   	showmessage('Cannot edit block size. This is a computed value.');
       exit;
   end;
   frmEditValue.Edit1.text := StringGrid2.cells[2,StringGrid2.row];
	if frmEditValue.showmodal = mrOk then
   begin
		for i := 0 to frmBlocks.listbox1.items.count -1 do
       begin
			if frmBlocks.listbox1.selected[i] then
			begin
           	mb := TMessageblock(frmBlocks.listbox1.items.objects[i]);
               mb.angles[Stringgrid2.row -2] := strtofloat(frmEditValue.Edit1.text);
           end;
       end;
	   StringGrid2.cells[2,StringGrid2.row] := frmEditValue.Edit1.text;
      modified := true;
	end;
end;

procedure TfrmEdit.FormDestroy(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   r.writeInteger('EditWindow','Top',Top);
   r.writeInteger('EditWindow','Left',Left);
   r.writeInteger('EditWindow','Width',Width);
   r.writeInteger('EditWindow','Height',Height);
   r.writeInteger('EditWindow','WindowState',Longint(WindowState));
   r.free;

end;

end.
