unit config;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,registry,dialogs, Spin;

type
  TfrmConfig = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    SpinEdit1: TSpinEdit;
    Edit2: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Edit3: TEdit;
    Debug: TCheckBox;
    procedure OKBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConfig: TfrmConfig;

implementation

{$R *.DFM}

procedure TfrmConfig.OKBtnClick(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   r.writestring('Config','WorkDir',Edit1.text);
   r.writestring('Config','Quake',Edit2.text);
   r.writestring('Config','GameDir',Edit3.text);
   r.writeinteger('Config','SplitSize',SpinEdit1.value);
   r.writebool('Config','Debug',Debug.checked);
   r.destroy;
end;

procedure TfrmConfig.FormCreate(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   Edit1.text := r.readstring('Config','WorkDir','');
   Edit2.text := r.readstring('Config','Quake','c:\quake');
   Edit3.text := r.readstring('Config','GameDir','');
   SpinEdit1.value := r.readinteger('Config','Splitsize',32497);
   Debug.checked := r.readbool('Config','Debug',false);

   r.destroy;
   if Edit1.text = '' then
   	Showmessage('Your working directory is blank. You will probably want to go to File/Options and set it to your quake\id1 directory');
end;

end.
