//
// BspFileStructs.h
//

#define MAX_ENTITY_STR 65536


// the return value of CBspFile member functions
typedef enum
{
	SUCCESS,
	FAILURE
} STATUS;

// basic structures
typedef struct
{
	float x;
	float y;
	float z;
} BSPVERTEX;

typedef struct				    
{ 
	float x;					
	float y;					
	float z;					
} BSP3DVECFLOAT;				// vector or position

typedef float vec_t;

typedef vec_t vec3_t[3];

typedef struct
{
	short x;
	short y;
	short z;
} BSP3DVECSHORT;				// vector or position

typedef struct					
{ 
	BSP3DVECFLOAT   min;		// minimum values of X,Y,Z
	BSP3DVECFLOAT   max;		// maximum values of X,Y,Z
} BSPBBOXFLOAT;					// bounding box

typedef struct					
{ 
	short   min;				// minimum values of X,Y,Z
	short   max;				// maximum values of X,Y,Z
} BSPBBOXSHORT;					// bounding box

typedef struct
{
	unsigned char red;
	unsigned char green;
	unsigned char blue;
} BSPPALETTEENTRY;

// directory entry structure
typedef struct                 
{ 
	long  offset;					// Offset to entry, in bytes, from start of file
	long  size;						// Size of entry in file, in bytes
} BSPDIRENTRY;

// directory - found at the beginning of the file
//
// Note: Edges and faces each seemingly have two entries in the
//       directory; however, one of the entries is just a list
//       of indices into the actual array of edges or faces.
//		 The list of indices is used by a face or a leaf and
//		 is there to avoid storing the same data for edges and
//		 faces that are used by more than one face and leaf.
// 
typedef struct                 
{
	long		version;            // Model version, must be 0x17 (23).
	BSPDIRENTRY	entities;           // List of Entities.
	BSPDIRENTRY	planes;             // Map Planes.
									// numplanes = size/sizeof(plane_t)
	BSPDIRENTRY	miptex;             // Wall Textures.
	BSPDIRENTRY	vertices;           // Map Vertices.
									// numvertices = size/sizeof(vertex_t)
	BSPDIRENTRY	visilist;           // Leaves Visibility lists.
	BSPDIRENTRY	nodes;              // BSP Nodes.
									// numnodes = size/sizeof(node_t)
	BSPDIRENTRY	texinfo;            // Texture Info for faces.
									// numtexinfo = size/sizeof(texinfo_t)
	BSPDIRENTRY	faces;              // Faces of each surface.
									// numfaces = size/sizeof(face_t)
	BSPDIRENTRY	lightmaps;          // Wall Light Maps.
	BSPDIRENTRY	clipnodes;          // clip nodes, for Models.
									// numclips = size/sizeof(clipnode_t)
	BSPDIRENTRY	leaves;             // BSP Leaves.
									// numlaves = size/sizeof(leaf_t)
	BSPDIRENTRY	lfaces;             // list of face indices
	BSPDIRENTRY	edges;              // Edges of Faces.
									// numedges = Size/sizeof(edge_t)
	BSPDIRENTRY	ledges;             // list of edge indices
	BSPDIRENTRY	models;             // static portions of the level
									// nummodels = Size/sizeof(model_t)
} BSPDIRECTORY;

// model - a static object
typedef struct
{
	BSPBBOXFLOAT	bbox;			// The bounding box of the Model
	BSP3DVECFLOAT	origin;         // Origin of model, usually (0,0,0)
	long			idxNode0;		// Index of first BSP node
	long			idxNode1;		// Index of the first Clip node
	long			idxNode2;		// Index of the second Clip node
	long			idxNode3;		// Usually zero
	long			numLeafs;		// Number of BSP leaves
	long			idxFaces;		// Index of the first face for this model
	long			numFaces;		// Number faces following idxFaces that
									// are part of this model.
} BSPMODEL;

// face
//
// Note: The edges for a face are indirectly referenced through
//       the edge list. The idxEdge member is the first index
//       in an array of concecutive indices to edges. Remember
//       that the actual edges in the edge array may not be
//       concecutive.
//.
typedef struct  
{ 
	short	idxPlane;				// The plane in which the face lies
									// must be in [0,numPlanes] 
	short	side;					// 0 if in front of the plane, 1 if behind the plane
	long	idxEdges;				// first edge in the List of edges
									// must be in [0,numEdges]
	short	numEdges;				// number of edges in the List of edges
	short	idxTexinfo;				// index of the Texture info the face is part of
									// must be in [0,numtexinfos] 
	unsigned char	typelight;      // type of lighting, for the face
	unsigned char	baselight;      // from 0xFF (dark) to 0 (bright)
	unsigned char	light[2];       // two additional light models  
	long			idxLightmap;	// index inside the general light map, or -1
									// this define the start of the face light map
} BSPFACE;

// edge
typedef struct
{
	unsigned short idxV0;			// index of the start vertex
									// must be in [0,numvertices]
	unsigned short idxV1;			// index of the end vertex
									// must be in [0,numvertices]
} BSPEDGE;

/*
 * texinfo
 */
typedef struct
{
	BSP3DVECFLOAT s;
	float offsetS;
	BSP3DVECFLOAT t;
	float offsetT;
	long idxTexture;
	long flags;
} BSPTEXINFO;

typedef struct
{
	long numMiptex;
	long offsets[4];		// an array of numMiptex offsets from BSPMIPTEXLUMP
							// to each indivitual BSPMIPTEX
} BSPMIPTEXLUMP;

#define MIPLEVELS 4

typedef struct
{
	char name[16];
	unsigned long width,
				  height;
	unsigned long offsets[MIPLEVELS];	/* immediately following each miptex
										   header is the data for the mipmaps */
} BSPMIPTEX;


typedef struct
{ 
	int    plane_id;            // The plane that splits the node
                               //           must be in [0,numplanes[
	u_short		children[2];	// negative numbers are -(leafs+1), not nodes
//  	u_short front;               // If bit15==0, index of Front child node
                               // If bit15==1, ~front = index of child leaf
//  	u_short back;                // If bit15==0, id of Back child node
                               // If bit15==1, ~back =  id of child leaf
	u_short		mins[3];		// for sphere culling
	u_short		maxs[3];
  	u_short face_id;             // Index of first Polygons in the node
 	u_short face_num;            // Number of faces in the node
} BSPNODE;

typedef struct
{ 
	int type;                   // Special type of leaf
  	int vislist;                // Beginning of visibility lists
                               //     must be -1 or in [0,numvislist[
//  	BSPBBOXSHORT bound;           // Bounding box of the leaf
	short mins[3];
	short maxs[3];
	u_short lface_id;            // First item of the list of faces
                               //     must be in [0,numlfaces[
  	u_short lface_num;           // Number of faces in the leaf  
  	u_char sndwater;             // level of the four ambient sounds:
  	u_char sndsky;               //   0    is no sound
  	u_char sndslime;             //   0xFF is maximum volume
  	u_char sndlava;              //
} BSPLEAF;

typedef struct
{ 
  vec3_t normal;               // Vector orthogonal to plane (Nx,Ny,Nz)
                               // with Nx2+Ny2+Nz2 = 1
  float dist;               // Offset to plane, along the normal vector.
                               // Distance from (0,0,0) to the plane
  long    type;                // Type of plane, depending on normal vector.
} BSPPLANE;

