unit blocks;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,Registry;

type
  TfrmBlocks = class(TForm)
    ListBox1: TListBox;
    procedure ListBox1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBox1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
	procedure ClearListbox;
  end;

var
  frmBlocks: TfrmBlocks;

implementation

uses msgs,main,edit,view;

{$R *.DFM}

procedure TfrmBlocks.ListBox1Click(Sender: TObject);
var
   m:Tmsg;
   mb:Tmessageblock;
begin
	frmMsgs.Listbox1.clear;
	mb := Tmessageblock(listbox1.items.objects[Listbox1.itemindex]);
   m := Tmsg(mb.m);
   while (m <> nil) do
   begin
   	frmMsgs.listbox1.items.addobject(m.desc,m);
       m := m.next;
   end;
	searchblock := listbox1.itemindex;
   searchmsg := 0;
   frmEdit.StringGrid2.rowcount := 5;
   frmEdit.StringGrid2.cells[0,1] := 'Block size';
   frmEdit.StringGrid2.cells[1,1] := 'Long ';
   frmEdit.StringGrid2.cells[2,1] := inttostr(mb.blocksize);

   frmEdit.StringGrid2.cells[0,2] := 'Camera X';
   frmEdit.StringGrid2.cells[1,2] := 'Angle';
   frmEdit.StringGrid2.cells[2,2] :=  Floattostr(mb.angles[0]);
   frmEdit.StringGrid2.cells[0,3] := 'Camera Y';
   frmEdit.StringGrid2.cells[1,3] := 'Angle';
   frmEdit.StringGrid2.cells[2,3] :=  Floattostr(mb.angles[1]);
   frmEdit.StringGrid2.cells[0,4] := 'Camera Z';
   frmEdit.StringGrid2.cells[1,4] := 'Angle';
   frmEdit.StringGrid2.cells[2,4] :=  Floattostr(mb.angles[2]);

	frmView.DoFrame(mb,true);
end;

procedure TfrmBlocks.ClearListbox;
var
	mb:Tmessageblock;
   m,n:Tmsg;
begin
	Screen.Cursor := crHourglass;
  try
	while frmBlocks.Listbox1.items.count > 0 do
   begin
		mb := Tmessageblock(frmBlocks.Listbox1.items.objects[0]);
       if mb <> nil then
       begin
			m := mb.m;
           while (m <> nil) do
           begin
				if m.p <> nil then
               	freemem(m.p);
               n := m;
               m := m.next;
               n.free;
           end;
       end;
		frmBlocks.Listbox1.items.delete(0);
       mb.free;
   end;
  finally
  		Screen.Cursor := crDefault;
  end;
end;

procedure TfrmBlocks.FormDestroy(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   r.writeInteger('BlocksWindow','Top',Top);
   r.writeInteger('BlocksWindow','Left',Left);
   r.writeInteger('BlocksWindow','Width',Width);
   r.writeInteger('BlocksWindow','Height',Height);
   r.writeInteger('BlocksWindow','WindowState',Longint(WindowState));
   r.free;
//	ClearListBox;
end;

procedure TfrmBlocks.FormCreate(Sender: TObject);
var
	r:TRegIniFile;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   Top := r.ReadInteger('BlocksWindow','Top',0);
   Left := r.ReadInteger('BlocksWindow','Left',0);
   Width := r.ReadInteger('BlocksWindow','Width',200);
   Height := r.ReadInteger('BlocksWindow','Height',320);
   r.free;
	WindowState := TWindowState(r.ReadInteger('BlocksWindow','WindowState',0));
end;

procedure TfrmBlocks.ListBox1DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
	Accept := true;
end;

end.
