/*---------------------------------------------------------\
|                                                          |
| view.c                                                   |
|                                                          |
| by Joel Beaudoin                                         |
|                                                          |
|----------------------------------------------------------|
|                                                          |
| This module contains data and functions that pertain to  |
| the rendered view of the level in the client area of the |
| window.                                                  |
|                                                          |
\---------------------------------------------------------*/

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <gl\gl.h>
#include <gl\glu.h>
#include "BspFileStructs.h"
#include "leveldata.h"

//int facesrendered;
int levellist;
vec3_t viewp;

typedef struct ent_t {
	vec3_t pos;
	struct ent_t *next;
}ENT_T;

ENT_T *ent_list=NULL;
extern int rendermode;


_declspec( dllexport ) 
void WINAPI ChangeSize(GLsizei w, GLsizei h)
{
	GLfloat fAspect;

	// Prevent a divide by zero
	if(h == 0)
		h = 1;

	// Set Viewport to window dimensions
    glViewport(0, 0, w, h);

	fAspect = (GLfloat)w/(GLfloat)h;

	// Reset coordinate system
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	// Produce the perspective projection
	gluPerspective(60.0f, fAspect, 1.0, 10000.0);

	glMatrixMode(GL_MODELVIEW);
	//glLoadIdentity();
}

/*-----------------------------------------------------------------*/


_declspec( dllexport ) 
void RenderScene(void)
{
	ENT_T *t;


	glCallList(levellist);
	// draw the entities
	t = ent_list;
	while (t) {
		glColor3f(0.9f,0.0f,0.0f);
		glBegin(GL_POLYGON);
		glVertex3f(t->pos[0]+12,t->pos[1]+20,t->pos[2]+12);
		glVertex3f(t->pos[0]+12,t->pos[1]+20,t->pos[2]-12);
		glVertex3f(t->pos[0]+12,t->pos[1]-20,t->pos[2]-12);
		glVertex3f(t->pos[0]+12,t->pos[1]-20,t->pos[2]+12);
		glEnd();
		glBegin(GL_POLYGON);
		glVertex3f(t->pos[0]-12,t->pos[1]-20,t->pos[2]+12);
		glVertex3f(t->pos[0]-12,t->pos[1]-20,t->pos[2]-12);
		glVertex3f(t->pos[0]-12,t->pos[1]+20,t->pos[2]-12);
		glVertex3f(t->pos[0]-12,t->pos[1]+20,t->pos[2]+12);
		glEnd();

		glBegin(GL_POLYGON);
		glVertex3f(t->pos[0]+12,t->pos[1]+20,t->pos[2]+12);
		glVertex3f(t->pos[0]-12,t->pos[1]+20,t->pos[2]+12);
		glVertex3f(t->pos[0]-12,t->pos[1]+20,t->pos[2]-12);
		glVertex3f(t->pos[0]+12,t->pos[1]+20,t->pos[2]-12);
		glEnd();
		glBegin(GL_POLYGON);
		glVertex3f(t->pos[0]+12,t->pos[1]-20,t->pos[2]-12);
		glVertex3f(t->pos[0]-12,t->pos[1]-20,t->pos[2]-12);
		glVertex3f(t->pos[0]-12,t->pos[1]-20,t->pos[2]+12);
		glVertex3f(t->pos[0]+12,t->pos[1]-20,t->pos[2]+12);
		glEnd();
		
		glBegin(GL_POLYGON);
		glVertex3f(t->pos[0]+12,t->pos[1]+20,t->pos[2]+12);
		glVertex3f(t->pos[0]+12,t->pos[1]-20,t->pos[2]+12);
		glVertex3f(t->pos[0]-12,t->pos[1]-20,t->pos[2]+12);
		glVertex3f(t->pos[0]-12,t->pos[1]+20,t->pos[2]+12);
		glEnd();
		glBegin(GL_POLYGON);
		glVertex3f(t->pos[0]-12,t->pos[1]+20,t->pos[2]-12);
		glVertex3f(t->pos[0]-12,t->pos[1]-20,t->pos[2]-12);
		glVertex3f(t->pos[0]+12,t->pos[1]-20,t->pos[2]-12);
		glVertex3f(t->pos[0]+12,t->pos[1]+20,t->pos[2]-12);
		glEnd(); 
		t = t->next;
	}
	glFinish();
}

void MakeDisplayList(void)
{
	BSPFACE* pCurFace = NULL;
	BSPEDGE* pCurEdge = NULL;
	BSPVERTEX* pCurVertex = NULL;
	long edgeIndex;
	int i, j;

	levellist = glGenLists(1);
	glNewList(levellist,GL_COMPILE);
	// Clear the window with current clearing color
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	for(i=0; i<levelModel.numFaces; i++)
	{
		pCurFace = &faces[levelModel.idxFaces + i];
		glColor3f(v[i].x, v[i].y, v[i].z);
		if (rendermode == 1)
			glBegin(GL_LINE_LOOP);
		else
			glBegin(GL_POLYGON);

			for(j=0; j<pCurFace->numEdges; j++)
			{
				edgeIndex = edgeIndices[pCurFace->idxEdges + j];
				if(edgeIndex > 0)
				{
					pCurEdge = &edges[edgeIndex];
					pCurVertex = &vertices[pCurEdge->idxV0];
				}
				else
				{
					pCurEdge = &edges[-edgeIndex];
					pCurVertex = &vertices[pCurEdge->idxV1];
				}
				glVertex3f(pCurVertex->x, pCurVertex->z, -pCurVertex->y);
			}
		glEnd();
	}
	// Flush drawing commands
//	glFlush();
	glEndList();

}

_declspec( dllexport ) 
void WINAPI ClearEntities()
{
	ENT_T *t,*r;

	t = ent_list;
	while (t) {
		r = t->next;
		free(t);
		t = r;
	}
	ent_list = NULL;
}

_declspec( dllexport ) 
void WINAPI AddEntity(float x,float y, float z)
{
	ENT_T *t;

	t = malloc(sizeof(struct ent_t));
	t->next = ent_list;
	ent_list = t;
	t->pos[0] = x;
	t->pos[1] = y;
	t->pos[2] = z;
}