/*---------------------------------------------------------\
|                                                          |
| qgl.c                                                    |
|                                                          |
| by Joel Beaudoin                                         |
|                                                          |
|----------------------------------------------------------|
|                                                          |
| A simple Quake level-walk-through program. The program   |
| loads the geometry for a level (E1M1) and passes all of  |
| the faces in the level to OpenGL for rendering. Each     |
| face is rendered with a random solid color. The camera   |
| can be moved around using the keys found in the WM_CHAR  |
| handler.                                                 |
|                                                          |
\---------------------------------------------------------*/

#include <windows.h>
#include <stdlib.h>            
#include <gl\gl.h>             
#include <gl\glu.h>             
#include "bspfile.h"
#include "leveldata.h"
#include "palette.h"
#include "oglrc.h"
#include "view.h"
#include "camera.h"


LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM  wParam, LPARAM lParam);
void handleCreate(HWND hWnd);
void handleDestroy(void);
void handleChar(HWND hWnd, WPARAM wParam);
void handleSize(LPARAM lParam);
void handlePaint(HWND hWnd);
int handleQueryNewPalette(HWND hWnd);
int handlePaletteChanged(HWND hWnd, WPARAM wParam);
HPALETTE GetOpenGLPalette(HDC hDC);

static HGLRC hRC;               
static HDC hDC;                 

extern FILE* bspFile;
int rendermode=0;

/*-----------------------------------------------------------------*/

int APIENTRY WinMain(HINSTANCE hInst,
					 HINSTANCE hPrevInstance,
					 LPSTR lpCmdLine,
					 int nCmdShow)
{
	MSG msg;           
	WNDCLASS wc;                    
	HWND hWnd;           

	

	wc.style                = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc          = (WNDPROC) WndProc;
	wc.cbClsExtra           = 0;
	wc.cbWndExtra           = 0;
	wc.hInstance            = hInst;
	wc.hIcon                = NULL;
	wc.hCursor              = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground        = NULL;
	wc.lpszMenuName         = NULL;
	wc.lpszClassName        = "Qgl";

	if(RegisterClass(&wc) == 0)
		return FALSE;

	hWnd = CreateWindow(
				"Qgl",
				"Qgl",
				WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
				50, 50,
				320, 240,
				NULL,
				NULL,
				hInst,
				NULL);

	if(hWnd == NULL)
		return FALSE;

	ShowWindow(hWnd,SW_SHOW);
	UpdateWindow(hWnd);

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}

/*-----------------------------------------------------------------*/

/*----------------------\
|                       |
| MAIN WINDOW PROCEDURE |
|                       |
\-----------------------*/


LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM  wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_CREATE:
			handleCreate(hWnd);
			break;

		case WM_DESTROY:
			handleDestroy();
			break;

		case WM_CHAR:
			handleChar(hWnd, wParam);
			break;

		case WM_SIZE:
			handleSize(lParam);
			break;

		case WM_PAINT:
			handlePaint(hWnd);
			break;

		case WM_QUERYNEWPALETTE:
			return handleQueryNewPalette(hWnd);
			break;

		case WM_PALETTECHANGED:
			return handlePaletteChanged(hWnd, wParam);
			break;

		default:   
			return (DefWindowProc(hWnd, message, wParam, lParam));

	}

    return (0L);
}

/*-----------------------------------------------------------------*/

/*-----------------\
|                  |
| MESSAGE HANDLERS |
|                  |
\-----------------*/

int LoadBSPFile(char *quakedir,char *mapfile,char *gamedir)
{
	char dir[100];	
	unsigned int i;
	// try from gamedir
	
	if (strcmp(gamedir,"") != 0) {
		//try from gamedir\maps
		strcpy(dir,quakedir);
		strcat(dir,"\\");
		strcat(dir,gamedir);
		strcat(dir,"\\");
		strcat(dir,mapfile);
		// convert / to \ 
		for (i =0;i<strlen(dir);i++)
			if (dir[i] == 47)
				dir[i] = 92;
		bspFile = fopen(dir, "rb");
		if (bspFile != NULL) 
			return 1;

		//try from pak0.pak
		strcpy(dir,quakedir);
		strcat(dir,"\\");
		strcat(dir,gamedir);
		strcat(dir,"\\pak0.pak");
		bspFile = OpenPakFile(dir,mapfile);
		if (bspFile != NULL) 
			return 1;

		//try from pak1.pak
		strcpy(dir,quakedir);
		strcat(dir,"\\");
		strcat(dir,gamedir);
		strcat(dir,"\\pak1.pak");
		bspFile = OpenPakFile(dir,mapfile);
		if (bspFile != NULL) 
			return 1;

	}

	//try from id1\maps
	strcpy(dir,quakedir);
	strcat(dir,"\\id1\\");
	strcat(dir,mapfile);
	// convert / to \ 
	for (i =0;i<strlen(dir);i++)
		if (dir[i] == 47)
			dir[i] = 92;
	bspFile = fopen(dir, "rb");
	if (bspFile != NULL) 
		return 1;

	//try from pak0.pak
	strcpy(dir,quakedir);
	strcat(dir,"\\id1\\pak0.pak");
	bspFile = OpenPakFile(dir,mapfile);
	if (bspFile != NULL) 
		return 1;

	//try from pak1.pak
	strcpy(dir,quakedir);
	strcat(dir,"\\id1\\pak1.pak");
	bspFile = OpenPakFile(dir,mapfile);
	if (bspFile != NULL) 
		return 1;

	return 0;
}

void handleCreate(HWND hWnd)
{
	static rval;
	FILE *f;
	int i;

	// Store the device context
	hDC = GetDC(hWnd);              

	// Select the pixel format
	SetDCPixelFormat(hDC);          

	initPalette(hDC);

	// Create the rendering context and make it current
	hRC = wglCreateContext(hDC);
	wglMakeCurrent(hDC, hRC);
	SetupRC();

	if (LoadBSPFile("C:\\GAMES\\QUAKE","maps/e1m1.bsp","") != 1)
	{			
		MessageBox(NULL, "Error opening bsp file.", NULL, MB_OK);
		exit(1);
	}

	rval = openBSP("C:\\GAMES\\QUAKE\\ID1\\MAPS\\DM2.BSP");
	if(rval == FAILURE)
	{
		MessageBox(NULL, "Error opening bsp file.", NULL, MB_OK);
		exit(1);
	}
	loadLevelData();
	MakeDisplayList();
	//texinit();
	//glLoadIdentity();
	glTranslatef(-480.0f,  -88.0f,-352.0f);
	viewp[0] = (float)480;
	viewp[1] = (float)88;
	viewp[2] = (float)352;
	//glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
	//gluLookAt(480.0, 88.0, -352.0, 480.0, 88.0, 351.0, 0.0, 1.0, 0.0);
	//glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
/*	f = fopen("C:\\debug.txt","w+");			
	for (i = 0;i < numLeaves;i++)
		fprintf(f,"%u %d %u %u\n",i,leaves[i].type,leaves[i].lface_id,leaves[i].lface_num);
	fclose(f);
	f = fopen("C:\\debug2.txt","w+");			
	fclose(f); */
}

/*-----------------------------------------------------------------*/

void handleDestroy(void)
{
	// Deselect the current rendering context and delete it
	wglMakeCurrent(hDC,NULL);
	wglDeleteContext(hRC);

	destroyPalette();

	destroyLevelData();
	
	// Tell the application to terminate after the window
	// is gone.
	PostQuitMessage(0);
}

/*-----------------------------------------------------------------*/

void handleChar(HWND hWnd, WPARAM wParam)
{
	RECT r;
	
	switch(toupper(wParam))
	{
		case 'W':
			viewp[2] = viewp[2] + 20;
			moveCamera(0.0f, 0.0f, -20.0f);
			GetClientRect(hWnd, &r);
			InvalidateRect(hWnd, &r, FALSE);
			break;
		
		case 'S':
			viewp[2] = viewp[2] - 20;
			moveCamera(0.0f, 0.0f, 20.0f);
			GetClientRect(hWnd, &r);
			InvalidateRect(hWnd, &r, FALSE);
			break;
	
		case 'Q':
			viewp[0] = viewp[0] + 20;
			moveCamera(-20.0f, 0.0f, 0.0f);
			GetClientRect(hWnd, &r);
			InvalidateRect(hWnd, &r, FALSE);
			break;
	
		case 'E':
			viewp[0] = viewp[0] - 20;
			moveCamera(20.0f, 0.0f, 0.0f);
			GetClientRect(hWnd, &r);
			InvalidateRect(hWnd, &r, FALSE);
			break;
		
		case 'C':
			viewp[1] = viewp[1] + 20;
			moveCamera(0.0f, -20.0f, 0.0f);
			GetClientRect(hWnd, &r);
			InvalidateRect(hWnd, &r, FALSE);
			break;
		
		case 'F':
			viewp[1] = viewp[1] - 20;
			moveCamera(0.0f, 20.0f, 0.0f);
			GetClientRect(hWnd, &r);
			InvalidateRect(hWnd, &r, FALSE);
			break;
	
		case 'A':
			turnCamera(10.0f);
			GetClientRect(hWnd, &r);
			InvalidateRect(hWnd, &r, FALSE);
			break;
	
		case 'D':
			turnCamera(-10.0f);
			GetClientRect(hWnd, &r);
			InvalidateRect(hWnd, &r, FALSE);
			break;

	}

}

/*-----------------------------------------------------------------*/

void handleSize(LPARAM lParam)
{
	// Call our function which modifies the clipping
	// volume and viewport
	ChangeSize(LOWORD(lParam), HIWORD(lParam));
}

/*-----------------------------------------------------------------*/

void handlePaint(HWND hWnd)
{
	
	// Call OpenGL drawing code
	RenderScene();

	//textureRenderScene();

	SwapBuffers(hDC);

	// Validate the newly painted client area
	ValidateRect(hWnd,NULL);
}

/*-----------------------------------------------------------------*/

int handleQueryNewPalette(HWND hWnd)
{
	HPALETTE hPalette;

	hPalette = getPaletteHandle();

	// If the palette was created.
	if(hPalette)
	{
		int nRet;

		// Selects the palette into the current device context
		SelectPalette(hDC, hPalette, FALSE);

		// Map entries from the currently selected palette to
		// the system palette.  The return value is the number 
		// of palette entries modified.
		nRet = RealizePalette(hDC);

		// Repaint, forces remap of palette in current window
		InvalidateRect(hWnd,NULL,FALSE);

		return nRet;
	}
	return (0L);
}

/*-----------------------------------------------------------------*/

int handlePaletteChanged(HWND hWnd, WPARAM wParam)
{
	HPALETTE hPalette;

	hPalette = getPaletteHandle();

	// Don't do anything if the palette does not exist, or if
	// this is the window that changed the palette.
	if((hPalette != NULL) && ((HWND)wParam != hWnd))
	{
		// Select the palette into the device context
		SelectPalette(hDC,hPalette,FALSE);

		// Map entries to system palette
		RealizePalette(hDC);
				
		// Remap the current colors to the newly realized palette
		UpdateColors(hDC);
		return 0;
	}
	return (0L);
}

/*---------------------\
|                      |
| END MESSAGE HANDLERS |
|                      |
\---------------------*/
