unit Main;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls,ShellAPI,Registry,
  Math, FileHistory;

type
    TPos = class(Tobject)
         x,y,z:single;
         a,b,c:single;
    end;
   TMsg = class(Tobject)
   	id:integer;
       size:integer;
		desc:string;
		cachefile:string;
       p:pchar;
		pos:longint;
       x,y,z:single;
       angx,angy,angz:single;
       next:Tmsg;
       ent:integer;
   end;
	TMessageBlock = class(Tobject)
   	blocksize:longint;
       angles:array[0..2] of single;
		camerapos:array[0..2] of single;
       m:Tmsg;
       msg:pchar;
       pos:longint;
       time:single;
       printtext:string;
	end;
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileOpenItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog1: TOpenDialog;
    FileSaveItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    SpeedPanel: TPanel;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    StatusBar: TStatusBar;
    N2: TMenuItem;
    SPlice1: TMenuItem;
    Split1: TMenuItem;
    Compress1: TMenuItem;
    N3: TMenuItem;
    Options1: TMenuItem;
    PasteSpecial1: TMenuItem;
    Insert1: TMenuItem;
    Delete1: TMenuItem;
    N4: TMenuItem;
    Find1: TMenuItem;
    FindDialog1: TFindDialog;
    SaveDialog1: TSaveDialog;
    View1: TMenuItem;
    N3D1: TMenuItem;
    Wireframe1: TMenuItem;
    Solid1: TMenuItem;
    Textured1: TMenuItem;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    Information1: TMenuItem;
    Remove1: TMenuItem;
    Effects1: TMenuItem;
    ReCamera1: TMenuItem;
    FadeIn1: TMenuItem;
    SlowMo1: TMenuItem;
    FastMo1: TMenuItem;
    FixTime1: TMenuItem;
    test1: TMenuItem;
    SpeedButton4: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure CutItemClick(Sender: TObject);
    procedure CopyItemClick(Sender: TObject);
    procedure PasteItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
	procedure ReadDemo(filename:string);
	procedure WriteDemo(startblock,n:integer);
    procedure Find1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure Split1Click(Sender: TObject);
    procedure SPlice1Click(Sender: TObject);
    procedure Options1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Compress1Click(Sender: TObject);
    procedure PasteSpecial1Click(Sender: TObject);
    procedure Insert1Click(Sender: TObject);
	procedure DoPaste;
    procedure N3D1Click(Sender: TObject);
    procedure Wireframe1Click(Sender: TObject);
    procedure Solid1Click(Sender: TObject);
    procedure Textured1Click(Sender: TObject);
    procedure Information1Click(Sender: TObject);
    procedure FileHist1FileSelected(FileName: string;
      var ReOrder: Boolean);
    procedure Remove1Click(Sender: TObject);
    procedure ReCamera1Click(Sender: TObject);
	procedure PopulateFileHistory;
	procedure AddToFileHistory(s:string);
	procedure FileHistoryClick(Sender:Tobject);
	procedure ChangeMo(style:integer);
	procedure InsertMsg(mb:TmessageBlock;m:Tmsg);
    procedure SlowMo1Click(Sender: TObject);
    procedure FastMo1Click(Sender: TObject);
    procedure FixTime1Click(Sender: TObject);
    procedure FadeIn1Click(Sender: TObject);
	procedure DoFade(style:integer);
    procedure test1Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string);
    procedure ShowHint(Sender: TObject);
  public
    { Public declarations }
   Version:string;
	mapname:string;
   levelname:string;
   numberofblocks:integer;
   numberofmsgs:integer;
   lasttime:single;
	entities:Tstringlist;
   FileHistory:Tstringlist;
  end;

var
  MainForm: TMainForm;
  startx,starty:integer;
  resizing:boolean;
  searchblock:integer;
  searchmsg:integer;
	cdtrack:integer;
	modified:boolean;
   Clipboard:Tstringlist;
   Clipboardmode:integer;
   cameraentity:integer;
	playing:boolean;
   originalmenuitems:integer;

implementation

{$R *.DFM}

uses About, blocks, msgs, filmprog, config, pastespe, spltsplc, edit,
  insert, compress, view, info, models, sounds, editvalu,
  entities, remove, camera, timebase, fade, qserv;

procedure shell(t:string);
var
   LPC2:Pchar;
   LPC3:Pchar;
   LPC4:Pchar;
   s:string;
begin
   GetDir(0,s);
   {setup filename}
	t := t + ' ';
   LPC2 := StrAlloc(length(copy(t,1,pos(' ',t)-1))+1);
   StrPCopy(LPC2,copy(t,1,pos(' ',t)-1));
   {setup params}
   LPC3 := StrAlloc(length(copy(t,pos(' ',t)+1,length(t)))+1);
   StrPCopy(LPC3,copy(t,pos(' ',t)+1,length(t)));
   {setup directory}
	s := 'C:\games\quake';
   LPC4 := StrAlloc(length(s)+1);
   StrPCopy(LPC4,s);
   ShellExecute(Mainform.handle,nil,LPC2,LPC3,LPC4,3);
   StrDispose(LPC2);
   StrDispose(LPC3);
   StrDispose(LPC4);
end;

function CleanString(s:string):string;
var
	i:integer;
begin
	Result := '';
	for i := 1 to length(s) do
   begin
		case s[i] of
       ' '..'~':
       	Result := Result + s[i];
		end;
   end;
end;

procedure ClearClipboard;
var
	mb:Tmessageblock;
   m,n:Tmsg;
begin
	if (clipboardmode = 1) then
   begin
   	m := Tmsg(clipboard.objects[0]);
       if m.p <> nil then
       	freemem(m.p);
       m.free;
       clipboard.delete(0);
		exit;
   end;

	Screen.Cursor := crHourglass;
 try
	while clipboard.count > 0 do
   begin
		mb := Tmessageblock(clipboard.objects[0]);
       if mb <> nil then
       begin
			m := mb.m;
           while (m <> nil) do
           begin
				if m.p <> nil then
               	freemem(m.p);
               n := m;
               m := m.next;
               n.free;
           end;
       end;
		clipboard.delete(0);
       mb.free;
   end;
 finally
   Screen.Cursor := crDefault;
 end;
end;


procedure TMainForm.FormCreate(Sender: TObject);
var
	r:TRegIniFile;
   m:Tmenuitem;
   i,j:integer;
   junk:string;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   Top := r.ReadInteger('MainWindow','Top',0);
   Left := r.ReadInteger('MainWindow','Left',0);
   Width := r.ReadInteger('MainWindow','Width',200);
   Height := r.ReadInteger('MainWindow','Height',320);
	WindowState := TWindowState(r.ReadInteger('MainWindow','WindowState',0));
	i := r.ReadInteger('FileHistory','Num',0);
	originalmenuitems := MainMenu1.items[0].count;
	FileHistory := Tstringlist.create;
   if i > 0 then
   begin
       for j := 0 to i-1 do
       begin
  			junk := r.ReadString('FileHistory',inttostr(j),'');
           FileHistory.add(junk);
       end;
   end;
   r.free;
   PopulateFileHistory;

  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
  Version := 'Version 0.96beta';
  searchblock := 0;
  searchmsg := 0;
  Entities:=Tstringlist.create;
  SaveDialog1.options := [ofOverwritePrompt];
  modified := false;
  Clipboard := Tstringlist.create;
  FindDialog1.options := [frDown,frHideUpDown,frHideMatchcase,frHideWholeword];
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TfrmView;
begin
  { create a new MDI child window }
  Child := TfrmView.Create(Application);
  Child.Caption := Name;
end;

procedure TMainForm.FileNewItemClick(Sender: TObject);
begin
  CreateMDIChild('NONAME' + IntToStr(MDIChildCount + 1));
end;

procedure TMainForm.FileOpenItemClick(Sender: TObject);
var
	f1,f2:string;
begin
	if modified then
   begin
		if MessageDlg('This file was modified. Save it?',mtcustom,[mbYes,mbNo],0) = mryes then
       begin
			FileSaveItemClick(Sender);
       end;
   end;

	OpenDialog1.initialdir := frmConfig.edit1.text;
	if (OpenDialog1.Execute) then
  	begin
		frmBlocks.ClearListbox;
		ReadDemo(opendialog1.filename);
//       FileHist1.addfile(opendialog1.filename);
		AddToFileHistory(opendialog1.filename);
       modified := false;
       Caption := 'Film At 11 - ' + opendialog1.filename;
       Application.title := 'Film At 11 - ' + opendialog1.filename;
	end;
end;

procedure TMainForm.FileSaveItemClick(Sender: TObject);
begin
	SaveDialog1.initialdir := OpenDialog1.initialdir;
	if (SaveDialog1.Execute) then
	begin
		if pos('.', Savedialog1.filename) = 0 then
       	SaveDialog1.filename := savedialog1.filename + '.dem';
   	WriteDemo(0,frmBlocks.Listbox1.items.count -1);
		modified := false;
   end;
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
	playing := false;
	if modified then
   begin
		if MessageDlg('This file was modified. Save it?',mtcustom,[mbYes,mbNo],0) = mryes then
       begin
			FileSaveItemClick(Sender);
       end;
   end;
  Close;
end;

procedure TMainForm.CutItemClick(Sender: TObject);
var
	i:integer;
   mb,mb2:Tmessageblock;
   m,m2:Tmsg;
begin
	ClearClipboard;

	if frmBlocks.Listbox1.focused then
	begin
		if frmBlocks.Listbox1.itemindex = -1 then
       	exit;
		if frmBlocks.Listbox1.selcount < 1 then
   	begin
	       exit;
   	end;

		i := 0;
		while (i < (frmBlocks.Listbox1.items.count -1)) do
	   	begin
			if frmBlocks.Listbox1.selected[i] then
           begin
				mb := TMessageblock(frmBlocks.Listbox1.items.objects[i]);
				Clipboardmode := 0;
				Clipboard.addobject(frmBlocks.Listbox1.items.strings[i],mb);
               frmBlocks.Listbox1.items.delete(i);
           end else
           	inc(i);
	   end;
   end;

	if frmMsgs.Listbox1.focused then
	begin
		if frmMsgs.Listbox1.itemindex = -1 then
       	exit;

		mb := TMessageblock(frmBlocks.Listbox1.items.objects[frmBlocks.Listbox1.itemindex]);
		m := mb.m;
		m2 := nil;
		m := Tmsg(mb.m);
		if frmMsgs.listbox1.itemindex = 0 then
       begin
       	mb.m := m.next;
       end else
       begin
       	for i:= 0 to frmMsgs.Listbox1.itemindex -2 do
	       		m := m.next;
			m2 := m;
           m := m.next;
           m2.next := m.next;
		end;
       Clipboardmode := 1;
       Clipboard.addobject(m.desc,m);
       m.next := nil;
       mb.blocksize := mb.blocksize - m.size;
       frmMsgs.Listbox1.items.delete(frmMsgs.Listbox1.itemindex);
		frmBlocks.Listbox1Click(Sender);
   end;
   modified := true;
	UpdateMenuItems(Sender);
end;

procedure TMainForm.CopyItemClick(Sender: TObject);
var
	i:integer;
   mb,mb2:Tmessageblock;
   m,m2:Tmsg;
begin
	ClearClipboard;
	if frmBlocks.Listbox1.focused then
	begin
		if frmBlocks.Listbox1.itemindex = -1 then
       	exit;
		if frmBlocks.Listbox1.selcount < 1 then
   	begin
	       exit;
   	end;

		i := 0;
		while (i < (frmBlocks.Listbox1.items.count -1)) do
	   	begin
			if frmBlocks.Listbox1.selected[i] then
           begin
				mb := TMessageblock(frmBlocks.Listbox1.items.objects[i]);
				mb2 := Tmessageblock.create;
               mb2.blocksize := mb.blocksize;
				mb2.angles := mb.angles;
               mb2.msg := nil;
				mb2.m := nil;
				if mb.m <> nil then
               begin
					m := mb.m;
                   m2 := Tmsg.create;
					while m <> nil do
                   begin
						if mb2.m = nil then
                       	mb2.m := m2
                       else if m2.next = nil then
                       begin
                       	m2.next := Tmsg.create;
                           m2 := m2.next;
                       end;
                       m2.p := allocmem(m.size);
                       CopyMemory(m2.p,m.p,m.size);
                       m2.id := m.id;
                       m2.size := m.size;
                       m2.desc := m.desc;
                       m2.pos := m.pos;
                       m2.next := nil;
                       m := m.next;
                   end;
               end;
				Clipboardmode := 0;
				Clipboard.addobject(frmBlocks.Listbox1.items.strings[i],mb2);
           end;
           inc(i);
	   end;
   end;

	if frmMsgs.Listbox1.focused then
	begin
		if frmMsgs.Listbox1.itemindex = -1 then
       	exit;

		mb := TMessageblock(frmBlocks.Listbox1.items.objects[frmBlocks.Listbox1.itemindex]);
		m := mb.m;
       while m <> nil do
       begin
			if m = Tmsg(frmMsgs.Listbox1.items.objects[frmMsgs.Listbox1.itemindex]) then
           	break;
			m := m.next;
       end;
		if m = nil then
       begin
			Showmessage('Could not copy message to clipboard');
       	exit;
       end;
       m2 := Tmsg.create;
       m2.p := allocmem(m.size);
       CopyMemory(m2.p,m.p,m.size);
       m2.id := m.id;
       m2.size := m.size;
       m2.desc := m.desc;
       m2.pos := m.pos;
       m2.next := nil;
       m := m.next;

       Clipboardmode := 1;
       Clipboard.addobject(m2.desc,m2);
   end;
  	UpdateMenuItems(Sender);

end;

procedure TMainForm.PasteItemClick(Sender: TObject);
begin
	frmPasteSpecial.edit1.text := '1';
   frmPasteSpecial.edit2.text := '1';
   DoPaste;
end;

procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.UpdateMenuItems(Sender: TObject);
begin
  FileSaveItem.Enabled := MDIChildCount > 0;
  CutItem.Enabled := MDIChildCount > 0;
  CopyItem.Enabled := MDIChildCount > 0;
  PasteItem.Enabled := Clipboard.count > 0;
  PasteSpecial1.Enabled := Clipboard.count > 0;

  SaveBtn.Enabled := MDIChildCount > 0;
  CutBtn.Enabled := MDIChildCount > 0;
  CopyBtn.Enabled := MDIChildCount > 0;
  PasteBtn.Enabled := MDIChildCount > 0;
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
	r:TRegIniFile;
   j:integer;
begin
	r := TRegIniFile.create('Software\FilmAt11');
   r.writeInteger('MainWindow','Top',Top);
   r.writeInteger('MainWindow','Left',Left);
   r.writeInteger('MainWindow','Width',Width);
   r.writeInteger('MainWindow','Height',Height);
   r.writeInteger('MainWindow','WindowState',Longint(WindowState));
   if FileHistory.count > 0 then
   begin
		r.writeinteger('FileHistory','Num',FileHistory.count);
       for j := 0 to FileHistory.count -1  do
       begin
  			r.WriteString('FileHistory',inttostr(j),FileHistory[j]);
       end;
   end;

   r.free;

  Screen.OnActiveFormChange := nil;
//  	ClearClipboard;

   Entities.free;
	Clipboard.free;

end;

procedure TMainForm.HelpAboutItemClick(Sender: TObject);
begin
	Aboutbox.show;
end;

procedure TMainform.ReadDemo(filename:string);
var
	f:TFileStream;
	f1:textfile;
   line:string;
   flen,fpos,r,numblocks:longint;
   i,j,k,len,blocks,msgs:integer;
	g:^smallint;
	mask:smallint;
   mb:Tmessageblock;
   p,q:pchar;
   p1,p2,p3:single;
   a1,a2,a3:single;
   root:Ttreenode;
   whole:pchar;
	a:Plongint;
	z:Pinteger;
   b:Psingle;
   c,d:char;
   m,n:tmsg;
  desc,junk:string;
  x:single;
	parts:integer;
   fname1,fname2:string;
   newpart:boolean;
	startofheader,endofheader:longint;
   po,pa:TPos;

  begin
	frmModels.listbox1.clear;
   frmsounds.listbox1.clear;
	numblocks := 0;
	blocks := 0;
   msgs := 0;

	{read file into memory}
	f := TFileStream.create(filename,fmOpenRead);
	flen := f.size;
	if (flen =0) then
	begin
		f.destroy;
		exit;
	end;
	frmProgress.Progressbar1.min := 0;
	frmProgress.Progressbar1.max := 32000;
	frmProgress.Progressbar1.position := 0;
	frmProgress.Show;
	fpos := 0;
	while (1=1) do
	begin
		f.read(c,1);
		if (c = #10) then
			break;
		line := line + c;
	end;
	cdtrack := strtoint(line);
	mb := nil;
	frmBlocks.listbox1.enabled := false;
	frmBlocks.listbox1.Items.BeginUpdate;

	while (f.position < flen) do
	begin
		mb := TMessageblock.create;
		q := @mb.blocksize;
		f.read(q^,16);
		mb.msg := allocmem(mb.blocksize);
		f.read(mb.msg^,mb.blocksize);
		fpos := f.position;
		if (blocks mod 50) = 0 then
		begin
			if flen > 32000 then
				frmProgress.Progressbar1.position := fpos div (flen div 32000);
			frmProgress.label1.caption := 'Parsing ' + inttostr(fpos) +' of '+inttostr(flen);
			frmProgress.refresh;
		end;

		if (numblocks > 32500) then
		begin
			ShowMessage('This file is too large to be loaded. Use the File/Split function to split it into loadable chunks.');
			break;
		end;

		frmBlocks.Listbox1.items.addobject('block '+inttostr(blocks),mb);

		inc(blocks);
		inc(numblocks);
		mb.m := nil;
		mb.printtext := '';
		m := nil;
		i := 0;
		while( i < mb.blocksize) do
		begin
			c := mb.msg[i];
			inc(i);
		case (c) of
		#0: {bad len=0}
			begin
				desc := 'bad!!';
				showmessage('Bad message encountered! Aborting.');
				f.destroy;
				frmProgress.hide;
				exit;
			end;
		#1: {nop len=0}
			begin
				desc := 'NOP';
				len := 0;
			end;
		#2: {disconnect len=0}
			begin
				desc := 'disconnect';
				len := 0;
			end;
		#3: {updatestat}
			begin
				a := @mb.msg[i+1];
				if (frmConfig.debug.checked) then
					desc := 'updatestat ' + inttostr(ord(mb.msg[i])) + ' ' + inttostr(a^)
				else
					desc := 'updatestat ';
				len := 5;
			end;
		#4: {version len=2 int ver (0x0F) }
			begin
				a := @mb.msg[i+1];
				desc := 'version '+inttostr(a^);
				len := 4;
			end;
		#5: {setview len=2 int entity}
			begin
				g := @mb.msg[i];
				desc := 'setview ' + inttostr(g^);
               cameraentity := g^;
				len := 2;
           end;
       #6: {sound len=18?}
			begin
           	desc := 'sound';
				len := 1;
				mask := ord(mb.msg[i]);
               if ((mask and 1)=1) then
               	len := len + 1;
               if ((mask and 2)=2) then
               	len := len + 1;
				desc := 'sound ';//+ frmSounds.listbox1.items[ord(mb.msg[i+len+2])-1];
				len := len + 9;
			end;
		#7: {time len=4}
			begin
				b := @mb.msg[i];
				desc := 'time ' + floattostr(b^);
				mb.time := b^;
				lasttime := b^;
				len := 4;
			end;
		#8: {print len=null term string }
			begin
				j := i;
				d := mb.msg[j];
				junk :=strpas(@mb.msg[j]);
				desc := 'print "' +junk +'"';
				mb.printtext := mb.printtext + CleanString(strpas(@mb.msg[j]));
				len := length(junk)+1;
			end;
		#9: {stufftext len=string}
			begin
				j := i;
				d := mb.msg[j];
				junk :=strpas(@mb.msg[j]);
				desc := 'stufftext "' +junk+'"';
				// watch for multi level demos
				if strpas(@mb.msg[j]) = 'reconnect'+#10 then
					if parts = 0 then
						if MessageDlg('This demo has multiple levels. Do you wish to split it?',mtcustom,[mbyes,mbno],0) = mrYes then
							newpart := true;

				len := length(junk)+1;
			end;
		#$A: {setangle len=1}
			begin
				desc := 'setangle';
				len := 3;
			end;
		#$B: {serverinfo len=}
			begin
				desc := 'serverinfo';
				len := 6;
				j := i+6;
				junk := strpas(@mb.msg[j]);
				levelname := junk;
				len := len + length(junk) + 1;
				j := i+ len;
				desc := 'serverinfo ' + junk;

				{map title}
				junk := strpas(@mb.msg[j]);
				len := len + length(junk) + 1;
				j := i+ len;

				mapname := junk;
				frmModels.listbox1.items.add(mapname);

				while (mb.msg[j] <> #0) do {read a bunch of strings }
               begin
					junk := strpas(@mb.msg[j]);
					frmmodels.listbox1.items.add(junk);
                   len := len + length(junk) + 1;
                   j := i + len;
				end;
               inc(j);
               inc(len);
				while (mb.msg[j] <> #0) do {read a bunch of strings }
				begin
					junk := strpas(@mb.msg[j]);
					frmsounds.listbox1.items.add(strpas(@mb.msg[j]));
                   len := len + length(junk) + 1;
                   j := i + len;
				end;
               inc(j);
				inc(len);
           end;
		#$C: {lightstyle}
       	begin
           	desc := 'lightstyle';
				len := 1;
				j := i +1;
				junk := strpas(@mb.msg[j]);
				len := len + length(junk) + 1;
           end;
		#$D: {updatename}
       	begin
               j := i +1;
				mask := ord(mb.msg[i]);

				junk := strpas(@mb.msg[j]);
           	desc := 'updatename "' +junk+'"';
           	len := 1 + length(junk) +1;
               frmEntities.listbox1.items[mask+1] := junk;
			end;
		#$E: {updatefrags}
       	begin
				desc := 'updatefrags';
           	len := 3;
			end;
       #$F: {clientdata}
       	begin;
				g := @mb.msg[i];
				mask := g^;
				if (frmConfig.Debug.checked) then
					desc := 'clientdata '+inttostr(mask)
				else
					desc := 'clientdata ';
				len := 2;
				if ((mask and $1)<>0) then {viewheight}
				begin
//					mb.viewheight := ord(mb.msg[i+len]);
					inc(len);
				end;
				if ((mask and $2)<>0) then {idealpitch}
					inc(len);

				if ((mask and $4)<>0) then {punchangles}
					inc(len);
				if ((mask and $8)<>0) then
					inc(len);
				if ((mask and $10)<>0) then
					inc(len);
				if ((mask and $20)<>0) then
					inc(len);
				if ((mask and $40)<>0) then
					inc(len);
				if ((mask and $80)<>0) then
					inc(len);

			   if ((mask and $100)<>0) then
					len := len + 0;
				if ((mask and $200)<>0) then {items}
					len := len + 0;
				if ((mask and $400)<>0) then {onground}
					len := len + 0;
				if ((mask and $800)<>0) then {inwater}
					len := len + 0;

				if ((mask and $1000)<>0) then {weaponframe}
					inc(len);
				if ((mask and $2000)<>0) then {armour}
					inc(len);
				if ((mask and $4000)<>0) then {weapon}
					inc(len);
				len := len + 12;
				end;
		#$10: {stopsound}
			begin
				desc := 'stopsound';
				len := 2;
			end;
		#$11: {updatecolors}
			begin
				desc := 'updatecolors';
				len := 2;
			end;
		#$12: {particle}
			begin
				desc := 'particle';
				len := 11;
			end;
		#$13: {damage}
			begin
           	desc := 'damage';
           	len := 8;
			end;
		#$14: {spawnstatic}
			begin
           	desc := 'spawnstatic';
				len := 13;
			end;
		#$15: {spawnbinary...obsolete, shouldn't occur}
       	begin
           	desc := 'spawnbinary...obselete';
           	len := 0;
			end;
		#$16: {spawnbaseline}
			begin
                g := @mb.msg[i];
          		desc := 'spawnbaseline ' + inttostr(g^) + ' ' + frmModels.listbox1.items[ord(mb.msg[i+2])-1];
				k := g^;
				while (g^) > frmEntities.listbox1.items.count -1 do
               	frmEntities.listbox1.items.add('');
          		frmEntities.listbox1.items[g^] := frmModels.listbox1.items[ord(mb.msg[i+2])-1];
				po := Tpos.create;
				pa := Tpos.create;
               frmEntities.listbox1.items.objects[g^] := po;
               g := @mb.msg[i+6];
               po.x := g^ * 0.125;
				po.a := ord(mb.msg[i+8]) / 92160;
               g := @mb.msg[i+9];
				po.y := g^ * 0.125;
               po.b := ord(mb.msg[i+11]) / 92160;
               g := @mb.msg[i+12];
               po.z := g^ * 0.125;
               po.c := ord(mb.msg[i+14]) / 92160;
           	len := 15;
			end;
		#$17: {tempentity}
			begin
           	desc := 'tempentity';
           	mask := ord(mb.msg[i]);
               case (mask) of
               0,1,2,3,4,7,8,10,11:
               	len := 7;
				5,6,9:
					len := 15;
               end;
			end;
		#$18: {setpause}
       	begin
				desc := 'setpause';
           	len := 1;
			end;
		#$19: {signon}
       	begin
           	desc := 'signon - '+inttostr(ord(mb.msg[i]));
           	len := 1;
			end;
		#$1A: {centerprint}
       	begin
				len := 0;
               j := i;
	           	d := mb.msg[j];
				junk := strpas(@mb.msg[j]);
               desc := 'centerprint "'+junk+'"';
				len := length(junk)+1;
			end;
		#$1B: {killedmonster}
       	begin
           	desc := 'killedmonster';
           	len := 0;
			end;
		#$1C: {foundsecret}
       	begin
				desc := 'foundsecret';
           	len := 0;
			end;
		#$1D: {spawnstaticsound}
       	begin
           	desc := 'spawnstaticsound '+ frmSounds.listbox1.items[ord(mb.msg[i+6])-1];
           	len := 9;
			end;
		#$1E: {intermission}
       	begin
           	desc := 'intermission';
           	len := 0;
			end;
		#$1F: {finale}
       	begin
				desc := 'finale';
           	len := 0;
               j := i;
               while (1=1) do
               begin
					d := mb.msg[j];
                   inc(j);
					inc(len);
                   if (d = #0) then
                   	break;
               end;
			end;
       #$20: {cdtrack len=2}
       	begin
           	desc := 'cdtrack '+inttostr(ord(mb.msg[i]))+' '+inttostr(ord(mb.msg[i+1]));
				len := 2;
           end;
		#$21: {sellscreen}
       	begin
           	desc := 'sellscreen';
           	len := 0;
			end;
		else {update entity}
			begin
				mask := ord(c) and $7f;
				len := 0;
				if ((mask and $1)<>0) then
				begin
					p := @mask;
					p[1] := mb.msg[i];
					inc(len);
				end;
				if ((mask and $4000)<>0) then {entity}
				begin
					g := @mb.msg[i+len];
					k := g^;
					len := len +2;
				end
				else
				begin
					k := ord(mb.msg[i+len]);
					len := len + 1;
				end;

{				if (k > 0) and (k < frmEntities.listbox1.items.count) then
				begin
					 po := Tpos(frmEntities.listbox1.items.objects[k]);
					 if (po <> nil) then
					 begin
						  p1 := po.x;
						  p2 := po.y;
						  p3 := po.z;
						  a1 := po.a;
						  a2 := po.b;
						  a3 := po.c;
					 end;
				end;}
				if k = cameraentity then
				begin
					mb.camerapos[0] := 0;
					mb.camerapos[1] := 0;
					mb.camerapos[2] := 0;
				end;
				if ((mask and $400)<>0) then {modelindex}
					len := len +1;
				if ((mask and $40)<>0) then {frame}
					len := len +1;
				if ((mask and $800)<>0) then {colormap}
					len := len +1;
				if ((mask and $1000)<>0) then {skin}
					len := len +1;
				if ((mask and $2000)<>0) then {effects}
					len := len +1;

				if ((mask and $2)<>0) then
				begin
					 g := @mb.msg[i+len];
					 p1 := g^ * 0.125;
					if k = cameraentity then
					begin
						mb.camerapos[0] := g^ * 0.125;
					end;
					len := len + 2;
				end;
				if ((mask and $100)<>0) then
				begin
					a1 := ord(mb.msg[i+len]) / 92160;
					len := len +1;
				end;
				if ((mask and $4)<>0) then
				begin
					g := @mb.msg[i+len];
					p2 := g^ * 0.125;
					if k = cameraentity then
					begin
						mb.camerapos[1] := g^ * 0.125;
					end;
					len := len +2;
				end;
				if ((mask and $10)<>0) then
				begin
					a2 := ord(mb.msg[i+len]) / 92160;
					len := len +1;
				end;
				if ((mask and $8)<>0) then
				begin
					g := @mb.msg[i+len];
					p3 := g^ * 0.125;
					if k = cameraentity then
					begin
						mb.camerapos[2] := g^ * 0.125;
					end;
					len := len +2;
				end;
				if ((mask and $200)<>0) then
				begin
					a3 := ord(mb.msg[i+len]) / 92160;
					len := len +1;
				end;

{				if frmConfig.debug.checked then
				begin
					desc := 'updateentity ' + inttostr(k)+' '+ inttostr(mask);
					if (k > 0) and (k < frmEntities.listbox1.items.count) then
						if (frmEntities.listbox1.items[k] <> '') then
							desc := 'updateentity ' + frmEntities.listbox1.items[k]+' ('+ inttostr(k) + ') ' + inttostr(mask);
				end else begin
					desc := 'updateentity ' + inttostr(k);
					if (k > 0) and (k < frmEntities.listbox1.items.count) then
						if (frmEntities.listbox1.items[k] <> '') then
							desc := 'updateentity ' + frmEntities.listbox1.items[k]+' ('+ inttostr(k) + ') ';
				end;
				if (k = cameraentity) then
				begin
					if frmConfig.debug.checked then
					begin
						desc := 'updateentity ' +inttostr(k)+' '+ inttostr(mask) +' '+ floattostr(mb.camerapos[0]) + ' '+ floattostr(mb.camerapos[1]) + ' '+ floattostr(mb.camerapos[2]);
						if (k > 0) and (k < frmEntities.listbox1.items.count) then
							if (frmEntities.listbox1.items[k] <> '') then
								desc := 'updateentity ' +frmEntities.listbox1.items[k]+' ('+ inttostr(k) + ') ' + inttostr(mask) +' '+ floattostr(mb.camerapos[0]) + ' '+ floattostr(mb.camerapos[1]) + ' '+ floattostr(mb.camerapos[2]);
					end else begin
						desc := 'updateentity ' +inttostr(k);
						if (k > 0) and (k < frmEntities.listbox1.items.count) then
							if (frmEntities.listbox1.items[k] <> '') then
								desc := 'updateentity ' +frmEntities.listbox1.items[k]+' ('+ inttostr(k) + ') ' ;
					end;
				end;}
			end;

		end;
		inc(msgs);
		inc(len);
		if (m <> nil) then
		begin
			m.next := Tmsg.create;
			m := m.next;
		end else
			m := Tmsg.create;

		if (mb.m = nil) then
		begin
			mb.m := m;
		end;

		m.id := ord(c);
		m.size := len;
		m.desc := desc;
		m.pos := f.position - mb.blocksize + i -1;
		m.next := nil;
		if (m.id = $16) or (m.id > $21) then
		begin
			 m.x := p1;
			 m.y := p2;
			 m.z := p3;
			 m.ent := k;
			 m.angx := a1;
			 m.angy := a2;
			 m.angz := a3;
		end;
		p1 :=0;
		p2 :=0;
		p3 :=0;
		a1 := 0;
		a2 := 0;
		a3 := 0;
		if (m.id = 7) then
		begin
			m.p := allocmem(5);
			m.p[0] := c;
			m.p[1] := mb.msg[i];
			m.p[2] := mb.msg[i+1];
			m.p[3] := mb.msg[i+2];
			m.p[4] := mb.msg[i+3];
		end else begin
			m.p := allocmem(len);
			m.p[0] := c;
			move(mb.msg[i],m.p[1],len-1);
		end;
		i := i + (len-1);
	end;
	freemem(mb.msg);

	end;
	frmProgress.hide;
	Statusbar.simpletext := OpenDialog1.filename + ' loaded, '+inttostr(blocks)+' blocks, '+inttostr(msgs)+' msgs';
	numberofblocks  := blocks;
	numberofmsgs := msgs;
	frmBlocks.listbox1.enabled := true;
	frmBlocks.listbox1.items.endupdate;
	f.destroy;
end;

procedure TMainform.WriteDemo(startblock,n:integer);
var
	f:Tfilestream;
   f1:textfile;
   line:string;
   i,j,b:integer;
   q:pchar;
	mb:Tmessageblock;
   m:tmsg;
   c:char;
	x:^smallint;
   junk:array[0..255] of char;
   junk2:string;
	p:pchar;
   l:longint;
   lasttime:single;
   d:Psingle;
begin
	frmProgress.Progressbar1.min := 0;
	frmProgress.Progressbar1.max := frmBlocks.Listbox1.items.count;
	frmProgress.Progressbar1.position := 0;
	frmProgress.Show;
	b := 0;
	Assignfile(f1,SaveDialog1.filename);
   rewrite(f1);
   closefile(f1);
	f := TFileStream.create(SaveDialog1.filename,fmOpenWrite);
	line := inttostr(cdtrack) + #10;
   f.write(line[1],length(line));
	lasttime := 0;
   { this whole rewrite the serverinfo thing is a terrible hack }
   l := 7;
   // write out levelname
   junk2 := levelname + #0;
   l := l + length(junk2);
	// write out models
   for j := 0 to frmModels.listbox1.items.count -1 do
   begin
        junk2 := frmModels.listbox1.items[j] + #0;
        l := l + length(junk2);
   end;
   inc(l); // null terminator
   // write out sounds
   for j := 0 to frmSounds.listbox1.items.count -1 do
   begin
        junk2 := frmSounds.listbox1.items[j] + #0;
        l := l + length(junk2);
   end;
   inc(l);

	for i := 0 to frmBlocks.Listbox1.items.count -1 do
   begin
		mb := Tmessageblock(frmBlocks.Listbox1.items.objects[i]);
       if i = 0 then
       begin
		     m := mb.m;
		     while(m <> nil) do
			 begin
                    if m.id = $B then
                       break;
                    m := m.next;
            end;
            mb.blocksize := mb.blocksize - m.size;
            mb.blocksize := mb.blocksize + l;
       end;
		if (mb.blocksize > 0) and (mb.m <> nil) then begin
		q := @mb.blocksize;
		f.write(q^,16);
		m := mb.m;
       if (b mod 50) = 0 then
       begin
	       	frmProgress.Progressbar1.position := b;
			frmProgress.label1.caption := 'Writing ' + inttostr(b) +' of '+inttostr(frmBlocks.Listbox1.items.count);
			frmProgress.refresh;
       end;
       inc(b);
		while(m <> nil) do
       begin
       	if (m.id = $f) then //if updateentity
			begin
           	x := @m.p[1];
               x^ := x^ or $200;
           end;
           if (m.id = $B) then //if serverinfo
           begin
           	f.write(m.p[0],7); // keep first 4 bytes of original header
               // write out levelname
               junk2 := levelname + #0;
               f.write(junk2[1],length(junk2));
               // write out models
               for j := 0 to frmModels.listbox1.items.count -1 do
               begin
               	junk2 := frmModels.listbox1.items[j] + #0;
                   f.write(junk2[1],length(junk2));
               end;
               junk2 := #0;
               f.write(junk2[1],1); //trailing null
               // write out sounds
               for j := 0 to frmSounds.listbox1.items.count -1 do
               begin
               	junk2 := frmSounds.listbox1.items[j] + #0;
					f.write(junk2[1],length(junk2));
               end;
               junk2 := #0;
               f.write(junk2[1],1); //trailing null
{           end else if (m.id = $7) then begin//if time stamp
				// correct time stamps as we write the demo
				d := @m.p[1];
               d^ := lasttime;
               lasttime := lasttime + 0.05;
           	f.write(m.p^,m.size);}
			end else
           	f.write(m.p^,m.size);

           m := m.next;
       end;
       end;
   end;
   f.destroy;
	frmProgress.hide;
end;


procedure TMainForm.Find1Click(Sender: TObject);
begin
	FindDialog1.execute;
end;

procedure TMainForm.Delete1Click(Sender: TObject);
var
	i:integer;
   mb:Tmessageblock;
   m,n:Tmsg;
begin
	if ActiveMDICHild = frmBlocks then
	begin
   	if frmBlocks.listbox1.itemindex = -1 then
       	exit;
		modified := true;
		if frmBlocks.listbox1.selcount = 1 then
   	begin
			frmBlocks.listbox1.items.delete(frmBlocks.listbox1.itemindex);
	       exit;
   	end;

		i := 0;
		while (i < (frmBlocks.listbox1.items.count -1)) do
	    begin
			if frmBlocks.listbox1.selected[i] then
				frmBlocks.listbox1.items.delete(i)
   	    else
       		inc(i);
	   	end;
      	exit;
   end;

	if ActiveMDICHild = frmMsgs  then
	begin
		if frmMsgs.listbox1.itemindex = -1 then
       	exit;
		modified := true;
		mb := Tmessageblock(frmBlocks.Listbox1.items.objects[frmBlocks.listbox1.itemindex]);
		m := Tmsg(mb.m);
		if frmMsgs.listbox1.itemindex = 0 then
       begin
       	mb.m := m.next;
			mb.blocksize := mb.blocksize - m.size;
			m.free;
			frmBlocks.ListBox1Click(Sender);
           exit;
       end;
       for i:= 0 to frmMsgs.listbox1.itemindex -2 do
	       m := m.next;
		// we are now at the msg just before the one to delete
		n := m.next;
		mb.blocksize := mb.blocksize - n.size;
       m.next := n.next;
       n.free;
		frmBlocks.ListBox1Click(Sender);
       exit;
   end;

	if ActiveMDICHild = frmModels  then
	begin
		if frmModels.listbox1.itemindex = -1 then
       	exit;
		frmModels.listbox1.items.delete(frmModels.listbox1.itemindex);
		exit;
   end;
	if ActiveMDICHild = frmSounds  then
	begin
		if frmSounds.listbox1.itemindex = -1 then
       	exit;
		frmSounds.listbox1.items.delete(frmSounds.listbox1.itemindex);
		exit;
   end;
end;

procedure TMainForm.FindDialog1Find(Sender: TObject);
var
   line:string;
   i,j:integer;
   q:pchar;
	mb:Tmessageblock;
   m:tmsg;
   c:char;
begin
	if frmBlocks.listbox1.selcount > 1 then
   begin
		for i := 0 to frmBlocks.listbox1.items.count -1 do
       	frmBlocks.listbox1.selected[i] := false;
	end;
		for i := searchblock to frmBlocks.Listbox1.items.count -1 do
   	begin
			mb := Tmessageblock(frmBlocks.listbox1.items.objects[i]);
			q := @mb.blocksize;
			m := mb.m;
			j := 0;
			if searchmsg > 0 then
				for j := 0 to searchmsg do
   	        	if (m <> nil) then
       	        	m := m.next;
			while(m <> nil) do
	    	begin
           	if pos(lowercase(FindDialog1.findtext),lowercase(m.desc)) > 0 then
               begin
               	frmBlocks.listbox1.selected[i] := true;
                   frmBlocks.listbox1.update;
                   frmBlocks.listbox1Click(Sender);

                   frmMsgs.Listbox1.itemindex := j;
					frmMsgs.Listbox1.update;
                   searchblock := i;
					searchmsg := j+1;
                   exit;
               end;
				inc(j);
       	    m := m.next;
               searchmsg := 0;
       	end;
           searchmsg := 0;
   	end;
       ShowMessage('Text not found');
       searchblock := 0;
       searchmsg := 0;
end;

procedure TMainForm.Split1Click(Sender: TObject);
var
	c:char;
   fname2,line:string;
   f,f2:Tfilestream;
   f1:textfile;
   blocks,numblocks,parts,fpos:longint;
   mb:Tmessageblock;
	q,header:pchar;
begin
	OpenDialog1.initialdir := frmConfig.edit1.text;
	if not OpenDialog1.execute then
   	exit;

	frmSplitSplice.listbox1.clear;
	fname2 := copy(opendialog1.filename,1,pos('.',opendialog1.filename));

	f := TFileStream.create(OpenDialog1.filename,fmOpenRead);
	if (f.size = 0) then
   begin
   	f.destroy;
       exit;
   end;
	frmProgress.Progressbar1.min := 0;
	frmProgress.Progressbar1.max := 32000;
	frmProgress.Progressbar1.position := 0;
	frmProgress.Show;
   while (1=1) do
   begin
		f.read(c,1);
		if (c = #10) then
       	break;
       line := line + c;
   end;
	parts := 0;
   blocks := 0;
   numblocks := 0;
   Assignfile(f1,fname2 +  inttostr(parts));
   rewrite(f1);
   closefile(f1);
   f2 := Tfilestream.create(fname2 + inttostr(parts),fmOpenWrite);
	frmSplitSplice.listbox1.items.add(fname2 + inttostr(parts));
   line := line + #10;
   f2.write(line[1],length(line));

  	mb := TMessageblock.create;
	while (f.position < f.size) do
   begin
		q := @mb.blocksize;
		f.read(q^,16);
       f2.write(q^,16);
		mb.msg := allocmem(mb.blocksize);
		f.read(mb.msg^,mb.blocksize);
		f2.write(mb.msg^,mb.blocksize);
       if mb.msg[0] = #9 then{its stufftext!}
       	if strpas(@mb.msg[1]) = ('reconnect' +#10) then
           	if MessageDlg('This appears to be a multi level demo. Do you want to split it into a new file?',mtcustom,[mbYes,mbNo],0) = mrYes then
					if SaveDialog1.execute then
                   begin
                   	numblocks := 32500;
						fname2 := copy(Savedialog1.filename,1,pos('.',Savedialog1.filename));
						parts := -1;
                   end;
       freemem(mb.msg);
		inc(blocks);
       inc(numblocks);
		if blocks = 3 then
       begin
			//save a copy of the header
			fpos := f.position;
			header := allocmem(fpos);
           f.seek(0,0);
           f.read(header^,fpos);
           f.seek(fpos,0);
		end;
       if (blocks mod 50) = 0 then
       begin
       	if f.position > 32000 then
	       		frmProgress.Progressbar1.position := f.position div (f.size div 32000);
			frmProgress.label1.caption := 'Splitting ' + inttostr(f.position) +' of '+inttostr(f.size);
			frmProgress.refresh;
   	end;
		if (numblocks > frmConfig.SpinEdit1.value) then
       begin
			// start a new file
           inc(parts);
           numblocks := 0;
       	f2.destroy;
			Assignfile(f1,fname2 +  inttostr(parts));
   		rewrite(f1);
   		closefile(f1);
           f2 := Tfilestream.create(fname2 + inttostr(parts),fmOpenWrite);
			f2.write(header^,fpos);
			frmSplitSplice.listbox1.items.add(fname2 + inttostr(parts));
       end;
	end;
	frmProgress.hide;
   f.destroy;
	f2.destroy;
   freemem(header);
   mb.free;
  	frmSplitSplice.caption := 'These files were created';
   frmSplitSplice.button1.visible := false;
   frmSplitSplice.button2.visible := false;
	frmSplitSplice.showmodal;
end;

procedure TMainForm.SPlice1Click(Sender: TObject);
var
	c:char;
   fname2,line:string;
   f,f2:Tfilestream;
   f1:textfile;
   blocks,numblocks,parts,fpos,totalsize:longint;
   mb:Tmessageblock;
   q,header:pchar;
   i,j:integer;
begin
	frmSplitSplice.listbox1.clear;
	frmSplitSplice.caption := 'Select files to splice';
   frmSplitSplice.button1.visible := true;
   frmSplitSplice.button2.visible := true;
	if frmSplitSplice.showmodal = mrCancel then
		exit;
   if frmSplitSplice.listbox1.items.count < 2 then
   begin
   	Showmessage('You must select 2 or more files to splice');
       exit;
   end;

   if not SaveDialog1.execute then
   	exit;

   Assignfile(f1,fname2 +  inttostr(parts));
   rewrite(f1);
   closefile(f1);

   Assignfile(f1,SaveDialog1.filename);
   rewrite(f1);
   closefile(f1);

   f2 := Tfilestream.create(SaveDialog1.filename,fmOpenWrite);
   mb := TMessageblock.create;
	// find out total size
   totalsize := 0;
   for i := 0 to frmSplitSplice.listbox1.items.count -1 do
   begin
		f := Tfilestream.create(frmSplitSplice.listbox1.items[i],fmOpenRead);
       totalsize := totalsize + f.size;
       f.destroy;
   end;
	frmProgress.Progressbar1.min := 0;
	frmProgress.Progressbar1.max := 32000;
	frmProgress.Progressbar1.position := 0;
	frmProgress.Show;
   for i := 0 to frmSplitSplice.listbox1.items.count -1 do
   begin
		f := Tfilestream.create(frmSplitSplice.listbox1.items[i],fmOpenRead);
		// read cdtrack
	   	while (1=1) do
   	begin
			f.read(c,1);
			if (c = #10) then
       		break;
       	line := line + c;
   	end;
       if i = 0 then
       begin
       	line := line + #10;
   		f2.write(line[1],length(line));
       end;
		// read 1st 3 blocks
		for j := 0 to 2 do
       begin
			q := @mb.blocksize;
			f.read(q^,16);
			mb.msg := allocmem(mb.blocksize);
       	f.read(mb.msg^,mb.blocksize);
       	if i = 0 then
       	begin
       		f2.write(q^,16);
				f2.write(mb.msg^,mb.blocksize);
			end;
       	freemem(mb.msg);
			inc(blocks);
       	inc(numblocks);
       end;

		//read/write the rest of the blocks
		while (f.position < f.size) do
   	begin
			q := @mb.blocksize;
			f.read(q^,16);
			// skip last block
           if f.position = f.size then
           	break;
			mb.msg := allocmem(mb.blocksize);
       	f.read(mb.msg^,mb.blocksize);
           f2.write(q^,16);
           f2.write(mb.msg^,mb.blocksize);
       	freemem(mb.msg);
			inc(blocks);
       	inc(numblocks);
       	if (blocks mod 50) = 0 then
   	    begin
       		if f.position > 32000 then
					frmProgress.Progressbar1.position := f.position div (totalsize div 32000);
				frmProgress.label1.caption := 'Splicing ' + inttostr(f.position) +' of '+inttostr(totalsize);
				frmProgress.refresh;
   		end;
       end;
       f.destroy;
	end;
   f2.destroy;
   frmProgress.hide;
   mb.free;
   ShowMessage('Successfully spliced');
end;

procedure TMainForm.Options1Click(Sender: TObject);
begin
	frmConfig.showmodal;
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
	OpenDialog1.initialdir := frmConfig.edit1.text;
	SaveDialog1.initialdir := frmConfig.edit1.text;
	frmSplitSplice.OpenDialog1.initialdir := frmConfig.edit1.text;
end;

procedure TMainForm.Compress1Click(Sender: TObject);
var
	c,d:char;
   fname2,line:string;
   f,f2:Tfilestream;
   f1:textfile;
   blocks,numblocks,parts,fpos,totalsize:longint;
   mb:Tmessageblock;
   p,q,header:pchar;
   i,j,TicksPerSecond,beforetime,aftertime:integer;
	startblock,endblock,len:longint;
   mask:smallint;
   keepblock:boolean;
   blocklist:Tstringlist;
   eventstring:string;
begin
	if frmCompress.showmodal = mrCancel then
   	exit;
	if frmCompress.RadioGroup1.itemindex = 0 then
		TicksPerSecond := 10
   else
   	TicksPerSecond := 20;
	beforetime := strtoint(frmCompress.Edit1.text) * TicksPerSecond;
	aftertime := strtoint(frmCompress.Edit2.text) * TicksPerSecond;

   if not OpenDialog1.execute then
   	exit;

   if not SaveDialog1.execute then
   	exit;

   f := Tfilestream.create(OpenDialog1.filename,fmOpenRead);
   Assignfile(f1,SaveDialog1.filename);
   rewrite(f1);
   closefile(f1);
   f2 := Tfilestream.create(SaveDialog1.filename,fmOpenWrite);
	blocklist := Tstringlist.create;
	// find out total size
   totalsize := f.size;
	frmProgress.Progressbar1.min := 0;
	frmProgress.Progressbar1.max := 32000;
	frmProgress.Progressbar1.position := 0;
	frmProgress.Show;

   //prepare eventstring
   { always keep signon and disconnect }
   eventstring := #2#$19;
   if frmCompress.Checkbox1.checked then
   	eventstring := eventstring + #$E;
   if frmCompress.Checkbox2.checked then
   	eventstring := eventstring + #$D;
   if frmCompress.Checkbox3.checked then
   	eventstring := eventstring + #$1A;
   if frmCompress.Checkbox4.checked then
   	eventstring := eventstring + #$18;
   if frmCompress.Checkbox5.checked then
   	eventstring := eventstring + #$8;
   if frmCompress.Checkbox6.checked then
   	eventstring := eventstring + #$6;
   if frmCompress.Checkbox7.checked then
   	eventstring := eventstring + #$11;
   if frmCompress.Checkbox8.checked then
   	eventstring := eventstring + #$13;
	if frmCompress.Checkbox9.checked then
   	eventstring := eventstring + #$1B;
   if frmCompress.Checkbox10.checked then
   	eventstring := eventstring + #$1C;
   // read cdtrack
   while (1=1) do
   begin
   	f.read(c,1);
       if (c = #10) then
       	break;
       line := line + c;
   end;
   line := line + #10;
   f2.write(line[1],length(line));
	blocks := 0;
   numblocks := 0;
	// make sure first 3 blocks are protected
	startblock := 0 - beforetime;
   endblock := 3 + aftertime;
   while (f.position < f.size) do
   begin
   	mb := TMessageblock.create;
		q := @mb.blocksize;
       f.read(q^,16);
       mb.msg := allocmem(mb.blocksize+16);
		f.seek(f.position-16,0);
       f.read(mb.msg^,mb.blocksize+16);
       if (blocks mod 50) = 0 then
       begin
       		if f.position > 32000 then
	       			frmProgress.Progressbar1.position := f.position div (totalsize div 32000);
				frmProgress.label1.caption := 'Compressing ' + inttostr(f.position) +' of '+inttostr(totalsize);
				frmProgress.refresh;
       end;
		i := 16;
		keepblock := false;
		while( i < mb.blocksize+16) do
       begin
			c := mb.msg[i];
			inc(i);
       case (c) of
       #0: {bad len=0}
       	begin
				len := 0;
			end;
       #1: {nop len=0}
       	begin
				len := 0;
           end;
       #2: {disconnect len=0}
       	begin
				len := 0;
           end;
       #3: {updatestat}
       	begin
				len := 5;
           end;
       #4: {version len=2 int ver (0x0F) }
       	begin
				len := 4;
           end;
       #5: {setview len=2 int entity}
       	begin
				len := 2;
           end;
       #6: {sound len=18?}
			begin
				len := 10;
				mask := ord(mb.msg[i]);
               if ((mask and 1)=1) then
               	len := len + 1;
               if ((mask and 2)=2) then
               	len := len + 1;
           end;
       #7: {time len=4}
       	begin
				len := 4;
           end;
       #8: {print len=null term string }
       	begin
				len := length(strpas(@mb.msg[i]))+1;
           end;
       #9: {stufftext len=string}
       	begin
				len := length(strpas(@mb.msg[i]))+1;
           end;
       #$A: {setangle len=1}
       	begin
				len := 3;
           end;
		#$B: {serverinfo len=}
       	begin
				len := 6;
				j := i+6;
               	while (1=1) do {server greeting }
               	begin
               		d := mb.msg[j];
                   	inc(j);
                   	inc(len);
                   	if (d = #0) then
                   		break;
               	end;
               	while (1=1) do {map name}
               	begin
               		d := mb.msg[j];
                   	inc(j);
                   	inc(len);
                   	if (d = #0) then
                   		break;
               	end;
				while (mb.msg[j] <> #0) do {read a bunch of strings }
               begin
               	while (1=1) do
               	begin
               		d := mb.msg[j];
                   	inc(j);
                   	inc(len);
                   	if (d = #0) then
                   		break;
               	end;
				end;
               inc(j);
               inc(len);
				while (mb.msg[j] <> #0) do {read a bunch of strings }
               begin
               	while (1=1) do
               	begin
               		d := mb.msg[j];
                   	inc(j);
                   	inc(len);
                   	if (d = #0) then
                   		break;
					end;
				end;
               inc(j);
               inc(len);
           end;
		#$C: {lightstyle}
       	begin
           	len := 1;
               j := i +1;
               while (1=1) do
               begin
               	d := mb.msg[j];
                   inc(j);
                   inc(len);
                   if (d = #0) then
                   	break;
               end;
           end;
		#$D: {updatename}
       	begin
               j := i +1;
               d := mb.msg[j];
				len := 1;
               while (1=1) do
               begin
               	d := mb.msg[j];
                   inc(j);
                   inc(len);
                   if (d = #0) then
                   	break;
               end;
			end;
		#$E: {updatefrags}
       	begin
           	len := 3;
			end;
       #$F: {clientdata}
       	begin;
               mask := 0;
				mask := ord(mb.msg[i+1]);
               mask := mask shl 8;
				mask := mask + ord(mb.msg[i]) ;
               len := 2;
               if ((mask and $1)<>0) then {viewheight}
					inc(len);
               if ((mask and $2)<>0) then {idealpitch}
               	inc(len);

               if ((mask and $4)<>0) then {punchangles}
               	inc(len);
               if ((mask and $8)<>0) then
               	inc(len);
               if ((mask and $10)<>0) then
               	inc(len);
               if ((mask and $20)<>0) then
               	inc(len);
               if ((mask and $40)<>0) then
               	inc(len);
               if ((mask and $80)<>0) then
               	inc(len);

              if ((mask and $100)<>0) then
               	len := len + 0;
               if ((mask and $200)<>0) then {items}
               	len := len + 0;
               if ((mask and $400)<>0) then {onground}
					len := len + 0;
               if ((mask and $800)<>0) then {inwater}
               	len := len + 0;

               if ((mask and $1000)<>0) then {weaponframe}
               	inc(len);
               if ((mask and $2000)<>0) then {armour}
               	inc(len);
               if ((mask and $4000)<>0) then {weapon}
               	inc(len);
				len := len + 12;
               end;
		#$10: {stopsound}
       	begin
           	len := 2;
			end;
		#$11: {updatecolors}
       	begin
           	len := 2;
			end;
		#$12: {particle}
       	begin
				len := 11;
			end;
		#$13: {damage}
       	begin
           	len := 8;
			end;
		#$14: {spawnstatic}
       	begin
           	len := 13;
			end;
		#$15: {spawnbinary...obsolete, shouldn't occur}
       	begin
           	len := 0;
			end;
		#$16: {spawnbaseline}
       	begin
           	len := 15;
			end;
		#$17: {tempentity}
       	begin
           	mask := ord(mb.msg[i]);
               case (mask) of
				0,1,2,3,4,7,8,10,11:
               	len := 7;
				5,6,9:
		           	len := 15;
               end;
			end;
		#$18: {setpause}
       	begin
           	len := 1;
			end;
		#$19: {signon}
       	begin
           	len := 1;
			end;
		#$1A: {centerprint}
       	begin
				len := length(strpas(@mb.msg[i]))+1;
			end;
		#$1B: {killedmonster}
       	begin
           	len := 0;
			end;
		#$1C: {foundsecret}
       	begin
           	len := 0;
			end;
		#$1D: {spawnstaticsound}
       	begin
           	len := 9;
			end;
		#$1E: {intermission}
       	begin
           	len := 0;
			end;
		#$1F: {finale}
       	begin
				len := length(strpas(@mb.msg[i]))+1;
			end;
       #$20: {cdtrack len=2}
       	begin
           	len := 2;
           end;
		#$21: {sellscreen}
       	begin
				len := 0;
			end;
		else {updateentity}
			begin;
				mask := ord(c) and $7f;
				len := 0;
				j :=i;
               if ((mask and $1)<>0) then
               begin
               	p := @mask;
                   p[1] := mb.msg[i];
               	inc(len);
                   inc(j);
               end;
               if ((mask and $4000)<>0) then {entity}
				begin
               	len := len +2;
               end
               else
               begin
               	len := len + 1;
               end;

               if ((mask and $400)<>0) then {modelindex}
               	len := len +1;
               if ((mask and $40)<>0) then {frame}
               	len := len +1;
               if ((mask and $800)<>0) then {colormap}
               	len := len +1;
               if ((mask and $1000)<>0) then {skin}
               	len := len +1;
               if ((mask and $2000)<>0) then {effects}
               	len := len +1;

               if ((mask and $2)<>0) then
               	len := len +2;
               if ((mask and $100)<>0) then
               	len := len +1;
               if ((mask and $4)<>0) then
               	len := len +2;
               if ((mask and $10)<>0) then
               	len := len +1;
               if ((mask and $8)<>0) then
               	len := len +2;
				if ((mask and $200)<>0) then
               	len := len +1;
			end;
       end; // end of case

       if pos(c,eventstring) > 0 then
         	keepblock := true;

		i := i + (len);

       end; // end of this block

		blocklist.addobject(inttostr(blocks),mb);

       if keepblock then //adjust window
		begin
       	startblock := blocks - beforetime;
			endblock := blocks + aftertime;
       end;

		if (blocks >= beforetime) then
       begin
			// if it falls within window, write to disk
			mb := Tmessageblock(blocklist.objects[0]);
			if (strtoint(blocklist[0]) >= startblock) and (strtoint(blocklist[0]) <= endblock) then
			begin
       		f2.write(mb.msg^,mb.blocksize+16);
           end;
           freemem(mb.msg);
           mb.free;
			blocklist.delete(0);
		end;
       inc(blocks);
       inc(numblocks);

	end; //end of file
	while (blocklist.count > 0) do
   begin
			// if it falls within window, write to disk
			mb := Tmessageblock(blocklist.objects[0]);
			if (strtoint(blocklist[0]) >= startblock) and (strtoint(blocklist[0]) <= endblock) then
			begin
       		f2.write(mb.msg^,mb.blocksize+16);
           end;
			freemem(mb.msg);
           mb.free;
			blocklist.delete(0);
   end;

   f2.destroy;
   f.destroy;
   frmProgress.hide;
   ShowMessage('Successfully compressed');
   blocklist.free;
end;

procedure TMainForm.PasteSpecial1Click(Sender: TObject);
begin
	if frmPasteSpecial.showmodal = mrOk then
   	DoPaste;
   frmPasteSpecial.Checkbox1.checked := false;
   frmPasteSpecial.edit1.text := '1';
   frmPasteSpecial.edit2.text := '1';
end;

procedure TMainForm.Insert1Click(Sender: TObject);
var
	i,j:integer;
   mb,mb2:Tmessageblock;
   m,m2:Tmsg;
begin
	if ActiveMDICHild = frmMsgs then
	begin
		if frmMsgs.Listbox1.itemindex = -1 then
       	exit;
		modified := true;
		mb := Tmessageblock(frmBlocks.Listbox1.items.objects[frmBlocks.Listbox1.itemindex]);
		m := mb.m;
       while m.next <> nil do
	       m := m.next;
		// we are now at the msg just before the one to insert
		frmEdit.mb := mb;
		frmEdit.m := m;
		if frmInsert.Showmodal = mrOk then
		begin
           m.next := Tmsg(frmInsert.m);
           m := Tmsg(frmInsert.m);
           m.next := nil;
			frmEdit.m := m;
           frmEdit.Editmsg;
           frmEdit.Encodemsg;
           mb.blocksize := mb.blocksize + m.size;
			modified := true;
//       	frmEdit.Showmodal;
		end;
		frmBlocks.Listbox1Click(Sender);
       exit;
   end;

	if ActiveMDICHild = frmModels then
	begin
   	frmEditValue.caption := 'Enter model file to precache';
   	frmEditValue.Combobox1.visible := false;
       frmEditValue.edit1.visible := true;
       if frmEditvalue.showmodal = mrOK then
       begin
			frmModels.listbox1.items.add(frmEditvalue.edit1.text);
       end;
   	exit;
   end;

	if ActiveMDICHild = frmSounds then
	begin
   	frmEditValue.caption := 'Enter sound file to precache';
   	frmEditValue.Combobox1.visible := false;
       frmEditValue.edit1.visible := true;
       if frmEditvalue.showmodal = mrOK then
       begin
			frmSounds.listbox1.items.add(frmEditvalue.edit1.text);
       end;
   	exit;
   end;

end;

procedure TMainForm.DoPaste;
var
	i,j,k,targetblock,numblocks:integer;
   mb,mb2:Tmessageblock;
   m,m2:Tmsg;
begin
  targetblock := frmBlocks.Listbox1.itemindex;
	numblocks := strtoint(frmPasteSpecial.edit1.text);
  while (numblocks > 0) do
  begin
	if (ActiveMDIChild = frmBlocks) and (Clipboardmode = 0) then
	begin
		if targetblock = -1 then
       	exit;

		j := targetblock;

		if frmPasteSpecial.checkbox1.checked then
       	i := clipboard.count -1
       else
       	i := 0;
		k := clipboard.count;
		while k > 0 do
	   	begin
       	mb := TMessageblock(Clipboard.objects[i]);
           mb2 := Tmessageblock.create;
           mb2.blocksize := mb.blocksize;
           mb2.angles := mb.angles;
           mb2.msg := nil;
			mb2.m := nil;
           if mb.m <> nil then
           begin
           	m := mb.m;
               m2 := Tmsg.create;
               while m <> nil do
               begin
                   if mb2.m = nil then
                   	mb2.m := m2
                   else if m2.next = nil then
                   begin
                   	m2.next := Tmsg.create;
                       m2 := m2.next;
                   end;
                   m2.p := allocmem(m.size);
                   CopyMemory(m2.p,m.p,m.size);
                   m2.id := m.id;
                   m2.size := m.size;
                   m2.desc := m.desc;
                   m2.pos := m.pos;
                   m2.next := nil;
                   m := m.next;
				end;
           end;
           frmBlocks.Listbox1.items.insertobject(j+1,clipboard.strings[i],mb2);
           inc(j);
           dec(k);
           if frmPasteSpecial.checkbox1.checked then
       		dec(i)
       	else
       		inc(i);
	    end;
		break;
   end;

	if Clipboardmode = 1 then
	begin
		// create copy of msg in m2
       m := Tmsg(Clipboard.objects[0]);
       m2 := Tmsg.create;
       m2.p := allocmem(m.size);
       CopyMemory(m2.p,m.p,m.size);
       m2.id := m.id;
       m2.size := m.size;
		m2.desc := m.desc;
       m2.pos := m.pos;
       m2.next := nil;

		mb := TMessageblock(frmBlocks.Listbox1.items.objects[targetblock]);
		m := mb.m;
       while m <> nil do
       begin
       	if ActiveMDIChild = frmBlocks then
           begin
           	if m.next = nil then
               	break;
           end else
           	if (ActiveMDICHild = frmMsgs) then
               	if m = Tmsg(frmMsgs.Listbox1.items.objects[frmMsgs.Listbox1.itemindex]) then
           	break;
			m := m.next;
       end;
		m2.next := m.next;
       m.next := m2;
       mb.blocksize := mb.blocksize + m2.size;
		frmBlocks.Listbox1Click(nil);
	end else
       begin
       	Showmessage('Cannot paste blocks into messages. Try clicking on the blocks listbox');
			exit;
       end;

  targetblock := targetblock + strtoint(frmPasteSpecial.edit2.text);
  dec(numblocks);
  end;
	modified := true;
end;

procedure TMainForm.N3D1Click(Sender: TObject);
begin
	N3D1.checked := true;
   Wireframe1.checked := false;
   Solid1.checked := false;
   Textured1.checked := false;
   frmView.SetView(0);
end;

procedure TMainForm.Wireframe1Click(Sender: TObject);
begin
	if mapname = '' then
   	exit;
	N3D1.checked := false;
   Wireframe1.checked := true;
   Solid1.checked := false;
   Textured1.checked := false;
   frmView.SetView(1);
end;

procedure TMainForm.Solid1Click(Sender: TObject);
begin
	if mapname = '' then
   	exit;
	N3D1.checked := false;
   Wireframe1.checked := false;
   Solid1.checked := true;
   Textured1.checked := false;
   frmView.SetView(2);
   frmView.DoFrame(Tmessageblock(frmBlocks.listbox1.items.objects[4]),true);
end;

procedure TMainForm.Textured1Click(Sender: TObject);
begin
	if mapname = '' then
   	exit;
	N3D1.checked := false;
   Wireframe1.checked := false;
   Solid1.checked := false;
   Textured1.checked := true;
   frmView.SetView(3);
end;

procedure TMainForm.Information1Click(Sender: TObject);
begin
	frmInfo.showmodal;
end;


procedure TMainForm.FileHist1FileSelected(FileName: string;
  var ReOrder: Boolean);
begin
	if modified then
   begin
		if MessageDlg('This file was modified. Save it?',mtcustom,[mbYes,mbNo],0) = mryes then
       begin
			FileSaveItemClick(nil);
       end;
   end;
	frmBlocks.ClearListbox;
   ReadDemo(Filename);
   modified := false;
   Caption := 'Film At 11 - ' + filename;
   Application.title := 'Film At 11 - ' + filename;
   Reorder := true;
end;

procedure TMainForm.Remove1Click(Sender: TObject);
var
	pr:Tmsg;
   m:Tmsg;
   n:tmsg;
   mb:Tmessageblock;
   i:integer;
   mask:shortint;
   p:pchar;
	k,len:integer;
   g:^shortint;
begin
	if frmRemove.showmodal = mrOk then
   begin
		Cursor := crHourglass;
		for i := 0 to frmBlocks.Listbox1.items.count -1 do
   	begin
         if frmBlocks.listbox1.selected[i] then
         begin
			mb := Tmessageblock(frmBlocks.listbox1.items.objects[i]);
			m := mb.m;
           p := nil;
			while(m <> nil) do
	    	begin
				n := m.next;
				if m.id = frmRemove.listbox1.itemindex then
               begin
					if p = nil then
                   	mb.m := m.next
                   else
                   	pr.next := m.next;
					mb.blocksize := mb.blocksize - m.size;
                   m.free;
                   modified := true;
				end else if m.id > $21 then begin
					mask := m.id and $7f;
					len := 1;
               	if ((mask and $1)<>0) then
               	begin
               		p := @mask;
                   	p[1] := m.p[len];
               		inc(len);
               	end;
               	if ((mask and $4000)<>0) then {entity}
					begin
						g := @m.p[len];
                   	k := g^;
               		len := len +2;
                   end
               	else
               	begin
						k := ord(m.p[len]);
               		len := len + 1;
					end;
					if k = frmRemove.Combobox1.itemindex then
                   begin
						if pr = nil then
                   		mb.m := m.next
                   	else
                   		pr.next := m.next;
                   	mb.blocksize := mb.blocksize - m.size;
                   	m.free;
                   	modified := true;
                   end else
               		pr := m;
               end else
               	pr := m;
       	    m := n;
       	end;
		  end;
   	end;
		Cursor := crDefault;
   end;
end;

function dotproduct(x1,y1,z1,x2,y2,z2:single):single;
begin
	Result := (x1*x2) + (y1*y2) + (z1*z2);
end;

function vlength(x,y,z:single):single;
begin
	Result := sqrt((abs(x) * abs(x)) + (abs(y) * abs(y)) + (abs(z) * abs(z)));
end;

procedure TMainForm.ReCamera1Click(Sender: TObject);
var
	pr:Tmsg;
   m:Tmsg;
   n:tmsg;
   mb:Tmessageblock;
   i:integer;
   firstblock:boolean;
   u:pinteger;
	camerapos,targetpos,ps:Tpos;
   ent,len:integer;
   mask:shortint;
	p:pchar;
	g:^smallint;
   x,y,z,a,yaw,pitch:single;
begin
	if frmCamera.showmodal = mrOk then
   begin
		firstblock := true;

		if frmCamera.checkbox1.checked then
       begin
       	camerapos := Tpos.create;
           targetpos := Tpos.create;
           ps := Tpos(frmEntities.listbox1.items.objects[frmCamera.combobox1.itemindex]);
           camerapos.x := ps.x;
           camerapos.y := ps.y;
           camerapos.z := ps.z;
           ps := Tpos(frmEntities.listbox1.items.objects[frmCamera.combobox2.itemindex]);
           targetpos.x := ps.x;
           targetpos.y := ps.y;
           targetpos.z := ps.z;

       end;
		for i := 0 to frmBlocks.Listbox1.items.count -1 do
   	begin
			mb := Tmessageblock(frmBlocks.listbox1.items.objects[i]);
			m := mb.m;
           p := nil;
           //find updateentity for the camera entity and remove it
			while(m <> nil) do
           begin
           	n := m.next;
				if frmCamera.checkbox1.checked then
               begin
					if m.id > $21 then //updateentity
                   begin
                   	if m.ent = frmCamera.ComboBox1.itemindex then
						begin
                       	camerapos.x := m.x;
                       	camerapos.y := m.y;
                       	camerapos.z := m.z;
                       end else if m.ent = frmCamera.Combobox2.itemindex then begin
                       	targetpos.x := m.x;
                       	targetpos.y := m.y;
                       	targetpos.z := m.z;
						end;
                   end;
               end;
               pr := m;
               m := n;
           end;
           //this should leave p as the last msg in the chain
         if frmBlocks.listbox1.selected[i] then
		  begin
			if firstblock then begin
               // insert setview msg
				m := Tmsg.create;
               m.id := 5;
               m.size := 3;
               m.p := allocmem(m.size);
               m.p[0] := chr(5);
				u := @m.p[1];
               u^ := frmCamera.Combobox1.itemindex;
				m.desc := 'setview '+ frmCamera.combobox1.text + ' (' + inttostr(u^) + ')';
               pr.next := m;
               m.next := nil;
               mb.blocksize := mb.blocksize + m.size;
				// insert new updateentity msg

				firstblock := false;
           end;
           if frmCamera.checkbox1.checked then
           begin
				x := targetpos.x - camerapos.x ;
				y := targetpos.y - camerapos.y ;
				z := targetpos.z  - camerapos.z ;
        		if (x = 0) and (y = 0) then
				begin
               	yaw := 0;
           		if z > 0 then
               		pitch := 90
               	else
               		pitch := 270;
               end else begin
					yaw := arctan2(y,x) * 180 / 3.14159265358979323846;
					if yaw < 0 then
                   	yaw := yaw + 360;
					a := sqrt (x*x + y*y);
                	pitch := arctan2(z,a ) * 180 / 3.14159265358979323846;
//                	if (pitch < 0) then
//                        pitch := pitch + 360;

				end;
               mb.angles[0] := 0-pitch;
               mb.angles[1] := yaw;
				mb.angles[2] := 0;
           end;
		  end;
   	end;
       ShowMessage('Done');
   end;
end;

procedure TMainForm.PopulateFileHistory;
var
	i,j:integer;
   m:Tmenuitem;
begin
	// remove previous filehistory menu items
	while MainMenu1.items[0].count > originalmenuitems do
   	MainMenu1.items[0].delete(MainMenu1.items[0].count-1);

   if FileHistory.count > 0 then
   begin
  		m := Tmenuitem.create(Owner);
  		m.caption := '-';
  		MainMenu1.items[0].add(m);
       for j := 0 to FileHistory.count-1 do
       begin
  			m := Tmenuitem.create(Owner);
  			m.caption := '&' + inttostr(j) + ' ' + FileHistory[j];
			m.OnClick := FileHistoryClick;
  			MainMenu1.items[0].add(m);
       end;
   end;
end;

procedure TMainForm.AddToFileHistory(s:string);
var
	i,j:integer;
   m:Tmenuitem;
label start;
begin
start:
	for i := 0 to FileHistory.count -1 do
   	if FileHistory[i] = s then
       begin
       	FileHistory.delete(i);
           goto start;
       end;

	FileHistory.insert(0,s);
	while FileHistory.count > 10 do
   	FileHistory.delete(FileHistory.count-1);
   PopulateFileHistory;
end;

procedure TMainForm.FileHistoryClick(Sender:Tobject);
var
	f1,f2:string;
   i:integer;
begin
	if modified then
   begin
		if MessageDlg('This file was modified. Save it?',mtcustom,[mbYes,mbNo],0) = mryes then
       begin
			FileSaveItemClick(Sender);
       end;
   end;

		frmBlocks.ClearListbox;
		f1 := copy(TMenuitem(Sender).caption,pos(' ',TMenuitem(Sender).caption)+1,300);
		ReadDemo(f1);
		AddToFileHistory(f1);
       modified := false;
       Caption := 'Film At 11 - ' + f1;
       Application.title := 'Film At 11 - ' + f1;
		for i := length(f1) downto 1 do
       	if f1[i] = '\' then
           	break;
		f2 := copy(f1,1,i-1);
       opendialog1.initialdir := f2;
end;

procedure TMainForm.ChangeMo(style:integer);
var
	i:integer;
   m:Tmsg;
   mb:Tmessageblock;
	p:Tmsg;
   junk:string;
   mode:integer;
   a:single;
begin
	mode := 0;
	for i := 0 to frmBlocks.Listbox1.items.count -1 do
   begin
   	mb := Tmessageblock(frmBlocks.listbox1.items.objects[i]);
       m := mb.m;
       p := nil;
       if mode = 0 then
       begin
			if frmBlocks.ListBox1.selected[i] then
           begin
           	mode := 1;
				//sample the time rate
               a := (Tmessageblock(frmBlocks.listbox1.items.objects[i+frmBlocks.listbox1.selcount]).time - Tmessageblock(frmBlocks.listbox1.items.objects[i]).time) / frmBlocks.listbox1.selcount;
				if style = 0 then
					junk := 'host_framerate ' + floattostr(a / 2) + #10#0
				else
					junk := 'host_framerate ' + floattostr(a * 2) + #10#0;
				m := Tmsg.create;
               m.id := 9;
               m.size := 1+length(junk);
               m.p := allocmem(m.size);
               m.p[0] := #9;
               strcopy(@m.p[1],@junk[1]);
				m.desc := 'stufftext ' + junk;
               InsertMsg(mb,m);
			end;
       end
       else
       begin
			if ((i+1) > (frmBlocks.listbox1.items.count-1)) or (not frmBlocks.ListBox1.selected[i+1]) then
           begin
               junk := 'host_framerate 0' +#10+#0;
				m := Tmsg.create;
               m.id := 9;
               m.size := 19;
               m.p := allocmem(m.size);
               m.p[0] := #9;
				strcopy(@m.p[1],@junk[1]);
				m.desc := 'stufftext ' + junk;
               InsertMsg(mb,m);
               break;
			end;
       end;
   end;
end;

// insert a msg at the end of a messageblock
procedure TMainForm.InsertMsg(mb:Tmessageblock;m:Tmsg);
var
	n,p:Tmsg;
begin
	p := nil;
	n := mb.m;
   while n <> nil do
   begin
   	p := n;
       n := n.next;
   end;
	if p = nil then
   	mb.m := m
   else
		p.next := m;
	mb.blocksize := mb.blocksize + m.size;

end;

procedure TMainForm.SlowMo1Click(Sender: TObject);
begin
	if frmBlocks.ListBox1.SelCount < 2 then
   begin
   	Showmessage('You must select a group of blocks to change');
       exit;
   end;
   ChangeMo(0);
end;

procedure TMainForm.FastMo1Click(Sender: TObject);
begin
	if frmBlocks.ListBox1.SelCount < 2 then
   begin
   	Showmessage('You must select a group of blocks to change');
       exit;
   end;
   ChangeMo(1);
end;

procedure TMainForm.FixTime1Click(Sender: TObject);
var
   line:string;
   i,j,b,z,s:integer;
   q:pchar;
	mb:Tmessageblock;
   m:Tmsg;
   mp:Tmsg;
   TicksPerSecond:integer;
   fname1,fname2:string;
   x:Psingle;
   realtimeperblock,adjtimeperblock,prevtime,timebase:single;
   doit:boolean;
begin
		if frmTimeBase.showmodal = mrCancel then
   		exit;

		if frmTimebase.radiobutton1.checked then
   		adjtimeperblock := 0.1;
		if frmTimebase.radiobutton2.checked then
   		adjtimeperblock := 0.05;
		if frmTimebase.radiobutton3.checked then
   		adjtimeperblock := strtofloat(frmTimebase.edit1.text);

	realtimeperblock := adjtimeperblock;

	frmProgress.Progressbar1.min := 0;
	frmProgress.Progressbar1.position := 0;
	frmProgress.Show;

	prevtime := 0;
   timebase := 0;
	for i := 0 to frmBlocks.Listbox1.items.count -1 do
   begin
   	doit := false;
		if (frmBlocks.Listbox1.selcount > 1) then
       begin
       	if frmBlocks.Listbox1.selected[i] then
           	doit := true;
       end;
		mb := Tmessageblock(frmBlocks.Listbox1.items.objects[i]);
		q := @mb.blocksize;
		m := mb.m;
       if (i mod 50) = 0 then
       begin
			frmProgress.Progressbar1.max := frmBlocks.Listbox1.items.count;
	       	frmProgress.Progressbar1.position := i;
			frmProgress.label1.caption := 'Fixing ' + inttostr(i) +' of '+inttostr(frmBlocks.Listbox1.items.count);
			frmProgress.refresh;
       end;
		while (m <> nil) do
       begin
			if m.id = $7 then
           begin
           	// fixup time
               x := @m.p[1];
				if prevtime = 0 then
               	prevtime := x^;
				case frmTimeBase.Radiogroup1.itemindex of
               0:
                 begin
               	x^ := timebase;
                   timebase := timebase + adjtimeperblock;
				  end;
               1:
                 begin
                 	adjtimeperblock := abs(x^ - prevtime);
                   prevtime := x^;
               	x^ := timebase + adjtimeperblock;
                   timebase := timebase + adjtimeperblock;
				  end;
				2:
				  begin
                 	adjtimeperblock := x^ - prevtime;
                   timebase := prevtime;
                   prevtime := x^;
					if doit then
                   begin
               		x^ := timebase + realtimeperblock;
						prevtime := x^;
               	end else
               		x^ := timebase + adjtimeperblock;
                 end;
  				end;
           	m.desc := 'time ' + floattostr(x^);
           end;
           m := m.next;
       end;
   end;

	frmProgress.hide;
   showmessage('Successfully fixed time!');
   modified := true;
end;

procedure TMainForm.DoFade(style:integer);
var
	i:integer;
   m:Tmsg;
   mb:Tmessageblock;
	p:Tmsg;
   junk:string;
   mode:integer;
   a:single;
   z,v:integer;
   colorstring:string;
begin
	mode := 0;
	if frmFade.RadioGroup2.itemindex = 0 then
   	colorstring := '0 0 0 '
   else
   	colorstring := '255 255 255 ';
	z := 255 div (frmBlocks.listbox1.selcount-1);
			if style = 0 then
           	v := 255
           else
           	v := z;
	for i := 0 to frmBlocks.Listbox1.items.count -1 do
   begin
		mb := Tmessageblock(frmBlocks.listbox1.items.objects[i]);
       m := mb.m;
       p := nil;
       if mode = 0 then
       begin
			if frmBlocks.ListBox1.selected[i] then
           begin
           	mode := 1;
           	junk := 'v_cshift ' + colorstring +inttostr(v) +#10+#0;
           	m := Tmsg.create;
           	m.id := 9;
           	m.size := length(junk)+1;
           	m.p := allocmem(m.size);
           	m.p[0] := #9;
           	strcopy(@m.p[1],@junk[1]);
				m.desc := 'stufftext ' + junk;
               InsertMsg(mb,m);
			if style = 0 then
           	v := v - z
           else
           	v := v + z;
			end;
       end
       else
		begin
			if not frmBlocks.ListBox1.selected[i] then
           begin
				break;
           end;
           	junk := 'v_cshift ' + colorstring +inttostr(v) +#10+#0;
           	m := Tmsg.create;
           	m.id := 9;
           	m.size := length(junk)+1;
           	m.p := allocmem(m.size);
           	m.p[0] := #9;
           	strcopy(@m.p[1],@junk[1]);
				m.desc := 'stufftext ' + junk;
               InsertMsg(mb,m);
			if style = 0 then
           	v := v - z
           else
           	v := v + z;
       end;
   end;
end;

procedure TMainForm.FadeIn1Click(Sender: TObject);
begin
		if frmBlocks.ListBox1.SelCount < 2 then
   	begin
   		Showmessage('You must select a group of blocks to change');
       	exit;
   	end;
	if frmFade.showmodal = mrOk then
   begin
   	DoFade(frmFade.RadioGroup1.itemindex);
   end;

end;

procedure TMainForm.test1Click(Sender: TObject);
begin
	form1.show;
end;

procedure TMainForm.SpeedButton4Click(Sender: TObject);
var
	i:integer;
begin
	for i := 0 to 15000 do
		frmBlocks.ListBox1.items.add('1');
	Showmessage('done');
end;

end.
