/*---------------------------------------------------------\
|                                                          |
| camera.c                                                 |
|                                                          |
| by Joel Beaudoin                                         |
|                                                          |
|----------------------------------------------------------|
|                                                          |
| This module contains routines that manipulate the        |
| position and orientation of the 'camera'. These routines |
| simply modify the OpenGL modelview matrix to achieve the |
| desired effect.                                          |
|                                                          |
\---------------------------------------------------------*/


#include <windows.h>
#include <gl\gl.h>
#include <gl\glu.h>

void moveCamera(float dx, float dy, float dz)
{
	GLfloat m[4][4];

	glGetFloatv(GL_MODELVIEW_MATRIX, (GLfloat*)m);
	glLoadIdentity();
	glTranslatef(-dx, -dy, -dz);
	glMultMatrixf((GLfloat*)m);
}

/*-----------------------------------------------------------------*/

void turnCamera(float angle)
{
	GLfloat m[4][4];

	glGetFloatv(GL_MODELVIEW_MATRIX, (GLfloat*)m);
	glLoadIdentity();
	glRotatef(-angle, 0.0f, 1.0f, 0.0f);
	glMultMatrixf((GLfloat*)m);
}

/*-----------------------------------------------------------------*/

void tiltCamera(float angle)
{
	GLfloat m[4][4];

	glGetFloatv(GL_MODELVIEW_MATRIX, (GLfloat*)m);
	glLoadIdentity();
	glRotatef(-angle, 1.0f, 0.0f, 0.0f);
	glMultMatrixf((GLfloat*)m);
}

/*-----------------------------------------------------------------*/

void rollCamera(float angle)
{
	GLfloat m[4][4];

	glGetFloatv(GL_MODELVIEW_MATRIX, (GLfloat*)m);
	glLoadIdentity();
	glRotatef(-angle, 0.0f, 0.0f, 1.0f);
	glMultMatrixf((GLfloat*)m);
}
