//
// BspFile.h
//

#include <stdio.h>

#define	MAX_MAP_HULLS		4

#define	MAX_MAP_MODELS		256
#define	MAX_MAP_BRUSHES		4096
#define	MAX_MAP_ENTITIES	1024
#define	MAX_MAP_ENTSTRING	65536

#define	MAX_MAP_PLANES		8192
#define	MAX_MAP_NODES		32767		// because negative shorts are contents
#define	MAX_MAP_CLIPNODES	32767		//
#define	MAX_MAP_LEAFS		32767		// 
#define	MAX_MAP_VERTS		65535
#define	MAX_MAP_FACES		65535
#define	MAX_MAP_MARKSURFACES 65535
#define	MAX_MAP_TEXINFO		4096
#define	MAX_MAP_EDGES		256000
#define	MAX_MAP_SURFEDGES	512000
#define	MAX_MAP_MIPTEX		0x200000
#define	MAX_MAP_LIGHTING	0x100000
#define	MAX_MAP_VISIBILITY	0x100000

// key / value pair sizes

#define	MAX_KEY		32
#define	MAX_VALUE	1024
		
#include "BspFileStructs.h"

extern	STATUS openBSP(char* filename);
extern	STATUS closeBSP(void);
extern	STATUS getDirectory(BSPDIRECTORY* pDirectory);
		
extern	STATUS getModel(BSPMODEL* pModel, short idxModel);
		
//
// FACE METHODS
//
extern STATUS getFace(BSPFACE* pFace, unsigned short idxFace);
extern	unsigned short getNumFaces(void);
extern	STATUS getFaceArray(BSPFACE* faceArray);
		
//
// EDGE METHODS
//
extern	STATUS getEdge(BSPEDGE* pEdge, long idxEdge);
extern	long getNumEdges(void);
extern	STATUS getEdgeArray(BSPEDGE* edgeArray);
		
//
// FACE INDEX METHODS
//
extern	STATUS getFaceIndex(unsigned short* pidxFace, unsigned short idxFaceIndex);
		
//
// EDGE INDEX METHODS
//
extern	STATUS getEdgeIndex(long* pidxEdge, long idxEdgeIndex);
extern	long getNumEdgeIndices(void);
extern	STATUS getEdgeIndicesArray(long* edgeIndicesArray);
		
//
// VERTEX METHODS
//
extern	STATUS getVertex(BSPVERTEX* pVertex, unsigned short idxVertex);
extern	unsigned short getNumVertices(void);
extern	STATUS getVerticesArray(BSPVERTEX* verticesArray);

//
// ENTITY METHODS
//
extern	STATUS getPlayerStartCoords(BSPVERTEX* pCoords);		

//
// MIPTEX METHODS
//
extern long getSizeOfMiptexLump(void);
extern STATUS getMiptexLump(BSPMIPTEXLUMP* pHeader);

/*
 * TEXINFO METHODS
 */
extern STATUS getTexinfo(BSPTEXINFO* pTexinfo, short idxTexinfo);
extern short getNumTexinfos(void);
extern STATUS getTexinfoArray(BSPTEXINFO* texinfoArray);

//
// NODE METHODS
//
extern  long getNumNodes(void);
extern  STATUS getNodeArray(BSPNODE* NodeArray);

//
// LEAF METHODS
//
extern  long getNumLeaves(void);
extern  STATUS getLeavesArray(BSPLEAF* LeavesArray);

//
// ENTITY METHODS
//
//extern  long getNumEntities(void);
//extern  STATUS getEntitiesArray(BSPENTITY* entityArray);

//
// MODEL METHODS
//
extern  long getNumModels(void);
extern  STATUS getModelsArray(BSPMODEL* ModelArray);

//
// MODEL METHODS
//
extern  long getNumPlanes(void);
extern  STATUS getPlanesArray(BSPPLANE* planeArray);

extern vec3_t viewp;

//
// MODEL METHODS
//
extern  long getVisiListSize(void);
extern  STATUS getVisiList(u_char* visiArray);
