//
// BspFile.c
//


//#define BSPFILETEST		// include this definition for testing this module

#include <windows.h>
#include <gl\gl.h>
#include <gl\glu.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "BspFile.h"

FILE* bspFile = NULL;
static long startFP = 0;
static BSPDIRECTORY dir;
static char entityString[MAX_ENTITY_STR+1];


STATUS openBSP(char* filename)
{
	STATUS result;

	
//	if(bspFile != NULL)					
//		return FAILURE;

//	bspFile = fopen(filename, "rb");
	
	if(bspFile != NULL)
	{
		result = getDirectory(&dir);
		if(result == SUCCESS)
			return SUCCESS;
		else
			return FAILURE;
	}
	else
		return FAILURE;
}

STATUS closeBSP(void)
{
	if(bspFile != NULL)
	{
		if(fclose(bspFile) == 0) {
			bspFile = NULL;
			return SUCCESS;
		} else
			return FAILURE;
	}
	else
		return FAILURE;
}

STATUS getDirectory(BSPDIRECTORY* pDirectory)
{
	size_t count = 0;

	// if a bsp file has been opened
	if(bspFile != NULL)
	{
		// save the old file pointer
		startFP = ftell(bspFile);
		// move the file pointer to the beginning of the file
		//fseek(bspFile, 0, SEEK_SET);
		// read the directory into the callers structure
		fseek(bspFile, startFP, SEEK_SET);
		count = fread(pDirectory, sizeof(BSPDIRECTORY), 1, bspFile);
		// if the full directory was read
		if(count == 1)
		{
			// and return success
			return SUCCESS;
		}
		// else return failure
		else
			return FAILURE;
	}
	// else return failure
	else
		return FAILURE;

}

STATUS getModel(BSPMODEL* pModel, short idxModel)
{
	size_t count = 0;

	// if a bsp file has been opened
	if(bspFile != NULL)
	{
		// move the file pointer to the beginning of the model array
		fseek(bspFile, startFP + dir.models.offset + idxModel * sizeof(BSPMODEL), SEEK_SET);
		// read the model into the callers structure
		count = fread(pModel, sizeof(BSPMODEL), 1, bspFile);
		// if the full model was read
		if(count == 1)
		{
			// and return success
			return SUCCESS;
		}
		// else return failure
		else
			return FAILURE;
	}
	// else return failure
	else
		return FAILURE;
}

STATUS getFace(BSPFACE* pFace, unsigned short idxFace)
{
	size_t count = 0;

	// if a bsp file has been opened
	if(bspFile != NULL)
	{
		// move the file pointer to the face
		fseek(bspFile, startFP + dir.faces.offset + idxFace * sizeof(BSPFACE), SEEK_SET);
		// read the face into the callers structure
		count = fread(pFace, sizeof(BSPFACE), 1, bspFile);
		// if the full face was read
		if(count == 1)
		{
			// and return success
			return SUCCESS;
		}
		// else return failure
		else
			return FAILURE;
	}
	// else return failure
	else
		return FAILURE;
}

unsigned short getNumFaces(void)
{
	return dir.faces.size / sizeof(BSPFACE);
}

STATUS getFaceArray(BSPFACE* faceArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       faceArray paramater.
	/////////////////////////////////////////////////////
	
	long count;
	unsigned short numFaces;

	// get the number of faces in the bsp file
	numFaces = getNumFaces();

	// set the file pointer to the beginning of the face array
	fseek(bspFile, startFP + dir.faces.offset, SEEK_SET);

	// read the faces into the callers array
	count = fread(faceArray, sizeof(BSPFACE), numFaces, bspFile);

	// verify that all the faces were read
	if(count != numFaces)
		return FAILURE;

	return SUCCESS;
}

STATUS getEdge(BSPEDGE* pEdge, long idxEdge)
{
	size_t count = 0;

	// if a bsp file has been opened
	if(bspFile != NULL)
	{
		// move the file pointer to the edge
		fseek(bspFile, startFP + dir.edges.offset + idxEdge * sizeof(BSPEDGE), SEEK_SET);
		// read the edge into the callers structure
		count = fread(pEdge, sizeof(BSPEDGE), 1, bspFile);
		// if the full edge was read
		if(count == 1)
		{
			// and return success
			return SUCCESS;
		}
		// else return failure
		else
			return FAILURE;
	}
	// else return failure
	else
		return FAILURE;
}

long getNumEdges(void)
{
	return dir.edges.size / sizeof(BSPEDGE);
}

long getNumNodes(void)
{
	return dir.nodes.size / sizeof(BSPNODE);
}
long getNumLeaves(void)
{
	return dir.leaves.size / sizeof(BSPLEAF);
}
long getNumPlanes(void)
{
	return dir.planes.size / sizeof(BSPPLANE);
}
long getVisiListSize(void)
{
	return dir.visilist.size;
}
/*
long getNumEntities(void)
{
	return dir.entities.size / sizeof(BSPENTITY);
}
*/
long getNumModels(void)
{
	return dir.models.size / sizeof(BSPMODEL);
}

STATUS getVisiList(u_char* visiArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       edgeArray paramater.
	/////////////////////////////////////////////////////

	long count;

	// set the file pointer to the beginning of the edge array
	fseek(bspFile, startFP + dir.visilist.offset, SEEK_SET);

	// read the edges into the callers array
	count = fread(visiArray, 1, dir.visilist.size, bspFile);

	// verify that all the edges were read
	if(count != dir.visilist.size)
		return FAILURE;

	return SUCCESS;
}


STATUS getEdgeArray(BSPEDGE* edgeArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       edgeArray paramater.
	/////////////////////////////////////////////////////

	long count;
	long numEdges;

	// get the number of edges in the bsp file
	numEdges = getNumEdges();

	// set the file pointer to the beginning of the edge array
	fseek(bspFile, startFP + dir.edges.offset, SEEK_SET);

	// read the edges into the callers array
	count = fread(edgeArray, sizeof(BSPEDGE), numEdges, bspFile);

	// verify that all the edges were read
	if(count != numEdges)
		return FAILURE;

	return SUCCESS;
}

STATUS getNodeArray(BSPNODE* nodeArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       nodeArray paramater.
	/////////////////////////////////////////////////////

	long count;
	long numNodes;

	// get the number of edges in the bsp file
	numNodes = getNumNodes();

	// set the file pointer to the beginning of the edge array
	fseek(bspFile, startFP + dir.nodes.offset, SEEK_SET);

	// read the edges into the callers array
	count = fread(nodeArray, sizeof(BSPNODE), numNodes, bspFile);

	// verify that all the edges were read
	if(count != numNodes)
		return FAILURE;

	return SUCCESS;
}

STATUS getLeavesArray(BSPLEAF* leavesArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       nodeArray paramater.
	/////////////////////////////////////////////////////

	long count;
	long numLeaves;

	// get the number of edges in the bsp file
	numLeaves = getNumLeaves();

	// set the file pointer to the beginning of the edge array
	fseek(bspFile, startFP + dir.leaves.offset, SEEK_SET);

	// read the edges into the callers array
	count = fread(leavesArray, sizeof(BSPLEAF), numLeaves, bspFile);

	// verify that all the edges were read
	if(count != numLeaves)
		return FAILURE;

	return SUCCESS;
}

STATUS getFaceIndex(unsigned short* pidxFace, unsigned short idxFaceIndex)
{
	size_t count = 0;

	// if a bsp file has been opened
	if(bspFile != NULL)
	{
		// move the file pointer to the face index
		fseek(bspFile, startFP + dir.lfaces.offset + idxFaceIndex * sizeof(short), SEEK_SET);
		// read the face index into the callers structure
		count = fread(pidxFace, sizeof(short), 1, bspFile);
		// if the full edge was read
		if(count == 1)
		{
			// and return success
			return SUCCESS;
		}
		// else return failure
		else
			return FAILURE;
	}
	// else return failure
	else
		return FAILURE;
}

STATUS getEdgeIndex(long* pidxEdge, long idxEdgeIndex)
{
	size_t count = 0;

	// if a bsp file has been opened
	if(bspFile != NULL)
	{
		// move the file pointer to the edge index
		fseek(bspFile, startFP + dir.ledges.offset + idxEdgeIndex * sizeof(long), SEEK_SET);
		// read the edge index into the callers structure
		count = fread(pidxEdge, sizeof(long), 1, bspFile);
		// if the full edge was read
		if(count == 1)
		{
			// and return success
			return SUCCESS;
		}
		// else return failure
		else
			return FAILURE;
	}
	// else return failure
	else
		return FAILURE;
}

long getNumEdgeIndices(void)
{
	return dir.ledges.size / sizeof(long);
}

STATUS getEdgeIndicesArray(long* edgeIndicesArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       edgeIndicesArray paramater.
	/////////////////////////////////////////////////////

	long count;
	long numEdgeIndices;

	// get the number of edge indices in the bsp file
	numEdgeIndices = getNumEdgeIndices();

	// set the file pointer to the beginning of the edge indices array
	fseek(bspFile, startFP + dir.ledges.offset, SEEK_SET);

	// read the edge indices into the callers array
	count = fread(edgeIndicesArray, sizeof(long), numEdgeIndices, bspFile);

	// verify that all the edge indices were read
	if(count != numEdgeIndices)
		return FAILURE;

	return SUCCESS;
}

STATUS getVertex(BSPVERTEX* pVertex, unsigned short idxVertex)
{
	size_t count = 0;

	// if a bsp file has been opened
	if(bspFile != NULL)
	{
		// move the file pointer to the vertex
		fseek(bspFile, startFP + dir.vertices.offset + idxVertex * sizeof(BSPVERTEX), SEEK_SET);
		// read the vertex into the callers structure
		count = fread(pVertex, sizeof(BSPVERTEX), 1, bspFile);
		// if the full vertex was read
		if(count == 1)
		{
			// and return success
			return SUCCESS;
		}
		// else return failure
		else
			return FAILURE;
	}
	// else return failure
	else
		return FAILURE;	
}

unsigned short getNumVertices(void)
{
	return dir.vertices.size / sizeof(BSPVERTEX);
}

STATUS getVerticesArray(BSPVERTEX* verticesArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       verticesArray paramater.
	/////////////////////////////////////////////////////

	long count;
	unsigned short numVertices;

	// get the number of vertices in the bsp file
	numVertices = getNumVertices();

	// set the file pointer to the beginning of the vertices array
	fseek(bspFile, startFP + dir.vertices.offset, SEEK_SET);

	// read the vertices into the callers array
	count = fread(verticesArray, sizeof(BSPVERTEX), numVertices, bspFile);

	// verify that all the vertices were read
	if(count != numVertices)
		return FAILURE;

	return SUCCESS;
}

STATUS getPlayerStartCoords(BSPVERTEX* pCoords)
{
	
	char* p;
	size_t count = 0;
	int x, y, z;

	if(bspFile != NULL)
	{
		// move the file pointer to the start of the entity lump
		fseek(bspFile, startFP + dir.entities.offset, SEEK_SET);
		// read the entire entity string into the array
		count = fread(entityString, sizeof(char), dir.entities.size, bspFile);
		if(count != (unsigned int)dir.entities.size)
			return FAILURE;
		// add the null character at the end of the array
		entityString[MAX_ENTITY_STR] = '\0';
		// find the coords
		p = strstr(entityString, "info_player_start");
		p = strstr(p, "origin");
		p = strstr(p, "\"");
		p = strstr(p, "\"");
		p++;
		sscanf(p, "%d %d %d", &x, &y, &z);
		pCoords->x = (float)x; pCoords->y = (float)y; pCoords->z = (float)z;
		return SUCCESS;
	}
	else
		return FAILURE;
}

/*STATUS getMiptexLumpHeader(BSPMIPTEXLUMPHEADER* pHeader)
{

}*/

STATUS getTexinfo(BSPTEXINFO* pTexinfo, short idxTexinfo)
{
	size_t count = 0;

	// if a bsp file has been opened
	if(bspFile != NULL)
	{
		// move the file pointer to the texinfo
		fseek(bspFile, startFP + dir.texinfo.offset + idxTexinfo * sizeof(BSPTEXINFO), SEEK_SET);
		// read the vertex into the callers structure
		count = fread(pTexinfo, sizeof(BSPTEXINFO), 1, bspFile);
		// if the full vertex was read
		if(count == 1)
		{
			// and return success
			return SUCCESS;
		}
		// else return failure
		else
			return FAILURE;
	}
	// else return failure
	else
		return FAILURE;		
}

short getNumTexinfos(void)
{
	return dir.texinfo.size / sizeof(BSPTEXINFO);
}

STATUS getTexinfoArray(BSPTEXINFO* texinfoArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       texinfoArray paramater.
	/////////////////////////////////////////////////////

	long count;
	short numTexinfos;

	// get the number of texinfos in the bsp file
	numTexinfos = getNumTexinfos();

	// set the file pointer to the beginning of the texinfo array
	fseek(bspFile, startFP + dir.texinfo.offset, SEEK_SET);

	// read the texinfos into the callers array
	count = fread(texinfoArray, sizeof(BSPTEXINFO), numTexinfos, bspFile);

	// verify that all the vertices were read
	if(count != numTexinfos)
		return FAILURE;

	return SUCCESS;
}

long getSizeOfMiptexLump(void)
{
	return dir.miptex.size;
}

STATUS getMiptexLump(BSPMIPTEXLUMP* pMiptexLump)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       miptexLump paramater.
	/////////////////////////////////////////////////////

	long count;
	long sizeOfMiptexLump;

	// get the size of the miptex lump
	sizeOfMiptexLump = getSizeOfMiptexLump();

	// set the file pointer to the beginning of the miptex lump
	fseek(bspFile, startFP + dir.miptex.offset, SEEK_SET);

	// read the miptex lump into the callers array
	count = fread(pMiptexLump, sizeOfMiptexLump, 1, bspFile);

	// verify that the lump was read
	if(count != 1)
		return FAILURE;

	return SUCCESS;
}

/*
STATUS getEntitiesArray(BSPENTITY* entityArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       EntityArray paramater.
	/////////////////////////////////////////////////////

	long count;
	long numEntities;

	// get the number of edges in the bsp file
	numEntities = getNumEntities();

	// set the file pointer to the beginning of the edge array
	fseek(bspFile, startFP + dir.entities.offset, SEEK_SET);

	// read the edges into the callers array
	count = fread(entityArray, sizeof(BSPENTITY), numEntities, bspFile);

	// verify that all the edges were read
	if(count != numEntities)
		return FAILURE;

	return SUCCESS;
}
*/

STATUS getModelsArray(BSPMODEL* ModelArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       EntityArray paramater.
	/////////////////////////////////////////////////////

	long count;
	long numModels;

	// get the number of edges in the bsp file
	numModels = getNumModels();

	// set the file pointer to the beginning of the edge array
	count = fseek(bspFile, startFP + dir.models.offset, SEEK_SET);

	// read the edges into the callers array
	count = fread(ModelArray, sizeof(BSPMODEL), numModels, bspFile);

	// verify that all the edges were read
	if(count != numModels)
		return FAILURE;

	return SUCCESS;
}

STATUS getPlanesArray(BSPPLANE* planeArray)
{
	/////////////////////////////////////////////////////
	// NOTE: This function assumes that a suitable amount
	//       of memory has been allocated for the
	//       edgeArray paramater.
	/////////////////////////////////////////////////////

	long count;
	long numPlanes;

	// get the number of edges in the bsp file
	numPlanes = getNumPlanes();

	// set the file pointer to the beginning of the edge array
	fseek(bspFile, startFP + dir.planes.offset, SEEK_SET);

	// read the edges into the callers array
	count = fread(planeArray, sizeof(BSPPLANE), numPlanes, bspFile);

	// verify that all the edges were read
	if(count != numPlanes)
		return FAILURE;

	return SUCCESS;
}
