#include <stdio.h>
#include "g_local.h"

unsigned char get_next_unsigned_char(block_t* block)
{
	unsigned char a;
	
	a = *(unsigned char *)(block->p);
	block->p += 1;
	return a;
}

char get_next_signed_char(block_t *block)
{
	char a;

	a = *(char *)(block->p);
	block->p += 1;
	return a;
}

short get_next_short(block_t *block)
{
	long a;

	a =	(((unsigned char*)(block->p))[0]) + 
		((((signed char*)(block->p))[1])<<8);
	block->p += 2;
	return a;
}

long get_next_long(block_t *block)
{
	long a;

	a =	(((unsigned char*)(block->p))[0])+ 
		((((unsigned char*)(block->p))[1])<<8 ) + 
		((((unsigned char*)(block->p))[2])<<16) + 
		((((signed char*)(block->p))[3])<<24);
	block->p += 4;
	return a;
}

float get_next_float(block_t *block)
{
	/* endian-save float read, it works only with 32 bit long and 32 bit float */
	union {long l; float f;} a;
	a.l =	(((unsigned char*)(block->p))[0])+
			((((unsigned char*)(block->p))[1])<<8 ) +
			((((unsigned char*)(block->p))[2])<<16) +
			((((unsigned char*)(block->p))[3])<<24);
	block->p += 4;
	return a.f;
}

char *get_next_string(block_t *block, char *buffer)
{
	long i;
	char *b;
	
	for (i=0,b=buffer;i<0x7FF && *(block->p) ;i++,block->p++)
		*b++ = *(block->p);
	*b = '\0';
	block->p++;
	return buffer;
}


long ReadByte(block_t *block)
{
	return (long) get_next_unsigned_char(block);
}

long ReadChar(block_t *block)
{
	return (long) get_next_signed_char(block);
}

long ReadShort(block_t *block)
{
	return (long) get_next_short(block);
}

long ReadLong(block_t *block)
{
	return get_next_long(block);
}

long ReadLongBE(block_t *block)
{
	return	(ReadByte(block)<<24)+
			(ReadByte(block)<<16)+
			(ReadByte(block)<< 8)+
			(ReadByte(block));
}

float ReadFloat(block_t *block)
{
	return get_next_float(block);
}

float ReadAngle(block_t *block)
{
	return (float) ReadChar(block) / 256.0 * 360.0;
}

float ReadCoord(block_t *block)
{
	return (float) ReadShort(block) * 0.125;
}

char* ReadString(block_t *block, char* buffer)
{
	return get_next_string(block, buffer); 
}

long ReadEntity(block_t *block)
{
	return ReadShort(block);
}

float ReadAngle16(block_t *block)
{
	return (float) ReadShort(block) / 65536.0 * 360.0;
}

void ReadPosition(block_t *block, vec3_t a)
{
	int i;

	for (i = 0; i < 3; i++)
		a[i] = ReadCoord(block);
//	return a;
}

float ReadBlend(block_t *block)
{
	return ReadByte(block) / 255.0;
}

float* ReadBlendVec(block_t *block, float* a)
{
	int i;
	
	for (i = 0; i < 4; i++)
		a[i] = ReadBlend(block);
	return a;
}

float ReadOffset(block_t *block)
{
	return ReadChar(block) / 4.0;
}

float* ReadOffsetVec(block_t *block, float* a)
{
	int i;
	
	for ( i=0 ; i<3 ; i++ )
		a[i] = ReadOffset(block);
	return a;
}

#define DM2_NUMVERTEXNORMALS 162
vec3_t avertexnormals[DM2_NUMVERTEXNORMALS] =
{
	{-0.525731027, 0, 0.850651026},
	{-0.442862988, 0.238856003, 0.864188015},
	{-0.295242012, 0, 0.955422997},
	{-0.309017003, 0.5, 0.809017003},
	{-0.162459999, 0.26286599, 0.951056004},
	{0, 0, 1},
	{0, 0.850651026, 0.525731027},
	{-0.147621006, 0.71656698, 0.681717992},
	{0.147621006, 0.71656698, 0.681717992},
	{0, 0.525731027, 0.850651026},
	{0.309017003, 0.5, 0.809017003},
	{0.525731027, 0, 0.850651026},
	{0.295242012, 0, 0.955422997},
	{0.442862988, 0.238856003, 0.864188015},
	{0.162459999, 0.26286599, 0.951056004},
	{-0.681717992, 0.147621006, 0.71656698},
	{-0.809017003, 0.309017003, 0.5},
	{-0.587785006, 0.425325006, 0.688190997},
	{-0.850651026, 0.525731027, 0},
	{-0.864188015, 0.442862988, 0.238856003},
	{-0.71656698, 0.681717992, 0.147621006},
	{-0.688190997, 0.587785006, 0.425325006},
	{-0.5, 0.809017003, 0.309017003},
	{-0.238856003, 0.864188015, 0.442862988},
	{-0.425325006, 0.688190997, 0.587785006},
	{-0.71656698, 0.681717992, -0.147621006},
	{-0.5, 0.809017003, -0.309017003},
	{-0.525731027, 0.850651026, 0},
	{0, 0.850651026, -0.525731027},
	{-0.238856003, 0.864188015, -0.442862988},
	{0, 0.955422997, -0.295242012},
	{-0.26286599, 0.951056004, -0.162459999},
	{0, 1, 0},
	{0, 0.955422997, 0.295242012},
	{-0.26286599, 0.951056004, 0.162459999},
	{0.238856003, 0.864188015, 0.442862988},
	{0.26286599, 0.951056004, 0.162459999},
	{0.5, 0.809017003, 0.309017003},
	{0.238856003, 0.864188015, -0.442862988},
	{0.26286599, 0.951056004, -0.162459999},
	{0.5, 0.809017003, -0.309017003},
	{0.850651026, 0.525731027, 0},
	{0.71656698, 0.681717992, 0.147621006},
	{0.71656698, 0.681717992, -0.147621006},
	{0.525731027, 0.850651026, 0},
	{0.425325006, 0.688190997, 0.587785006},
	{0.864188015, 0.442862988, 0.238856003},
	{0.688190997, 0.587785006, 0.425325006},
	{0.809017003, 0.309017003, 0.5},
	{0.681717992, 0.147621006, 0.71656698},
	{0.587785006, 0.425325006, 0.688190997},
	{0.955422997, 0.295242012, 0},
	{1, 0, 0},
	{0.951056004, 0.162459999, 0.26286599},
	{0.850651026, -0.525731027, 0},
	{0.955422997, -0.295242012, 0},
	{0.864188015, -0.442862988, 0.238856003},
	{0.951056004, -0.162459999, 0.26286599},
	{0.809017003, -0.309017003, 0.5},
	{0.681717992, -0.147621006, 0.71656698},
	{0.850651026, 0, 0.525731027},
	{0.864188015, 0.442862988, -0.238856003},
	{0.809017003, 0.309017003, -0.5},
	{0.951056004, 0.162459999, -0.26286599},
	{0.525731027, 0, -0.850651026},
	{0.681717992, 0.147621006, -0.71656698},
	{0.681717992, -0.147621006, -0.71656698},
	{0.850651026, 0, -0.525731027},
	{0.809017003, -0.309017003, -0.5},
	{0.864188015, -0.442862988, -0.238856003},
	{0.951056004, -0.162459999, -0.26286599},
	{0.147621006, 0.71656698, -0.681717992},
	{0.309017003, 0.5, -0.809017003},
	{0.425325006, 0.688190997, -0.587785006},
	{0.442862988, 0.238856003, -0.864188015},
	{0.587785006, 0.425325006, -0.688190997},
	{0.688190997, 0.587785006, -0.425325006},
	{-0.147621006, 0.71656698, -0.681717992},
	{-0.309017003, 0.5, -0.809017003},
	{0, 0.525731027, -0.850651026},
	{-0.525731027, 0, -0.850651026},
	{-0.442862988, 0.238856003, -0.864188015},
	{-0.295242012, 0, -0.955422997},
	{-0.162459999, 0.26286599, -0.951056004},
	{0, 0, -1},
	{0.295242012, 0, -0.955422997},
	{0.162459999, 0.26286599, -0.951056004},
	{-0.442862988, -0.238856003, -0.864188015},
	{-0.309017003, -0.5, -0.809017003},
	{-0.162459999, -0.26286599, -0.951056004},
	{0, -0.850651026, -0.525731027},
	{-0.147621006, -0.71656698, -0.681717992},
	{0.147621006, -0.71656698, -0.681717992},
	{0, -0.525731027, -0.850651026},
	{0.309017003, -0.5, -0.809017003},
	{0.442862988, -0.238856003, -0.864188015},
	{0.162459999, -0.26286599, -0.951056004},
	{0.238856003, -0.864188015, -0.442862988},
	{0.5, -0.809017003, -0.309017003},
	{0.425325006, -0.688190997, -0.587785006},
	{0.71656698, -0.681717992, -0.147621006},
	{0.688190997, -0.587785006, -0.425325006},
	{0.587785006, -0.425325006, -0.688190997},
	{0, -0.955422997, -0.295242012},
	{0, -1, 0},
	{0.26286599, -0.951056004, -0.162459999},
	{0, -0.850651026, 0.525731027},
	{0, -0.955422997, 0.295242012},
	{0.238856003, -0.864188015, 0.442862988},
	{0.26286599, -0.951056004, 0.162459999},
	{0.5, -0.809017003, 0.309017003},
	{0.71656698, -0.681717992, 0.147621006},
	{0.525731027, -0.850651026, 0},
	{-0.238856003, -0.864188015, -0.442862988},
	{-0.5, -0.809017003, -0.309017003},
	{-0.26286599, -0.951056004, -0.162459999},
	{-0.850651026, -0.525731027, 0},
	{-0.71656698, -0.681717992, -0.147621006},
	{-0.71656698, -0.681717992, 0.147621006},
	{-0.525731027, -0.850651026, 0},
	{-0.5, -0.809017003, 0.309017003},
	{-0.238856003, -0.864188015, 0.442862988},
	{-0.26286599, -0.951056004, 0.162459999},
	{-0.864188015, -0.442862988, 0.238856003},
	{-0.809017003, -0.309017003, 0.5},
	{-0.688190997, -0.587785006, 0.425325006},
	{-0.681717992, -0.147621006, 0.71656698},
	{-0.442862988, -0.238856003, 0.864188015},
	{-0.587785006, -0.425325006, 0.688190997},
	{-0.309017003, -0.5, 0.809017003},
	{-0.147621006, -0.71656698, 0.681717992},
	{-0.425325006, -0.688190997, 0.587785006},
	{-0.162459999, -0.26286599, 0.951056004},
	{0.442862988, -0.238856003, 0.864188015},
	{0.162459999, -0.26286599, 0.951056004},
	{0.309017003, -0.5, 0.809017003},
	{0.147621006, -0.71656698, 0.681717992},
	{0, -0.525731027, 0.850651026},
	{0.425325006, -0.688190997, 0.587785006},
	{0.587785006, -0.425325006, 0.688190997},
	{0.688190997, -0.587785006, 0.425325006},
	{-0.955422997, 0.295242012, 0},
	{-0.951056004, 0.162459999, 0.26286599},
	{-1, 0, 0},
	{-0.850651026, 0, 0.525731027},
	{-0.955422997, -0.295242012, 0},
	{-0.951056004, -0.162459999, 0.26286599},
	{-0.864188015, 0.442862988, -0.238856003},
	{-0.951056004, 0.162459999, -0.26286599},
	{-0.809017003, 0.309017003, -0.5},
	{-0.864188015, -0.442862988, -0.238856003},
	{-0.951056004, -0.162459999, -0.26286599},
	{-0.809017003, -0.309017003, -0.5},
	{-0.681717992, 0.147621006, -0.71656698},
	{-0.681717992, -0.147621006, -0.71656698},
	{-0.850651026, 0, -0.525731027},
	{-0.688190997, 0.587785006, -0.425325006},
	{-0.587785006, 0.425325006, -0.688190997},
	{-0.425325006, 0.688190997, -0.587785006},
	{-0.425325006, -0.688190997, -0.587785006},
	{-0.587785006, -0.425325006, -0.688190997},
	{-0.688190997, -0.587785006, -0.425325006},
};

void ReadDir(block_t* block, vec3_t a)
{
	int		code;

	code = ReadByte(block);
	if (code >= DM2_NUMVERTEXNORMALS)
	    code=0;
	a = avertexnormals[code];  
//  return a;
}
