#include <stdio.h>
#include <string.h>
#include "g_local.h"

FILE *dm2log;

// ripped from SNIPPETS
// http://www.snippets.org
char *strnsub(char *pszString,
			  char *pszPattern,
			  char *pszReplacement,
			  int iMaxLength)
{
	char *pszSubstring, *pszTmpSubstring;
	int iPatternLength, iReplacementLength;
	
	pszTmpSubstring = pszSubstring = pszString;
	iPatternLength = strlen(pszPattern);
	iReplacementLength = strlen(pszReplacement);
	
	if (!strcmp(pszPattern, pszReplacement))
		return(NULL);					// Pattern == replacement: loop
	
	if ((pszSubstring = strstr(pszString, pszPattern)) == NULL)
	{									// No match found
		return(NULL);
	}
	
	// Enough space for replacement?
	if ((strlen(pszString) + (iReplacementLength - iPatternLength))
		>= iMaxLength)
		return(NULL);
	
	// Buy some workspace
	pszTmpSubstring = (char *) calloc(iMaxLength, sizeof(char));
	if (NULL == pszTmpSubstring)	// No memory left
		return(NULL) ;
	
	strcpy(pszTmpSubstring, pszSubstring + iPatternLength);
	
	// If there was space left
	while (iReplacementLength--)
	{	// Copy replacement
		*pszSubstring++ = *pszReplacement++;
	}
	// Add old stuff back
	strcpy(pszSubstring, pszTmpSubstring);
	free(pszTmpSubstring);
	// Return pointer to change
	return(pszSubstring - iPatternLength);
}

void WriteLog (char *format, ...)
{
	va_list	argptr;
	char string[MAX_STRING_LENGTH];

	if (!dm2log)
		return;
	va_start (argptr, format);
	vsprintf (string, format, argptr);
	va_end (argptr);
	fputs(string, dm2log);
	fflush(dm2log);
}

void unicast_configstring (edict_t *ent, int index, char *string)
{
	if (!ent || !ent->client || !ent->inuse)
		return;

	gi.WriteByte(svc_configstring);
	gi.WriteShort(index);
	gi.WriteString(string);
	gi.unicast(ent, true);
}

void multicast_configstring (int index, char *string)
{
	if (index < 0 || index >= MAX_CONFIGSTRINGS)
		return;
	if (!string)
		return;

	strcpy(level.configstrings[index], string);
	
	gi.configstring(index, string);
}

int dm2_modelindex (char *string)
{
	int	i;

	i = gi.modelindex(string);
	if (!i)
		return 0;

	strcpy(level.configstrings[CS_MODELS+i], string);
	return i;
}

int dm2_soundindex (char *string)
{
	int	i;

	i = gi.soundindex(string);
	if (!i)
		return 0;

	strcpy(level.configstrings[CS_SOUNDS+i], string);
	return i;
}

int dm2_imageindex (char *string)
{
	int	i;

	i = gi.imageindex(string);
	if (!i)
		return 0;

	strcpy(level.configstrings[CS_IMAGES+i], string);
	return i;
}

char *DM2Map (char *filename)
{
	static	char mapname[MAX_QPATH];
	char	buf[MAX_QPATH], *ptr;
	dm2_t	tempdm2;
	block_t	*block = &tempdm2.curblock;
	int		i;
	configstring_t *data;

	Com_sprintf(buf, MAX_QPATH, "%s/demos/%s", game.dir, filename);

	memset(&tempdm2, 0, sizeof(dm2_t));
	WriteLog("Opening %s to find map...\n");
	DemoOpen(&tempdm2, buf);
	if (!dm2.file)
		gi.error("Cannot open %s.\n", buf);

	while (!block->framenum && block->size != -1)
	{
		ReadBlock(block, &tempdm2);
		if (block->size == -1)
			return NULL;
		block->framenum = ParseBlock(&tempdm2, true);
//		gi.dprintf("Nummessages: %d\n", block->num_messages);

		i = -1;
		while ((i = FindInBlock(block, i, svc_configstring)) > -1)
		{
			data = (configstring_t *)block->message[i].data;
			// assume models[1] (index 33) is mapname
			if (data->index == CS_MODELS+1)
				goto Success;
		}
		FreeBlock(block);
	}
	gi.dprintf("No map found\n");
	return NULL;
Success:
	data = (configstring_t *)block->message[i].data;
	// remove "maps/" prefix
	strncpy(mapname, data->string+5, MAX_QPATH);
	// remove ".bsp" suffix
	if (ptr = strstr(mapname, ".bsp"))
		*ptr = 0;

	FreeBlock(block);
	WriteLog("Closing %s to find map\n", filename);
	DemoClose(&tempdm2);
	return mapname;
}

void SetPlayerState (dm2_t *p, edict_t *ent, usercmd_t *ucmd)
{
	int i, dm2flags;
	player_state_t	*ps;

	if (!ent || !ent->inuse || !ent->client)
		return;

	ps = &ent->client->ps;
	dm2flags = ent->client->pers.dm2flags;
	// no player state in server demos
	if (p->isdemo == RECORD_SERVER)
		dm2flags = DM2_NOTINT;

	if (dm2flags & DM2_LOCKPOS)
	{
		VectorCopy(p->vieworigin, ent->s.origin);
		VectorCopy(p->ps.pmove.origin, ps->pmove.origin);
		VectorCopy(p->ps.pmove.velocity, ps->pmove.velocity);
		VectorCopy(p->ps.viewoffset, ps->viewoffset);
		ps->pmove.pm_flags = p->ps.pmove.pm_flags;
		ps->pmove.pm_time = p->ps.pmove.pm_time;
		ps->pmove.gravity = p->ps.pmove.gravity;
		ps->rdflags = p->ps.rdflags;
		gi.linkentity(ent);
	}
	else
	{
		VectorClear(ps->viewoffset);
		VectorClear(ps->pmove.velocity);
		ps->pmove.gravity = 0;
		ps->pmove.pm_flags = 0;
		ps->pmove.pm_time = 0;
		ps->rdflags = 0;
	}

	if (dm2flags & DM2_LOCKVIEW)
	{
		if (dm2flags & DM2_LOCKPOS)
		{
			VectorCopy (p->ps.viewangles, ps->viewangles);
			VectorCopy (p->ps.kick_angles, ps->kick_angles);
			ps->fov = p->ps.fov;
			if (ps->fov < 1)
				ps->fov = 90;
		}
		else
		{
			// keep looking at viewent, but allow camera
			// to circle around it
			vec3_t	start, dir, end;
			trace_t	tr;

//			if (inbounds(p->viewent, 1, MAX_EDICTS-1) && EDICT(p, p->viewent) && EDICT(p, p->viewent)->s.modelindex)
//				VectorCopy (EDICTp, p->viewent)->s.origin, start);
//			else
				VectorAdd (p->vieworigin, p->ps.viewoffset, start);

			if (ucmd)
			{
				for (i = 0; i < 3; i++)
					dir[i] = SHORT2ANGLE(ucmd->angles[i]);
			}
			else
				VectorSet(dir, 0, 0, 0);
			
			if (dm2flags & DM2_CHASEVIEW)
				VectorAdd(dir, p->ps.viewangles, dir);
			AngleVectors(dir, dir, NULL, NULL);

			if (ucmd)
				ent->client->pers.dist -= (float)ucmd->forwardmove * ucmd->msec / 2000;

			if (ent->client->pers.dist < 32)
				ent->client->pers.dist = 32;

			VectorMA(start, -ent->client->pers.dist, dir, end);
			tr = gi.trace(start, tv(-8, -8, -8), tv(8, 8, 8), end, NULL, MASK_SOLID);
			VectorSubtract(start, tr.endpos, dir);
			// chase-view doesn't change distance
			if (dm2flags & DM2_CHASEVIEW || tr.fraction == 1.0)
				VectorNormalize(dir);
			else
				ent->client->pers.dist = VectorNormalize(dir);

			VectorClear(ps->kick_angles);
			vectoangles(dir, ps->viewangles);
			VectorCopy(tr.endpos, ent->s.origin);
			for (i = 0; i < 3; i++)
				ps->pmove.origin[i] = ent->s.origin[i]*8;
			gi.linkentity(ent);
		}
		ps->pmove.pm_type = PM_FREEZE;
	}
	else
	{
		VectorClear (ps->kick_angles);
		ps->pmove.pm_type = PM_SPECTATOR;
	}

	if (dm2flags & DM2_SHOWSTATUS)
	{
		ps->gunindex = p->ps.gunindex;
		ps->gunframe = p->ps.gunframe;
		VectorCopy(p->ps.gunoffset, ps->gunoffset);
		VectorCopy(p->ps.gunangles, ps->gunangles);
		memcpy(ps->stats, p->ps.stats, sizeof(ps->stats));
	}
	else
	{
		ps->gunindex = 0;
		ps->gunframe = 0;
		VectorClear(ps->gunoffset);
		VectorClear(ps->gunangles);
		memset(ps->stats, 0, sizeof(ps->stats));
	}

	if (dm2flags & DM2_NOTINT)
	{
		ps->stats[STAT_FLASHES] = 0;
		memset(ps->blend, 0, sizeof(ps->blend));
	}
	else
	{
		ps->stats[STAT_FLASHES] = p->ps.stats[STAT_FLASHES];
		memcpy(ps->blend, p->ps.blend, sizeof(ps->blend));
	}
}

int VWeapIndex (dm2_t *p, int in)
{
	int		i, num;
	char	*name, *str;

	in = (in >> 8) & 255;
	if (!in)
		return 0;
	for (i = 0, num = 0; i < MAX_MODELS && num < in; i++)
	{
		str = p->configstrings[CS_MODELS+i];
		if (str[0] != '#')
			continue;
		num++;
	}
	name = str;

	for (i = 0, num = 0; i < MAX_MODELS; i++)
	{
		str = level.configstrings[CS_MODELS+i];
		if (str[0] != '#')
			continue;
		num++;
		if (!strcmp(name, str))
			return num;
	}
	return 0;
}