// maximum message length
#define	MAX_MESSAGE_SIZE	1400
// maximum string size
#define MAX_STRING_LENGTH	0x800
// maximum number of areas in a map
#define MAX_MAP_AREAS		256
// maximum messages per frame; arbitrary value
#define MAX_MSGPERBLOCK		1024

// demo type
#define RECORD_NETWORK		0
#define RECORD_CLIENT		1
#define RECORD_SERVER		2

//dm2 to dll world conversions
#define EDICT(p, num)	((p)->edicts[(num)])
#define MODEL(p, num)	((num) == 255 || (num) <= 1 ? (num) : ((p)->configstring[(num)+CS_MODELS] ? (p)->configstring[(num)+CS_MODELS]-CS_MODELS : 0))
#define SOUND(p, num)	((p)->configstring[(num)+CS_SOUNDS] ? (p)->configstring[(num)+CS_SOUNDS]-CS_SOUNDS : 0)
#define IMAGE(p, num)	((p)->configstring[(num)+CS_IMAGES] ? (p)->configstring[(num)+CS_IMAGES]-CS_IMAGES : 0)
#define PLAYER(p, num)	((p)->configstring[((num) & 255)+CS_PLAYERSKINS] ? (p)->configstring[((num) & 255)+CS_PLAYERSKINS]-CS_PLAYERSKINS : 0)
#define INVEN(p, num)	((p)->configstring[(num)]);

//player options
#define DM2_SHOWSTATUS		0x01
#define DM2_LOCKPOS			0x02
#define DM2_LOCKVIEW		0x04
#define DM2_NOTINT			0x08
#define DM2_CHASEVIEW		0x10

#define	inbounds(x, y, z)	((x) >= (y) && (x) <= (z) ? true : false)
#define setbounds(x, y, z)	((x) = min(z, max(x, y)))

enum
{
	STAT_NUMBER,
	STAT_IMAGE,
	STAT_STRING,
};

typedef struct
{
	unsigned char id;
	void *data;
} message_t;

typedef struct
{
	unsigned long size;						// size of block
	unsigned char *buffer;					// raw data for block
	unsigned char *p;						// current position in buffer
	unsigned char *end;						// last position in buffer
	int num_messages;						// number of messages in block
	int framenum;							// current frame
	int oldframe;							// old frame
	message_t message[MAX_MSGPERBLOCK];		// message array (parsed and convenient)
	qboolean entityupdated[MAX_EDICTS];		// entity was updated in this block
} block_t;

typedef struct
{
	FILE*	file;							// file pointer
	int		isdemo;							// 0 = network; 1 = client record; 2 = serverrecord
	block_t curblock;						// current block
	float	lastframe;						// last level frame processed
	int		version;						// protocol version
	int		viewent;						// ent number of camera
	int		viewentmodel;					// model of viewent
	vec3_t	vieworigin;						// camera position
	int		maxclients;						// maxclients
	char	mapname[MAX_QPATH];				// descriptive mapname

	edict_t *edicts[MAX_EDICTS];			// dm2 to world edict translation table
	entity_state_t baselines[MAX_EDICTS];	// edict baselines
	player_state_t ps;						// player state of camera
	char	configstrings[MAX_CONFIGSTRINGS][MAX_QPATH];// strings
	int		configstring[MAX_CONFIGSTRINGS];// translation table
	int		statusbar[MAX_STATS];			// tells whether stat item is image, string, etc.
} dm2_t;

// structs for all message types
typedef struct
{
	long entity;	// entity that makes muzzleflash
	long value;		// MZ_* and MZ2_* value
} muzzleflash_t;	// svc_muzzleflash and svc_muzzleflash2

typedef struct
{
	long entitytype;	// TE_* value
	vec3_t origin;		// origin for point entities
	vec3_t endpos;		// endpoint for line entities
	vec3_t offset;		// offset if came from an edict
	vec3_t movedir;		// direction of particles
	int entity;			// entity associated with a line tempent
	int sound;			// sound number in precache list
	int count;			// number of particles
	int color;			// index in color palette
} temp_entity_t;		// svc_temp_entity

typedef struct
{
	char text[MAX_STRING_LENGTH];
} layout_t;			// svc_layout

typedef struct
{
	int inventory[MAX_ITEMS];
} inventory_t;		// svc_inventory

typedef struct
{
	long mask;		// mask to save network bandwidth
	long soundnum;	// index in sound precache list
	float vol;		// volume (0.0 thru 1.0)
	float attenuation; // attenuation
	float timeofs;	// time offset
	long channel;	// CHAN_* value
	long entity;	// entity that made sound
	vec3_t origin;	// origin of sound
} sound_t;			// svc_sound

typedef struct
{
	long level;		// PRINT_LOW, PRINT_MEDIUM, etc.
	char string[MAX_STRING_LENGTH];
} print_t;			// svc_print

typedef struct
{
	char text[MAX_STRING_LENGTH];
} stufftext_t;		// svc_stufftext

typedef struct
{
	long serverversion;	// protocol version
	long key;			// unique key for client
	long isdemo;		// network, clientrecord, or serverrecord
	char game[MAX_QPATH]; // gamedir of dm2
	long player;		// edict to make invisible (camera)
	char mapname[MAX_QPATH]; // descriptive name of map
	int compatible;		// compatible with v3.05
} serverdata_t;		// svc_serverdata

typedef struct
{
	int index;		// index in configstring list
//	char string[MAX_QPATH];
	char string[MAX_QPATH+1];	// statusbars can be 64 + terminating \0 chars
} configstring_t;	// svc_configstring

typedef struct
{
	long mask;		// mask to save network bandwidth
	long entity;	// entity
	entity_state_t s; // defaults for entity
} spawnbaseline_t;	// svc_spawnbaseline

typedef struct
{
	char text[MAX_STRING_LENGTH];
} centerprint_t;	// svc_centerprint

typedef struct
{
	long size;		// number of bytes in packet
	long percent;	// precent complete
	char downloadbuffer[MAX_MESSAGE_SIZE];	// data in buffer
	char filename[MAX_QPATH];				// filename for data
	FILE *fp;		// file pointer
} download_t;		// svc_download

typedef struct
{
	long mask;		// mask to save network bandwidth
	long mask2;		// stats mask
	long pm_type;	// PM_* value
	vec3_t origin;	// origin of camera
	vec3_t velocity;// velocity for prediction
	byte pm_flags;	// PMF_* value
	byte pm_time;	// time for pm_flags
	short gravity;	// gravity for prediction
	vec3_t delta_angles;	// change in firing dir since last update
	vec3_t viewangles;		// viewing dir
	vec3_t viewoffset;		// view offset with respect to camera origin
	vec3_t kick_angles;		// added to viewangles
	vec3_t gunangles;		// angle of gun model
	vec3_t gunoffset;		// offset of gun model
	int gunindex;			// modelindex of gun model
	int gunframe;			// frame of gun model
	float blend[4];			// RGBA blend values
	long fov;				// field of view of camera
	int rdflags;			// RDF_* value
	short stats[MAX_STATS];	// statusbar variables
} playerinfo_t;		// svc_playerinfo

typedef struct
{
	long mask;		// mask to save network bandwidth
	long entity;	// entity
	long remove;	// remove this entity
	vec3_t origin;	// origin of entity
	vec3_t angles;	// angles of entity
	vec3_t old_origin;	// old origin of entity
	long modelindex;	// modelindex (255 for players)
	long modelindex2;	// modelindex2 (255 for weapon)
	long modelindex3;	// modelindex3 (CTF flags, etc.)
	long modelindex4;	// modelindex4
	long frame;		// frame for model
	long skin;		// skin for model (configstring index for players)
	long effects;	// EF_* value
	long renderfx;	// RF_* value
	long solid;		// set by gi.linkentity()
	long sound;		// looping sound for entity in sound list
	long event;		// EV_* value
} packetentities_t;	// svc_packetentities

typedef struct
{
	long seq1;		// current frame
	long seq2;		// old frame
	long count;		// number of bytes in area array
	unsigned char areas[MAX_MAP_AREAS / 8];	// currently viewable areas
} frame_t;			// svc_frame

//dm2_file.c
FILE	*DemoOpen (dm2_t *p, char *filename);
void	DemoClose (dm2_t *p);
void	SetPlayerState (dm2_t *p, edict_t *ent, usercmd_t *ucmd);
int		ParseBlock (dm2_t *dm2, qboolean change);
qboolean NextFrame (dm2_t *p);
void ProcessPreFrame (dm2_t *p);
block_t	*ReadBlock (block_t *dest, dm2_t *dm2);
void	FreeBlock (block_t *block);
int		FindInBlock (block_t *block, int from, int id);

extern dm2_t	dm2;
extern cvar_t	*demoname;
extern cvar_t	*gamedir;
extern qboolean	stopdemo;
extern FILE		*dm2log;
extern cvar_t	*demoname;
extern cvar_t	*gamedir;
extern cvar_t	*timescale;
extern qboolean	stopdemo;

//dm2_misc.c
char *strnsub (char *pszString, char *pszPattern, char *pszReplacement, int iMaxLength);
void WriteLog (char *format, ...);
void unicast_configstring (edict_t *ent, int index, char *string);
void multicast_configstring (int index, char *string);
int dm2_modelindex (char *string);
int dm2_soundindex (char *string);
int dm2_imageindex (char *string);
char *DM2Map (char *filename);
int VWeapIndex (dm2_t *p, int in);

#include "dm2_parse.h"
