//=============================================================================
// CS_Wrap.
//
// This Actor when triggered closes up the Cut Sequence.  It returns the HUD to 
// normal and resets the POV.
//=============================================================================
class CS_Wrap expands CutSeq;

#exec Texture Import File=Textures\movie.pcx Name=S_Move Group=CutSequences Mips=Off Flags=2

var() bool bSetFinalRotation;

function Trigger(actor Other, pawn EventInstigator)
{

 	local CSPlayer P;
 	local UnrealGameInfo g;
 	
 	
 	LOG("****IN CS_WRAP");
 	
	// Switch the Cut Sequence Engine off for all players in the game

 	foreach ALLActors(class'CSPlayer',p)
 	{
 	    LOG("CS_WRAP: Reseting Player");
 	    	     	    
	  	p.POVFirstPerson();	// Reset their view
	}

	CSPlayer(EventInstigator).Freeze(false);

    if (bSetFinalRotation)
    {
      EventInstigator.CLientSetRotation(Self.Rotation);
      Log("CS_WRAP: Setting Player Rotation");
	      
    }  

	// If the player's movements have been locked up, clear it all.

	if (CSPlayer(EventInstigator).bIsActing)
	{
	   CSPlayer(EventInstigator).ResetScriptedMove();	
	   CSPlayer(EventInstigator).Freeze(false);
	}
	
    LOG("****OUT CS_WRAP");
 		
}

defaultproperties
{
     Texture=Texture'CutSequences.CutSequences.S_Move'
}
