//=============================================================================
// CS_ShotList.  - The Shotlist is basically a Dispatcher.  It calls each camera
//                 along the way.  It also can be used to generate an event.
//=============================================================================
class CS_ShotList expands CutSeq;

#exec Texture Import File=Textures\movie.pcx Name=S_Move Group=CutSequences Mips=Off Flags=2

//-----------------------------------------------------------------------------
// Dispatcher variables.

var() name  OutCamera[8]; // Camera to activate
var() name  OutEvents[8]; // Events to generate.
var() float OutDelays[8]; // Relative delays before generating events.
var int i;                // Internal counter.
var CS_Camera tmpCam;	
var bool bActive;               // Is this shotlist active
var bool bAbort;				// has this shotlist been aborted.


function Trigger( actor Other, pawn EventInstigator )
{
	Instigator = EventInstigator;
	gotostate('Dispatch');
}

state IsDone
{
begin:
  Log("****OUT CS_SHOTLIST");
}

//
// Dispatch events.  This was taken straight from the Dispatcher actor.  I just 
// altered it to my needs.
//
state Dispatch
{
Begin:
	disable('Trigger');
	
	LOG("****IN CS_SHOTLIST");

	// Do each sequence (up to 8)

	bActive=true;
	
	for( i=0; i<8; i++)
	{

		// If this ShotList has been aborted, exit out.

		if (bAbort==True)  
		{
		
		  Log("CS_SHOTLIST: Aborted!");
		  bAbort=false;
		  bActive=false;
		  GotoState('IsDone');
		}
	
		// Switch to that Camera
	
		if (OutCamera[i] != '')
		{

			foreach AllActors(class 'CS_Camera',TmpCam, OutCamera[i])
		    {
		     	Log("CS_SHOTLIST: Triggered Camera");
		     	TmpCam.Trigger(Self,Instigator);	
		    }

		}
		
		// Trigger the Event
	
		if( OutEvents[i] != '' )
		{
			foreach AllActors( class 'Actor', Target, OutEvents[i] )
			{

				Log("CS_SHOTLIST: Triggered Trigger");
				Target.Trigger( Self, Instigator );
			}
 		  						
		}
		
		// Pause for Station break		   
		
  		LOG("CS:SHOTLIST: SLEEPING");
   		Sleep( OutDelays[i] );		
   		LOG("CS:SHOTLIST: DONE SLEEPING");
		
	}

    bActive=false;	
	
	LOG("****OUT CS_SHOTLIST");
	
	enable('Trigger');
}

event PreBeginPlay()
{

  bAbort = false;
  bActive = false;

}

defaultproperties
{
     Texture=Texture'CutSequences.CutSequences.S_Move'
}
