//=============================================================================
// CS_Hud.
//=============================================================================
class CS_Hud expands UnrealHUD;

#exec Texture Import File=Textures\black.pcx Name=CS_LetterBox Mips=Off Flags=2
#exec Texture Import File=Textures\csskull.pcx Name=CS_Skull Mips=off Flags=2


simulated function ChangeHud(int d)
{
	HudMode = HudMode + d;
	if ( HudMode>5 ) HudMode = 0;
	else if ( HudMode < 0 ) HudMode = 5;
}

simulated function PostRender( canvas Canvas )
{

    local int lbx;

	HUDSetup(canvas);

    // Handle our custom modes	

    if (HudMode==6)  // Normal
      return;
      
    if (HudMode==7)  // Letterboxed
    {
    
        // A letterboxed screen uses the aspect ratio of 16:9. 
    
        lbx = Canvas.CLipX / 16;
        lbx *= 9;
        lbx = (Canvas.ClipY-lbx)/2;
              
    
	    Canvas.SetPos(0,0);
	    Canvas.DrawRect(Texture'CS_LetterBox',Canvas.ClipX,lbx);
	    Canvas.SetPos(0,Canvas.ClipY-lbx);
	    Canvas.DrawRect(Texture'CS_letterBox',Canvas.ClipX,Canvas.ClipY);    
	    return;
    }


	if ( PlayerPawn(Owner) != None )
	{
		if ( PlayerPawn(Owner).bShowMenu )
		{
			if ( MainMenu == None )
				CreateMenu();
			if ( MainMenu != None )
				MainMenu.DrawMenu(Canvas);
			return;
		}
		if ( PlayerPawn(Owner).bShowScores )
		{
			if ( (PlayerPawn(Owner).Scoring == None) && (PlayerPawn(Owner).ScoringType != None) )
				PlayerPawn(Owner).Scoring = Spawn(PlayerPawn(Owner).ScoringType, PlayerPawn(Owner));
			if ( PlayerPawn(Owner).Scoring != None )
			{ 
				PlayerPawn(Owner).Scoring.ShowScores(Canvas);
				return;
			}
		}
		else if ( (PlayerPawn(Owner).Weapon != None) && (Level.LevelAction == LEVACT_None) )
			DrawCrossHair(Canvas, 0.5 * Canvas.ClipX - 8, 0.5 * Canvas.ClipY - 8);

		if ( PlayerPawn(Owner).ProgressTimeOut > Level.TimeSeconds )
			DisplayProgressMessage(Canvas);

	}


	if (HudMode==5) 
	{
		DrawInventory(Canvas, Canvas.ClipX-96, 0,False);		
		Return;
	}
	if (Canvas.ClipX<320) HudMode = 4;

	// Draw Armor
	if (HudMode<2) DrawArmor(Canvas, 0, 0,False);
	else if (HudMode==3 || HudMode==2) DrawArmor(Canvas, 0, Canvas.ClipY-32,False);
	else if (HudMode==4) DrawArmor(Canvas, Canvas.ClipX-64, Canvas.ClipY-64,True);
	
	// Draw Ammo
	if (HudMode!=4) DrawAmmo(Canvas, Canvas.ClipX-48-64, Canvas.ClipY-32);
	else DrawAmmo(Canvas, Canvas.ClipX-48, Canvas.ClipY-32);
	
	// Draw Health
	if (HudMode<2) DrawHealth(Canvas, 0, Canvas.ClipY-32);
	else if (HudMode==3||HudMode==2) DrawHealth(Canvas, Canvas.ClipX-128, Canvas.ClipY-32);
	else if (HudMode==4) DrawHealth(Canvas, Canvas.ClipX-64, Canvas.ClipY-32);
		
	// Display Inventory
	if (HudMode<2) DrawInventory(Canvas, Canvas.ClipX-96, 0,False);
	else if (HudMode==3) DrawInventory(Canvas, Canvas.ClipX-96, Canvas.ClipY-64,False);
	else if (HudMode==4) DrawInventory(Canvas, Canvas.ClipX-64, Canvas.ClipY-64,True);
	else if (HudMode==2) DrawInventory(Canvas, Canvas.ClipX/2-64, Canvas.ClipY-32,False);	

	// Display Frag count
	if ( (Level.Game == None) || Level.Game.IsA('DeathMatchGame') ) 
	{
		if (HudMode<3) DrawFragCount(Canvas, Canvas.ClipX-32,Canvas.ClipY-64);
		else if (HudMode==3) DrawFragCount(Canvas, 0,Canvas.ClipY-64);
		else if (HudMode==4) DrawFragCount(Canvas, 0,Canvas.ClipY-32);
	}

}


defaultproperties
{
     HudMode=2
     MainMenuType=None
}
