//=============================================================================
// CS_Camera. - This is the actual Camera actor.  It sets the POV to the 3D Person
//              and makes it look nice.
//=============================================================================
class CS_Camera expands Keypoint;

var Actor Target;
var bool bLockedOn; 	// Is this Camera locked on to a target
var bool bFollowing;	// Are we following someone

function Trigger(actor Other, pawn EventInstigator)
{

 	local CSPlayer P;
 	local PlayerPawn x;
 	
 	Log("****IN CS_CAMERA");
 	
	// Find all players.

 	foreach AllActors(class'CSPlayer',p)
 	{
 	  	LOG("CS_CAMERA: Found an Actor");

		// Change their POV to that of the camera.

 	  	p.POVGotoLocation(Self);
	   	  	 	  	
   	} 		
 	
 	Log("****OUT CS_CAMERA");
  
 	
}

function UnTrigger(actor Other, pawn EventInstigator)
{	
}

function TurnTowardsTarget(vector targ)
{

    SetRotation(Rotator(targ - location));
        
}


function AdjustWithPlayer(vector Vel)
{

  Velocity = Vel;
}


event Tick(float DeltaTime)
{
    if (bLockedOn) 
  		TurnTowardsTarget(target.Location);
  		
    if (bFollowing)
      AdjustWithPlayer(target.Velocity);
     	   
  Super.Tick(DeltaTime);
  
}

defaultproperties
{
     bStatic=False
     bDirectional=True
     bStasis=True
     bFixedRotationDir=True
}
