//=============================================================================
// CS_AdjustCamera.
//
// This actor allows you to adjust how the camera is moving in the world.  
// You can adjust it's rotation and velocity.  
// 
//=============================================================================
class CS_AdjustCamera expands CutSeq;

#exec Texture Import File=Textures\movie.pcx Name=S_Move Group=CutSequences Mips=Off Flags=2

var() rotator Adj_DesiredRotation;
var() rotator Adj_RotationRate;
var() vector Adj_Velocity;

function Trigger(actor Other, pawn EventInstigator)
{

 	local CS_Camera C;
 	local UnrealGameInfo g;
	 	
 	LOG("****IN CS_ADJUSTCAMERA");
 	
	// Find the camera.

 	foreach ALLActors(class'CS_Camera',c,self.Event)
 	{ 
 	    LOG("CS_AdjustCamera: Found Camera to Adjust");

		// Adjust it's settings.

		C.DesiredRotation = Adj_DesiredRotation;
		C.RotationRate = Adj_RotationRate;
		C.Velocity = Adj_Velocity;

		// What a hack.  The only mode that I could get the
		// camera to both rotate and move in was as a projectile.
		// I thought PHYS_Flying would work, but no go.  But hey..
		// does it really matter?
 	  
 	  	C.SetPhysics(PHYS_Projectile);
 	  
	}
	
    LOG("****OUT CS_ADJUSTCAMERA");
 		
}

defaultproperties
{
     Texture=Texture'CutSequences.CutSequences.S_Move'
}
