//=============================================================================
// CSSinglePlayer.
//=============================================================================
class CSSinglePlayer expands UnrealGameInfo;


// Switch players to their Cut Sequence  equivalent as they log in.

event playerpawn Login
(
	string[32] Portal,
	string[120] Options,
	out string[80] Error,
	class<playerpawn> SpawnClass
)
{
	local playerpawn NewPlayer;

	// Switch the player's UnrealIPlayer spawnclass with
	// a AWGDPlayer spawn class of the same type
//	switch (SpawnClass) {
//		case class'SkaarjPlayer':
//			SpawnClass = class'CSSkaarjPlayer';
//			break;
//		case class'MaleOne':
//			SpawnClass = class'CSMaleOne';
//			break;
//		case class'MaleTwo':
//			SpawnClass = class'CSMaleTwo';
//			break;
//		case class'MaleThree':
//			SpawnClass = class'CSMaleThree';
//			break;
//		case class'FemaleOne':
//			SpawnClass = class'CSFemaleOne';
//			break;
//		case class'FemaleTwo':
//			SpawnClass = class'CSFemaleTwo';
//			break;
//		else:
//		    SpawnClass = class'CSFemaleTwo';
//	}

	SpawnClass = class 'CSMaleTwo';

	NewPlayer = Super.Login(Portal, Options, Error, SpawnClass);

	return NewPlayer;
}

// From Unreal's SinglePlayer 
function Killed(pawn killer, pawn Other, name damageType)
{
	super.Killed(killer, Other, damageType);
	if ( Other.IsA('Nali') )
		killer.Score -= 2;
}	

function PlayTeleportEffect( actor Incoming, bool bOut, bool bSound)
{
}

function DiscardInventory(Pawn Other)
{
	if ( Other.Weapon != None )
		Other.Weapon.PickupViewScale *= 0.7;
	Super.DiscardInventory(Other);
}

defaultproperties
{
     DefaultPlayerClass=Class'CutSequences.CSMaleOne'
     HUDType=Class'CutSequences.CS_Hud'
}
