/*

MIPINDEX.H

Miptexture management utility for BSP / PAK / WAD2

Introducing two new file formats: DST (distributable BSP / WAD2) and IDX
(miptex index into other files)

by Ed Kiser (edkiser@jaxnet.com) Copyright (c) 1996

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

This program is still under construction.

History moved to history.txt.

*/

#ifndef __MIPINDEX_H
#define __MIPINDEX_H
#else
#error Multiple includes of MIPINDEX.H not allowed
#endif

#ifndef __IOSTREAM_H
#include <iostream.h>
#endif
#ifndef __dj_include_string_h_
#include <string.h>
#endif
#ifndef __dj_include_unistd_h_
#include <unistd.h>
#endif
#ifndef __dj_include_dir_h_
#include <dir.h>
#endif
#ifndef assert
#include <assert.h>
#endif

#ifndef __UTILITY_H
#include "utility.h"
#endif
#ifndef __MINDEX_H
#include "mindex.h"
#endif
#ifndef __QSTRUCTS_H
#include "qstructs.h"
#endif

/***** app class *****/

class indexer
{ public:
  indexer(int argc, char * argv[]);
  ~indexer();
  bool is_valid() const;
  void run(ostream & cout);
  void explain(ostream & cout);

  private:
  void print_list(ostream & cout);
// void show_view(ostream & cout);
  void make_wad2(ostream & cout);
  void make_idx(ostream & cout);
  void bsp_dst(ostream & cout, bool want_dst);
  void print_gpl(ostream & cout);
//  void make_bsp(ostream & cout);

  enum actiontype
  { error, list, view, wad2, saveidx, dst, undst, gpl } action;
  enum errortype
  { nooption, unknownopt, toofewparms, toomanyparms } what_error;
  int _argc;
  char ** _argv;
  miptex_index idx;
};

inline bool indexer::is_valid() const
{ return action!=error;
};

int main(int argc, char * argv[]);



