/*

BSP-DST.CPP

Conversion functions for Mipindex

by Ed Kiser (edkiser@jaxnet.com) Copyright (c) 1996

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __MIPINDEX_H
#include "mipindex.h"
#endif

static bool zaptex(ostream & cout, istream & src, ostream & dest,
 miptex_index & idx)
{ bool result=true;
  int origin=dest.tellp();
  int offset=src.tellg();
  long numtex; read_image(numtex,src); write_image(numtex,dest);
  cout << howmany("Altering miptexure section with % entr[y](ies).\n",
   numtex);
  long * miptexoffset = 0;
  try
  { miptexoffset=new long[numtex];
    src.read((char*)miptexoffset,numtex*sizeof(long));
    if (src.fail()) throw "Could not read miptexture directory!\n";
    dest.write((char*)miptexoffset,numtex*sizeof(long)); // fill in later
    for (int j=0; j<numtex; j++)
    { long & mo=miptexoffset[j];
      if (mo==-1)
      { cout << "Skipping empty entry.\n";
        continue;
      }
      src.seekg(mo+offset);
      if (src.fail()) throw "Bad miptexture offset in source file!\n";
      miptex mt(src);
      miptex_id mtid=(miptex_id)mt;
      mo=dest.tellp()-origin;
      if (mt.is_valid())
      { if (idx.has(mtid))
        { dest.write("r",1);
          write_image(mtid,dest);
          cout << "Removing " << mtid << "\n";
        } else
        { dest.write("k",1);
          mt.write_bytes(dest);
          cout << "Keeping " << mtid << "\n";
        }
      } else
      { dest.write("b",1);
        cout << "Ignored invalid miptexture.\n";
        result=false;
      }
    } /* for each miptexture */
    int finalpos=dest.tellp();
    dest.seekp(origin+sizeof(long));
    dest.write((char*)miptexoffset,numtex*sizeof(long));
    dest.seekp(finalpos);
    delete[] miptexoffset;
  }
  catch (...)
  { delete[] miptexoffset;
    throw;
  }
};

static bool fixtex(ostream & cout, istream & src, ostream & dest,
 miptex_index & idx)
{ bool result=true;
  int origin=dest.tellp();
  int offset=src.tellg();
  long numtex; read_image(numtex,src); write_image(numtex,dest);
  cout << howmany("Restoring miptexure section with % entr[y](ies).\n",
   numtex);
  long * miptexoffset = 0;
  try
  { miptexoffset=new long[numtex];
    src.read((char*)miptexoffset,numtex*sizeof(long));
    if (src.fail()) throw "Could not read miptexture directory!\n";
    dest.write((char*)miptexoffset,numtex*sizeof(long)); // fill in later
    for (int j=0; j<numtex; j++)
    { long & mo=miptexoffset[j];
      if (mo==-1)
      { cout << "Skipping empty entry.\n";
        continue;
      }
      src.seekg(mo+offset);
      if (src.fail()) throw "Bad miptexture offset in source file!\n";
      char what_happened; src.read(&what_happened,1);
      miptex mt; bool invalid=false;
      if (what_happened=='r')
      { miptex_id mtid; read_image(mtid,src);
        cout << "Replacing " << mtid << "\n";
        bool success=idx.get(mtid,mt);
        if (!success)
         throw "Miptexture was not found in index or didn't read.\n";
      } else if (what_happened=='k')
      { mt=miptex(src);
        cout << "Keeping " << (miptex_id)mt << "\n";
      } else
      { if (what_happened!='b') throw "Defective DST file.";
        cout << "Ignoring invalid miptexture.\n";
        invalid=true; result=false;
      };
      mo=dest.tellp()-origin;
      if (!invalid) mt.write_bytes(dest);
      else write_image(miptex_id::bad_id,dest);
    } /* for each miptexture */
    int finalpos=dest.tellp();
    dest.seekp(origin+sizeof(long));
    dest.write((char*)miptexoffset,numtex*sizeof(long));
    dest.seekp(finalpos);
    delete[] miptexoffset;
  }
  catch (...)
  { delete[] miptexoffset;
    throw;
  }
  return result;
};

static bool run_conversion (ostream & cout, istream & src, ostream & dest,
 bool want_dst, miptex_index & idx)
{ bool result=true;
  long dest_origin=dest.tellp();
  bsp_header head(src);
  if (!head.is_valid() || src.fail()) throw "Source file is corrupt.\n";
  write_image(head,dest);
  for (int i=bsp_header::entities; i<bsp_header::END; i++)
  { long & size=head.entry[i].size;
    long & offset=head.entry[i].offset;
    src.seekg(offset);
    if (src.fail()) throw "Bad offset in source file.\n";
    if (i==bsp_header::miptextures)
    { offset=dest.tellp();
      if (want_dst) result=zaptex(cout,src,dest,idx);
      else result=fixtex(cout,src,dest,idx);
      size=dest.tellp()-offset;
    } else
    { char * buf=new char[size];
      src.read(buf,size);
      if (src.fail()) throw "Bad size or offset in source file.\n";
      offset=dest.tellp();
      dest.write(buf,size);
    }
  }
  dest.seekp(dest_origin);
  write_image(head,dest);
  return result;
};

static void init_streams(ostream & cout, char * inname, bool want_dst,
 ifstream & src, ofstream & dest)
{ char outname[260]; strcpy(outname,inname);
  char * srcext=".bsp"; char * destext=".dst";
  if (!want_dst)
  { char * p=srcext; srcext=destext; destext=p;
  }
  if (!has_extension(inname,srcext)) throw "Source file is not a BSP.";
  strcpy(outname+strlen(outname)-4,destext);
  src.open(inname,ios::in | ios::nocreate | ios::binary);
  if (src.fail()) throw "Source file not found.";
  dest.open(outname,ios::out | ios::noreplace | ios::binary);
  if (dest.fail()) throw "Destination file already exists.";
  cout << "Converting " <<inname << " to " << outname << ".\n";
  if (want_dst) dest.write("KiserDST",8);
  else
  { char p[8]; src.read(p,8);
    if (strncmp(p,"KiserDST",8)!=0) throw "Bad DST file header.";
  }
};

void indexer::bsp_dst(ostream & cout, bool want_dst)
{ bool succeeded_with[_argc];
  cout << "Building index.\n";
  idx.read_file(_argv[2],cout);
  for (int file=3; file<_argc; file++)
  { try
    { ifstream src;
      ofstream dest;
      init_streams(cout,_argv[file],want_dst,src,dest);
      succeeded_with[file]=run_conversion(cout,src,dest,want_dst,idx);
    }
    catch (char * error)
    { cout << "File error: " << error << "\n";
      succeeded_with[file]=false;
    }
    cout << endl;
  }
  bool all_succeeded=true;
  bool all_failed=true;
  for (int file=3; file<_argc; file++)
  { all_succeeded=all_succeeded && succeeded_with[file];
    all_failed=all_failed && (!succeeded_with[file]);
  };
  if (!all_failed)
  { cout << "Successfully converted:\n";
    for (int file=3; file<_argc; file++)
    if (succeeded_with[file]) cout << "  " << _argv[file] << "\n";
  }
  if ((!all_failed) && (!all_succeeded)) cout << endl;
  if (!all_succeeded)
  { cout << "There were errors converting:\n";
    for (int file=3; file<_argc; file++)
    if (!succeeded_with[file]) cout << "  " << _argv[file] << "\n";
  }
};

#if 0
void indexer::make_dst(ostream & cout)
{ cout << "Building index.\n";
  idx.read_file(_argv[2],cout);
  for (int file=3; file<_argc; file++)
  { char name[260]; strcpy(name,_argv[file]);
    cout << "Processing: " << name << ".\n";
    try
    { if (!has_extension(name,".bsp")) throw "Source file is not a BSP!\n";
      ifstream src(name,ios::in | ios::nocreate | ios::binary);
      if (src.fail()) throw "Source file does not exist!\n";
      strcpy(name+strlen(name)-3,"dst");
      cout << "Making DST: " << name << ".\n";
      ofstream dest(name,ios::out | ios::noreplace | ios::binary);
      if (dest.fail()) throw "Destination already exists!\n";
      bsp_header head(src);
      if (!head.is_valid() || src.fail()) throw "Source file is corrupt!\n";
      dest.write("KiserDST",8);
      write_image(head,dest);
      for (int i=bsp_header::entities; i<bsp_header::END; i++)
      { long & size=head.entry[i].size;
        long & offset=head.entry[i].offset;
/*      cout << "Processing " << bsp_header::entry_name[i]
             << " at " << offset << " (" << size << " bytes).\n";
*/      src.seekg(offset);
        if (src.fail()) throw "Bad offset in source file!\n";
        if (i==bsp_header::miptextures) /* miptexture bsp section */
        { int origin=dest.tellp();
          long numtex; read_image(numtex,src); write_image(numtex,dest);
          cout << howmany("Altering miptexure section with % miptexture(s).\n",numtex);
          long * miptexoffset=new long[numtex];
          src.read((char*)miptexoffset,numtex*sizeof(long));
          if (src.fail()) throw "Could not read miptexture directory!\n";
          dest.write((char*)miptexoffset,numtex*sizeof(long)); // fill in later
          for (int j=0; j<numtex; j++)
          { long & mo=miptexoffset[j];
            if (mo==-1)
            { cout << "Skipping blank slot.\n";
              continue;
            }
            src.seekg(mo+offset);
            if (src.fail()) throw "Bad miptexture offset in source file!\n";
            miptex mt(src);
            miptex_id mtid=(miptex_id)mt;
            mo=dest.tellp()-origin;
            if (mt.is_valid())
            { if (idx.has(mtid))
              { dest.write("r",1);
                write_image(mtid,dest);
                cout << "Removing " << mtid << "\n";
              } else
              { dest.write("k",1);
                mt.write_bytes(dest);
                cout << "Keeping " << mtid << "\n";
              }
            } else
            { dest.write("b",1);
              cout << "Ignored invalid miptexture.\n";
            }
          } /* for each miptexture */
          int finalpos=dest.tellp();
          dest.seekp(origin+sizeof(long));
          dest.write((char*)miptexoffset,numtex*sizeof(long));
          dest.seekp(finalpos);
          offset=origin;
          size=finalpos-origin;
          delete[] miptexoffset;
        } else /* ordinary bsp section */
        { char * buf=new char[size];
          src.read(buf,size);
          offset=dest.tellp();
          dest.write(buf,size);
        }
      } /* for each bsp section */
      dest.seekp(8);
      write_image(head,dest);
    }
    catch (char * i)
    { cout << "File error: " << i << "\n";
    }
    cout << "\n";
  } /* for each file */
  cout << "Done.\n";
};

void indexer::make_bsp(ostream & cout)
{ cout << "Building index.\n";
  idx.read_file(_argv[2],cout);
  for (int file=3; file<_argc; file++)
  { char name[260]; strcpy(name,_argv[file]);
    cout << "Processing: " << name << ".\n";
    try
    { if (!has_extension(name,".dst")) throw "Source file is not a DST!\n";
      ifstream src(name,ios::in | ios::nocreate | ios::binary);
      if (src.fail()) throw "Source file does not exist!\n";
      strcpy(name+strlen(name)-3,"bsp");
      cout << "Making BSP: " << name << ".\n";
      ofstream dest(name,ios::out | ios::noreplace | ios::binary);
      if (dest.fail()) throw "Destination already exists!\n";
      { char n[8]; src.read(n,8);
        if (strncmp(n,"KiserDST",8)!=0) throw  "Bad header on source file!\n";
      }
      bsp_header head(src);
      if (!head.is_valid() || src.fail()) throw "Source file is corrupt!\n";
      write_image(head,dest);
      for (int i=bsp_header::entities; i<bsp_header::END; i++)
      { long & size=head.entry[i].size;
        long & offset=head.entry[i].offset;
/*      cout << "Processing " << bsp_header::entry_name[i]
             << " at " << offset << " (" << size << " bytes).\n";
*/      src.seekg(offset);
        if (src.fail()) throw "Bad offset in source file!\n";
        if (i==bsp_header::miptextures) /* miptexture bsp section */
        { int origin=dest.tellp();
          long numtex; read_image(numtex,src); write_image(numtex,dest);
          cout << howmany("Restoring miptexure section with % miptexture(s).\n",numtex);
          long * miptexoffset=new long[numtex];
          src.read((char*)miptexoffset,numtex*sizeof(long));
          if (src.fail()) throw "Could not read miptexture directory!\n";
          dest.write((char*)miptexoffset,numtex*sizeof(long)); // fill in later
          for (int j=0; j<numtex; j++)
          { long & mo=miptexoffset[j];
            if (mo==-1)
            { cout << "Skipping blank slot.\n";
              continue;
            }
            src.seekg(mo+offset);
            if (src.fail()) throw "Bad miptexture offset in source file!\n";
            char what_happened; src.read(&what_happened,1);
            miptex mt; bool invalid=false;
            if (what_happened=='r')
            { miptex_id mtid; read_image(mtid,src);
              cout << "Replacing " << mtid << "\n";
              bool success=idx.get(mtid,mt);
              if (!success) throw "Miptexture did not read from index!\n";
            } else if (what_happened=='k')
            { mt=miptex(src);
              cout << "Keeping " << (miptex_id)mt << "\n";
            } else
            { assert(what_happened=='b');
              cout << "Ignoring invalid miptexture.\n";
              invalid=true;
            };
            mo=dest.tellp()-origin;
            if (!invalid) mt.write_bytes(dest);
            else
            { miptex_id bad;
              strncpy(bad.name,"originally bad",16);
              bad.width=-1; bad.height=-1;
              bad.clean();
              write_image(bad,dest);
            }
          } /* for each miptexture */
          int finalpos=dest.tellp();
          dest.seekp(origin+sizeof(long));
          dest.write((char*)miptexoffset,numtex*sizeof(long));
          dest.seekp(finalpos);
          offset=origin;
          size=finalpos-origin;
          delete[] miptexoffset;
        } else /* ordinary bsp section */
        { char * buf=new char[size];
          src.read(buf,size);
          offset=dest.tellp();
          dest.write(buf,size);
        }
      } /* for each bsp section */
      dest.seekp(0);
      write_image(head,dest);
    }
    catch (char * i)
    { cout << "File error: " << i << "\n";
    }
    cout << "\n";
  } /* for each file */
  cout << "Done.\n";
};
#endif
