#include "g_local.h"
#include "m_player.h"
#include "stdlog.h"	//	StdLog - Mark Davies

FILE *zbotfile = NULL;

int deas = 10;

void ClientUserinfoChanged (edict_t *ent, char *userinfo);
void SP_misc_teleporter_dest (edict_t *ent);
void WFRemoveDisguise(edict_t *ent);

//
// Gross, ugly, disgustuing hack section
//

// this function is an ugly as hell hack to fix some map flaws
//
// the coop spawn spots on some maps are SNAFU.  There are coop spots
// with the wrong targetname as well as spots with no name at all
//
// we use carnal knowledge of the maps to fix the coop spot targetnames to match
// that of the nearest named single player spot

static void SP_FixCoopSpots (edict_t *self)
{
	edict_t	*spot;
	vec3_t	d;

	spot = NULL;

	while(1)
	{
		spot = G_Find(spot, FOFS(classname), "info_player_start");
		if (!spot)
			return;
		if (!spot->targetname)
			continue;
		VectorSubtract(self->s.origin, spot->s.origin, d);
		if (VectorLength(d) < 384)
		{
			if ((!self->targetname) || stricmp(self->targetname, spot->targetname) != 0)
			{
//				gi.dprintf("FixCoopSpots changed %s at %s targetname from %s to %s\n", self->classname, vtos(self->s.origin), self->targetname, spot->targetname);
				self->targetname = spot->targetname;
			}
			return;
		}
	}
}

// now if that one wasn't ugly enough for you then try this one on for size
// some maps don't have any coop spots at all, so we need to create them
// where they should have been

static void SP_CreateCoopSpots (edict_t *self)
{
	edict_t	*spot;

	if(stricmp(level.mapname, "security") == 0)
	{
		spot = G_Spawn();
		spot->classname = "info_player_coop";
		spot->s.origin[0] = 188 - 64;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->targetname = "jail3";
		spot->s.angles[1] = 90;

		spot = G_Spawn();
		spot->classname = "info_player_coop";
		spot->s.origin[0] = 188 + 64;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->targetname = "jail3";
		spot->s.angles[1] = 90;

		spot = G_Spawn();
		spot->classname = "info_player_coop";
		spot->s.origin[0] = 188 + 128;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->targetname = "jail3";
		spot->s.angles[1] = 90;

		return;
	}
}


/*QUAKED info_player_start (1 0 0) (-16 -16 -24) (16 16 32)
The normal starting point for a level.
*/
void SP_info_player_start(edict_t *self)
{
	if (!coop->value)
		return;
	if(stricmp(level.mapname, "security") == 0)
	{
		// invoke one of our gross, ugly, disgusting hacks
		self->think = SP_CreateCoopSpots;
		self->nextthink = level.time + FRAMETIME;
	}
}

/*QUAKED info_player_deathmatch (1 0 1) (-16 -16 -24) (16 16 32)
potential spawning position for deathmatch games
*/
void SP_info_player_deathmatch(edict_t *self)
{
	if (!deathmatch->value)
	{
		G_FreeEdict (self);
		return;
	}
	SP_misc_teleporter_dest (self);
}

/*QUAKED info_player_coop (1 0 1) (-16 -16 -24) (16 16 32)
potential spawning position for coop games
*/

void SP_info_player_coop(edict_t *self)
{
	if (!coop->value)
	{
		G_FreeEdict (self);
		return;
	}

	if((stricmp(level.mapname, "jail2") == 0)   ||
	   (stricmp(level.mapname, "jail4") == 0)   ||
	   (stricmp(level.mapname, "mine1") == 0)   ||
	   (stricmp(level.mapname, "mine2") == 0)   ||
	   (stricmp(level.mapname, "mine3") == 0)   ||
	   (stricmp(level.mapname, "mine4") == 0)   ||
	   (stricmp(level.mapname, "lab") == 0)     ||
	   (stricmp(level.mapname, "boss1") == 0)   ||
	   (stricmp(level.mapname, "fact3") == 0)   ||
	   (stricmp(level.mapname, "biggun") == 0)  ||
	   (stricmp(level.mapname, "space") == 0)   ||
	   (stricmp(level.mapname, "command") == 0) ||
	   (stricmp(level.mapname, "power2") == 0) ||
	   (stricmp(level.mapname, "strike") == 0))
	{
		// invoke one of our gross, ugly, disgusting hacks
		self->think = SP_FixCoopSpots;
		self->nextthink = level.time + FRAMETIME;
	}
}


/*QUAKED info_player_intermission (1 0 1) (-16 -16 -24) (16 16 32)
The deathmatch intermission point will be at one of these
Use 'angles' instead of 'angle', so you can set pitch or roll as well as yaw.  'pitch yaw roll'
*/
void SP_info_player_intermission(void)
{
}


/*QUAKED info_position (1 0 1) (-16 -16 -24) (16 16 32)
Used to describe the location within a map
Use 'angles' instead of 'angle', so you can set pitch or roll as well as yaw.  'pitch yaw roll'
*/
void SP_info_position(edict_t *ent)
{
/*
	gi.dprintf("DEBUG (Spawned info_position) Classname = %s\n", ent->classname);
	if 	(ent->message && ent->message[0]) 
		gi.dprintf("DEBUG (info_position) Message = %s\n", ent->message);
*/  

}

//=======================================================================


void player_pain (edict_t *self, edict_t *other, float kick, int damage)
{
	// player pain is handled at the end of the frame in P_DamageFeedback
}


qboolean IsFemale (edict_t *ent)
{
	char		*info;

	if (!ent->client)
		return false;

	//WF - This depends on if player classes are used
	if ((ent->client) && (((int)wfflags->value & WF_NO_PLAYER_CLASSES)  == 0))
	{
		if (ent->client->player_model == CLASS_MODEL_FEMALE)
			return true;
		else
			return false;
	}

	info = Info_ValueForKey (ent->client->pers.userinfo, "skin");
	if (info[0] == 'f' || info[0] == 'F')
		return true;
	return false;
}

//WF
qboolean IsCyborg (edict_t *ent)
{

	char		*info;

	if (!ent->client)
		return false;

	//This depends on if player classes are used
	if ((ent->client) && (((int)wfflags->value & WF_NO_PLAYER_CLASSES)  == 0))
	{
		if (ent->client->player_model == CLASS_MODEL_CYBORG)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	info = Info_ValueForKey (ent->client->pers.userinfo, "skin");
	if (info[0] == 'c' || info[0] == 'C')
	{
		return true;
	}

	return false;
}
//WF

void ClientObituary (edict_t *self, edict_t *inflictor, edict_t *atk)
{
	int			mod;
	char		*message;
	char		*message2;
	qboolean	ff;
	edict_t *attacker;

	qboolean special_message;

	special_message = false;

	attacker = atk;

	//If this is a death by sentry gun, then the attacker's owner
	//is the real attacker
	if ((atk->creator) &&(!atk->client) && (meansOfDeath == MOD_SENTRY || meansOfDeath == MOD_SENTRY_ROCKET || meansOfDeath == MOD_SHRAPNEL || meansOfDeath == MOD_PELLET) )
		attacker = atk->creator;

	if (coop->value && attacker->client)
		meansOfDeath |= MOD_FRIENDLY_FIRE;

	if (deathmatch->value || coop->value)
	{
		ff = meansOfDeath & MOD_FRIENDLY_FIRE;
		mod = meansOfDeath & ~MOD_FRIENDLY_FIRE;
		message = NULL;
		message2 = "";

		switch (mod)
		{
		case MOD_SUICIDE:
			message = "suicides";
			break;
		case MOD_FALLING:
			message = "cratered";
			break;
		case MOD_CRUSH:
			message = "was squished";
			break;
		case MOD_WATER:
			message = "sank like a rock";
			break;
		case MOD_SLIME:
			message = "melted";
			break;
		case MOD_LAVA:
			message = "does a back flip into the lava";
			break;
		case MOD_EXPLOSIVE:
		case MOD_BARREL:
			message = "blew up";
			break;
		case MOD_EXIT:
			message = "found a way out";
			break;
		case MOD_TARGET_LASER:
			message = "saw the light";
			break;
		case MOD_TARGET_BLASTER:
			message = "got blasted";
			break;
		case MOD_BOMB:
		case MOD_SPLASH:
		case MOD_TRIGGER_HURT:
			message = "was in the wrong place";
			break;
		}

		if (attacker == self)
		{
			switch (mod)
			{
			case MOD_HELD_GRENADE:
				message = "tried to put the pin back in";
				break;
			case MOD_HG_SPLASH:
			case MOD_G_SPLASH:
				if (IsFemale(self))
					message = "tripped on her own grenade";
				else
					message = "tripped on his own grenade";
				break;
			case MOD_R_SPLASH:
				if (IsFemale(self))
					message = "blew herself up";
				else
					message = "blew himself up";
				break;
			case MOD_BFG_BLAST:
				message = "should have used a smaller gun";
				break;
			default:
				if (IsFemale(self))
					message = "killed herself";
				else
					message = "killed himself";
				special_message = true;
				break;
			}
		}
		if (message)
		{
			gi.bprintf (PRINT_MEDIUM, "%s %s.\n", self->client->pers.netname, message);
			if (deathmatch->value)
				self->client->resp.score--;
			self->enemy = NULL;
			sl_LogScore( &gi, self->client->pers.netname, "", "Suicide",mod,-1 );	// StdLog 

			if (special_message)
			{
//                                gi.cprintf(self, PRINT_HIGH, "[YOU KILLED YOURSELF: ");
//                                if ((inflictor) && (inflictor->classname))
//                                        gi.cprintf(self, PRINT_HIGH, " item=%s",inflictor->classname);
//                                gi.cprintf(self, PRINT_HIGH, "]\n");
			}

			return;

		}

		self->enemy = attacker;
		if (attacker && attacker->client)
		{
			switch (mod)
			{
			case MOD_BLASTER:
				message = "was blasted by";
				break;
			case MOD_SHOTGUN:
				message = "was gunned down by";
				break;
			case MOD_SSHOTGUN:
				message = "was blown away by";
				message2 = "'s super shotgun";
				break;
			case MOD_MACHINEGUN:
				message = "was machinegunned by";
				break;
			case MOD_CHAINGUN:
				message = "was cut in half by";
				message2 = "'s chaingun";
				break;
			case MOD_GRENADE:
				message = "was popped by";
				message2 = "'s grenade";
				break;
			case MOD_G_SPLASH:
				message = "was shredded by";
				message2 = "'s shrapnel";
				break;
			case MOD_ROCKET:
				message = "ate";
				message2 = "'s rocket";
				break;
			case MOD_HOMINGROCKET:
				message = "was slammed";
				message2 = "'s homing rocket";
				break;
			case MOD_R_SPLASH:
				message = "almost dodged";
				message2 = "'s rocket";
				break;
			case MOD_HYPERBLASTER:
				message = "was melted by";
				message2 = "'s hyperblaster";
				break;
			case MOD_RAILGUN:
				message = "was railed by";
				break;
			case MOD_BFG_LASER:
				message = "saw the pretty lights from";
				message2 = "'s BFG";
				break;
			case MOD_BFG_BLAST:
				message = "was disintegrated by";
				message2 = "'s BFG blast";
				break;
			case MOD_BFG_EFFECT:
				message = "couldn't hide from";
				message2 = "'s BFG";
				break;
			case MOD_HANDGRENADE:
				message = "caught";
				message2 = "'s handgrenade";
				break;
			case MOD_HG_SPLASH:
				message = "didn't see";
				message2 = "'s handgrenade";
				break;
			case MOD_HELD_GRENADE:
				message = "feels";
				message2 = "'s pain";
				break;
			case MOD_TELEFRAG:
				message = "tried to invade";
				message2 = "'s personal space";
				break;
//ZOID
			case MOD_GRAPPLE:
				message = "was caught by";
				message2 = "'s grapple";
				break;
//ZOID

//WF
			case MOD_WF_LASERBALL:
				message = "was fried by";
				message2 = "'s laserball";
				break;

			case MOD_WF_GOODYEAR:
				message = "was popped by";
				message2 = "'s goodyear grenade";
				break;

			case MOD_WF_PROXIMITY:
				message = "swallowed";
				message2 = "'s proximity grenade";
				break;

			case MOD_WF_CLUSTER:
				message = "was ripped by";
				message2 = "'s cluster grenade";
				break;

			case MOD_WF_PIPEBOMB:
				message = "fell for";
				message2 = "'s pipebomb";
				break;

			case MOD_WF_EARTHQUAKE:
				message = "was shaken by";
				message2 = "'s earthquake";
				break;

			case MOD_WF_FLAME:
				message = "was burned by";
				message2 = "'s flame";
				break;

			case MOD_FLAMETHROWER:
				message = "was chared by";
				message2 = "'s flamethrower";
				break;

			case MOD_REVERSE_TELEFRAG:
				message = "was reverse telefragged by";
				break;
			case MOD_NAG:
				message = "was NAGed to death by";
				break;
			case MOD_SHRAPNEL:
				message = "was pithed by";
				message2 = "'s shrapnel grenade";
				break;
			case MOD_CLUSTERROCKET:
				message = "was splattered by";
				message2 = "'s cluster rocket";
				break;
			case MOD_DISEASE:
				message = "died from";
				message2 = "'s disease";
				break;

			case MOD_SNIPERRIFLE:
				message = "was slaughtered by";
				message2 = "'s sniper rifle";
				break;
			case MOD_SNIPERRIFLE_LEG:
				message = "had their legs shot out by";
				message2 = "'s sniper rifle";
				break;
			case MOD_SNIPERRIFLE_HEAD:
				message = "had his head blown off by";
				message2 = "'s sniper rifle";
				break;

			case MOD_SHC:
				message = "burst into flames from";
				message2 = "'s SHC rifle";
				break;

			case MOD_NEEDLER:
				message = "was needled by";
				break;

			case MOD_CONCUSSION:
				message = "lost his head from";
				message2 = "'s concussion grenade";
				break;

			case MOD_ARMORDART:
				message = "was pierced by";
				message2 = "'s dart";
				break;

			case MOD_INFECTEDDART:
				message = "was infected by";
				message2 = "'s dart";
				break;

			case MOD_NAPALMROCKET:
				message = "was smoked by";
				message2 = "'s napalm rocket";
				break;
			case MOD_NAPALMGRENADE:
				message = "got crispy from";
				message2 = "'s napalm grenade";
				break;

			case MOD_LIGHTNING:
				message = "saw lightning from";
				message2 = "'s lightning gun";
				break;

			case MOD_TELSA:
				message = "was exposed to";
				message2 = "'s telsa coil";
				break;

			case MOD_MAGNOTRON:
				message = "was sucked into";
				message2 = "'s magnotron";
				break;

			case MOD_SHOCK:
				message = "was shocked by";
				break;

			case MOD_PELLET:
				message = "was pelleted by";
				break;

			case MOD_FLAREGUN:
				message = "was embarassed to be toasted by";
				message2 = "'s flare gun";
				break;

			case MOD_FLARE:
				message = "was snuffed by";
				message2 = "'s flare";
				break;

			case MOD_TRANQUILIZER:
				message = "slowed to a stop from";
				message2 = "'s tranquilizer";
				break;

			case MOD_LRPROJECTILE:
				message = "was blasted by";
				message2 = "'s LR Projectile Launcher";
				break;

			case MOD_BOLTEDBLASTER:
				message = "expired from";
				message2 = "'s bolted blaster";
				break;

			case MOD_WF_TURRET:
				message="caught Turret's Syndrome from";
				message2="'s Turret Grenade.";
				break;

			case MOD_PLASMABOMB:
				message = "was vaporized by";
				break;
			case MOD_NAIL:
				message = "was nailed by";
				//message2 = "";
				break;
			case MOD_MBPC:
				message = "was disintegrated by";
				message2 = "'s Pulse Cannon";
				break;
			case MOD_SENTRY:
				message = "was laid low by";
				message2 = "'s Sentry Gun";
				break;
			case MOD_SENTRY_ROCKET:
				message = "was liquidated by";
				message2 = "'s Sentry Gun Rocket";
				break;
			case MOD_KAMIKAZE:
				message = "didn't survive";
				message2 = "'s Kamikaze run";
				break;
			case MOD_TRANQUILIZERDART:
				message = "did not escape";
				message2 = "'s tranquilizer dart";
				break;
			case MOD_DEPOT:
				message = "was blown to bits by";
				message2 = "'s supply depot";
				break;
			case MOD_HEALINGDEPOT:
				message = "was blown to bits by";
				message2 = "'s healing depot";
				break;
			case MOD_MEGACHAINGUN:
				message = "was cut to ribbons";
				message2 = "'s mega chaingun";
				break;
			case MOD_SENTRYKILLER:
				message = "got in the way of ";
				message2 = "'s Sentry Killer Rocket";
				break;

			case MOD_KNIFE:
                                message = "was punctured by";
				message2 = "'s knife";
				break;
			case MOD_KNIFEBACK:
				message = "was stabbed in the back by";
				message2 = "'s knife";
				break;

			case MOD_LASERCUTTER:
				message = "was sliced and diced by";
				message2 = "'s laser cutter grenade";
				break;

			case MOD_TARGET_LASER:
				message = "saw";
				message2 = "'s light";
				break;
//WF
			}
			if (message)
			{
				gi.bprintf (PRINT_MEDIUM,"%s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
				if (deathmatch->value)
				{
				if (ff)
				{
					attacker->client->resp.score--;
					sl_LogScore( &gi, attacker->client->pers.netname, self->client->pers.netname, "Friendly Fire",mod,-1 );	// StdLog - Mark Davies
				}
				else
				{
					attacker->client->resp.score++;
					sl_LogScore( &gi, attacker->client->pers.netname, self->client->pers.netname, "Kill",mod,1 );	// StdLog - Mark Davies
				}
			}
			return;
		}
	}
	}

	gi.bprintf (PRINT_MEDIUM,"%s died.\n", self->client->pers.netname);

//        gi.cprintf(self, PRINT_HIGH, "[YOU WERE KILLED WITH: ");
//      if ((inflictor) && (inflictor->classname))
//                gi.cprintf(self, PRINT_HIGH, " %s",inflictor->classname);
//        if ((attacker) && (attacker->client) && (attacker->client->pers.netname))
//                gi.cprintf(self, PRINT_HIGH, " BY %s",attacker->client->pers.netname);
//        gi.cprintf(self, PRINT_HIGH, "]\n");

	if (deathmatch->value)
	self->client->resp.score--;
}


void Touch_Item (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);

void TossClientWeapon (edict_t *self)
{
	gitem_t		*item;
	edict_t		*drop;
	qboolean	quad;
	float		spread;

	if (!deathmatch->value)
		return;

//WF  If player classes are on, don't drop a weapon
	if (self->client && (((int)wfflags->value & WF_NO_PLAYER_CLASSES) == 0))
		return;
//WF

	item = self->client->pers.weapon;
	if (! self->client->pers.inventory[self->client->ammo_index] )
		item = NULL;
	if (item && (strcmp (item->pickup_name, "Blaster") == 0))
		item = NULL;

	if (!((int)(dmflags->value) & DF_QUAD_DROP))
		quad = false;
	else
		quad = (self->client->quad_framenum > (level.framenum + 10));

	if (item && quad)
		spread = 22.5;
	else
		spread = 0.0;

	if (item)
	{
		self->client->v_angle[YAW] -= spread;
		drop = Drop_Item (self, item);
		self->client->v_angle[YAW] += spread;
		drop->spawnflags = DROPPED_PLAYER_ITEM;
	}

	if (quad)
	{
		self->client->v_angle[YAW] += spread;
		drop = Drop_Item (self, FindItemByClassname ("item_quad"));
		self->client->v_angle[YAW] -= spread;
		drop->spawnflags |= DROPPED_PLAYER_ITEM;

		drop->touch = Touch_Item;
		drop->nextthink = level.time + (self->client->quad_framenum - level.framenum) * FRAMETIME;
		drop->think = G_FreeEdict;
	}
}


/*
==================
LookAtKiller
==================
*/
void LookAtKiller (edict_t *self, edict_t *inflictor, edict_t *attacker)
{
	vec3_t		dir;

	if (attacker && attacker != world && attacker != self)
	{
		VectorSubtract (attacker->s.origin, self->s.origin, dir);
	}
	else if (inflictor && inflictor != world && inflictor != self)
	{
		VectorSubtract (inflictor->s.origin, self->s.origin, dir);
	}
	else
	{
		self->client->killer_yaw = self->s.angles[YAW];
		return;
	}

	self->client->killer_yaw = 180/M_PI*atan2(dir[1], dir[0]);
}

/*
==================
player_die
==================
*/
void player_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	int		n;

	//Reset fov if autozoom was on
	if (self->client->pers.autozoom)
	{
		self->client->ps.fov = 90;
		self->PlayerSnipingZoom = 0;
	}

	//Free laser sight
	if ( self->lasersight ) 
	{    
		G_FreeEdict(self->lasersight);   
		self->lasersight = NULL;
	}


	WFPlayer_Die (self);

	Kamikaze_Cancel(self);			

	VectorClear (self->avelocity);

	self->takedamage = DAMAGE_YES;
	self->movetype = MOVETYPE_TOSS;

	self->s.modelindex2 = 0;	// remove linked weapon model
//ZOID
	self->s.modelindex3 = 0;	// remove linked ctf flag
//ZOID

	self->s.angles[0] = 0;
	self->s.angles[2] = 0;

	self->s.sound = 0;
	self->client->weapon_sound = 0;

	self->maxs[2] = -8;

//	self->solid = SOLID_NOT;
	self->svflags |= SVF_DEADMONSTER;

	if (!self->deadflag)
	{
		self->client->respawn_time = level.time + 1.0;
		LookAtKiller (self, inflictor, attacker);
		self->client->ps.pmove.pm_type = PM_DEAD;
		ClientObituary (self, inflictor, attacker);
//ZOID
		CTFFragBonuses(self, inflictor, attacker);
//ZOID
		TossClientWeapon (self);
//ZOID
		CTFPlayerResetGrapple(self);
		CTFDeadDropFlag(self);
		CTFDeadDropTech(self);
//ZOID
		if (deathmatch->value && !self->client->showscores)
			Cmd_Help_f (self);		// show scores
	}

	// remove powerups
	self->client->quad_framenum = 0;
	self->client->invincible_framenum = 0;
	self->client->breather_framenum = 0;
	self->client->enviro_framenum = 0;

	// clear inventory
	memset(self->client->pers.inventory, 0, sizeof(self->client->pers.inventory));

//WF & ATTILA begin
	if ( Jet_Active(self) )
	{
		Jet_BecomeExplosion( self, damage );
		/*stop jetting when dead*/
		self->client->Jet_framenum = 0;
	}
//WF & ATTILA

	if (self->health < -40)
	{	// gib
		gi.sound (self, CHAN_BODY, gi.soundindex ("misc/udeath.wav"), 1, ATTN_NORM, 0);
		for (n= 0; n < 4; n++)
			ThrowGib (self, "models/objects/gibs/sm_meat/tris.md2", damage, GIB_ORGANIC);
		ThrowClientHead (self, damage);
//ZOID
		self->client->anim_priority = ANIM_DEATH;
		self->client->anim_end = 0;
//ZOID
		self->takedamage = DAMAGE_NO;
	}
	else
	{	// normal death
		if (!self->deadflag)
		{
			static int i;

			i = (i+1)%3;
			// start a death animation
			self->client->anim_priority = ANIM_DEATH;
			if (self->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				self->s.frame = FRAME_crdeath1-1;
				self->client->anim_end = FRAME_crdeath5;
			}
			else switch (i)
			{
			case 0:
				self->s.frame = FRAME_death101-1;
				self->client->anim_end = FRAME_death106;
				break;
			case 1:
				self->s.frame = FRAME_death201-1;
				self->client->anim_end = FRAME_death206;
				break;
			case 2:
				self->s.frame = FRAME_death301-1;
				self->client->anim_end = FRAME_death308;
				break;
			}
			gi.sound (self, CHAN_VOICE, gi.soundindex(va("*death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
		}
	}

	self->deadflag = DEAD_DEAD;

	gi.linkentity (self);
}

//=======================================================================

/*
==============
InitClientPersistant

This is only called when the game first initializes in single player,
but is called after each death and level change in deathmatch
==============
*/
void InitClientPersistant (gclient_t *client)
{
	gitem_t		*item;
	int			i;
	int			HasVoted = client->pers.HasVoted;
	int			tmpGrenade[GRENADE_TYPE_COUNT + 1];
	int			tmpSpecial[SPECIAL_COUNT + 1];
    qboolean	homing_state = client->pers.homing_state;
	int			laseron = client->pers.laseron;
	int			autozoom = client->pers.autozoom;
	int			fastaim = client->pers.fastaim;
	int			nospam_level = client->pers.nospam_level;
	qboolean	autoconfig = client->pers.autoconfig;

	//Save grenade and special counts
	for (i=1; i <= GRENADE_TYPE_COUNT; ++i)
	{
		tmpGrenade[i] = client->pers.active_grenades[i];
	}

	for (i=1; i <= SPECIAL_COUNT; ++i)
		tmpSpecial[i] = client->pers.active_special[i];

	memset (&client->pers, 0, sizeof(client->pers));

	//Restore grenade and special counts
	for (i=1; i <= GRENADE_TYPE_COUNT; ++i)
	{
		if (tmpGrenade[i] < 0) tmpGrenade[i] = 0;
		client->pers.active_grenades[i] = tmpGrenade[i];
	}

	for (i=1; i <= SPECIAL_COUNT; ++i)
		client->pers.active_special[i] = tmpSpecial[i];


	item = FindItem("Blaster");
	client->pers.selected_item = ITEM_INDEX(item);
	client->pers.inventory[client->pers.selected_item] = 1;

	client->pers.weapon = item;
//ZOID
	client->pers.lastweapon = item;
//ZOID


	client->pers.health			= 100;
	client->pers.max_health		= 100;

	client->pers.connected = true;

	// WF & CCH: reset homing_state
	client->pers.HasVoted = HasVoted;

    client->pers.homing_state = homing_state;
	client->pers.laseron = laseron;
	client->pers.autozoom = autozoom;
	client->pers.fastaim = fastaim;
	client->pers.nospam_level = nospam_level;
	client->pers.autoconfig = autoconfig;

	// Initialize grenade type
	client->pers.grenade_num    = 1;
	client->pers.grenade_type    = GRENADE_TYPE_NORMAL;
	if (((int)wfflags->value & WF_NO_PLAYER_CLASSES)  == 0) 
		client->pers.grenade_type = client->grenade_type1;

    // Scanner
	//ClearScanner(client);

}


void InitClientResp (gclient_t *client)
{
//	int i;
	int ctf_team = client->resp.ctf_team;

	int player_class = client->resp.next_player_class;

	memset (&client->resp, 0, sizeof(client->resp));
	
	client->resp.ctf_team = ctf_team;
	client->resp.next_player_class = player_class;

	client->resp.enterframe = level.framenum;
	client->resp.coop_respawn = client->pers;
 
//ZOID
	if (ctf->value && client->resp.ctf_team < CTF_TEAM1)
		CTFAssignTeam(client);
//ZOID
}

/*
==================
SaveClientData

Some information that should be persistant, like health, 
is still stored in the edict structure, so it needs to
be mirrored out to the client structure before all the
edicts are wiped.
==================
*/
void SaveClientData (void)
{
	int		i;
	edict_t	*ent;

	for (i=0 ; i<game.maxclients ; i++)
	{
		ent = &g_edicts[1+i];
		if (!ent->inuse)
			continue;
		game.clients[i].pers.health = ent->health;
		game.clients[i].pers.max_health = ent->max_health;
		game.clients[i].pers.powerArmorActive = (ent->flags & FL_POWER_ARMOR);
		if (coop->value)
			game.clients[i].pers.score = ent->client->resp.score;
	}
}

void FetchClientEntData (edict_t *ent)
{
	ent->health = ent->client->pers.health;
	ent->max_health = ent->client->pers.max_health;
	if (ent->client->pers.powerArmorActive)
		ent->flags |= FL_POWER_ARMOR;
	if (coop->value)
		ent->client->resp.score = ent->client->pers.score;
}



/*
=======================================================================

  SelectSpawnPoint

=======================================================================
*/

/*
================
PlayersRangeFromSpot

Returns the distance to the nearest player from the given spot
================
*/
float	PlayersRangeFromSpot (edict_t *spot)
{
	edict_t	*player;
	float	bestplayerdistance;
	vec3_t	v;
	int		n;
	float	playerdistance;


	bestplayerdistance = 9999999;

	for (n = 1; n <= maxclients->value; n++)
	{
		player = &g_edicts[n];

		if (!player->inuse)
			continue;

		if (player->health <= 0)
			continue;

		VectorSubtract (spot->s.origin, player->s.origin, v);
		playerdistance = VectorLength (v);

		if (playerdistance < bestplayerdistance)
			bestplayerdistance = playerdistance;
	}

	return bestplayerdistance;
}

/*
================
SelectRandomDeathmatchSpawnPoint

go to a random point, but NOT the two points closest
to other players
================
*/
edict_t *SelectRandomDeathmatchSpawnPoint (void)
{
	edict_t	*spot, *spot1, *spot2;
	int		count = 0;
	int		selection;
	float	range, range1, range2;

	spot = NULL;
	range1 = range2 = 99999;
	spot1 = spot2 = NULL;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		count++;
		range = PlayersRangeFromSpot(spot);
		if (range < range1)
		{
			range1 = range;
			spot1 = spot;
		}
		else if (range < range2)
		{
			range2 = range;
			spot2 = spot;
		}
	}

	if (!count)
		return NULL;

	if (count <= 2)
	{
		spot1 = spot2 = NULL;
	}
	else
		count -= 2;

	selection = rand() % count;

	spot = NULL;
	do
	{
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
		if (spot == spot1 || spot == spot2)
			selection++;
	} while(selection--);

	return spot;
}

/*
================
SelectFarthestDeathmatchSpawnPoint

================
*/
edict_t *SelectFarthestDeathmatchSpawnPoint (void)
{
	edict_t	*bestspot;
	float	bestdistance, bestplayerdistance;
	edict_t	*spot;


	spot = NULL;
	bestspot = NULL;
	bestdistance = 0;
	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		bestplayerdistance = PlayersRangeFromSpot (spot);

		if (bestplayerdistance > bestdistance)
		{
			bestspot = spot;
			bestdistance = bestplayerdistance;
		}
	}

	if (bestspot)
	{
		return bestspot;
	}

	// if there is a player just spawned on each and every start spot
	// we have no choice to turn one into a telefrag meltdown
	spot = G_Find (NULL, FOFS(classname), "info_player_deathmatch");

	return spot;
}

edict_t *SelectDeathmatchSpawnPoint (void)
{
	if ( (int)(dmflags->value) & DF_SPAWN_FARTHEST)
		return SelectFarthestDeathmatchSpawnPoint ();
	else
		return SelectRandomDeathmatchSpawnPoint ();
}


edict_t *SelectCoopSpawnPoint (edict_t *ent)
{
	int		index;
	edict_t	*spot = NULL;
	char	*target;

	index = ent->client - game.clients;

	// player 0 starts in normal player spawn point
	if (!index)
		return NULL;

	spot = NULL;

	// assume there are four coop spots at each spawnpoint
	while (1)
	{
		spot = G_Find (spot, FOFS(classname), "info_player_coop");
		if (!spot)
			return NULL;	// we didn't have enough...

		target = spot->targetname;
		if (!target)
			target = "";
		if ( Q_stricmp(game.spawnpoint, target) == 0 )
		{	// this is a coop spawn point for one of the clients here
			index--;
			if (!index)
				return spot;		// this is it
		}
	}


	return spot;
}


/*
===========
SelectSpawnPoint

Chooses a player start, deathmatch start, coop start, etc
============
*/
void	SelectSpawnPoint (edict_t *ent, vec3_t origin, vec3_t angles)
{
	edict_t	*spot = NULL;

	if (deathmatch->value)
//ZOID
		if (ctf->value)
			spot = SelectCTFSpawnPoint(ent);
		else
//ZOID
			spot = SelectDeathmatchSpawnPoint ();
	else if (coop->value)
		spot = SelectCoopSpawnPoint (ent);

	// find a single player start spot
	if (!spot)
	{
//		gi.dprintf("DEBUG - No CTF Spawn Point.\n");
		while ((spot = G_Find (spot, FOFS(classname), "info_player_start")) != NULL)
		{
			if (!game.spawnpoint[0] && !spot->targetname)
				break;

			if (!game.spawnpoint[0] || !spot->targetname)
				continue;

			if (Q_stricmp(game.spawnpoint, spot->targetname) == 0)
				break;
		}

		if (!spot)
		{
//			gi.dprintf("DEBUG - No Spawn Point Without Target.\n");
			if (!game.spawnpoint[0])
			{	// there wasn't a spawnpoint without a target, so use any
				spot = G_Find (spot, FOFS(classname), "info_player_start");
			}
			if (!spot)
				gi.error ("Couldn't find spawn point %s\n", game.spawnpoint);
		}
	}

	VectorCopy (spot->s.origin, origin);
	origin[2] += 9;
	VectorCopy (spot->s.angles, angles);
}

//======================================================================


void InitBodyQue (void)
{
	int		i;
	edict_t	*ent;

	level.body_que = 0;
	for (i=0; i<BODY_QUEUE_SIZE ; i++)
	{
		ent = G_Spawn();
		ent->classname = "bodyque";
	}
}

void body_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	int	n;

	if (self->health < -40)
	{
		gi.sound (self, CHAN_BODY, gi.soundindex ("misc/udeath.wav"), 1, ATTN_NORM, 0);
		for (n= 0; n < 4; n++)
			ThrowGib (self, "models/objects/gibs/sm_meat/tris.md2", damage, GIB_ORGANIC);
		self->s.origin[2] -= 48;
		ThrowClientHead (self, damage);
		self->takedamage = DAMAGE_NO;
	}
}

void CopyToBodyQue (edict_t *ent)
{
	edict_t		*body;


	// grab a body que and cycle to the next one
	body = &g_edicts[(int)maxclients->value + level.body_que + 1];
	level.body_que = (level.body_que + 1) % BODY_QUEUE_SIZE;

	// FIXME: send an effect on the removed body

	gi.unlinkentity (ent);

	gi.unlinkentity (body);
	body->s = ent->s;
	body->s.number = body - g_edicts;

	body->svflags = ent->svflags;
	VectorCopy (ent->mins, body->mins);
	VectorCopy (ent->maxs, body->maxs);
	VectorCopy (ent->absmin, body->absmin);
	VectorCopy (ent->absmax, body->absmax);
	VectorCopy (ent->size, body->size);
	body->solid = ent->solid;
	body->clipmask = ent->clipmask;
	body->owner = ent->owner;
	body->movetype = ent->movetype;

	body->die = body_die;
	body->takedamage = DAMAGE_YES;

	gi.linkentity (body);
}


void respawn (edict_t *self)
{
	if (deathmatch->value || coop->value)
	{
		CopyToBodyQue (self);
		PutClientInServer (self);

		// add a teleportation effect
		self->s.event = EV_PLAYER_TELEPORT;

		// hold in place briefly
		self->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
		self->client->ps.pmove.pm_time = 14;

		self->client->respawn_time = level.time;

		return;
	}

	// restart the entire server
	gi.AddCommandString ("menu_loadgame\n");
}

//==============================================================

// WF: Weapons Factory user setup */
static void WFClientSetup (edict_t *ent)
{
	int i;

    //Set aliases required for mod
	stuffcmd(ent,"alias +thrust \"cmd thrust on\"\n");
	stuffcmd(ent,"alias -thrust \"cmd thrust off\"\n");
	stuffcmd(ent,"alias +rzoom \"fov 30;+mlook\"\n");
	stuffcmd(ent,"alias -rzoom \"fov 90;-mlook\"\n");
	//stuffcmd(ent,"alias wfhelp \"cmd wfhelp\"\n");
	//stuffcmd(ent,"alias vote \"cmd vote\"\n");

	//FORCE SOME BINDS
//	stuffcmd(ent,"bind \";\" cmd special\n");
//	stuffcmd(ent,"bind v +thrust\n");
//	stuffcmd(ent,"bind b cmd grenade\n");

	//note - removed mlook from rzoom command

	//Clear grenade and special item limits
	for (i=1; i <= GRENADE_TYPE_COUNT; ++i)
		ent->client->pers.active_grenades[i] = 0;

	for (i=1; i <= SPECIAL_COUNT; ++i)
		ent->client->pers.active_special[i] = 0;

}
//WF

/*
===========
PutClientInServer

Called when a player connects to a server or respawns in
a deathmatch.
============
*/

void PutClientInServer (edict_t *ent)
{
	vec3_t	mins = {-16, -16, -24};
	vec3_t	maxs = {16, 16, 32};
	int		index;
	vec3_t	spawn_origin, spawn_angles;
	gclient_t	*client;
	int		i;
	client_persistant_t	saved;
	client_respawn_t	resp;
	int pclass_curr;             //temp variable for player classes
	int pclass_next;             //temp variable for player classes

	//don't know why this isn't persistant, so save it
	pclass_next = ent->client->resp.next_player_class;
	pclass_curr = ent->client->player_class;
	
	// find a spawn point
	// do it before setting health back up, so farthest
	// ranging doesn't count this client
	SelectSpawnPoint (ent, spawn_origin, spawn_angles);

	index = ent-g_edicts-1;
	client = ent->client;

	// deathmatch wipes most client data every spawn
	if (deathmatch->value)
	{
		char		userinfo[MAX_INFO_STRING];

		resp = client->resp;
		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
		InitClientPersistant (client);
		ClientUserinfoChanged (ent, userinfo);
	}
	else if (coop->value)
	{
		int			n;
		char		userinfo[MAX_INFO_STRING];

		resp = client->resp;
		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
		// this is kind of ugly, but it's how we want to handle keys in coop
		for (n = 0; n < MAX_ITEMS; n++)
		{
			if (itemlist[n].flags & IT_KEY)
				resp.coop_respawn.inventory[n] = client->pers.inventory[n];
		}
		client->pers = resp.coop_respawn;
		ClientUserinfoChanged (ent, userinfo);
		if (resp.score > client->pers.score)
			client->pers.score = resp.score;
	}
	else
	{
		memset (&resp, 0, sizeof(resp));
	}

	// clear everything but the persistant data
	saved = client->pers;
	memset (client, 0, sizeof(*client));
	client->pers = saved;
	if (client->pers.health <= 0)
		InitClientPersistant(client);
	client->resp = resp;

	// copy some data from the client to the entity
	FetchClientEntData (ent);

	// clear entity values
	ent->groundentity = NULL;
	ent->client = &game.clients[index];
	ent->takedamage = DAMAGE_AIM;
	ent->movetype = MOVETYPE_WALK;
	ent->viewheight = 22;
	ent->inuse = true;
	ent->classname = "player";
	ent->mass = 200;
	ent->solid = SOLID_BBOX;
	ent->deadflag = DEAD_NO;
	ent->air_finished = level.time + 12;
	ent->clipmask = MASK_PLAYERSOLID;
	ent->model = "players/male/tris.md2";
	ent->pain = player_pain;
	ent->die = player_die;
	ent->waterlevel = 0;
	ent->watertype = 0;
	ent->flags &= ~FL_NO_KNOCKBACK;
	ent->svflags &= ~SVF_DEADMONSTER;

	VectorCopy (mins, ent->mins);
	VectorCopy (maxs, ent->maxs);
	VectorClear (ent->velocity);

	// clear playerstate values
	memset (&ent->client->ps, 0, sizeof(client->ps));

	client->ps.pmove.origin[0] = spawn_origin[0]*8;
	client->ps.pmove.origin[1] = spawn_origin[1]*8;
	client->ps.pmove.origin[2] = spawn_origin[2]*8;
//ZOID
	client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
//ZOID

	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		client->ps.fov = 90;
	}
	else
	{
		client->ps.fov = atoi(Info_ValueForKey(client->pers.userinfo, "fov"));
		if (client->ps.fov < 1)
			client->ps.fov = 90;
		else if (client->ps.fov > 160)
			client->ps.fov = 160;
	}

	client->ps.gunindex = gi.modelindex(client->pers.weapon->view_model);

	// clear entity state values
	ent->s.effects = 0;
	ent->s.skinnum = ent - g_edicts - 1;
	ent->s.modelindex = 255;		// will use the skin specified model
	ent->s.modelindex2 = 255;		// custom gun model
	ent->s.frame = 0;
	VectorCopy (spawn_origin, ent->s.origin);
	ent->s.origin[2] += 1;	// make sure off ground
	VectorCopy (ent->s.origin, ent->s.old_origin);

	// set the delta angle
	for (i=0 ; i<3 ; i++)
		client->ps.pmove.delta_angles[i] = ANGLE2SHORT(spawn_angles[i] - client->resp.cmd_angles[i]);

	ent->s.angles[PITCH] = 0;
	ent->s.angles[YAW] = spawn_angles[YAW];
	ent->s.angles[ROLL] = 0;
	VectorCopy (ent->s.angles, client->ps.viewangles);
	VectorCopy (ent->s.angles, client->v_angle);

//WF - for flash grenades
    client->blindBase = 0;
    client->blindTime = 0;	
	ent->client->pers.autozoom = 1;		//default sniper rifle to auto-zoom

	//Clear disguise stuff
	ent->disguised = 0;
	ent->disguising = 0;
	ent->disguisetime = 0;
	ent->disguisingteam = 0;
	ent->disguisedteam = 0;
	ent->disguiseshots = 0;

	lasersight_off (ent);

	//Stop any disease
	ent->disease = 0;
	ent->cantmove = 0;

//WF
	//set the team of the entity
	ent->wf_team = client->resp.ctf_team;

	//set respawn protection time
    ent->client->protecttime = level.time + RESPAWN_PROTECT_TIME;

	//Set player classes

	//Fixup class if team is set but there is no next_player_class
	if ((client->resp.ctf_team > 0) && (ent->client->resp.next_player_class == 0))
	{
		//Can we use current setting?
		if (ent->client->player_class)
		{
			ent->client->resp.next_player_class = ent->client->player_class;
		}
		//Can we use temp variable?
                else if (pclass_next)
		{
                        ent->client->resp.next_player_class = pclass_next;
		}
		//Just assign them to the first class if all else fails
		else
		{
			ent->client->resp.next_player_class = 1;
		}
	}

	//Did class change?
	if (pclass_curr != ent->client->resp.next_player_class)
	{
		//Remove all their old stuff lying around
//		gi.dprintf("Class changed-removing stuff.  Old class=%d, New Class=%d\n",ent->client->player_class, ent->client->resp.next_player_class);
		WFPlayer_ChangeClassTeam(ent);
	}

	ent->client->player_class = ent->client->resp.next_player_class;
	
	
	if ((((int)wfflags->value & WF_NO_PLAYER_CLASSES) == 0) && (ent->client->player_class))
	{
//		gi.dprintf("Player Classes Used\n");
		wf_InitPlayerClass(ent->client);
	}
//    else if ((int)wfflags->value & WF_RESPAWN_ARMED)
//	{
//		ent->client->resp.next_player_class = CLASS_SUPERMAN;
//		ent->client->player_class = CLASS_SUPERMAN;
//		wf_InitPlayerClass(ent->client);
//	}
	else
	{
		ent->client->resp.next_player_class = 0;
		ent->client->player_class = 0;
	}
	Cmd_ShowClass(ent);

	//Pick the best weapon for the class
	NoAmmoWeaponChange (ent);



//ZOID
	if (CTFStartClient(ent))
		return;
//ZOID


	
	if (!KillBox (ent))
	{	// could't spawn in?
	}

	gi.linkentity (ent);

	// force the current weapon up
	client->newweapon = client->pers.weapon;
	ChangeWeapon (ent);
}

/* Anti-ZBot Support Code */
void wf_strdate(char *s);
void wf_strtime(char *s);

void  zbotFileOpen(  )
{
    char path[100];

	zbotfile = NULL;

	//Is zbot detection on?
    if (((int)wfflags->value & WF_ZBOT_DETECT) == 0)
        return;

    strcpy(path, gamedir->string);

#if defined(_WIN32) || defined(WIN32)
    strcat(path,"\\zbot.log");
#else
    strcat(path,"/zbot.log");
#endif

    if( zbotfile = fopen(path,"a") )
    {
        fprintf(zbotfile,"\nSERVER RESTART\n");
		gi.dprintf("ZBot Protection Enabled\n");
    }
}

void zbotLogAttack(edict_t *ent)
{
	char tDate[50];
	char tTime[50];

	if (!zbotfile) return;

	//value = Info_ValueForKey (userinfo, "ip");
	wf_strdate( tDate );
	wf_strtime( tTime );

	fprintf(zbotfile,"%s %s: Name = %s\n",
		tDate, tTime, ent->client->pers.netname);

}

void zbotFileClose()
{
	if (zbotfile) fclose(zbotfile);
}

/*
=====================
ClientBeginDeathmatch

A client has just connected to the server in 
deathmatch mode, so clear everything out before starting them.
=====================
*/
void ClientBeginDeathmatch (edict_t *ent)
{
	G_InitEdict (ent);

	InitClientResp (ent->client);

	// locate ent at a spawn point
	PutClientInServer (ent);

	// -- ANTI-ZBOT STARTS -- //
	ent->client->resp.bot_start = level.time + 5 + (rand() % 5);
	ent->client->resp.bot_end = 0;
	ent->client->resp.bot_retries = 0;
    // between 5 and 9 seconds later.
	// -- ANTI-ZBOT ENDS -- //

    // Voting
	ent->client->pers.HasVoted = false;

	// Homing
	ent->client->pers.homing_state = 1;

	// send effect
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGIN);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	gi.bprintf (PRINT_HIGH, "%s entered the game\n", ent->client->pers.netname);

//WF Setup user
    WFClientSetup(ent);
	sl_LogPlayerConnect( &gi, level, ent ); // StdLog - Mark Davies
//WF

	// make sure all view stuff is valid
	ClientEndServerFrame (ent);

}


/*
===========
ClientBegin

called when a client has finished connecting, and is ready
to be placed into the game.  This will happen every level load.
============
*/
void ClientBegin (edict_t *ent)
{
	int		i;

	ent->client = game.clients + (ent - g_edicts - 1);

	if (deathmatch->value)
	{
		ClientBeginDeathmatch (ent);
		return;
	}

	// if there is already a body waiting for us (a loadgame), just
	// take it, otherwise spawn one from scratch
	if (ent->inuse == true)
	{
		// the client has cleared the client side viewangles upon
		// connecting to the server, which is different than the
		// state when the game is saved, so we need to compensate
		// with deltaangles
		for (i=0 ; i<3 ; i++)
			ent->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(ent->client->ps.viewangles[i]);
	}
	else
	{
		// a spawn point will completely reinitialize the entity
		// except for the persistant data that was initialized at
		// ClientConnect() time
		G_InitEdict (ent);
		ent->classname = "player";
		InitClientResp (ent->client);
		PutClientInServer (ent);
	}

	if (level.intermissiontime)
	{
		MoveClientToIntermission (ent);
	}
	else
	{
		// send effect if in a multiplayer game
		if (game.maxclients > 1)
		{
			gi.WriteByte (svc_muzzleflash);
			gi.WriteShort (ent-g_edicts);
			gi.WriteByte (MZ_LOGIN);
			gi.multicast (ent->s.origin, MULTICAST_PVS);

			gi.bprintf (PRINT_HIGH, "%s entered the game\n", ent->client->pers.netname);
		}
	}

//WF Setup user
    WFClientSetup(ent);
//WF

	// make sure all view stuff is valid
	ClientEndServerFrame (ent);
}

/*
===========
ClientUserInfoChanged

called whenever the player updates a userinfo variable.

The game can override any of the settings in place
(forcing skins or names, etc) before copying it off.
============
*/
void ClientUserinfoChanged (edict_t *ent, char *userinfo)
{
	char	*s;
	int		playernum;

	// check for malformed or illegal info strings
	if (!Info_Validate(userinfo))
	{
		strcpy (userinfo, "\\name\\badinfo\\skin\\male/grunt");
	}

	// set name
	s = Info_ValueForKey (userinfo, "name");
    // start - mdavies
    // Has the player got a name
    if( strlen(ent->client->pers.netname) )
    {
        // has the name changed
        if( strcmp( ent->client->pers.netname, s ) )
        {
            int iTimeInSeconds = level.time;

            // log player rename
            sl_LogPlayerRename( &gi,
                                ent->client->pers.netname,
                                s);
        }
    }
    // end - mdavies
	strncpy (ent->client->pers.netname, s, sizeof(ent->client->pers.netname)-1);

	// set skin
	s = Info_ValueForKey (userinfo, "skin");

	playernum = ent-g_edicts-1;

	// combine name and skin into a configstring
//ZOID
	if (ctf->value)
		CTFAssignSkin(ent, s);
	else
//ZOID
		gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	// fov
	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		ent->client->ps.fov = 90;
	}
	else
	{
		ent->client->ps.fov = atoi(Info_ValueForKey(userinfo, "fov"));
		if (ent->client->ps.fov < 1)
			ent->client->ps.fov = 90;
		else if (ent->client->ps.fov > 160)
			ent->client->ps.fov = 160;
	}

	// handedness
	s = Info_ValueForKey (userinfo, "hand");
	if (strlen(s))
	{
		ent->client->pers.hand = atoi(s);
	}

	// save off the userinfo in case we want to check something later
	strncpy (ent->client->pers.userinfo, userinfo, sizeof(ent->client->pers.userinfo)-1);

}


/*
===========
ClientConnect

Called when a player begins connecting to the server.
The game can refuse entrance to a client by returning false.
If the client is allowed, the connection process will continue
and eventually get to ClientBegin()
Changing levels will NOT cause this to be called again, but
loadgames will.
============
*/
qboolean ClientConnect (edict_t *ent, char *userinfo)
{
	char	*value;
	char    *tmp;
	int i;

	// check to see if they are on the banned IP list
	value = Info_ValueForKey (userinfo, "ip");

	// drop port #
    tmp = value;
	while (tmp) 
	{
		if (*(++tmp) == ':') 
		{
			*tmp = (char) NULL;
			break;
		}
	}

	if (IsBanned(value))
	{
		gi.dprintf("*** Banned IP %s tried to connect!\n", value);
		Info_SetValueForKey(userinfo, "rejmsg", "You are banned.");
		return false;
	}

/*	if(ent->client->pers.netname == "chewy"||value =="209.5.104.221")
	{
		gi.bprintf (PRINT_HIGH, "Hey everyone %b tried to join but I decide not to allow him since he kept nuking the beta server.  AFter beta maybe I will let him play!",ent->client->pers.netname);
		return false;
	}
*/

	// check for a password
	value = Info_ValueForKey (userinfo, "password");
	if (strcmp(password->string, value) != 0)
		return false;

	// they can connect
	ent->client = game.clients + (ent - g_edicts - 1);

	// if there is already a body waiting for us (a loadgame), just
	// take it, otherwise spawn one from scratch
	if (ent->inuse == false)
	{
		// clear the respawning variables
//ZOID -- force team join
		ent->client->resp.ctf_team = -1;
//ZOID
		InitClientResp (ent->client);
		if (!game.autosaved || !ent->client->pers.weapon)
			InitClientPersistant (ent->client);
	}

    // Clear active grenade and special item counts
//gi.dprintf("Debug: clear grenade counts. After =\n");
	for (i=1; i <= GRENADE_TYPE_COUNT; ++i)
		ent->client->pers.active_grenades[i] = 0;

	for (i=1; i <= SPECIAL_COUNT; ++i)
		ent->client->pers.active_special[i] = 0;

	ClientUserinfoChanged (ent, userinfo);

	if (game.maxclients > 1)
		gi.dprintf ("%s connected\n", ent->client->pers.netname);

	ent->client->pers.connected = true;
	return true;
}

/*
===========
ClientDisconnect

Called when a player drops from the server.
Will not be called between levels.
============
*/
void ClientDisconnect (edict_t *ent)
{
	int		playernum;

	if (!ent->client)
		return;

	gi.bprintf (PRINT_HIGH, "%s disconnected\n", ent->client->pers.netname);
//WF
	sl_LogPlayerDisconnect( &gi, level, ent );	// StdLog - Mark Davies
	WFPlayer_ChangeClassTeam(ent);

//WF

//ZOID
	CTFDeadDropFlag(ent);
	CTFDeadDropTech(ent);
//ZOID

	// send effect
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGOUT);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	gi.unlinkentity (ent);
	ent->s.modelindex = 0;
	ent->solid = SOLID_NOT;
	ent->inuse = false;
	ent->classname = "disconnected";
	ent->client->pers.connected = false;

	playernum = ent-g_edicts-1;
	gi.configstring (CS_PLAYERSKINS+playernum, "");
}


//==============================================================


edict_t	*pm_passent;

// pmove doesn't need to know about passent and contentmask
trace_t	PM_trace (vec3_t start, vec3_t mins, vec3_t maxs, vec3_t end)
{
	if (pm_passent->health > 0)
		return gi.trace (start, mins, maxs, end, pm_passent, MASK_PLAYERSOLID);
	else
		return gi.trace (start, mins, maxs, end, pm_passent, MASK_DEADSOLID);
}

unsigned CheckBlock (void *b, int c)
{
	int	v,i;
	v = 0;
	for (i=0 ; i<c ; i++)
		v+= ((byte *)b)[i];
	return v;
}
void PrintPmove (pmove_t *pm)
{
	unsigned	c1, c2;

	c1 = CheckBlock (&pm->s, sizeof(pm->s));
	c2 = CheckBlock (&pm->cmd, sizeof(pm->cmd));
	Com_Printf ("sv %3i:%i %i\n", pm->cmd.impulse, c1, c2);
}

/*
==============
ClientThink

This will be called once for each client frame, which will
usually be a couple times for each server frame.
==============
*/
void ClientThink (edict_t *ent, usercmd_t *ucmd)
{
	gclient_t	*client;
	edict_t	*other;
	int		i, j;
	pmove_t	pm;

	level.current_entity = ent;
	client = ent->client;

	if (level.intermissiontime)
	{
		client->ps.pmove.pm_type = PM_FREEZE;
		// can exit intermission after five seconds
		if (level.time > level.intermissiontime + 5.0 
			&& (ucmd->buttons & BUTTON_ANY) )
			level.exitintermission = true;
		return;
	}

	pm_passent = ent;

//ZOID
	if (ent->client->chase_target) {
		client->resp.cmd_angles[0] = SHORT2ANGLE(ucmd->angles[0]);
		client->resp.cmd_angles[1] = SHORT2ANGLE(ucmd->angles[1]);
		client->resp.cmd_angles[2] = SHORT2ANGLE(ucmd->angles[2]);
		return;
	}
//ZOID

	// set up for pmove
	memset (&pm, 0, sizeof(pm));

	if (ent->movetype == MOVETYPE_NOCLIP)
		client->ps.pmove.pm_type = PM_SPECTATOR;
	else if (ent->s.modelindex != 255)
		client->ps.pmove.pm_type = PM_GIB;
	else if (ent->deadflag)
		client->ps.pmove.pm_type = PM_DEAD;
	else
		client->ps.pmove.pm_type = PM_NORMAL;

	client->ps.pmove.gravity = sv_gravity->value;
	if (ent->flags & FL_BOOTS)
		client->ps.pmove.gravity = sv_gravity->value * 0.25;

	if(ent->Slower > level.time)
	{
		ucmd->forwardmove *= 0.5;
		ucmd->sidemove *= 0.5;
		ucmd->upmove *= 0.5;
	}

//WF & ATTILA begin
	//Turn off thrusting state if the WF_NO_FLYING flag is set
	//This is set here so the feature can be turned off mid-game
	//Some classes can't fly
	if (ent->client &&  (
		 (int)wfflags->value & WF_NO_FLYING) ||
		 ((ent->client->player_special & SPECIAL_JETPACK) == 0))
		ent->client->thrusting = 0;

	//Thrust if you are not all the way in the water
    if ((ent->client->thrusting) && (ent->waterlevel < 3))
         Jet_ApplyJet( ent, ucmd );
//WF & ATTILA end

	pm.s = client->ps.pmove;

	for (i=0 ; i<3 ; i++)
	{
		pm.s.origin[i] = ent->s.origin[i]*8;
		pm.s.velocity[i] = ent->velocity[i]*8;
	}

	if(ent->superslow)
	{
//		ucmd->forwardmove *= 0.4;
//		ucmd->sidemove *= 0.4;
//		ucmd->upmove *= 0.4;
		ucmd->forwardmove *= 0.75;
		ucmd->sidemove *= 0.75;
		ucmd->upmove *= 0.75;
	}
	if(ent->lame)
	{
		ucmd->forwardmove *= 0.5;
		ucmd->sidemove *= 0.5;
		ucmd->upmove *= 0.5;
	}


	if (memcmp(&client->old_pmove, &pm.s, sizeof(pm.s)))
	{
		pm.snapinitial = true;
//		gi.dprintf ("pmove changed!\n");
	}

//	for (j = 0; j < Speed; j++)
//	{
		pm.cmd = *ucmd;

		pm.trace = PM_trace;	// adds default parms
		pm.pointcontents = gi.pointcontents;

		// perform a pmove
		gi.Pmove (&pm);

		// save results of pmove
		client->ps.pmove = pm.s;
		client->old_pmove = pm.s;

		for (i=0 ; i<3 ; i++)
		{
			ent->s.origin[i] = pm.s.origin[i]*0.125;
			ent->velocity[i] = pm.s.velocity[i]*0.125;
		}

		for (i=0 ; i<3 ; i++)
		{
			ent->s.origin[i] = pm.s.origin[i]*0.125;
	//WF & ATTILA begin
			if ( !Jet_Active(ent) || (Jet_Active(ent)&&(fabs((float)pm.s.velocity[i]*0.125) < fabs(ent->velocity[i]))) )
				ent->velocity[i] = pm.s.velocity[i]*0.125;
	//WF & ATTILA end
		}

		VectorCopy (pm.mins, ent->mins);
		VectorCopy (pm.maxs, ent->maxs);

		client->resp.cmd_angles[0] = SHORT2ANGLE(ucmd->angles[0]);
		client->resp.cmd_angles[1] = SHORT2ANGLE(ucmd->angles[1]);
		client->resp.cmd_angles[2] = SHORT2ANGLE(ucmd->angles[2]);
//	}


//WF & ATTILA begin
	if ( Jet_Active(ent) )
		if( pm.groundentity )               /*are we on ground*/
			if ( Jet_AvoidGround(ent) )       /*then lift us if possible*/
				pm.groundentity = NULL;         /*now we are no longer on ground*/
//WF & ATTILA end

	
	if (ent->groundentity && !pm.groundentity && (pm.cmd.upmove >= 10) && (pm.waterlevel == 0))
	{
		gi.sound(ent, CHAN_VOICE, gi.soundindex("*jump1.wav"), 1, ATTN_NORM, 0);
		PlayerNoise(ent, ent->s.origin, PNOISE_SELF);
	}

	ent->viewheight = pm.viewheight;
	ent->waterlevel = pm.waterlevel;
	ent->watertype = pm.watertype;
	ent->groundentity = pm.groundentity;
	if (pm.groundentity)
		ent->groundentity_linkcount = pm.groundentity->linkcount;

	if (ent->deadflag)
	{
		client->ps.viewangles[ROLL] = 40;
		client->ps.viewangles[PITCH] = -15;
		client->ps.viewangles[YAW] = client->killer_yaw;
	}
	else
	{
		VectorCopy (pm.viewangles, client->v_angle);
		VectorCopy (pm.viewangles, client->ps.viewangles);
	}

//ZOID
	if (client->ctf_grapple)
		CTFGrapplePull(client->ctf_grapple);
//ZOID

	gi.linkentity (ent);

	if (ent->movetype != MOVETYPE_NOCLIP)
		G_TouchTriggers (ent);

	// touch other objects
	for (i=0 ; i<pm.numtouch ; i++)
	{
		other = pm.touchents[i];
		for (j=0 ; j<i ; j++)
			if (pm.touchents[j] == other)
				break;
		if (j != i)
			continue;	// duplicated
		if (!other->touch)
			continue;
		other->touch (other, ent, NULL, NULL);
	}


	client->oldbuttons = client->buttons;
	client->buttons = ucmd->buttons;
	client->latched_buttons |= client->buttons & ~client->oldbuttons;

	// save light level the player is standing on for
	// monster sighting AI
	ent->light_level = ucmd->lightlevel;

	// fire weapon from final position if needed
	if (client->latched_buttons & BUTTON_ATTACK
//ZOID
		&& ent->movetype != MOVETYPE_NOCLIP
//ZOID
		)
	{
		if (!client->weapon_thunk)
		{
			client->weapon_thunk = true;
			Think_Weapon (ent);
		}
	}
//STWF
	if ((ent->client->kamikaze_framenum <= level.framenum) && (ent->client->kamikaze_mode & 1))
	  Kamikaze_Explode(ent);
//STWF

//ZOID
//regen tech
	CTFApplyRegeneration(ent);
//ZOID

//ZOID
	for (i = 1; i <= maxclients->value; i++) {
		other = g_edicts + i;
		if (other->inuse && other->client->chase_target == ent)
			UpdateChaseCam(other);
	}
//ZOID

	//WF
	if(ent->cantmove)
		VectorCopy(ent->LockedPosition,ent->s.origin);


}

void VectorRotate(vec3_t in, vec3_t angles, vec3_t out); 

/*
==============
ClientBeginServerFrame

This will be called once for each server frame, before running
any other entities in the world.
==============
*/
void ClientBeginServerFrame (edict_t *ent)
{
	gclient_t	*client;
	int			buttonMask;
	qboolean noise = false;
	vec3_t temp,new;
//	int index;
//	edict_t *healed;
//	char *s;
	float volume = 1.0;
	int blood;
	int i;	

	if (level.intermissiontime)
		return;

	client = ent->client;

    // -- ANTI-ZBOT STARTS -- //
	if (ent->client->resp.bot_start > 0 && ent->client->resp.bot_start <= level.time)
	{
		ent->client->resp.bot_start = 0;
		stuffcmd(ent, "!zbot\n");
		ent->client->resp.bot_end = level.time + 4;
	}

	if (ent->client->resp.bot_end > 0 && ent->client->resp.bot_end <= level.time)
	{
		//If the player ping is too high, try again later
		if (ent->client->ping >= 700 && ent->client->resp.bot_retries <= 4)
		{
			ent->client->resp.bot_start = level.time + 5 + (rand() % 5);
			ent->client->resp.bot_end = 0;
			++ent->client->resp.bot_retries;
		}
		else
		{
			ent->client->resp.bot_end = 0;
			zbotLogAttack(ent);
			//gi.bprintf (PRINT_MEDIUM,"SYSTEM MESSAGE: %s has been kicked for using a ZBot.\n", ent->client->pers.netname);
			gi.cprintf(ent, PRINT_HIGH, "You have been kicked for using a ZBot (or you have a bad connection).\n");
			stuffcmd(ent, "disconnect\n"); // kick out zbots.
		}
	}
    // -- ANTI-ZBOT ENDS -- //

	// run weapon animations if it hasn't been done by a ucmd_t
	if (!client->weapon_thunk
//ZOID
		&& ent->movetype != MOVETYPE_NOCLIP
//ZOID
		)
		Think_Weapon (ent);
	else
		client->weapon_thunk = false;

	if (ent->deadflag)
	{
		// wait for any button just going down
		if ( level.time > client->respawn_time)
		{
			// in deathmatch, only wait for attack button
			if (deathmatch->value)
				buttonMask = BUTTON_ATTACK;
			else
				buttonMask = -1;

			if ( ( client->latched_buttons & buttonMask ) ||
				(deathmatch->value && ((int)dmflags->value & DF_FORCE_RESPAWN) ) )
			{
				respawn(ent);
				client->latched_buttons = 0;
			}
		}
		return;
	}
//STWF
//	deas = deas-1;
//	if (deas == 0) 
//		deas = 10;
//	if (ent->di)
//	{
//		ent->health= ent->health - 2;
//		ent->disease = ent->disease-2;
//	}
//STWF


	// add player trail so monsters can follow
//WF
	if (!deathmatch->value)
//	if ((int)wfflags->value & WF_DECOY_PURSUE) 
//WF
		if (!visible (ent, PlayerTrail_LastSpot() ) )
			PlayerTrail_Add (ent->s.old_origin);

	client->latched_buttons = 0;

//#include "b_antiweapon.h"
/*
	if(	ent->disguisetime == level.time)
	{
		ent->disguised = ent->disguising;
		ent->disguisedteam=ent->disguisingteam;
		ent->disguiseshots=4;
		s = Info_ValueForKey (ent->client->pers.userinfo, "skin");
		CTFAssignSkin(ent, s);
		gi.cprintf(ent, PRINT_HIGH, "You are disguised\n");
	}
*/

	if ((ent->disguised ||ent->disguisedteam) && (ent->disguiseshots==0))
	{
		WFRemoveDisguise(ent);
	}

	//See if menu is up
	if (ent->client->menu) 
	{
		//check timeout value of menu
		if ((client->menu->MenuTimeout) && (level.time > client->menu->MenuTimeout))
		{
			client->menu->MenuTimeout = 0;
			PMenu_Close(ent);
		}
	}


	//Start the artieral blood spray code JR 9/25/98
	if(ent-client->blood1_amount)
	{
		if(ent->client->blood1_amount<0)
			ent->client->blood1_amount=0;
		else
		{
			VectorRotate(ent->client->blood1_pos1, ent->s.angles, temp);
			VectorRotate(ent->client->blood1_pos2, ent->s.angles, new);

			VectorAdd(ent->s.origin, temp, ent->client->blood1_point);
			VectorSubtract(new, temp, new);
			vectoangles(new, ent->client->blood1_normal);

			blood =ent->client->blood1_amount;
			//Lets limit it at a hundred drops
			if(blood>100)
				blood=100;
			//do the blood spray
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SPLASH);
			gi.WriteByte (blood);
			gi.WritePosition (ent->client->blood1_point);
			gi.WriteDir (ent->client->blood1_normal);
			gi.WriteByte (0xeaec4543);
			gi.multicast (ent->client->blood1_point, MULTICAST_PVS);
			ent->client->blood1_amount-=5;
		}
	}
	if(ent-client->blood2_amount)
	{
		if(ent->client->blood2_amount<0)
			ent->client->blood2_amount=0;
		else
		{
			VectorRotate(ent->client->blood2_pos1, ent->s.angles, temp);
			VectorRotate(ent->client->blood2_pos2, ent->s.angles, new);

			VectorAdd(ent->s.origin, temp, ent->client->blood2_point);
			VectorSubtract(new, temp, new);
			vectoangles(new, ent->client->blood2_normal);

			blood =ent->client->blood2_amount;
			//Lets limit it at a hundred drops
			if(blood>100)
				blood=100;
			//do the blood spray
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SPLASH);//Splash Temp Entity
			gi.WriteByte (blood);//The amount of blood
			gi.WritePosition (ent->client->blood2_point);
			gi.WriteDir (ent->client->blood2_normal);
			gi.WriteByte (0xeaec4543);
			gi.multicast (ent->client->blood2_point, MULTICAST_PVS);
			if(!ent->client->blood1_amount)
			{
				ent->client->blood1_amount=ent->client->blood2_amount;
				for(i=0;i<3;i++)
				{
					ent->client->blood1_point[i]=ent->client->blood2_point[i];
					ent->client->blood1_normal[i]=ent->client->blood2_normal[i];
					ent->client->blood1_pos1[i]=ent->client->blood2_pos1[i];
					ent->client->blood1_pos2[i]=ent->client->blood2_pos2[i];				
				}
				ent->client->blood2_amount=0;
			}
			else
				ent->client->blood2_amount-=5;
		}
	}
	if(ent-client->sblood1_amount)
	{
		if(ent->client->sblood1_amount<0)
			ent->client->sblood1_amount=0;
		else
		{
			VectorRotate(ent->client->sblood1_pos1, ent->s.angles, temp);
			VectorRotate(ent->client->sblood1_pos2, ent->s.angles, new);

			VectorAdd(ent->s.origin, temp, ent->client->sblood1_point);
			VectorSubtract(new, temp, new);
			vectoangles(new, ent->client->sblood1_normal);

			blood =(int)ent->client->sblood1_amount/2;
			//Lets limit it at fifty drops
			if(blood>50)
				blood=50;
			//do the blood spray
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SPLASH);
			gi.WriteByte (blood);
			gi.WritePosition (ent->client->sblood1_point);
			gi.WriteDir (ent->client->sblood1_normal);
			gi.WriteByte (0xeaec4543);
			gi.multicast (ent->client->sblood1_point, MULTICAST_PVS);
			ent->client->sblood1_amount-=5;
		}
	}
	if(ent-client->sblood2_amount)
	{
		if(ent->client->sblood2_amount<0)
			ent->client->sblood2_amount=0;
		else
		{
			VectorRotate(ent->client->sblood2_pos1, ent->s.angles, temp);
			VectorRotate(ent->client->sblood2_pos2, ent->s.angles, new);

			VectorAdd(ent->s.origin, temp, ent->client->sblood2_point);
			VectorSubtract(new, temp, new);
			vectoangles(new, ent->client->sblood2_normal);

			blood =(int)ent->client->sblood2_amount/2;
			//Lets limit it at fifty drops
			if(blood>50)
				blood=50;
			//do the blood spray
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SPLASH);//Splash Temp Entity
			gi.WriteByte (blood);//The amount of blood
			gi.WritePosition (ent->client->sblood2_point);
			gi.WriteDir (ent->client->sblood2_normal);
			gi.WriteByte (0xeaec4543);
			gi.multicast (ent->client->sblood2_point, MULTICAST_PVS);
			if(!ent->client->sblood1_amount)
			{
				ent->client->sblood1_amount=ent->client->sblood2_amount;
				for(i=0;i<3;i++)
				{
					ent->client->sblood1_point[i]=ent->client->sblood2_point[i];
					ent->client->sblood1_normal[i]=ent->client->sblood2_normal[i];
					ent->client->sblood1_pos1[i]=ent->client->sblood2_pos1[i];
					ent->client->sblood1_pos2[i]=ent->client->sblood2_pos2[i];				
				}				ent->client->sblood2_amount=0;
			}
			else
				ent->client->sblood2_amount-=5;
		}
	}
	//end blood spray code;
}
