#include "g_local.h"
#include "m_player.h"
#include "wf_classmgr.h"

void Cmd_AutoConfig_f (edict_t *ent);
void cmd_Disguise (edict_t *ent);
void cmd_Sentry (edict_t *ent);
extern gitem_t *flag1_item;
extern gitem_t *flag2_item;

//WF
void CTFGrappleFire (edict_t *ent, vec3_t g_offset, int damage, int effect);

void cmd_Grapple(edict_t *ent)
{
	int		damage;

	damage = 10;
	CTFGrappleFire (ent, vec3_origin, damage, 0);
}

char *ClientTeam (edict_t *ent)
{
	char		*p;
	static char	value[512];

	value[0] = 0;

	if (!ent->client)
		return value;

	strcpy(value, Info_ValueForKey (ent->client->pers.userinfo, "skin"));
	p = strchr(value, '/');
	if (!p)
		return value;

	if ((int)(dmflags->value) & DF_MODELTEAMS)
	{
		*p = 0;
		return value;
	}

	// if ((int)(dmflags->value) & DF_SKINTEAMS)
	return ++p;
}

qboolean OnSameTeam (edict_t *ent1, edict_t *ent2)
{
	/*
	char	ent1Team [512];
	char	ent2Team [512];

	if (!((int)(dmflags->value) & (DF_MODELTEAMS | DF_SKINTEAMS)))
		return false;

	strcpy (ent1Team, ClientTeam (ent1));
	strcpy (ent2Team, ClientTeam (ent2));

	if (strcmp(ent1Team, ent2Team) == 0)
		return true;
	return false;
	*/
	if (ent1->wf_team == ent2->wf_team) return true;
	else return false;
}


void SelectNextItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;

	cl = ent->client;

//ZOID
	if (cl->menu) {
		PMenu_Next(ent);
		return;
	} else if (cl->chase_target) {
		ChaseNext(ent);
		return;
	}
//ZOID

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (cl->pers.selected_item + i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (!(it->flags & itflags))
			continue;

		cl->pers.selected_item = index;
		return;
	}

	cl->pers.selected_item = -1;
}

void SelectPrevItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;

	cl = ent->client;

//ZOID
	if (cl->menu) {
		PMenu_Prev(ent);
		return;
	} else if (cl->chase_target) {
		ChasePrev(ent);
		return;
	}
//ZOID

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (cl->pers.selected_item + MAX_ITEMS - i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (!(it->flags & itflags))
			continue;

		cl->pers.selected_item = index;
		return;
	}

	cl->pers.selected_item = -1;
}

void ValidateSelectedItem (edict_t *ent)
{
	gclient_t	*cl;

	cl = ent->client;

	if (cl->pers.inventory[cl->pers.selected_item])
		return;		// valid

	SelectNextItem (ent, -1);
}


//=================================================================================

/*
==================
Cmd_Give_f

Give items to a client
==================
*/
void Cmd_Give_f (edict_t *ent)
{
	char		*name;
	gitem_t		*it;
	int			index;
	int			i;
	qboolean	give_all;
	edict_t		*it_ent;

	if (deathmatch->value && !sv_cheats->value)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	name = gi.args();

	if (Q_stricmp(name, "all") == 0)
		give_all = true;
	else
		give_all = false;

	if (give_all || Q_stricmp(gi.argv(1), "health") == 0)
	{
		if (gi.argc() == 3)
			ent->health = atoi(gi.argv(2));
		else
			ent->health = ent->max_health;
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "weapons") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_WEAPON))
				continue;
			ent->client->pers.inventory[i] += 1;
		}
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "ammo") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_AMMO))
				continue;
			Add_Ammo (ent, it, 1000);
		}
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "armor") == 0)
	{
		gitem_armor_t	*info;

		it = FindItem("Jacket Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Combat Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Body Armor");
		info = (gitem_armor_t *)it->info;
		ent->client->pers.inventory[ITEM_INDEX(it)] = info->max_count;

		if (!give_all)
			return;
	}

/*
	if (give_all || Q_stricmp(name, "Power Shield") == 0)
	{
		it = FindItem("Power Shield");
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it_ent->inuse)
			G_FreeEdict(it_ent);

		if (!give_all)
			return;
	}
*/
	if (give_all)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (it->flags & (IT_ARMOR|IT_WEAPON|IT_AMMO))
				continue;
			ent->client->pers.inventory[i] = 1;
		}
		return;
	}

	it = FindItem (name);
	if (!it)
	{
		name = gi.argv(1);
		it = FindItem (name);
		if (!it)
		{
			gi.dprintf ("unknown item\n");
			return;
		}
	}

	if (!it->pickup)
	{
		gi.dprintf ("non-pickup item\n");
		return;
	}

	index = ITEM_INDEX(it);

	if (it->flags & IT_AMMO)
	{
		if (gi.argc() == 3)
			ent->client->pers.inventory[index] = atoi(gi.argv(2));
		else
			ent->client->pers.inventory[index] += it->quantity;
	}
	else
	{
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it_ent->inuse)
			G_FreeEdict(it_ent);
	}
}


/*
==================
Cmd_God_f

Sets client to godmode

argv(0) god
==================
*/
void Cmd_God_f (edict_t *ent)
{
	char	*msg;

	if (deathmatch->value && !sv_cheats->value)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	ent->flags ^= FL_GODMODE;
	if (!(ent->flags & FL_GODMODE) )
		msg = "godmode OFF\n";
	else
		msg = "godmode ON\n";

	if (ent->client) gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Notarget_f

Sets client to notarget

argv(0) notarget
==================
*/
void Cmd_Notarget_f (edict_t *ent)
{
	char	*msg;

	if (deathmatch->value && !sv_cheats->value)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	ent->flags ^= FL_NOTARGET;
	if (!(ent->flags & FL_NOTARGET) )
		msg = "notarget OFF\n";
	else
		msg = "notarget ON\n";

	if (ent->client) gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Noclip_f

argv(0) noclip
==================
*/
void Cmd_Noclip_f (edict_t *ent)
{
	char	*msg;

	if (deathmatch->value && !sv_cheats->value)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	if (ent->movetype == MOVETYPE_NOCLIP)
	{
		ent->movetype = MOVETYPE_WALK;
		msg = "noclip OFF\n";
	}
	else
	{
		ent->movetype = MOVETYPE_NOCLIP;
		msg = "noclip ON\n";
	}

	if (ent->client) gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Use_f

Use an inventory item
==================
*/
void Cmd_Use_f (edict_t *ent)
{
	int		index;
	gitem_t	*it;
	gitem_t	*orig_it;
	char	*s;
	char	*picked_item;
	int		slot;
	int		classnum;
	int		weapon;
	int		foundmenuitem;

	if (!ent->client)
	{
		gi.dprintf("Use: Not a client\n");
		return;
	}

	s = gi.args();
	it = FindItem (s);
	picked_item = s;
	if (!it)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "unknown item: %s\n", s);
		return;
	}
	if (!it->use)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}


	//WF  - Switch weapons to custom weapons if needed
	orig_it = it;

	//Pick a slot
	slot = 0;
	if(it == FindItem("blaster")) slot = 1;
	else if(it == FindItem("shotgun")) slot = 2;
	else if(it == FindItem("super shotgun")) slot = 3;
	else if(it == FindItem("Machinegun")) slot = 4;
	else if(it == FindItem("chaingun"))	slot = 5;
	else if(it == FindItem("grenade launcher")) slot = 6;
	else if(it == FindItem("rocket launcher")) slot = 7;
	else if(it == FindItem("hyperblaster")) slot = 8;
	else if(it == FindItem("railgun")) slot = 9;
	else if(it == FindItem("bfg10k")) slot = 10;

	//If there is a menu open, we may need to pick an item from it
	//instead of choosing a weapon
	if (ent->client->menu && ent->client->menu->UseNumberKeys && slot > 0)
	{
		foundmenuitem = WFMenuFromNumberKey(ent, slot);
		if (foundmenuitem) return;	//We are done if we found a menu item
	}

	if (!ent->client->player_class)
	{
//		gi.dprintf("Use: No current class selected\n");
		return;
	}


	//Slot choosen, now select weapon
	classnum = ent->client->player_class;
	if (slot)	//Things without a slot are not weapons
		weapon = classinfo[classnum].weapon[slot-1];
	else
		weapon = 0;

//gi.dprintf("Use: Slot=%d, class=%d, weapon=%d\n", slot, classnum,weapon);

	if(weapon == WEAPON_BLASTER) 
	{
		it = FindItem("blaster");
		picked_item = "Blaster";
	}

	else if(weapon == WEAPON_SHOTGUN)
	{
		it = FindItem("shotgun");
		picked_item = "Shotgun";
	}

	else if(weapon == WEAPON_SUPERSHOTGUN)
	{
		it = FindItem("super shotgun");
		picked_item = "Super Shotgun";
	}

		
	else if (weapon == WEAPON_NAILGUN)
	{
		it = FindItem ("NailGun");
		picked_item = "Nail Gun";
	}

	else if (weapon == WEAPON_SHC)
	{
		it = FindItem ("SHC Rifle");
		picked_item = "SHC Rifle";
	}

	else if (weapon == WEAPON_TRANQUILIZER)
	{
		it = FindItem ("Tranquilizer");
		picked_item = "Tranquilizer"; 
	}

	else if (weapon == WEAPON_LRPROJECTILE)
	{
		it = FindItem ("Projectile Launcher");
		picked_item = "Projectile Launcher"; 
	}

	else if (weapon == WEAPON_INFECTEDDART)
	{
		it = FindItem ("Infected Dart Launcher");
		picked_item = "Infected Dart";
	}

	else if (weapon == WEAPON_ARMORDART)
	{
		it = FindItem ("Poison Dart Launcher");
		picked_item = "Armor Piercing Dart";
	}

	else if (weapon == WEAPON_SHOTGUNCHOKE)
	{
		it = FindItem ("Shotgun Choke");
		picked_item = "Shotgun with Choke";
	}

	else if(weapon == WEAPON_MACHINEGUN)
	{
		it = FindItem("Machinegun");
		picked_item = "Machine Gun";
	}

	else if (weapon == WEAPON_NAG)
	{
		it = FindItem ("Nervous Accelerator Gun");
		picked_item = "Nervous Accelerator Gun";
	}

	else if (weapon == WEAPON_LIGHTNING)
	{
		it = FindItem ("Lightning Gun");
		picked_item = "Lightning Gun";
	}

	else if (weapon == WEAPON_PULSE)
	{
		it = FindItem ("Pulse Cannon");
		picked_item = "Pulse Cannon";
	}

	else if (weapon == WEAPON_LASERSNIPER)
	{
		it = FindItem ("Laser Sniper Rifle");
		picked_item = "Laser Sniper Rifle";
	}

	else if(weapon == WEAPON_CHAINGUN)
	{       
		it = FindItem("Chaingun");
		picked_item = "Chaingun";
	}

	else if (weapon == WEAPON_NEEDLER)
	{
		it = FindItem ("needler");
		picked_item = "Needler";
	}

	else if (weapon == WEAPON_SNIPERRIFLE)
	{
		it = FindItem ("Sniper Rifle");
		picked_item = "Sniper Rifle";
	}

	else if (weapon == WEAPON_CLUSTERROCKET)
	{
		it = FindItem ("Cluster Rocket Launcher");
		picked_item = "Cluster Rocket Launcher";
	}
	else if (weapon == WEAPON_SENTRYKILLER)
	{
		it = FindItem ("Sentry Killer");
		picked_item = "Sentry Killer";
	}
	else if (weapon == WEAPON_MEGACHAINGUN)
	{
		it = FindItem ("Mega Chaingun");
		picked_item = "Mega Chaingun";
	}
	else  if(weapon == WEAPON_GRENADELAUNCHER)
	{	
		it = FindItem("grenade launcher");
		picked_item = "Grenade Launcher";
	}

	else if (weapon == WEAPON_PELLET)
	{
		it = FindItem ("Pellet Rocket Launcher");
		picked_item = "Pellet Rocket Launcher";
	}

	else if (weapon == WEAPON_FLAREGUN)
	{
		it = FindItem ("Flare Gun");
		picked_item = "Flare Gun"; 
	}

	else if(weapon == WEAPON_ROCKETLAUNCHER)
	{
		it = FindItem("rocket launcher");
		picked_item = "Rocket Launcher";
	}

	else if (weapon == WEAPON_NAPALMMISSLE)
	{
		it = FindItem ("Rocket Napalm Launcher");
		picked_item = "Rocket Napalm Launcher";
	}

	else if(weapon == WEAPON_HYPERBLASTER)
	{
		it = FindItem("hyperblaster");
		picked_item = "Hyperblaster";
	}

	else if (weapon == WEAPON_TELSA)
	{
		it = FindItem ("Telsa Coil");
		picked_item = "Telsa Coil";
	}

	else if(weapon == WEAPON_RAILGUN)
	{
		it = FindItem("railgun");
		picked_item = "Railgun";
	}

	else if (weapon == WEAPON_BFG)
	{                
		it = FindItem("bfg10k");
		picked_item = "BFG";
	}
	else if (weapon == WEAPON_FLAMETHROWER)
	{
		it = FindItem ("FlameThrower");
		picked_item = "FlameThrower";
	}
	else if (weapon == WEAPON_TRANQUILDART)
	{
		it = FindItem ("Tranquilizer Dart Launcher");
		picked_item = "Tranquilizer Dart";
	}
	else if (weapon == WEAPON_KNIFE)
	{
		it = FindItem ("Knife");
		picked_item = "Knife";
	}

	if (it == NULL)
	{
		it = orig_it;
		if (ent->client) gi.cprintf(ent, PRINT_HIGH, "Coudn't find that weapon!\n");        
	}

	if (slot != 0 && weapon == 0)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Nothing There.\n");
		return;
	}

	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Not In Inventory.\n");
		return;
	}
	if (ent->client) gi.cprintf(ent, PRINT_HIGH, "%s Selected\n",picked_item);

	it->use (ent, it);

	//They may have done a "use <weapon name>" directly instead of
	// the number keys
	if(it == FindItem("Rocket Napalm Launcher")) weapon = WEAPON_NAPALMMISSLE;

	//Turn on/off laser sight if needed
	if (weapon == WEAPON_NAPALMMISSLE)
		lasersight_on (ent);
	else
		lasersight_off (ent);

}


/*
==================
Cmd_Drop_f

Drop an inventory item
==================
*/
void Cmd_Drop_f (edict_t *ent)
{
	int			index;
	gitem_t		*it;
	char		*s;

//ZOID--special case for tech powerups
	if (Q_stricmp(gi.args(), "tech") == 0 && (it = CTFWhat_Tech(ent)) != NULL) {
		it->drop (ent, it);
		return;
	}
//ZOID

//WF - Drop the flag
	if (Q_stricmp(gi.args(), "flag") == 0 ) {
		CTFDeadDropFlag(ent);
		return;
	}
//WF
	s = gi.args();
	it = FindItem (s);
	if (!it)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "unknown item: %s\n", s);
		return;
	}
	if (!it->drop)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}
	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
		return;
	}

	it->drop (ent, it);
}


/*
=================
Cmd_Inven_f
=================
*/
void Cmd_Inven_f (edict_t *ent)
{
	int			i;
	gclient_t	*cl;

	cl = ent->client;

	cl->showscores = false;
	cl->showhelp = false;

//ZOID
	if (ent->client->menu) {
		PMenu_Close(ent);
		ent->client->update_chase = true;
		return;
	}
//ZOID

	if (cl->showinventory)
	{
		cl->showinventory = false;
		return;
	}

//ZOID
	//has team been picked?
	if (ctf->value && cl->resp.ctf_team == CTF_NOTEAM) {
		CTFOpenJoinMenu(ent);
		return;
	}
//ZOID
//WF
	//has class been picked?
	if (ctf->value && ent->client->player_class == 0) {
		WFOpenClassMenu(ent);
		return;
	}
//WF

	cl->showinventory = true;

	gi.WriteByte (svc_inventory);
	for (i=0 ; i<MAX_ITEMS ; i++)
	{
		gi.WriteShort (cl->pers.inventory[i]);
	}
	gi.unicast (ent, true);
}

/*
=================
Cmd_InvUse_f
=================
*/
void Cmd_InvUse_f (edict_t *ent)
{
	gitem_t		*it;


//ZOID
	if (ent->client->menu) {
		PMenu_Select(ent);
		return;
	}
//ZOID

	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "No item to use.\n");
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];
	if (!it->use)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}

	it->use (ent, it);

}

//ZOID
/*
=================
Cmd_LastWeap_f
=================
*/
void Cmd_LastWeap_f (edict_t *ent)
{
	gclient_t	*cl;

	cl = ent->client;

	if (!cl->pers.weapon || !cl->pers.lastweapon)
		return;

	cl->pers.lastweapon->use (ent, cl->pers.lastweapon);
}
//ZOID

/*
=================
Cmd_WeapPrev_f
=================
*/
void Cmd_WeapPrev_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	cl = ent->client;

	if (!cl->pers.weapon)
		return;

	selected_weapon = ITEM_INDEX(cl->pers.weapon);

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;
		it->use (ent, it);
		if (cl->pers.weapon == it)
			return;	// successful
	}
}

/*
=================
Cmd_WeapNext_f
=================
*/
void Cmd_WeapNext_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	cl = ent->client;

	if (!cl->pers.weapon)
		return;

	selected_weapon = ITEM_INDEX(cl->pers.weapon);

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + MAX_ITEMS - i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;
		it->use (ent, it);
		if (cl->pers.weapon == it)
			return;	// successful
	}
}

/*
=================
Cmd_WeapLast_f
=================
*/
void Cmd_WeapLast_f (edict_t *ent)
{
	gclient_t	*cl;
	int			index;
	gitem_t		*it;

	cl = ent->client;

	if (!cl->pers.weapon || !cl->pers.lastweapon)
		return;

	index = ITEM_INDEX(cl->pers.lastweapon);
	if (!cl->pers.inventory[index])
		return;
	it = &itemlist[index];
	if (!it->use)
		return;
	if (! (it->flags & IT_WEAPON) )
		return;
	it->use (ent, it);
}

/*
=================
Cmd_InvDrop_f
=================
*/
void Cmd_InvDrop_f (edict_t *ent)
{
	gitem_t		*it;

	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "No item to drop.\n");
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];
	if (!it->drop)
	{
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}
	it->drop (ent, it);
}

/*
=================
Cmd_Kill_f
=================
*/
void Cmd_Kill_f (edict_t *ent)
{
//ZOID
	if (ent->solid == SOLID_NOT)
		return;
//ZOID

	if((level.time - ent->client->respawn_time) < 5)
		return;
	ent->flags &= ~FL_GODMODE;
	ent->health = 0;
	meansOfDeath = MOD_SUICIDE;

	//WF - Treat this like a change class. Clean up all their toys
	WFPlayer_ChangeClassTeam(ent);

	player_die (ent, ent, ent, 100000, vec3_origin);

	// don't even bother waiting for death frames
	ent->deadflag = DEAD_DEAD;
	respawn (ent);
}

/*
=================
Cmd_PutAway_f
=================
*/
void Cmd_PutAway_f (edict_t *ent)
{
	ent->client->showscores = false;
	ent->client->showhelp = false;
	ent->client->showinventory = false;
//ZOID
	if (ent->client->menu)
		PMenu_Close(ent);
	ent->client->update_chase = true;
//ZOID
}


int PlayerSort (void const *a, void const *b)
{
	int		anum, bnum;

	anum = *(int *)a;
	bnum = *(int *)b;

	anum = game.clients[anum].ps.stats[STAT_FRAGS];
	bnum = game.clients[bnum].ps.stats[STAT_FRAGS];

	if (anum < bnum)
		return -1;
	if (anum > bnum)
		return 1;
	return 0;
}

/*
=================
Cmd_Players_f
=================
*/
void Cmd_Players_f (edict_t *ent)
{
	int		i;
	int		count;
	char	small[64];
	char	large[1280];
	int		index[256];

	count = 0;
	for (i = 0 ; i < maxclients->value ; i++)
		if (game.clients[i].pers.connected)
		{
			index[count] = i;
			count++;
		}

	// sort by frags
	qsort (index, count, sizeof(index[0]), PlayerSort);

	// print information
	large[0] = 0;

	for (i = 0 ; i < count ; i++)
	{
		Com_sprintf (small, sizeof(small), "%3i %s\n",
			game.clients[index[i]].ps.stats[STAT_FRAGS],
			game.clients[index[i]].pers.netname);
		if (strlen (small) + strlen(large) > sizeof(large) - 100 )
		{	// can't print all of them in one packet
			strcat (large, "...\n");
			break;
		}
		strcat (large, small);
	}

	if (ent->client) gi.cprintf (ent, PRINT_HIGH, "%s\n%i players\n", large, count);
}

//WF - prototype from wf_decoy.c
void decoy_taunt (edict_t *self);
void decoy_flip (edict_t *self);
void decoy_salute (edict_t *self);
void decoy_wave (edict_t *self);
void decoy_point (edict_t *self);


/*
=================
Cmd_NoSpam_f
=================
*/
void Cmd_NoSpam_f (edict_t *ent)
{
	int		i;
	if (!ent->client) return;

	i = atoi (gi.argv(1));
	ent->client->pers.nospam_level = i;
	gi.cprintf (ent, PRINT_HIGH, "NOSPAM set to %d\n", i);
}


/*
=================
Cmd_Wave_f
=================
*/
void Cmd_Wave_f (edict_t *ent)
{
	int		i;

	i = atoi (gi.argv(1));

	// can't wave when ducked
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (ent->client->anim_priority > ANIM_WAVE)
		return;

	ent->client->anim_priority = ANIM_WAVE;

	switch (i)
	{
	case 0:
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "flipoff\n");
		ent->s.frame = FRAME_flip01-1;
		ent->client->anim_end = FRAME_flip12;

		//WF - if we have a decoy, make it flipoff too
		if (ent->decoy) decoy_flip(ent->decoy);
		break;
	case 1:
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "salute\n");
		ent->s.frame = FRAME_salute01-1;
		ent->client->anim_end = FRAME_salute11;

		//WF - if we have a decoy, make it salute too
		if (ent->decoy) decoy_salute(ent->decoy);
		break;
	case 2:
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "taunt\n");
		ent->s.frame = FRAME_taunt01-1;
		ent->client->anim_end = FRAME_taunt17;

		//WF - if we have a decoy, make it taunt too
		if (ent->decoy) decoy_taunt(ent->decoy);
		break;
	case 3:
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "wave\n");
		ent->s.frame = FRAME_wave01-1;
		ent->client->anim_end = FRAME_wave11;

		//WF - if we have a decoy, make it wave too
		if (ent->decoy) decoy_wave(ent->decoy);
		break;
	case 4:
	default:
		if (ent->client) gi.cprintf (ent, PRINT_HIGH, "point\n");
		ent->s.frame = FRAME_point01-1;
		ent->client->anim_end = FRAME_point12;

		//WF - if we have a decoy, make it point too
		if (ent->decoy) decoy_point(ent->decoy);
		break;
	}
}

/* 
Flood Protection (anti-spam) code by John.  Moved to function by Gregg
*/
int FloodProtect(edict_t *ent)
{
	int		floodtime;

	//See if flood protection is turned off
	if (!floodertime->value) return 0;//dont worry about it

	if (ent->client)
	{

		//WF John flood protection code
		if(ent->client->floodtime2<level.time)
		{
			if(ent->client->floodtime1>level.time)
				ent->client->floodtime2 = level.time + floodertime->value;
		}
		else
		{
			floodtime=(int)(ent->client->floodtime2-level.time);
			gi.cprintf(ent, PRINT_HIGH, "Cannot talk for %i more seconds\n",floodtime);
			return 1;
		}
	
		ent->client->floodtime1 = level.time + floodertime->value;
	}

	return 0;
}

/*
==================
Cmd_Say_f
==================
*/
void Cmd_Say_f (edict_t *ent, qboolean team, qboolean arg0)
{
	int		j;
	edict_t	*other;
	char	*p;
	char	text[2048];

	if (FloodProtect(ent))
		return;
	
	if (gi.argc () < 2 && !arg0)
		return;

	if (!((int)(dmflags->value) & (DF_MODELTEAMS | DF_SKINTEAMS)))
		team = false;

	if (team)
		Com_sprintf (text, sizeof(text), "(%s): ", ent->client->pers.netname);
	else
		Com_sprintf (text, sizeof(text), "%s: ", ent->client->pers.netname);

	if (arg0)
	{
		strcat (text, gi.argv(0));
		strcat (text, " ");
		strcat (text, gi.args());
	}
	else
	{
		p = gi.args();

		if (*p == '"')
		{
			p++;
			p[strlen(p)-1] = 0;
		}
		strcat(text, p);
	}

	// don't let text be too long for malicious reasons
	if (strlen(text) > 150)
		text[150] = 0;

	strcat(text, "\n");

	if (dedicated->value)
		gi.cprintf(NULL, PRINT_CHAT, "%s", text);

	for (j = 1; j <= game.maxclients; j++)
	{
		other = &g_edicts[j];
		if (!other->inuse)
			continue;
		if (!other->client)
			continue;
		if (team)
		{
			if (!OnSameTeam(ent, other))
				continue;
		}
		gi.cprintf(other, PRINT_CHAT, "%s", text);
	}
}

/*
=================
ClientCommand
=================
*/
void ClientCommand (edict_t *ent)
{
	char	*cmd;
	char	*args;
	int i;
	int class_picked;

	if (!ent->client)
		return;		// not fully in game yet

	cmd = gi.argv(0);

	if (Q_stricmp (cmd, "players") == 0)
	{
		Cmd_Players_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "say") == 0)
	{
		Cmd_Say_f (ent, false, false);
		return;
	}
	if (Q_stricmp (cmd, "say_team") == 0 || Q_stricmp (cmd, "steam") == 0)
	{
		CTFSay_Team(ent, gi.args());
		return;
	}
	if (Q_stricmp (cmd, "score") == 0)
	{
		Cmd_Score_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "help") == 0)
	{
		Cmd_Help_f (ent);
		return;
	}

	if (level.intermissiontime)
		return;

	if (Q_stricmp (cmd, "use") == 0)
		Cmd_Use_f (ent);
	else if (Q_stricmp (cmd, "drop") == 0)
		Cmd_Drop_f (ent);
	else if (Q_stricmp (cmd, "give") == 0)
		Cmd_Give_f (ent);
	else if (Q_stricmp (cmd, "god") == 0)
		Cmd_God_f (ent);
	else if (Q_stricmp (cmd, "notarget") == 0)
		Cmd_Notarget_f (ent);
	else if (Q_stricmp (cmd, "noclip") == 0)
		Cmd_Noclip_f (ent);
	else if (Q_stricmp (cmd, "inven") == 0)
		Cmd_Inven_f (ent);
	else if (Q_stricmp (cmd, "invnext") == 0)
	{
		SelectNextItem (ent, -1);
	}
	else if (Q_stricmp (cmd, "invprev") == 0)
		SelectPrevItem (ent, -1);
	else if (Q_stricmp (cmd, "invnextw") == 0)
		SelectNextItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invprevw") == 0)
		SelectPrevItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invnextp") == 0)
		SelectNextItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invprevp") == 0)
		SelectPrevItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invuse") == 0)
		Cmd_InvUse_f (ent);
	else if (Q_stricmp (cmd, "invdrop") == 0)
		Cmd_InvDrop_f (ent);
	else if (Q_stricmp (cmd, "weapprev") == 0)
		Cmd_WeapPrev_f (ent);
	else if (Q_stricmp (cmd, "weapnext") == 0)
		Cmd_WeapNext_f (ent);
	else if (Q_stricmp (cmd, "weaplast") == 0)
		Cmd_WeapLast_f (ent);
	else if (Q_stricmp (cmd, "kill") == 0)
		Cmd_Kill_f (ent);
	else if (Q_stricmp (cmd, "putaway") == 0)
		Cmd_PutAway_f (ent);
	else if (Q_stricmp (cmd, "wave") == 0)
		Cmd_Wave_f (ent);
	// -- ANTI-ZBOT STARTS -- //
	else if (Q_stricmp(cmd, "!zbot") == 0)
		ent->client->resp.bot_end = 0; // not a bot.
	// -- ANTI-ZBOT CODE ENDS -- //

//ZOID
	else if (Q_stricmp (cmd, "team") == 0)
	{
		CTFTeam_f (ent);
	} else if (Q_stricmp(cmd, "id") == 0) {
		CTFID_f (ent);
	}
//ZOID

/*===========
WF Commands 
=============*/
    // 'homing' command
    else if (Q_stricmp (cmd, "homing") == 0)
        Cmd_Homing_f (ent);

    // 'grenade' command
    else if (Q_stricmp (cmd, "grenade") == 0)
	{
		if (ent->health > 0 && ent->wf_team >= 1) 
	        Cmd_Grenade_f (ent);
	}

    // 'grenade1' command
    else if (Q_stricmp (cmd, "grenade1") == 0)
	{
//		gi.cprintf (ent, PRINT_HIGH, "Grenade1 picked...");
		if (ent->health > 0 && ent->wf_team >= 1) 
		{
//			gi.cprintf (ent, PRINT_HIGH, "Grenade1 OK.\n");
	        Cmd_Grenade1 (ent);
		}
//		else if (ent->health <= 0)
//			gi.dprintf("health too low\n");
//		else if (ent->wf_team < 1)
//			gi.dprintf("bad team: %d\n", ent->wf_team);
//		else
//			gi.dprintf("Don't know whats wrong\n");
	}

    // 'grenade2' command
    else if (Q_stricmp (cmd, "grenade2") == 0)
	{
		if (ent->health > 0 && ent->wf_team >= 1) 
	        Cmd_Grenade2 (ent);
	}

    // 'grenade3' command
    else if (Q_stricmp (cmd, "grenade3") == 0)
	{
		if (ent->health > 0 && ent->wf_team >= 1) 
	        Cmd_Grenade3 (ent);
	}

    // 'decoy' command
    else if (Q_stricmp (cmd, "decoy") == 0)
	{
		if (ent->health > 0 && ent->wf_team >= 1) 
	        SP_Decoy (ent);	
	}

    // jetpack thrust
    else if (Q_stricmp(cmd, "thrust") == 0 )
        Cmd_Thrust_f (ent);     

	// lasersight
//    else if (Q_stricmp (cmd, "lasersight") == 0)
//        SP_LaserSight (ent);	

	// Scanner
//    else if (Q_stricmp (cmd, "scanner") == 0)
//        Toggle_Scanner(ent);	

    // detpipes command
    else if (Q_stricmp (cmd, "detpipes") == 0)
        Cmd_DetPipes_f (ent);

    // reno commands
    else if (Q_stricmp (cmd, "reno") == 0)
        Cmd_Reno_f (ent);

    // Help command
    else if (Q_stricmp (cmd, "wfhelp") == 0)
		WFShowHelp(ent, NULL);

    // wfflags command
    else if (Q_stricmp (cmd, "wfflags") == 0)
		Cmd_WFFlags_f(ent);

    // decoy skins commands
    else if (Q_stricmp (cmd, "dskin") == 0)
        Cmd_DSkin_f (ent);

	//Grenade turrets
//	else if (Q_stricmp (cmd, "turret") == 0)
//		Cmd_Turret_f (ent);

	else if (Q_stricmp (cmd, "showclass") == 0)
	{
		Cmd_ShowClass(ent);
	}

	else if (Q_stricmp (cmd, "showplayers") == 0)
	{
		Cmd_ShowPlayers(ent);
	}


	else if (Q_stricmp (cmd, "changeclass") == 0)
	{
		WFOpenClassMenu(ent);
	}

    else if (Q_stricmp (cmd, "vote") == 0) 
    { 
		if (ent->client->pers.HasVoted == false)
		{
			WFMapVote(ent);
		}
		else
			if (ent->client) gi.cprintf (ent, PRINT_HIGH, "You have already voted for a map.\n");
 	}  

    else if (Q_stricmp (cmd, "special") == 0) 
    { 
		if (ent->health > 0 && ent->wf_team >= 1) 
				WFSpecialMenu(ent);
 	}  

    else if (Q_stricmp (cmd, "wfplay") == 0) //play the requested sound
    {
		if (FloodProtect(ent))
			return;

        args=gi.args();
		if (strlen(args) > 100)
		{
			gi.bprintf (PRINT_HIGH, "%s tried to cheat or crash the server!\nByeBye!\n", ent->client->pers.netname);
			stuffcmd(ent, "alias kickme say I tried to cheat and crash servers!;disconnect;echo Don't try to crash the server any more!\n");
			stuffcmd(ent, "kickme\n");
			return;
		}
		
//		gi.sound (ent, CHAN_VOICE, gi.soundindex (args), 1, ATTN_NORM, 0);
		gi.sound (ent, CHAN_AUTO, gi.soundindex (args), 1, ATTN_NORM, 0);
	}  

    else if (Q_stricmp (cmd, "wfteamplay") == 0) //play the requested sound
    {
		if (FloodProtect(ent))
			return;

        args=gi.args();
		if (strlen(args) > 100)
		{
			gi.bprintf (PRINT_HIGH, "%s tried to cheat or crash the server!\nByeBye!\n", ent->client->pers.netname);
			stuffcmd(ent, "alias kickme say I tried to cheat and crash servers!;disconnect;echo Don't try to crash the server any more!\n");
			stuffcmd(ent, "kickme\n");
			return;
		}
		
		Cmd_WFPlayTeam(ent, args);
	}  

    else if (Q_stricmp (cmd, "gdump") == 0) //grenade dump (show active grenades)
    {
		for (i = 1; i <= GRENADE_TYPE_COUNT; ++i)
			gi.dprintf("%d. %d\n",i,ent->client->pers.active_grenades[i]);
	}
	else if (Q_stricmp (cmd, "snipezoom") == 0)
	{

		ent->PlayerSnipingZoom= atoi(gi.argv(1));
		if (ent->PlayerSnipingZoom > 35)
			ent->PlayerSnipingZoom =35;
		else if (ent->PlayerSnipingZoom <25)
			ent->PlayerSnipingZoom = 25;
	}
	/* These are here for debuging.  The commands should be 
	   executed through the special menu in g_ctf.c
	   */

	else if(Q_stricmp (cmd, "debug-effect0") == 0)
	{
		ent->s.effects = 0;
		ent->s.renderfx = 0;
	}
	else if(Q_stricmp (cmd, "debug-effect1") == 0)
	{
		ent->s.effects = EF_FLAG1;
	}
	else if(Q_stricmp (cmd, "debug-effect2") == 0)
	{
		ent->s.effects = EF_FLAG2;
	}
	else if(Q_stricmp (cmd, "debug-effect3") == 0)
	{
		ent->s.effects = EF_GREENGIB;
	}
	else if(Q_stricmp (cmd, "debug-effect4") == 0)
	{
		ent->s.effects = EF_HYPERBLASTER;
	}
	else if(Q_stricmp (cmd, "debug-effect5") == 0)
	{
		ent->s.effects = EF_BOOMER;
	}
	else if(Q_stricmp (cmd, "debug-effect6") == 0)
	{
		ent->s.effects = EF_COLOR_SHELL;
		ent->s.renderfx = RF_SHELL_GREEN;

	}
	else if(Q_stricmp (cmd, "debug-effect7") == 0)
	{
		ent->s.effects = EF_COLOR_SHELL;
		ent->s.renderfx = RF_GLOW;
	}
	//simulate the removal of flags from a map
//	else if (Q_stricmp (cmd, "debug-killflags") == 0)
//	{
//		ent->client->pers.inventory[ITEM_INDEX(flag1_item)] = 0;
//		ent->client->pers.inventory[ITEM_INDEX(flag2_item)] = 0;
//	}

/*
	else if(Q_stricmp (cmd, "debug-placecam") == 0)
	{
		cmd_CameraPlace(ent);
	}

	else if(Q_stricmp (cmd, "debug-remotecam") == 0)
	{
		cmd_CameraToggle(ent);
	}
*/


//	else if (Q_stricmp (cmd, "tripbomb") == 0)	
//	{
//		cmd_TripBomb(ent);
//	}

	else if (Q_stricmp (cmd, "grapple") == 0)
	{

		//jR The great bug fix
		
		if (ent->health<0)
		{
		//gi.bprintf (PRINT_HIGH, "%s tried to cheat!\n But good old Cryect stopped him\n Cheaters never!!!\nByeBye!", ent->client->pers.netname);
		//stuffcmd(ent, "alias kickme say I cheat;say I try to cheat and crash servers thank you all and tell everyone how all about me!;disconnect;echo Wow what a great cheater!");
		//stuffcmd(ent, "bind mouse1 kickme");
		//stuffcmd(ent, "bind ctrl kickme");
		//stuffcmd(ent, "bind 1 kickme");
			return;
		}
		if (ent->movetype == MOVETYPE_NOCLIP)
			return;

		//Has server turned off grappling on server?
		if ((int)wfflags->value & WF_NO_GRAPPLE) 
		{
			if (ent->client) gi.cprintf(ent, PRINT_HIGH, "Sorry - The grapple is turned off on this server.\n");
			return;
		}
	
		//Is this class capable of using the grapple?
		if ((ent->client) &&  ((ent->client->player_special & SPECIAL_GRAPPLE) == 0))
		{
			if (ent->client) gi.cprintf(ent, PRINT_HIGH, "Sorry - This class cannot use the grapple.\n");
			return;
		}

		if (ent->wf_team <= 0)
			return;

		if (ent->client->ctf_grapple) 
		{
			CTFResetGrapple(ent->client->ctf_grapple);
		}
		else
		{
			cmd_Grapple(ent);
		}
	}

	//New commands in 3.3, 3.4

	//toggle on/off
	else if (Q_stricmp (cmd, "lasersight") == 0)
	{
		if(ent->client->pers.laseron)
			ent->client->pers.laseron=0;
		else
			ent->client->pers.laseron=1;
	}
	//no spam setting.  arg = number
	else if (Q_stricmp (cmd, "nospam") == 0)
		Cmd_NoSpam_f (ent);

    // 'autoconfig' command
	// arg = none, "on" or "off"
    else if (Q_stricmp (cmd, "autoconfig") == 0)
        Cmd_AutoConfig_f (ent);

	//toggle on/off
    else if (Q_stricmp (cmd, "supplydepot") == 0)
	{
		if (ent->client->player_special & SPECIAL_SUPPLY_DEPOT) 
			SP_SupplyDepot(ent);
		else
			if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Sorry, you can't build a supply depot.\n");
	}

	//toggle on/off
    else if (Q_stricmp (cmd, "healingdepot") == 0)
	{
		if (ent->client->player_special & SPECIAL_HEALING)
			SP_HealingDepot(ent);
		else
			if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Sorry, you can't build a healing depot\n");

	}

	//argument = "short", "medium" or "long"
    else if (Q_stricmp (cmd, "plasmabomb") == 0)
	{
		if (ent->client->player_special & SPECIAL_PLASMA_BOMB)
			cmd_PlasmaBomb(ent);
		else
			if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Sorry, you can't create a plasma bomb.\n");
	}

	//argument = "build", "remove", "upgrade", "repair" and "reload"
    else if (Q_stricmp (cmd, "sentry") == 0)
	{
		if (ent->client->player_special & SPECIAL_SENTRY_GUN)
			cmd_Sentry(ent);
		else
			if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Sorry, you can't create a sentry gun.\n");
	}

	//argument = class number.  default to class # 1
    else if (Q_stricmp (cmd, "disguise") == 0)
	{
		if (ent->client->player_special & SPECIAL_DISGUISE)
			cmd_Disguise(ent);
		else
			if (ent->client) gi.cprintf (ent, PRINT_HIGH, "Sorry, you are not allowed to disguise.\n");
	}


//WF
	else	
	{
		//See if this command is the name of a player class
		class_picked = 0;
		for (i = 1; i <= numclasses; ++i)
		{
			if ((Q_stricmp (cmd, classinfo[i].name) == 0) && (class_picked == 0))
				class_picked = i;
		}

		if (class_picked)
		{
			ent->client->resp.next_player_class = class_picked;
			if (ent->client) gi.cprintf (ent, PRINT_HIGH, "You will become a %s the next time you respawn. \n",
				classinfo[class_picked].name);
		}
		else
		{
			// anything that doesn't match a command will be a chat
			Cmd_Say_f (ent, false, true);
		}
	}
}
