/*==============================================================================
The Weapons Factory - 
Misc Functions
Original code by Gregg Reno and others
==============================================================================*/
#include "g_local.h"
void wf_earthquake (edict_t *owner);
void NoAmmoWeaponChange (edict_t *ent);
void weapon_grenade_fire (edict_t *ent, qboolean held);
void Weapon_Grenade (edict_t *ent);
void Pipebomb_Explode (edict_t *ent);
void alarm_remove(edict_t *self);
void Goodyear_Explode (edict_t *ent);
void Proximity_Explode (edict_t *ent);
void laser_defense_die(edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
void supplydepot_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);


#define GRENADE_TIMER 3.0

void wf_set_grenade (edict_t *ent)
{
	gitem_t	*g;

	g = FindItem("Grenades");

	//Switch to the grenade if are not already on it
	if (ent->client->pers.weapon != g)
	{
		ent->client->newweapon = g;
		ent->client->ps.gunframe = 1;
		ent->client->weaponstate = WEAPON_READY;
		ent->client->grenade_time = 0;
		Weapon_Grenade (ent);
	}
	wf_show_grenade_type(ent);

//	ent->client->grenade_time = level.time + GRENADE_TIMER + 0.2;
//	weapon_grenade_fire (ent, false);
//	gi.dprintf("Threw grenade\n");
}

/*
=================
Cmd_Grenade_f
Set the type of grenade
=================
*/
void Cmd_Grenade_f (edict_t *ent)
{
	char    *string;
	int max_grenade_types;
	int old_type;

	string=gi.args();

	old_type = ent->client->pers.grenade_type;

	//If player classes are on, just cycle through the three
	//grenade types
	if (((int)wfflags->value & WF_NO_PLAYER_CLASSES) == 0)
		max_grenade_types = 3;
	else
		max_grenade_types = GRENADE_TYPE_COUNT;

	//If no argument, go to next grenade type
	if (Q_stricmp ( string, "") == 0)
	{
		//Pick next grenade number
		ent->client->pers.grenade_num += 1;
		if (ent->client->pers.grenade_num > max_grenade_types)
			ent->client->pers.grenade_num = 1;

		//Set grenade type based on grenade number
		if (((int)wfflags->value & WF_NO_PLAYER_CLASSES) == 0)
		{
			if (ent->client->pers.grenade_num == 1)	ent->client->pers.grenade_type = ent->client->grenade_type1;
			if (ent->client->pers.grenade_num == 2)	ent->client->pers.grenade_type = ent->client->grenade_type2;
			if (ent->client->pers.grenade_num == 3)	ent->client->pers.grenade_type = ent->client->grenade_type3;
			//Test for empty grenade type.  If so, use slot 1 grenade
			if (ent->client->pers.grenade_type == GRENADE_TYPE_NONE)
			{
				ent->client->pers.grenade_num = 1;
				ent->client->pers.grenade_type = ent->client->grenade_type1;
			}
		}
		else
			ent->client->pers.grenade_type = ent->client->pers.grenade_num;
	}
	else if (Q_stricmp ( string, "normal") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_NORMAL;
		}
	else if (Q_stricmp ( string, "laserball") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_LASERBALL;
		}
	else if (Q_stricmp ( string, "proximity") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_PROXIMITY;
		}
	else if (Q_stricmp ( string, "cluster") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_CLUSTER;
		}
//	else if (Q_stricmp ( string, "pipebomb") == 0)
//		{
//		ent->client->pers.grenade_type = GRENADE_TYPE_PIPEBOMB;
//		}
	else if (Q_stricmp ( string, "goodyear") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_GOODYEAR;
		}
	else if (Q_stricmp ( string, "flash") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_FLASH;
		}
	else if (Q_stricmp ( string, "quake") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_EARTHQUAKE;
		}
	else if (Q_stricmp ( string, "turret") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_TURRET;
		}
	else if (Q_stricmp ( string, "napalm") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_NAPALM;
		}
	else if (Q_stricmp ( string, "concussion") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_CONCUSSION;
		}
	else if (Q_stricmp ( string, "narcotic") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_NARCOTIC;
		}
	else if (Q_stricmp ( string, "plague") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_PLAGUE;
		}
	else if (Q_stricmp ( string, "magnotron") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_MAGNOTRON;
		}
	else if (Q_stricmp ( string, "shock") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_SHOCK;
		}
	else if (Q_stricmp ( string, "pipebomb") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_PIPEBOMB;
		}
	else if (Q_stricmp ( string, "shrapnel") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_SHRAPNEL;
		}
	else if (Q_stricmp ( string, "flare") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_FLARE;
		}
	else if (Q_stricmp ( string, "slow") == 0)
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_SLOW;
		}

	
	else	//default to normal grenade
		{
		ent->client->pers.grenade_type = GRENADE_TYPE_NORMAL;
		}

	//Check for valid grenade
	if (((int)wfflags->value & WF_NO_PLAYER_CLASSES) == 0)
	{
		if ((ent->client->pers.grenade_type != ent->client->grenade_type1) &&
		    (ent->client->pers.grenade_type != ent->client->grenade_type2) &&
		    (ent->client->pers.grenade_type != ent->client->grenade_type3))
		{
			gi.cprintf (ent, PRINT_HIGH, "You can't use that type of grenade.\n");
			ent->client->pers.grenade_type = old_type;
		}

	}

	wf_set_grenade(ent);
//	wf_show_grenade_type(ent);

}




void Cmd_Grenade1 (edict_t *ent)
{
	ent->client->pers.grenade_num = 1;
	ent->client->pers.grenade_type = ent->client->grenade_type1;
//	wf_show_grenade_type(ent);
	wf_set_grenade(ent);
}

void Cmd_Grenade2 (edict_t *ent)
{
	ent->client->pers.grenade_num = 2;
	ent->client->pers.grenade_type = ent->client->grenade_type2;
//	wf_show_grenade_type(ent);
	wf_set_grenade(ent);
}

void Cmd_Grenade3 (edict_t *ent)
{
	//This grenade type could be empty
	if (ent->client->grenade_type3 == GRENADE_TYPE_NONE)
	{
		//Use grenade 1 instead
		ent->client->pers.grenade_num = 1;
		ent->client->pers.grenade_type = ent->client->grenade_type1;
	}
	else
	{
		ent->client->pers.grenade_num = 3;
		ent->client->pers.grenade_type = ent->client->grenade_type3;
	}
//	wf_show_grenade_type(ent);
	wf_set_grenade(ent);
}

/* wf_show_grenade_type */
void wf_show_grenade_type(edict_t *ent)
{
	switch (ent->client->pers.grenade_type)
		{
		case (GRENADE_TYPE_NORMAL):
			gi.cprintf (ent, PRINT_HIGH, "Normal Grenade\n");
			break;
		case (GRENADE_TYPE_PROXIMITY):
			gi.cprintf (ent, PRINT_HIGH, "Proximity Grenade\n");
			break;
		case (GRENADE_TYPE_CLUSTER):
			gi.cprintf (ent, PRINT_HIGH, "Cluster Grenade\n");
			break;
		case (GRENADE_TYPE_LASERBALL):
			gi.cprintf (ent, PRINT_HIGH, "Laserball Grenade\n");
			break;
		case (GRENADE_TYPE_FLASH):
			gi.cprintf (ent, PRINT_HIGH, "Flash Grenade\n");
			break;
		case (GRENADE_TYPE_GOODYEAR):
			gi.cprintf (ent, PRINT_HIGH, "Goodyear Grenade\n");
			break;
		case (GRENADE_TYPE_EARTHQUAKE):
			gi.cprintf (ent, PRINT_HIGH, "Earthquake Grenade\n");
			break;
		case (GRENADE_TYPE_TURRET):
			gi.cprintf (ent, PRINT_HIGH, "Turret Grenade\n");
			break;
		case (GRENADE_TYPE_CONCUSSION):
			gi.cprintf (ent, PRINT_HIGH, "Concussion Grenade\n");
			break;
		case (GRENADE_TYPE_NARCOTIC):
			gi.cprintf (ent, PRINT_HIGH, "Narcotic Grenade\n");
			break;
		case (GRENADE_TYPE_PLAGUE):
			gi.cprintf (ent, PRINT_HIGH, "Plague Grenade\n");
			break;
		case (GRENADE_TYPE_MAGNOTRON):
			gi.cprintf (ent, PRINT_HIGH, "Magnotron Grenade\n");
			break;
		case (GRENADE_TYPE_SHOCK):
			gi.cprintf (ent, PRINT_HIGH, "Shock Grenade\n");
			break;
		case (GRENADE_TYPE_PIPEBOMB):
			gi.cprintf (ent, PRINT_HIGH, "Pipebomb Grenade\n");
			break;
		case (GRENADE_TYPE_SHRAPNEL):
			gi.cprintf (ent, PRINT_HIGH, "Shrapnel Grenade\n");
			break;
		case (GRENADE_TYPE_FLARE):
			gi.cprintf (ent, PRINT_HIGH, "Flare\n");
			break;
		case (GRENADE_TYPE_SLOW):
			gi.cprintf (ent, PRINT_HIGH, "Slow Grenade\n");
			break;
		case (GRENADE_TYPE_NAPALM):
			gi.cprintf (ent, PRINT_HIGH, "Napalm Grenade\n");
			break;
		default:
			gi.cprintf (ent, PRINT_HIGH, "UNKNOWN Grenade\n");
			break;
		}
}


/*
=================
Cmd_Thrust_f

MUCE:
To set jetpack on or off
=================
*/
void Cmd_Thrust_f (edict_t *ent)
{
        char    *string;

        string=gi.args();

        if (Q_stricmp ( string, "on") == 0)
        {
                ent->client->thrusting=1;
                ent->client->next_thrust_sound=0;
        }
        else
        {
                ent->client->thrusting=0;
        }
}

/*
=================
Cmd_Homing_f
CCH: whole new function for adjusting homing missile state
=================
*/
void Cmd_Homing_f (edict_t *ent)
     {
        char    *string;

        string=gi.args();

        if (Q_stricmp ( string, "on") == 0)
			{
            gi.cprintf (ent, PRINT_HIGH, "HOMING MISSILES ON\n");
            ent->client->pers.homing_state = 1;
			}
		else if (Q_stricmp ( string, "off") == 0)
			{
            gi.cprintf (ent, PRINT_HIGH, "Homing missiles off\n");
            ent->client->pers.homing_state = 0;
			}
        else	//If no "on" or "off", toggle state
			{
			if (ent->client->pers.homing_state == 0)
				{
                gi.cprintf (ent, PRINT_HIGH, "HOMING MISSILES ON\n");
                ent->client->pers.homing_state = 1;
				}
			else
				{
	            gi.cprintf (ent, PRINT_HIGH, "Homing missiles off\n");
		        ent->client->pers.homing_state = 0;
				}
            }
     }

/*
=================
Cmd_Reno_f

Special Reno Commands
=================
*/
void Cmd_Reno_f (edict_t *ent)
{
        char    *string;

        string=gi.args();

        if (Q_stricmp ( string, "enter") == 0)
        {
                gi.sound (ent, CHAN_VOICE, gi.soundindex ("renoenter.wav"), 1, ATTN_NORM, 0);
        }
        if (Q_stricmp ( string, "exit") == 0)
        {
                gi.sound (ent, CHAN_VOICE, gi.soundindex ("renoexit.wav"), 1, ATTN_NORM, 0);
        }
        if (Q_stricmp ( string, "talk") == 0)
        {
                gi.sound (ent, CHAN_VOICE, gi.soundindex ("renotalk.wav"), 1, ATTN_NORM, 0);
        }
//        if (Q_stricmp ( string, "earthquake") == 0)
//        {
//                        wf_earthquake (ent);
//        }

}

//Respawn protection function from Keys2 Mod
qboolean K2_IsProtected(edict_t *ent)
{
	if (!ent->client)
		return false;

	if (ent->client->protecttime > level.time)
		return true;
	else
		return false;
}


/*
==================================
Cmd_WFFlags

Show the Weapons Factory Flags
==================================
*/
void Cmd_WFFlags_f (edict_t *ent)
{

    gi.cprintf (ent, PRINT_HIGH, "WF Flags = %d\n", (int)wfflags->value);

	if ((int)wfflags->value & WF_ALLOW_FRIENDLY_FIRE)
		gi.cprintf (ent, PRINT_HIGH, "WF_ALLOW_FRIENDLY_FIRE is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_ALLOW_FRIENDLY_FIRE is OFF\n");

	if ((int)wfflags->value & WF_NO_PLAYER_CLASSES)
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_PLAYER_CLASSES are ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_PLAYER_CLASSES are OFF\n");

	if ((int)wfflags->value & WF_NO_FORT_RESPAWN)
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_FORT_RESPAWN is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_FORT_RESPAWN is OFF\n");

	if ((int)wfflags->value & WF_NO_HOMING)
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_HOMING is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_HOMING is OFF\n");

	if ((int)wfflags->value & WF_NO_FLYING)
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_FLYING is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_FLYING is OFF\n");

	if ((int)wfflags->value & WF_DECOY_PURSUE)
		gi.cprintf (ent, PRINT_HIGH, "WF_DECOY_PURSUE is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_DECOY_PURSUE is OFF\n");

	if ((int)wfflags->value & WF_NO_RAILGUN_EFFECT)
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_RAILGUN_EFFECT is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_RAILGUN_EFFECT is OFF\n");

	if ((int)wfflags->value & WF_NO_TURRET)
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_TURRET is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_TURRET is OFF\n");

	if ((int)wfflags->value & WF_NO_EARTHQUAKES)
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_EARTHQUAKES is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_NO_EARTHQUAKES is OFF\n");

//	if ((int)wfflags->value & WF_RESPAWN_ARMED)
//		gi.cprintf (ent, PRINT_HIGH, "WF_RESPAWN_ARMED is ON\n");
//	else
//		gi.cprintf (ent, PRINT_HIGH, "WF_RESPAWN_ARMED is OFF\n");

	if ((int)wfflags->value & WF_MAP_VOTE)
		gi.cprintf (ent, PRINT_HIGH, "WF_MAP_VOTE is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_MAP_VOTE is OFF\n");

	if ((int)wfflags->value & WF_STD_LOG)
		gi.cprintf (ent, PRINT_HIGH, "WF_STD_LOG is ON\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "WF_STD_LOG is OFF\n");


}

void SV_WFFlags_f ()
{

    gi.dprintf ( "WF Flags = %d\n", (int)wfflags->value);

	if ((int)wfflags->value & WF_ALLOW_FRIENDLY_FIRE)
		gi.dprintf ( "WF_ALLOW_FRIENDLY_FIRE is ON\n");
	else
		gi.dprintf ( "WF_ALLOW_FRIENDLY_FIRE is OFF\n");

	if ((int)wfflags->value & WF_NO_PLAYER_CLASSES)
		gi.dprintf ( "WF_NO_PLAYER_CLASSES are ON\n");
	else
		gi.dprintf ( "WF_NO_PLAYER_CLASSES are OFF\n");

	if ((int)wfflags->value & WF_NO_FORT_RESPAWN)
		gi.dprintf ( "WF_NO_FORT_RESPAWN is ON\n");
	else
		gi.dprintf ( "WF_NO_FORT_RESPAWN is OFF\n");

	if ((int)wfflags->value & WF_NO_HOMING)
		gi.dprintf ( "WF_NO_HOMING is ON\n");
	else
		gi.dprintf ( "WF_NO_HOMING is OFF\n");

	if ((int)wfflags->value & WF_NO_FLYING)
		gi.dprintf ( "WF_NO_FLYING is ON\n");
	else
		gi.dprintf ( "WF_NO_FLYING is OFF\n");

	if ((int)wfflags->value & WF_DECOY_PURSUE)
		gi.dprintf ( "WF_DECOY_PURSUE is ON\n");
	else
		gi.dprintf ( "WF_DECOY_PURSUE is OFF\n");

	if ((int)wfflags->value & WF_NO_RAILGUN_EFFECT)
		gi.dprintf ( "WF_NO_RAILGUN_EFFECT is ON\n");
	else
		gi.dprintf ( "WF_NO_RAILGUN_EFFECT is OFF\n");

	if ((int)wfflags->value & WF_NO_TURRET)
		gi.dprintf ( "WF_NO_TURRET is ON\n");
	else
		gi.dprintf ( "WF_NO_TURRET is OFF\n");

	if ((int)wfflags->value & WF_NO_EARTHQUAKES)
		gi.dprintf ( "WF_NO_EARTHQUAKES is ON\n");
	else
		gi.dprintf ( "WF_NO_EARTHQUAKES is OFF\n");

//	if ((int)wfflags->value & WF_RESPAWN_ARMED)
//		gi.dprintf ( "WF_RESPAWN_ARMED is ON\n");
//	else
//		gi.dprintf ( "WF_RESPAWN_ARMED is OFF\n");

	if ((int)wfflags->value & WF_MAP_VOTE)
		gi.dprintf ( "WF_MAP_VOTE is ON\n");
	else
		gi.dprintf ( "WF_MAP_VOTE is OFF\n");

	if ((int)wfflags->value & WF_STD_LOG)
		gi.dprintf ( "WF_STD_LOG is ON\n");
	else
		gi.dprintf ( "WF_STD_LOG is OFF\n");


}


/*
==================================
wf_IsWeapon

Determine if an item is a weapon that should be removed 
from map (if player classes are used

Also checks for other items to remove
==================================
*/
qboolean wf_IsWeapon(char *classname)
{
	if (strcmp(classname, "weapon_shotgun") == 0) return true;
	if (strcmp(classname, "weapon_supershotgun") == 0) return true;
	if (strcmp(classname, "weapon_machinegun") == 0) return true;
	if (strcmp(classname, "weapon_chaingun") == 0) return true;
	if (strcmp(classname, "weapon_grenadelauncher") == 0) return true;
	if (strcmp(classname, "weapon_rocketlauncher") == 0) return true;
	if (strcmp(classname, "weapon_hyperblaster") == 0) return true;
	if (strcmp(classname, "weapon_railgun") == 0) return true;
	if (strcmp(classname, "weapon_bfg") == 0) return true;

	//Removes power shield from map too
	if (strcmp(classname, "item_power_shield") == 0) return true;

	return false;
}

void wf_GiveItem(gclient_t *client, char *item_name, int item_count)
{
	gitem_t *item;

	item = FindItem(item_name);
	if (item)
	{
		client->pers.inventory[ITEM_INDEX(item)] = item_count;
//        gi.dprintf ("WF: Gave item: %s\n",item_name);
	}
	else
        gi.dprintf ("WF: Can't give item: %s\n",item_name);
}


void wf_InitPlayerClass(gclient_t *client)
{

	switch (client->player_class)
	{
	case CLASS_RECON:
		client->player_weapons	= RECON_WEAPONS;
		client->player_armor	= RECON_ARMOR;
		client->player_speed	= RECON_SPEED;
		client->player_model	= RECON_MODEL;
		client->player_maxhealth = RECON_HEALTH;
		client->grenade_type1   = RECON_GRENADE1;
		client->grenade_type2   = RECON_GRENADE2;
		client->grenade_type3   = RECON_GRENADE3;
		client->player_special  = RECON_SPECIAL;
		client->player_items	= RECON_ITEMS;
		break;

	case CLASS_NURSE:
		client->player_weapons	= NURSE_WEAPONS;
		client->player_armor	= NURSE_ARMOR;
		client->player_speed	= NURSE_SPEED;
		client->player_model	= NURSE_MODEL;
		client->player_maxhealth = NURSE_HEALTH;
		client->grenade_type1   = NURSE_GRENADE1;
		client->grenade_type2   = NURSE_GRENADE2;
		client->grenade_type3   = NURSE_GRENADE3;
		client->player_special  = NURSE_SPECIAL;
		client->player_items	= NURSE_ITEMS;
		break;

	case CLASS_ENGINEER:
		client->player_weapons	= ENGINEER_WEAPONS;
		client->player_armor	= ENGINEER_ARMOR;
		client->player_speed	= ENGINEER_SPEED;
		client->player_model	= ENGINEER_MODEL;
		client->player_maxhealth = ENGINEER_HEALTH;
		client->grenade_type1   = ENGINEER_GRENADE1;
		client->grenade_type2   = ENGINEER_GRENADE2;
		client->grenade_type3   = ENGINEER_GRENADE3;
		client->player_special	= ENGINEER_SPECIAL;
		client->player_items	= ENGINEER_ITEMS;
		break;

	case CLASS_MARINE:
		client->player_weapons	= MARINE_WEAPONS;
		client->player_armor	= MARINE_ARMOR;
		client->player_speed	= MARINE_SPEED;
		client->player_model	= MARINE_MODEL;
		client->player_maxhealth = MARINE_HEALTH;
		client->grenade_type1   = MARINE_GRENADE1;
		client->grenade_type2   = MARINE_GRENADE2;
		client->grenade_type3   = MARINE_GRENADE3;
		client->player_special  = MARINE_SPECIAL;
		client->player_items	= MARINE_ITEMS;
		break;

	case CLASS_CYBORG:
		client->player_weapons	= CYBORG_WEAPONS;
		client->player_armor	= CYBORG_ARMOR;
		client->player_speed	= CYBORG_SPEED;
		client->player_model	= CYBORG_MODEL;
		client->player_maxhealth = CYBORG_HEALTH;
		client->grenade_type1   = CYBORG_GRENADE1;
		client->grenade_type2   = CYBORG_GRENADE2;
		client->grenade_type3   = CYBORG_GRENADE3;
		client->player_special  = CYBORG_SPECIAL;
		client->player_items	= CYBORG_ITEMS;
		break;

	case CLASS_ARSONIST:
		client->player_weapons	= ARSONIST_WEAPONS;
		client->player_armor	= ARSONIST_ARMOR;
		client->player_speed	= ARSONIST_SPEED;
		client->player_model	= ARSONIST_MODEL;
		client->player_maxhealth = ARSONIST_HEALTH;
		client->grenade_type1   = ARSONIST_GRENADE1;
		client->grenade_type2   = ARSONIST_GRENADE2;
		client->grenade_type3   = ARSONIST_GRENADE3;
		client->player_special  = ARSONIST_SPECIAL;
		client->player_items	= ARSONIST_ITEMS;
		break;

	case CLASS_SUPERMAN:
		client->player_weapons	= SUPERMAN_WEAPONS;
		client->player_armor	= SUPERMAN_ARMOR;
		client->player_speed	= SUPERMAN_SPEED;
		client->player_model	= SUPERMAN_MODEL;
		client->player_maxhealth = SUPERMAN_HEALTH;
		client->grenade_type1   = SUPERMAN_GRENADE1;
		client->grenade_type2   = SUPERMAN_GRENADE2;
		client->grenade_type3   = SUPERMAN_GRENADE3;
		client->player_special  = SUPERMAN_SPECIAL;
		client->player_items	= SUPERMAN_ITEMS;
		break;
	default:
//        gi.dprintf ("WF: NO CLASS CHOSEN\n");
		break;
	}

//	client->pers.max_health	= client->pers.health;

	//Give everyone a few grenades and set default grenade
	wf_GiveItem(client,"Grenades", 5);
	client->pers.grenade_type = client->grenade_type1;

	//Give weapons and ammo to the player
	if (client->player_weapons & WEAPON_SHOTGUN)
	{
		wf_GiveItem(client,"Shotgun", 1);
		wf_GiveItem(client,"Shells", 10);
	}

	if (client->player_weapons & WEAPON_SUPERSHOTGUN)
	{
		wf_GiveItem(client,"Super Shotgun", 1);
		wf_GiveItem(client,"Shells", 20);
	}

	if (client->player_weapons & WEAPON_MACHINEGUN)
	{
		wf_GiveItem(client,"Machinegun", 1);
		wf_GiveItem(client,"Bullets", 50);
	}

	if (client->player_weapons & WEAPON_CHAINGUN)
	{
		wf_GiveItem(client,"Chaingun", 1);
		wf_GiveItem(client,"Bullets", 150);
	}

	if (client->player_weapons & WEAPON_HYPERBLASTER)
	{
		wf_GiveItem(client,"HyperBlaster", 1);
		wf_GiveItem(client,"Cells", 50);
	}

	if (client->player_weapons & WEAPON_ROCKETLAUNCHER)
	{
		wf_GiveItem(client,"Rocket Launcher", 1);
		wf_GiveItem(client,"Rockets", 5);
		wf_GiveItem(client,"Cells", 20);
	}

	if (client->player_weapons & WEAPON_GRENADELAUNCHER)
	{
		wf_GiveItem(client,"Grenade Launcher", 1);
		wf_GiveItem(client,"Grenades", 15);
	}

	if (client->player_weapons & WEAPON_RAILGUN)
	{
		wf_GiveItem(client,"Railgun", 1);
		wf_GiveItem(client,"Slugs", 10);
	}

	if (client->player_weapons & WEAPON_BFG)
	{
		wf_GiveItem(client,"BFG10K", 1);
		wf_GiveItem(client,"Cells", 150);
	}

	//New Weapons
	if (client->player_weapons & WEAPON_NEEDLER)
	{
		wf_GiveItem(client,"Needler", 1);
		wf_GiveItem(client,"Bullets", 50);
	}

	if (client->player_weapons & WEAPON_NAG)
	{
		wf_GiveItem(client,"Nervous Accelerator Gun", 1);
		wf_GiveItem(client,"Cells", 20);
	}

	if (client->player_weapons & WEAPON_TELSA)
	{
		wf_GiveItem(client,"Telsa Coil", 1);
		wf_GiveItem(client,"Cells", 50);
	}

	if (client->player_weapons & WEAPON_LIGHTNING)
	{
		wf_GiveItem(client,"Lightning Gun", 1);
		wf_GiveItem(client,"Slugs", 20);
	}

	if (client->player_weapons & WEAPON_NAILGUN)
	{
		wf_GiveItem(client,"NailGun", 1);
		wf_GiveItem(client,"Bullets", 50);
	}
/*
	if (client->player_weapons & WEAPON_MAGBOLTED)
	{
		wf_GiveItem(client,"Mag Bolted", 1);
		wf_GiveItem(client,"Bullets", 50);
	}
*/
	if (client->player_weapons & WEAPON_PELLET)
	{
		wf_GiveItem(client,"Pellet Rocket Launcher", 1);
		wf_GiveItem(client,"Rockets", 10);
	}


	if (client->player_weapons & WEAPON_PULSE)
	{
		wf_GiveItem(client,"Pulse Cannon", 1);
		wf_GiveItem(client,"Bullets", 50);
	}

	if (client->player_weapons & WEAPON_SHC)
	{
		wf_GiveItem(client,"SHC Rifle", 1);
		wf_GiveItem(client,"Shells", 10);
	}

	if (client->player_weapons & WEAPON_FLAREGUN)
	{
		wf_GiveItem(client,"Flare Gun", 1);
		wf_GiveItem(client,"Bullets", 50);
	}

	if (client->player_weapons & WEAPON_NAPALMMISSLE)
	{
		wf_GiveItem(client,"Rocket Napalm Launcher", 1);
		wf_GiveItem(client,"Rockets", 10);
	}

	if (client->player_weapons & WEAPON_FLAMETHROWER)
	{
		wf_GiveItem(client,"FlameThrower", 1);
		wf_GiveItem(client,"Cells", 50);
	}

	if (client->player_weapons & WEAPON_INFECTEDDART)
	{
		wf_GiveItem(client,"Infected Dart Launcher", 1);
		wf_GiveItem(client,"Shells", 10);
	}

	if (client->player_weapons & WEAPON_LASERSNIPER)
	{
		wf_GiveItem(client,"Laser Sniper Rifle", 1);
		wf_GiveItem(client,"Slugs", 10);
	}

	if (client->player_weapons & WEAPON_CLUSTERROCKET)
	{
		wf_GiveItem(client,"Cluster Rocket Launcher", 1);
		wf_GiveItem(client,"Rockets", 5);
	}

	if (client->player_weapons & WEAPON_ARMORDART)
	{
		wf_GiveItem(client,"Poison Dart Launcher", 1);
		wf_GiveItem(client,"Shells", 10);
	}

	if (client->player_weapons & WEAPON_SHOTGUNCHOKE)
	{
		wf_GiveItem(client,"Shotgun Choke", 1);
		wf_GiveItem(client,"Shells", 10);
	}

	if (client->player_weapons & WEAPON_SNIPERRIFLE)
	{
		wf_GiveItem(client,"Sniper Rifle", 1);
		wf_GiveItem(client,"Slugs", 10);
	}

	if (client->player_weapons & WEAPON_TRANQUILIZER)
	{
		wf_GiveItem(client,"Tranquilizer", 1);
		wf_GiveItem(client,"Shells", 10);
	}

	if (client->player_weapons & WEAPON_LRPROJECTILE)
	{
		wf_GiveItem(client,"Projectile Launcher", 1);
		wf_GiveItem(client,"Rockets", 10);
	}

	//Class specific items
	if (client->player_class == CLASS_MARINE)
	{
		wf_GiveItem(client,"Slugs", 20);
	}


	//Give special items
	if (client->player_items & ITEM_REBREATHER)
		wf_GiveItem(client,"Rebreather", 1);

/* Don't give out armor.  Let them pick it up
	if (client->player_items & ITEM_BODYARMOR)
		wf_GiveItem(client,"Body Armor", 1);

	if (client->player_items & ITEM_COMBATARMOR)
		wf_GiveItem(client,"Combat Armor", 1);

	if (client->player_items & ITEM_JACKETARMOR)
		wf_GiveItem(client,"Jacket Armor", 1);

	if (client->player_items & ITEM_POWERSCREEN)
		wf_GiveItem(client,"Power Screen", 1);

*/
	if (client->player_items & ITEM_POWERSHIELD)
		wf_GiveItem(client,"Power Shield", 1);

	if (client->player_items & ITEM_SILENCER)
		wf_GiveItem(client,"Silencer", 1);
}


//What model is used by this class?
int wf_GetClassModel(int p_class)
{
	int p_model;

	switch (p_class)
	{
	case CLASS_RECON:
		p_model	= RECON_MODEL;
		break;
	case CLASS_NURSE:
		p_model	= NURSE_MODEL;
		break;
	case CLASS_ENGINEER:
		p_model	= ENGINEER_MODEL;
		break;
	case CLASS_CYBORG:
		p_model	= CYBORG_MODEL;
		break;
	case CLASS_MARINE:
		p_model	= MARINE_MODEL;
		break;
	case CLASS_ARSONIST:
		p_model	= ARSONIST_MODEL;
		break;
	case CLASS_SUPERMAN:
		p_model	= SUPERMAN_MODEL;
		break;
	default:
		p_model = ARSONIST_MODEL;
		break;
	}

	return (p_model);

}


/*
=================
Cmd_DSkin_f

Decoy Skin Commands
=================
*/
void Cmd_DSkin_f (edict_t *ent)
{
        char    *string;

        string=gi.args();

        if (Q_stricmp ( string, "0") == 0)
        {
            if (ent->decoy)
               ent->decoy->s.skinnum = 0;
        }
        if (Q_stricmp ( string, "1") == 0)
        {
            if (ent->decoy)
               ent->decoy->s.skinnum = 1;
        }
        if (Q_stricmp ( string, "2") == 0)
        {
            if (ent->decoy)
               ent->decoy->s.skinnum = 2;
        }
        if (Q_stricmp ( string, "3") == 0)
        {
            if (ent->decoy)
               ent->decoy->s.skinnum = 3;
        }
        if (Q_stricmp ( string, "0") == 0)
        {
            if (ent->decoy)
               ent->decoy->s.skinnum = 0;
        }

}
char getClassCode (gclient_t *c)
{
	if (!c) return '?';

	switch (c->player_class)
	{
		case (CLASS_RECON):
			return 'R';
			break;
		case (CLASS_NURSE):
			return 'N';
			break;
		case (CLASS_ENGINEER):
			return 'E';
			break;
		case (CLASS_MARINE):
			return 'M';
			break;
		case (CLASS_CYBORG):
			return 'C';
			break;
		case (CLASS_ARSONIST):
			return 'A';
			break;
		case (CLASS_SUPERMAN):
			return 'S';
			break;
		default:
			return '?';
			break;
	}
}

char *getClassName (gclient_t *c)
{

	if (!c) 
		return "(unknown)";

	switch (c->player_class)
	{
		case (CLASS_RECON):
			return "Recon";
			break;
		case (CLASS_NURSE):
			return "Nurse";
			break;
		case (CLASS_ENGINEER):
			return "Engineer";
			break;
		case (CLASS_MARINE):
			return "Marine";
			break;
		case (CLASS_CYBORG):
			return "Cyborg";
			break;
		case (CLASS_ARSONIST):
			return "Arsonist";
			break;
		case (CLASS_SUPERMAN):
			return "Superman";
			break;
		default:
			return "(unknown)";
			break;
	}
}


/*
=================
Cmd_ShowClass
=================
*/
void Cmd_ShowClass (edict_t *ent)
{
	switch (ent->client->player_class)
	{
		case (CLASS_RECON):
			gi.cprintf (ent, PRINT_HIGH, "You are a RECON\n");
			break;
		case (CLASS_NURSE):
			gi.cprintf (ent, PRINT_HIGH, "You are a COMBAT NURSE\n");
			break;
		case (CLASS_ENGINEER):
			gi.cprintf (ent, PRINT_HIGH, "You are an ENGINEER\n");
			break;
		case (CLASS_MARINE):
			gi.cprintf (ent, PRINT_HIGH, "You are a MARINE\n");
			break;
		case (CLASS_CYBORG):
			gi.cprintf (ent, PRINT_HIGH, "You are a CYBORG\n");
			break;
		case (CLASS_ARSONIST):
			gi.cprintf (ent, PRINT_HIGH, "You are an ARSONIST\n");
			break;
		case (CLASS_SUPERMAN):
			gi.cprintf (ent, PRINT_HIGH, "You are a SUPERMAN\n");
			break;
		default:
			//gi.cprintf (ent, PRINT_HIGH, "You don't have a class!\n");
			break;
	}
//	gi.cprintf (ent, PRINT_HIGH, "Curr=%d, Next=%d\n",
//		ent->client->player_class,ent->client->resp.next_player_class);
}

//Show all the players
void Cmd_ShowPlayers(edict_t *ent)
{
//	edict_t		*cl_ent;
//	gclient_t	*cl;
	edict_t	*e;

	int i;
	char classname[32];

	strcpy(classname,"123");

	//Show red players first
	for (i=1, e=g_edicts+i; i < globals.num_edicts; i++,e++)
	{
		if (!e->inuse)
			continue;
		if (!e->client)
			continue;
		//getClassName(e->client, classname);
		if (e->client->resp.ctf_team == CTF_TEAM1)
		{
			gi.cprintf (ent, PRINT_HIGH, "Red  %3d %8s %s\n",
				e->client->resp.score,
				getClassName(e->client),
				e->client->pers.netname);
		}
	}

	//Next blue
	for (i=1, e=g_edicts+i; i < globals.num_edicts; i++,e++)
	{
		if (!e->inuse)
			continue;
		if (!e->client)
			continue;
		//getClassName(e->client, classname);
		if (e->client->resp.ctf_team == CTF_TEAM2)
		{
			gi.cprintf (ent, PRINT_HIGH, "Blue %3d %8s %s\n",
				e->client->resp.score,
				getClassName(e->client),
				e->client->pers.netname);
		}
	}

	//Then observers
	for (i=1, e=g_edicts+i; i < globals.num_edicts; i++,e++)
	{
		if (!e->inuse)
			continue;
		if (!e->client)
			continue;
		//getClassName(e->client, classname);
		if (e->client->resp.ctf_team <= 0)
		{
			gi.cprintf (ent, PRINT_HIGH, "Obsv %3d %8s %s\n",
				e->client->resp.score,
				getClassName(e->client),
				e->client->pers.netname);
		}
	}
}


void Cmd_WFPlayTeam (edict_t *self, char *wavename)
{
	int		i;
	edict_t	*e;
	char cmd[250];

	if (strlen(wavename) > 200) wavename[200] = '\0';
	sprintf(cmd, "play %s\n",wavename);

	//Loop through all the entities to find players on the same team
	for (i=1, e=g_edicts+i; i < globals.num_edicts; i++,e++)
	{
		if (!e->inuse)
			continue;
		if (!e->client)
			continue;

		if (e->wf_team == self->wf_team)
			stuffcmd(e,cmd);

	}
}

//When player dies, clean up entities
void WFPlayer_Die (edict_t *ent)
{
	edict_t *blip = NULL;
	int i;

	for (i=1, blip=g_edicts+i ; i < globals.num_edicts ; i++,blip++)
//	while ((blip = findradius(blip, ent->s.origin, 1000)) != NULL)
	{
 	  if (blip->owner == ent)
	  {

		//Pipebombs
		if (!strcmp(blip->classname, "pipebomb") )
		{
			blip->think = Pipebomb_Explode;
			blip->nextthink = level.time + .1;
		}

	  }
	}
}

//If player changes class or team
void WFPlayer_ChangeClassTeam (edict_t *ent)
{
	edict_t *blip = NULL;
	int i;

	for (i=1, blip=g_edicts+i ; i < globals.num_edicts ; i++,blip++)
//	while ((blip = findradius(blip, ent->s.origin, 1000)) != NULL)
	{
 	  if ((blip->owner) && (blip->owner == ent))
	  {
		//Pipebombs
		if (!strcmp(blip->classname, "pipebomb") )
		{
			blip->think = Pipebomb_Explode;
			blip->nextthink = level.time + .1;
		}

		//Supply depot
		if (!strcmp(blip->classname, "depot") )
		{
			G_FreeEdict(blip);
                        if (blip->owner) blip->owner->supply = NULL;
//                      blip->think = supplydepot_die;
//			blip->nextthink = level.time + .1;
		}

		//Goodyear grenades
		if (!strcmp(blip->classname, "goodyear") )
		{
			blip->think = Goodyear_Explode;
			blip->nextthink = level.time + .1;
		}

		//Proximity grenades
		if (!strcmp(blip->classname, "proximity") )
		{
			blip->think = Proximity_Explode;
			blip->nextthink = level.time + .1;
		}

		//Laser defense
		if (!strcmp(blip->classname, "laser_defense") )
		{
			laser_defense_die(blip, NULL, NULL, 0, NULL);
		}


		//Alarms
		if (!strcmp(blip->classname, "Alarm") )
		{
			alarm_remove(blip);
		}
	  }

	  //These items use creator instead of owner
	  //so that you can't walk through them
 	  if ((blip->creator) && (blip->creator == ent))
	  {
		//Sentry guns
		if (!strcmp(blip->classname, "SentryGun") )
		{
			turret_remove(blip->creator);
		}
	  }
	}
}
