/*==============================================================================
The Weapons Factory - 
Global Include File
Original code by Gregg Reno
==============================================================================*/

#define WF_VERSION  "*Version 2.4d"
#define WF_URL "www.captured.com/weaponsfactory"

/* -------------------------------
   CONSTANTS AND MACROS 
------------------------------- */

// Grenade types
#define GRENADE_TYPE_NONE		0
#define GRENADE_TYPE_NORMAL		1
#define GRENADE_TYPE_LASERBALL	2
#define GRENADE_TYPE_GOODYEAR	3
#define GRENADE_TYPE_PROXIMITY	4
#define GRENADE_TYPE_FLASH		5
#define GRENADE_TYPE_CLUSTER	6
#define GRENADE_TYPE_EARTHQUAKE	7
#define GRENADE_TYPE_TURRET		8
#define GRENADE_TYPE_NAPALM		9
#define GRENADE_TYPE_CONCUSSION	10
#define GRENADE_TYPE_NARCOTIC	11
#define GRENADE_TYPE_PLAGUE		12
#define GRENADE_TYPE_MAGNOTRON	13
#define GRENADE_TYPE_SHOCK		14
#define GRENADE_TYPE_PIPEBOMB	15
#define GRENADE_TYPE_SHRAPNEL	16
#define GRENADE_TYPE_FLARE		17
#define GRENADE_TYPE_SLOW		18
#define GRENADE_TYPE_COUNT      18  //How many grenade types?

//Maximum number of active grenades for each type
#define MAX_TYPE_NORMAL     999
#define MAX_TYPE_LASERBALL  1
#define MAX_TYPE_GOODYEAR   4
#define MAX_TYPE_PROXIMITY  4
#define MAX_TYPE_FLASH      999
#define MAX_TYPE_CLUSTER    999
#define MAX_TYPE_EARTHQUAKE 999
#define MAX_TYPE_TURRET		2
#define MAX_TYPE_NAPALM     2
#define MAX_TYPE_CONCUSSION	1
#define MAX_TYPE_NARCOTIC	999
#define MAX_TYPE_PLAGUE		999
#define MAX_TYPE_MAGNOTRON	1
#define MAX_TYPE_SHOCK		2
#define MAX_TYPE_PIPEBOMB	999
#define MAX_TYPE_SHRAPNAL	999
#define MAX_TYPE_FLARE		999
#define MAX_TYPE_SLOW		999

// proximity grenade
#define PROXIMITY_TYPE_GRENADE	1
#define PROXIMITY_TYPE_PIPE     2

// grenade requirements
#define LASERBALL_CELLS			18
#define DECOY_CELLS			    0
#define EARTHQUAKE_GRENADES		6
#define TURRET_GRENADES			2
#define TURRET_SLUGS			4

//Other
#define RESPAWN_PROTECT_TIME	8.0

//Model Types
#define CLASS_MODEL_MALE		1
#define CLASS_MODEL_FEMALE		2
#define CLASS_MODEL_CYBORG		3
#define CLASS_MODEL_ANY			4	//use the player's choice

// Weapon types (bit masks)
#define WEAPON_BLASTER          1			//1
#define WEAPON_SHOTGUN          2			//2
#define WEAPON_SUPERSHOTGUN     4			//3
#define WEAPON_MACHINEGUN       8			//4
#define WEAPON_CHAINGUN         16			//5
#define WEAPON_HYPERBLASTER     32			//6
#define WEAPON_ROCKETLAUNCHER   64			//7
#define WEAPON_GRENADELAUNCHER  128			//8
#define WEAPON_RAILGUN          256			//9
#define WEAPON_BFG              512			//10
#define WEAPON_NEEDLER			1024		//11
#define WEAPON_NAG				2048		//12
#define WEAPON_TELSA			4096		//13
#define WEAPON_LIGHTNING		8192		//14
#define WEAPON_NAILGUN			16384		//15
#define WEAPON_CLUSTERROCKET	32768		//16
#define WEAPON_MAGBOLTED		65536		//17
#define WEAPON_PELLET			131072		//18
#define WEAPON_PULSE			262144		//19
#define WEAPON_SHC				524288		//20
#define WEAPON_FLAREGUN			1048576		//21
#define WEAPON_NAPALMMISSLE		2097152		//22
#define WEAPON_FLAMETHROWER		4194304		//23
#define WEAPON_TRANQUILIZER		8388608		//24
#define WEAPON_INFECTEDDART		16777216	//25
#define WEAPON_LASERSNIPER		33554432	//26
#define WEAPON_ARMORDART		67108864	//27
#define WEAPON_SHOTGUNCHOKE		134217728	//28
#define WEAPON_SNIPERRIFLE		268435456	//29
#define WEAPON_LRPROJECTILE		536870912	//30

// Player items
#define ITEM_NONE				0
#define ITEM_REBREATHER			1
#define ITEM_BODYARMOR			2
#define ITEM_COMBATARMOR		4
#define ITEM_JACKETARMOR		8
#define ITEM_POWERSCREEN		16
#define ITEM_POWERSHIELD		32
#define ITEM_SILENCER			64
//Temporary - use these for new items
#define ITEM_t1		128
#define ITEM_t2		256
#define ITEM_t3		512
#define ITEM_t4		1024
#define ITEM_t5		2048
#define ITEM_t6		4096


// Player special abilities
#define SPECIAL_NONE				0
#define SPECIAL_JETPACK				1		//1
#define SPECIAL_BINOCULARS			2		//2
#define SPECIAL_REMOTE_CAMERA		4		//3
#define SPECIAL_ANTIGRAV_BOOTS		8		//4
#define SPECIAL_DISGUISE			16		//5
#define SPECIAL_FEIGN				32		//6
#define SPECIAL_HEALING				64		//7
#define SPECIAL_SENTRY_GUN			128		//8
#define SPECIAL_MISSILE_LAUNCHER	256		//9
#define SPECIAL_REPAIR_ARMOR		512		//10
#define SPECIAL_ALARMS				1024	//11
#define SPECIAL_KAMIKAZE			2048	//12
#define SPECIAL_LASER_DEFENSE		4096	//13
#define SPECIAL_FLAME_RESISTANCE	8192	//14
#define SPECIAL_TRIPBOMB			16384	//15
#define SPECIAL_QUAKE				32768	//16
#define SPECIAL_SUPPLY_DEPOT		65536	//17
#define SPECIAL_PLASMA_BOMB			131072 	//18
//Temporary - use these for new special abilities
#define SPECIAL_t2			262144
#define SPECIAL_t3			524288
#define SPECIAL_t4			1048576	
#define SPECIAL_t5			2097152		
#define SPECIAL_t6			4194304	
//THESE TWO ARE RESERVED	
#define SPECIAL_OPTION1		8388608
#define SPECIAL_OPTION2		16777216
#define SPECIAL_COUNT		24

//MAX COUNTS FOR EACH SPECIAL THING
#define MAX_SPECIAL_REMOTE_CAMERA		1
#define MAX_SPECIAL_SENTRY_GUN			1
#define MAX_SPECIAL_MISSILE_LAUNCHER	1
#define MAX_SPECIAL_ALARMS				2
#define MAX_SPECIAL_LASER_DEFENSE		2
#define MAX_SPECIAL_TRIPBOMB			2
#define MAX_SPECIAL_QUAKE				2
#define MAX_SPECIAL_SUPPLY_DEPOT		1
#define MAX_SPECIAL_PLASMA_BOMB			1

//Sequential list of special items, rather than bitmask
#define ITEM_SPECIAL_REMOTE_CAMERA		1
#define ITEM_SPECIAL_SENTRY_GUN			2
#define ITEM_SPECIAL_MISSILE_LAUNCHER	3
#define ITEM_SPECIAL_ALARMS				4
#define ITEM_SPECIAL_LASER_DEFENSE		5
#define ITEM_SPECIAL_TRIPBOMB			6
#define ITEM_SPECIAL_QUAKE				7
#define ITEM_SPECIAL_SUPPLY_DEPOT		8
#define ITEM_SPECIAL_PLASMA_BOMB		9


//Classes
#define CLASS_RECON				1
#define CLASS_NURSE				2
#define CLASS_ENGINEER			3
#define CLASS_MARINE			4
#define CLASS_CYBORG			5
#define CLASS_ARSONIST			6
#define CLASS_NUM_CLASSES       6

#define CLASS_SUPERMAN          7 //special superman class


/* Old Classes 
#define CLASS_EXPLOSIVES		5
#define CLASS_SENTRYGUARD		6
#define CLASS_FLAMETROOPER		8
#define CLASS_SPY				2
#define CLASS_SNIPER			7
*/

//Class Items
#define RECON_WEAPONS			WEAPON_SHOTGUN + WEAPON_RAILGUN + WEAPON_SNIPERRIFLE
#define RECON_GRENADE1			GRENADE_TYPE_FLARE
#define RECON_GRENADE2			GRENADE_TYPE_FLASH
#define RECON_GRENADE3			GRENADE_TYPE_NONE
#define RECON_ARMOR				50
#define RECON_HEALTH			90
#define RECON_SPEED				575	
#define RECON_MODEL				CLASS_MODEL_FEMALE
#define RECON_SPECIAL			SPECIAL_JETPACK
#define RECON_ITEMS				ITEM_JACKETARMOR

#define NURSE_WEAPONS			WEAPON_INFECTEDDART + WEAPON_SHOTGUN + WEAPON_MACHINEGUN + WEAPON_NEEDLER
#define NURSE_GRENADE1			GRENADE_TYPE_NORMAL
#define NURSE_GRENADE2			GRENADE_TYPE_CONCUSSION
#define NURSE_GRENADE3			GRENADE_TYPE_PLAGUE
#define NURSE_ARMOR				125
#define NURSE_HEALTH			175
#define NURSE_SPEED				375
#define NURSE_MODEL				CLASS_MODEL_FEMALE
#define NURSE_SPECIAL			SPECIAL_NONE
#define NURSE_ITEMS				ITEM_JACKETARMOR + ITEM_COMBATARMOR

#define ENGINEER_WEAPONS		WEAPON_SHOTGUN + WEAPON_MACHINEGUN + WEAPON_ARMORDART + WEAPON_TELSA
#define ENGINEER_GRENADE1		GRENADE_TYPE_NORMAL
#define ENGINEER_GRENADE2		GRENADE_TYPE_MAGNOTRON
#define ENGINEER_GRENADE3		GRENADE_TYPE_SHOCK
#define ENGINEER_ARMOR			200
#define ENGINEER_HEALTH			150
#define ENGINEER_SPEED			250
#define ENGINEER_MODEL			CLASS_MODEL_MALE
//#define ENGINEER_SPECIAL		SPECIAL_SUPPLY_DEPOT + SPECIAL_MISSILE_LAUNCHER + SPECIAL_ALARMS + SPECIAL_SENTRY_GUN
#define ENGINEER_SPECIAL		SPECIAL_JETPACK + SPECIAL_SUPPLY_DEPOT + SPECIAL_ALARMS + SPECIAL_SENTRY_GUN
#define ENGINEER_ITEMS			ITEM_JACKETARMOR

#define CYBORG_WEAPONS			WEAPON_SHOTGUN  + WEAPON_GRENADELAUNCHER + WEAPON_ROCKETLAUNCHER + WEAPON_CLUSTERROCKET + WEAPON_LIGHTNING
#define CYBORG_GRENADE1			GRENADE_TYPE_SHRAPNEL
#define CYBORG_GRENADE2			GRENADE_TYPE_LASERBALL
#define CYBORG_GRENADE3			GRENADE_TYPE_CLUSTER
#define CYBORG_ARMOR			200
#define CYBORG_HEALTH			125
#define CYBORG_SPEED			215
#define CYBORG_MODEL			CLASS_MODEL_CYBORG
#define CYBORG_SPECIAL			SPECIAL_KAMIKAZE + SPECIAL_PLASMA_BOMB
#define CYBORG_ITEMS			ITEM_POWERSHIELD + ITEM_JACKETARMOR + ITEM_BODYARMOR + ITEM_COMBATARMOR

#define MARINE_WEAPONS			WEAPON_SHOTGUN + WEAPON_SUPERSHOTGUN + WEAPON_PULSE + WEAPON_ROCKETLAUNCHER + WEAPON_CHAINGUN + WEAPON_PELLET + WEAPON_HYPERBLASTER
#define MARINE_GRENADE1			GRENADE_TYPE_PROXIMITY
#define MARINE_GRENADE2			GRENADE_TYPE_GOODYEAR
#define MARINE_GRENADE3			GRENADE_TYPE_TURRET
#define MARINE_ARMOR			300
#define MARINE_HEALTH			225
#define MARINE_SPEED			185
#define MARINE_MODEL			CLASS_MODEL_MALE
#define MARINE_SPECIAL			SPECIAL_JETPACK + SPECIAL_ALARMS + SPECIAL_LASER_DEFENSE
#define MARINE_ITEMS			ITEM_POWERSHIELD + ITEM_JACKETARMOR + ITEM_BODYARMOR 

#define ARSONIST_WEAPONS		WEAPON_SHOTGUN + WEAPON_SHC + WEAPON_FLAREGUN + WEAPON_NAPALMMISSLE + WEAPON_FLAMETHROWER
#define ARSONIST_GRENADE1		GRENADE_TYPE_NORMAL
#define ARSONIST_GRENADE2		GRENADE_TYPE_NAPALM
#define ARSONIST_GRENADE3		GRENADE_TYPE_CONCUSSION
#define ARSONIST_ARMOR			150
#define ARSONIST_HEALTH			100
#define ARSONIST_SPEED			325
#define ARSONIST_MODEL			CLASS_MODEL_CYBORG
#define ARSONIST_SPECIAL		SPECIAL_QUAKE
#define ARSONIST_ITEMS			ITEM_JACKETARMOR

#define SUPERMAN_WEAPONS		-1 //ALL WEAPONS
#define SUPERMAN_GRENADE1		GRENADE_TYPE_CLUSTER
#define SUPERMAN_GRENADE2		GRENADE_TYPE_PROXIMITY
#define SUPERMAN_GRENADE3		GRENADE_TYPE_TURRET
#define SUPERMAN_ARMOR			400
#define SUPERMAN_HEALTH			400
#define SUPERMAN_SPEED			400	
#define SUPERMAN_MODEL			CLASS_MODEL_ANY
#define SUPERMAN_SPECIAL		-1   //ALL SKILLS
#define SUPERMAN_ITEMS			-1   //ALL ITEMS

//Scanner stuff
#define SCANNER_UNIT                   32
#define SCANNER_RANGE                  100
#define SCANNER_UPDATE_FREQ            1
#define PIC_SCANNER                    "pics/scanner/scanner.pcx"
#define PIC_SCANNER_TAG                "scanner/scanner"
#define PIC_DOT                        "pics/scanner/dot.pcx"
#define PIC_DOT_TAG                    "scanner/dot"
#define PIC_ACIDDOT                    "pics/scanner/aciddot.pcx"
#define PIC_ACIDDOT_TAG                "scanner/aciddot"
#define PIC_INVDOT                     "pics/scanner/invdot.pcx"
#define PIC_INVDOT_TAG                 "scanner/invdot"
#define PIC_QUADDOT                    "pics/scanner/quaddot.pcx"
#define PIC_QUADDOT_TAG                "scanner/quaddot"
#define PIC_DOWN                       "pics/scanner/down.pcx"
#define PIC_DOWN_TAG                   "scanner/down"
#define PIC_UP                         "pics/scanner/up.pcx"
#define PIC_UP_TAG                     "scanner/up"
#define PIC_SCANNER_ICON               "pics/scanner/scanicon.pcx"
#define PIC_SCANNER_ICON_TAG           "scanner/scanicon"
#define SAFE_STRCAT(org,add,maxlen)    if ((strlen(org) + strlen(add)) < maxlen)    strcat(org,add);
#define LAYOUT_MAX_LENGTH              1400

//Fast weapons switching
#define fastswitch 1

/* -------------------------------
      FUNCTION PROTOTYPES
------------------------------- */
// wf_jetpack.c 
void ApplyThrust (edict_t *ent);

// wf_proximity.c
void fire_proximity (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, int proximity_type);

// wf_laserball.c
void fire_laserball (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);

// wf_decoy.c
void SP_Decoy(edict_t *self);

// wf_goodyear.c
void fire_goodyear (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);

// wf_flash.c
void fire_flash (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);

// wf_cluster.c
void fire_cluster (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);

// wf_pipebomb.c
void fire_pipebomb (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void Cmd_DetPipes_f (edict_t *ent);

// wf_misc.c
void Cmd_Grenade_f (edict_t *ent);
void Cmd_Grenade1 (edict_t *ent);
void Cmd_Grenade2 (edict_t *ent);
void Cmd_Grenade3 (edict_t *ent);
void Cmd_Thrust_f (edict_t *ent);
void Cmd_Homing_f (edict_t *ent);
void Cmd_Reno_f (edict_t *ent);
void Cmd_WFFlags_f (edict_t *ent);
qboolean K2_IsProtected(edict_t *ent);
void wf_show_grenade_type(edict_t *ent);
qboolean wf_IsWeapon(char *classname);
void wf_InitPlayerClass(gclient_t *client);
void Cmd_DSkin_f (edict_t *ent);
void Cmd_ShowClass (edict_t *ent);
int wf_GetClassModel(int p_class);
void WFPlayer_Die (edict_t *ent);
void WFPlayer_ChangeClassTeam (edict_t *ent);

// b_turret.c
void turret_remove(edict_t *ent);


//wf_lasersight.c
void LaserSightThink (edict_t *self);
void SP_LaserSight(edict_t *self);

// wf_scanner.c 
void Toggle_Scanner (edict_t *ent);
void ShowScanner(edict_t *ent,char *layout);
void ClearScanner(gclient_t *client);
qboolean Pickup_Scanner (edict_t *ent, edict_t *other);

// wf_jet.c
qboolean Jet_AvoidGround( edict_t *ent );
qboolean Jet_Active( edict_t *ent );
void Jet_BecomeExplosion( edict_t *ent, int damage );
void Jet_ApplyJet( edict_t *ent, usercmd_t *ucmd );

// wf_earthquake.c
void fire_earthquake_grenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);

//wf_turret.c
void grenturret_think2(edict_t *ent);  //Prototypes for grenade turret
void grenturret_think4(edict_t *ent);  //think functions
void Cmd_Turret_f(edict_t *ent);
void grenturret_think4 (edict_t *ent);
void grenturret_think3 (edict_t *ent);
void grenturret_think2 (edict_t *ent);
void grenturret_think1 (edict_t *ent);
void fire_turret_grenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, qboolean held);

//wf_napalm.c
void fire_napalm (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);

//wf_flame.c
void fire_flame (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, qboolean held);


// Map Rotation Support
// DEFINES

#define MAX_MAPS           32

#define MAX_MAPNAME_LEN    16 

#define ML_ROTATE_SEQ          0 
#define ML_ROTATE_RANDOM       1 
#define ML_ROTATE_NUM_CHOICES  2 
      

// STRUCTURES 
 typedef struct 
{ 
   int  nummaps;          // number of maps in list 
   char mapnames[MAX_MAPS][MAX_MAPNAME_LEN]; 
   char rotationflag;     // set to ML_ROTATE_* 
   int  currentmap;       // index to current map 
   int  votes[MAX_MAPS];
   qboolean  voteonly[MAX_MAPS];  //True if this map should only be
								  //voted on, but not in rotation
   qboolean warning_given; // Have we given people a warning to vote?
} maplist_t; 
  
// GLOBALS 
maplist_t maplist; 
  
// PROTOTYPES 

//wf_maplist.c
int  LoadMapList(edict_t *ent, char *filename); 
void ClearMapList(); 
void Cmd_Maplist_f (edict_t *ent); 
void Display_Maplist_Usage(edict_t *ent);
void ClearMapVotes() ;
int MapMaxVotes();
void VoteForMap(int i);
void DumpMapVotes();
void Cmd_Maplist_f (edict_t *ent);
void MaplistNextMap();

// g_ctf.c
void WFSpecialMenu(edict_t *ent);
void WFMapVote(edict_t *ent);

// g_main.c
void EndDMLevel (void);

// remotecam.c
void cmd_CameraPlace(edict_t *ent);
void cmd_CameraToggle(edict_t *ent);


// fileio.c 
#include "wf_fileio.h" 

//w_laser.c
void cmd_TripBomb(edict_t *self);

//misc function prototypes
void cmd_TripBomb(edict_t *ent);
void SP_SupplyDepot(edict_t *self);
void place_alarm (int number,edict_t *ent);
void cmd_PlasmaBomb(edict_t *ent);
void cmd_LaserDefense(edict_t *ent);
void fire_napalm (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void burn_person(edict_t *target, edict_t *owner, int damage);
void infect_person(edict_t *target, edict_t *owner);
void Weapon_Generic (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void (*fire)(edict_t *ent));
void check_dodge (edict_t *self, vec3_t start, vec3_t dir, int speed);
void Grenade_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Grenade_Die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
void Rocket_Die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
void NoAmmoWeaponChange (edict_t *ent);
void ThrowUpNow(edict_t *self);
void TimedNuke_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void DiseaseGrenade_Explode (edict_t *ent);
void fire_concussiongrenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void fire_diseasegrenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void fire_magnogrenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void fire_bulletgrenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void fire_flare (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void fire_shockgrenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);


#include "m_player.h"
#include "dwm.h"
#include "q_devels.h"
#include "kamikaze.h"

extern qboolean is_quad;
extern byte is_silenced;

//JR Stuff for flames and a max amount of Fire
#define MAX_FLAMES         60
int TOTALWORLDFLAMES;


