/*==============================================================================
The Weapons Factory - 
Team Fortress Style Flag Capture Functions
Original code by Gregg Reno
==============================================================================*/
#include "g_local.h"

extern gitem_t *flag1_item;
extern gitem_t *flag2_item;
extern ctfgame_t ctfgame;

void CTFResetFlags(void);
void CTFResetFlag(int ctf_team);


qboolean STWFPickup_Flag(edict_t *ent, edict_t *other)
{
	int ctf_team;
	gitem_t *flag_item, *enemy_flag_item;

	// figure out what team this flag is
	if (strcmp(ent->classname, "item_flag_team1") == 0)
		ctf_team = CTF_TEAM1;
	else if (strcmp(ent->classname, "item_flag_team2") == 0)
		ctf_team = CTF_TEAM2;
	else 
	{
		gi.cprintf(ent, PRINT_HIGH, "Don't know what team the flag is on.\n");
		return false;
	}

	// same team, if the flag at base, check to he has the enemy flag
	if (ctf_team == CTF_TEAM1) 
	{
		flag_item = flag1_item;
		enemy_flag_item = flag2_item;
	} 
	else 
	{
		flag_item = flag2_item;
		enemy_flag_item = flag1_item;
	}

	//Note - you can't pick up your own flag - just the enemy's
	if (ctf_team != other->client->resp.ctf_team) 
	{

		// hey, its not our flag, pick it up
		gi.bprintf(PRINT_HIGH, "%s got the %s flag!\n",
			other->client->pers.netname, CTFTeamName(ctf_team));
		other->client->resp.score += CTF_FLAG_BONUS;

		other->client->pers.inventory[ITEM_INDEX(flag_item)] = 1;
		other->client->resp.ctf_flagsince = level.time;

		// pick up the flag
		// if it's not a dropped flag, we just make is disappear
		// if it's dropped, it will be removed by the pickup caller
		if (!(ent->spawnflags & DROPPED_ITEM)) 
		{
			ent->flags |= FL_RESPAWN;
			ent->svflags |= SVF_NOCLIENT;
			ent->solid = SOLID_NOT;
		}
		return true;
	}
	return false;
}

//Something touched home base
void Home_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	int i;
	edict_t *player;
	gitem_t *flag_item, *enemy_flag_item;

	//Did a player touch?
	if (!other->client)
		return;

	//Home base and player must be on same team
	if (ent->wf_team != other->wf_team)
		return;

	// same team, if the flag at base, check to he has the enemy flag
	if (other->wf_team == CTF_TEAM1) 
	{
		flag_item = flag1_item;
		enemy_flag_item = flag2_item;
	}
	else 
	{
		flag_item = flag2_item;
		enemy_flag_item = flag1_item;
	}

	//Does the player have the enemy flag?
	if (other->client->pers.inventory[ITEM_INDEX(enemy_flag_item)]) 
	{
		//Yes - TOUCHDOWN!
		gi.bprintf(PRINT_HIGH, "%s captured the %s flag!\n",
				other->client->pers.netname, CTFOtherTeamName(other->wf_team));

		other->client->pers.inventory[ITEM_INDEX(enemy_flag_item)] = 0;

		ctfgame.last_flag_capture = level.time;
		ctfgame.last_capture_team = other->wf_team;
		if (other->wf_team == CTF_TEAM1)
			ctfgame.team1++;
		else
			ctfgame.team2++;

		gi.sound (ent, CHAN_RELIABLE+CHAN_NO_PHS_ADD+CHAN_VOICE, gi.soundindex("ctf/flagcap.wav"), 1, ATTN_NONE, 0);

		// other gets another 10 frag bonus
		other->client->resp.score += CTF_CAPTURE_BONUS;

		// Ok, let's do the player loop, hand out the bonuses
		for (i = 1; i <= maxclients->value; i++) 
		{
			player = &g_edicts[i];
			if (!player->inuse)
				continue;
			if (player->client->resp.ctf_team != other->client->resp.ctf_team)
			{
				player->client->resp.ctf_lasthurtcarrier = -5;
			}
			else if (player->client->resp.ctf_team == other->client->resp.ctf_team) 
			{
				if (player != other)
					player->client->resp.score += CTF_TEAM_BONUS;
				// award extra points for capture assists
				if (player->client->resp.ctf_lastreturnedflag + CTF_RETURN_FLAG_ASSIST_TIMEOUT > level.time) 
				{
					gi.bprintf(PRINT_HIGH, "%s gets an assist for returning the flag!\n", player->client->pers.netname);
					player->client->resp.score += CTF_RETURN_FLAG_ASSIST_BONUS;
				}
				if (player->client->resp.ctf_lastfraggedcarrier + CTF_FRAG_CARRIER_ASSIST_TIMEOUT > level.time) 
				{
					gi.bprintf(PRINT_HIGH, "%s gets an assist for fragging the flag carrier!\n", player->client->pers.netname);
					player->client->resp.score += CTF_FRAG_CARRIER_ASSIST_BONUS;
				}
			}
		}
		if (ent->wf_team == CTF_TEAM1)
			CTFResetFlag(CTF_TEAM2);
		else
			CTFResetFlag(CTF_TEAM1);
	}
}

void Home_Think (edict_t *ent)
{
	//For some reason, entity needs a think function
	ent->nextthink = level.time + 5.0;
}


void Create_Home_Base(edict_t *flag, int team)
{
	edict_t *home;

	home = G_Spawn ();

	home->wf_team = team;

	VectorCopy(flag->s.origin, home->s.origin);
	home->s.origin[2] += 40;
	//home->classname="depot";
	home->takedamage=DAMAGE_NO;
	home->movetype= MOVETYPE_TOSS;
	home->mass = 200;
	home->solid = SOLID_BBOX;
	home->clipmask=MASK_ALL;
	home->deadflag =DEAD_NO;
	home->clipmask = MASK_SHOT;
	home->model = flag->model;
	home->s.modelindex = gi.modelindex ("models/objects/flagbase/tris.md2");

	if (team == CTF_TEAM1)
	{
		home->classname="home_team1";
                home->s.skinnum = 0;
	}
	else
	{
		home->classname="home_team2";
		home->s.skinnum = 1;
	}
	
	home->solid = SOLID_BBOX;

	VectorSet (home->mins, -20, -20, -15);
	VectorSet (home->maxs, 20, 20, -13);
	home->s.frame =0;
	home->waterlevel = 0;
	home->watertype=0;
	home->health= 100;
	home->max_health =100;
	home->gib_health = -80;
//	home->die = supplydepot_die;
	home->owner = flag;
	home->dmg = 100;
	home->dmg_radius = 100;
//	home->touch = SupplyTouch;
//	home->think =SupplyThink;
	home->touch = Home_Touch;
	home->think = Home_Think;
	home->nextthink = level.time + 1.0;
	VectorClear (home->velocity);
	gi.linkentity (home);

//	gi.dprintf("FLAG CREATED.\n");
}


